/**
 * Copyright albatrus_jp ( http://wonderfl.net/user/albatrus_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4NU6
 */

package {
	import flash.events.*;
	import flash.utils.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	// BitmapViewportSample クラス
	public class BitmapViewportSample extends BasicView {
		public function BitmapViewportSample() {
			// 球体を表示
			var light:PointLight3D = new PointLight3D();
			var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF, 0x222222);
			var sphere:Sphere = new Sphere(material, 300, 15, 15);
			sphere.x = -500;
			scene.addChild(sphere);
			
			// 球体を撮影するカメラを用意
			var camera2:Camera3D = new Camera3D();
			camera2.target = sphere;
			
			// ビットマップビューポートマテリアルを利用して
			// 鏡の役割をもった平面を作成
			var bmpViewport:BitmapViewport3D = new BitmapViewport3D();
			var mirorMat:BitmapViewportMaterial = new BitmapViewportMaterial(bmpViewport, true);
			var mirroObj1:Plane = new Plane(mirorMat, 1280, 960);
			mirroObj1.rotationY = 20;
			
			// 球体の裏側に鏡用の平面とカメラを配置
			mirroObj1.z = camera2.z = 1000;
			mirroObj1.x = camera2.x = 500;
			scene.addChild(mirroObj1);
			
			// レンダリング
			startRendering();
			
			// エンターフレームイベント登録
			addEventListener(Event.ENTER_FRAME, function(e:Event):void {
				sphere.rotationY += 0.5;
				// ビューポートマテリアル用にレンダリング
				renderer.renderScene(scene, camera2, bmpViewport);
				});
		}
	}
}
