/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Mwj
 */

// forked from ProjectNya's Gallery [PV3D] (4)
////////////////////////////////////////////////////////////////////////////////
// fork to use juick api
//
// Gallery [PV3D] (4)
//
// [PV3D]ギャラリーもどき (6)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1324
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.system.Security;
    import org.papervision3d.Papervision3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.events.FileLoadEvent;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
        private static var radius:uint = 400;
        private static var cameraHeight:uint = 0;
        private var angle:Number = 90;
        private static var radian:Number = Math.PI/180;
        private static var max:uint = 20*1;
        private var wall1:DisplayObject3D;
        private var wall2:DisplayObject3D;
        private var completed:uint = 0;
        private var basePoint:DisplayObject3D;
        private var targetPoint:DisplayObject3D;
        private var selectedId:Object = {wid: 0, id: 0};
        private var planes:Array;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            Security.loadPolicyFile("http://i.juick.com/crossdomain.xml");
            scene = new Scene3D();
            camera =new Camera3D();
            viewport = new Viewport3D(0, 0, true, false);
            renderer = new BasicRenderEngine();
            setup();
            initialize();
            addChild(viewport);
        }
        private function setup():void {
            camera.x = 0;
            camera.y = 0;
            camera.z = radius;
            camera.zoom = 25;
            camera.focus = 20;
            camera.target = DisplayObject3D.ZERO;
            viewport.interactive = true;
            viewport.buttonMode = true;
            viewport.mouseChildren = false;
            viewport.addEventListener(MouseEvent.CLICK, click, false, 0, true);
            basePoint = new DisplayObject3D();
            basePoint.x = 0;
            basePoint.y = 0;
            basePoint.z = radius;
            targetPoint = new DisplayObject3D();
        }
        private function initialize():void {
            wall1 = new DisplayObject3D();
            wall1.x = 200;
            wall1.y = 0;
            wall1.z = - 40;
            wall1.rotationY = 90 + 20;
            scene.addChild(wall1);
            wall2 = new DisplayObject3D();
            wall2.x = -200;
            wall2.y = 0;
            wall2.z = - 40;
            wall2.rotationY = - 90 - 20;
            scene.addChild(wall2);
            planes = new Array();
            planes[1] = new Array();
            planes[2] = new Array();
            new JuickPhotos (initialize1);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, releaseOutside, false, 0, true);
        }
        private function initialize1(photos:Array):void {
            for (var n:uint = 0; n < 10; n++) {
                var filePath:String = photos [n].photo.thumbnail;
                var material:BitmapFileMaterial = new BitmapFileMaterial(filePath, false);
                material.doubleSided = true;
                material.smooth = true;
                material.interactive = true;
                material.addEventListener(FileLoadEvent.LOAD_COMPLETE, loaded, false, 0, true);
                var layer:uint = n%5;
                var plane:Plane = new Plane(material, 80, 60, 0, 0);
                plane.x = 90*layer;
                plane.y = 105 - 70*(uint(n/5)+1);
                plane.z = 0;
                plane.extra = {wid: 1, id: n};
                wall1.addChild(plane);
                planes[1].push(plane);
                if (uint (n/5) == 1) {
                    var reflection:ReflectionPlane = new ReflectionPlane(material, 80, 60, 0, 0, 0.2);
                    reflection.x = 90*layer;
                    reflection.y = 105 - 70*2 - 60;
                    reflection.z = 0;
                    wall1.addChild(reflection);
                }
            }
            initialize2(photos);
            //start();
        }
        private function initialize2(photos:Array):void {
            for (var n:uint = 10; n < 20; n++) {
                var filePath:String = photos [n].photo.thumbnail;
                var material:BitmapFileMaterial = new BitmapFileMaterial(filePath, false);
                material.doubleSided = true;
                material.smooth = true;
                material.interactive = true;
                material.addEventListener(FileLoadEvent.LOAD_COMPLETE, loaded, false, 0, true);
                var layer:uint = n%5;
                var plane:Plane = new Plane(material, 80, 60, 0, 0);
                plane.x = - 90*layer;
                plane.y = 105 - 70*(uint(n/5)-1);
                plane.z = 0;
                plane.extra = {wid: 2, id: n};
                wall2.addChild(plane);
                planes[2].push(plane);
                if (uint (n/5) == 3) {
                    var reflection:ReflectionPlane = new ReflectionPlane(material, 80, 60, 0, 0, 0.2);
                    reflection.x = -90*layer;
                    reflection.y = 105 - 70*2 - 60;
                    reflection.z = 0;
                    wall2.addChild(reflection);
                }
            }
        }
        private function loaded(evt:FileLoadEvent):void {
            completed ++;
            if (completed > max - 1) start();
        }
        private function start():void {
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
        }
        private function render(evt:Event):void {
            renderer.renderScene(scene, camera, viewport);
        }
        private function click(evt:MouseEvent):void {
            var plane:Plane = Plane(viewport.hitTestMouse().displayObject3D);
            if (plane) {
                selectedId = {wid: plane.extra.wid, id: plane.extra.id};
                targetPoint.copyTransform(plane.world);
                targetPoint.moveBackward(100);
                zoomIn();
            } else {
                zoomOut();
            }
        }
        private function releaseOutside(evt:MouseEvent):void {
            if (!this.hitTestPoint(stage.mouseX, stage.mouseY, true)) {
                zoomOut();
            }
        }
        private function zoomIn():void {
            enable(false);
            camera.target = null;
            var wall:DisplayObject3D;
            var targetAngle:Number;
            switch (selectedId.wid) {
                case 1 :
                    wall = wall1;
                    targetAngle = 180 - wall.rotationY;
                    break;
                case 2 :
                    wall = wall2;
                    targetAngle =  - 180 - wall.rotationY;
                    break;
            }
            var itween:ITween = BetweenAS3.to(camera, 
                {x: targetPoint.x, y: targetPoint.y, z: targetPoint.z, rotationY: targetAngle}, 1, Quad.easeOut);
            itween.addEventListener(TweenEvent.COMPLETE, zoomed, false, 0, true);
            itween.play();
        }
        private function zoomOut():void {
            enable(false);
            var itween:ITween = BetweenAS3.to(camera, 
                {x: basePoint.x, y: basePoint.y, z: basePoint.z, 
                rotationX: 180, rotationY: 0, rotationZ: 180}, 1, Quad.easeOut);
            itween.addEventListener(TweenEvent.COMPLETE, zoomed, false, 0, true);
            itween.play();
        }
        private function zoomed(evt:TweenEvent):void {
            evt.target.removeEventListener(TweenEvent.COMPLETE, zoomed);
            //camera.target = DisplayObject3D.ZERO;
            enable(true);
        }
        private function enable(useful:Boolean):void {
            viewport.interactive = useful;
            if (useful) {
                viewport.addEventListener(MouseEvent.CLICK, click, false, 0, true);
                stage.addEventListener(MouseEvent.MOUSE_DOWN, releaseOutside, false, 0, true);
            } else {
                viewport.removeEventListener(MouseEvent.CLICK, click);
                stage.removeEventListener(MouseEvent.MOUSE_DOWN, releaseOutside);
            }
        }
        
    }

}


//////////////////////////////////////////////////
// ReflectionPlaneクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.display.Shape;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import org.papervision3d.objects.DisplayObject3D;
import org.papervision3d.materials.BitmapFileMaterial;
import org.papervision3d.materials.BitmapMaterial;
import org.papervision3d.events.FileLoadEvent;
import org.papervision3d.objects.primitives.Plane;

class ReflectionPlane extends DisplayObject3D {
    private var _material:BitmapFileMaterial;
    private var _width:Number = 0;
    private var _height:Number = 0;
    private var _segmentsW:Number = 0;
    private var _segmentsH:Number = 0;
    private var _alpha:Number = 1;
    private var plane:Plane;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;

    public function ReflectionPlane(material:BitmapFileMaterial = null, width:Number = 0, height:Number = 0, segmentsW:Number = 0, segmentsH:Number = 0, alpha:Number = 1) {
        _material = material;
        _width = width;
        _height = height;
        _segmentsW = segmentsW;
        _segmentsH = segmentsH;
        _alpha = alpha;
        init();
    }

    private function init():void {
        _material.addEventListener(FileLoadEvent.LOAD_COMPLETE, loaded, false, 0, true);
    }
    private function loaded(evt:FileLoadEvent):void {
        draw();
        reflect();
        var material:BitmapMaterial = new BitmapMaterial(bitmapData, false);
        material.smooth = true;
        plane = new Plane(material, _width, _height, _segmentsW, _segmentsH);
        addChild(plane);
    }
    private function draw():void {
        var bd:BitmapData = _material.bitmap.clone();
        bitmapData = new BitmapData(bd.width, bd.height, false, 0xFFFFFFFF);
        var matrix:Matrix = new Matrix();
        matrix.scale(1, -1);
        matrix.translate(0, bd.height);
        var colorTrans:ColorTransform = new ColorTransform();
        colorTrans.alphaMultiplier = _alpha;
        bitmapData.lock();
        bitmapData.draw(bd, matrix, colorTrans);
        bitmapData.unlock();
        bd.dispose();
    }
    private function reflect():void {
        var overlay:Shape = new Shape();
        var colors:Array = [0xFFFFFF, 0xFFFFFF];
        var alphas:Array = [0, 1];
        var ratios:Array = [0, 204];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(bitmapData.width, bitmapData.height, Math.PI/2, 0, 0);
        overlay.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        overlay.graphics.drawRect(0, 0, bitmapData.width, bitmapData.height);
        overlay.graphics.endFill();
        bitmapData.lock();
        bitmapData.draw(overlay);
        bitmapData.unlock();
    }

}


import flash.events.Event;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;
class JuickPhotos {
	/**
	 * последние 20 картинок.
	 */
	public function JuickPhotos (callback:Function = null) {
		onComplete = callback;
		loader = new URLLoader;
		loader.dataFormat = URLLoaderDataFormat.TEXT;
		loader.addEventListener (Event.COMPLETE, onCompleteHandler);
		loader.load (new URLRequest ("http://api.juick.com/messages?media=photo"));
	}

	private var loader:URLLoader;
	private var onComplete:Function;
	private function onCompleteHandler (e:Event):void {
		loader.removeEventListener (Event.COMPLETE, onCompleteHandler);
//		trace (loader.data);
		if (onComplete != null) {
			onComplete (JSON.parse (loader.data));
		}
		loader = null;
		onComplete = null;
	}
}