/**
 * Copyright FlashBum ( http://wonderfl.net/user/FlashBum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Mf5
 */

package
{
	import camo.core.display.CamoDisplay;
	import camo.core.enum.CSSProperties;
	import camo.core.events.CamoDisplayEvent;

	import com.bit101.components.CheckBox;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.HSlider;
	import com.bit101.components.InputText;
	import com.bit101.components.Label;
	import com.bit101.components.PushButton;
	import com.bit101.components.RadioButton;

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.Shape;
	import flash.display.SpreadMethod;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.text.TextField;

	/**
	 * @author jessefreeman
	 */
	public class FlashTest extends Sprite 
	{

		private var camoDisplay : CamoDisplay;
		private var colorSelector : ColorChooser;
		private var colorLabel : Label;
		private var borderColorSelector : ColorChooser;
		private var borderSlider : HSlider;
		private var borderLabel : Label;
		private var borderTopSlider : HSlider;
		private var borderTopLabel : Label;
		private var borderRightSlider : HSlider;
		private var borderRightLabel : Label;
		private var borderBottomSlider : HSlider;
		private var borderBottomLabel : Label;
		private var borderLeftSlider : HSlider;
		private var borderLeftLabel : Label;
		private var borderColorLabel : Label;
		private var borderAlphaSlider : HSlider;
		private var borderAlphaLabel : Label;
		private var paddingSlider : HSlider;
		private var paddingLabel : Label;
		private var paddingTopSlider : HSlider;
		private var paddingTopLabel : Label;
		private var paddingBottomSlider : HSlider;
		private var paddingBottomLabel : Label;
		private var paddingRightSlider : HSlider;
		private var paddingRightLabel : Label;
		private var paddingLeftSlider : HSlider;
		private var paddingLeftLabel : Label;
		private var paddingDebugMode : CheckBox;
		private var paddingDebugColorSelector : ColorChooser;
		private var paddingDebugColorLabel : Label;
		private var texture : Bitmap;
		private var backgroundGroup : Sprite;
		private var bgRepeate : RadioButton;
		private var _lastCheckedRepeatButton : RadioButton;
		private var bgRepeatX : RadioButton;
		private var bgRepeatY : RadioButton;
		private var bgNoRepeat : RadioButton;
		private var backgroundImage : CheckBox;
		private var colorAlpha : HSlider;
		private var colorAlphaLabel : Label;
		private var backgroundImageAlpha : HSlider;
		private var backgroundImageAlphaLabel : Label;
		private var bgPositionX : InputText;
		private var bgPositionY : InputText;
		private var bgPositionXLabel : Label;
		private var bgPositionYLabel : Label;
		private var refresh : PushButton;
		private var reset : PushButton;

		public function FlashTest(autoStart : Boolean = true)
		{
			if(autoStart)
			{
				configureStage( );
				start( );
			}
		}

		protected function configureStage() : void
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener( Event.RESIZE, onStageResize );
		}

		private function onStageResize(event : Event = null) : void
		{
			uiContainer.x = uiContainer.y = 0;
			onRecenterCamoDisplay( );
		}

		public function start() : void
		{
			configureStage( );
			
			camoDisplay = new CamoDisplay( );
			camoDisplay.addEventListener( CamoDisplayEvent.DRAW, onRecenterCamoDisplay );
			camoDisplay.width = 100;
			camoDisplay.height = 100;
			camoDisplay.backgroundColor = 0xff0000;
			addChild( camoDisplay );
			createBoxModelUI( );
			createBackgroundTexture( );
		}

		private function onRecenterCamoDisplay(event : CamoDisplayEvent = null) : void
		{
			if(camoDisplay)
			{
				camoDisplay.x = Math.round( ((stage.stageWidth + 250) * .5) - (camoDisplay.width * .5) );
				camoDisplay.y = Math.round( (stage.stageHeight * .5) - (camoDisplay.height * .5) );
			}
		}

		private function createBackgroundTexture() : void
		{
			var textureShape : Shape = new Shape( );
			var fillType : String = GradientType.LINEAR;
			var colors : Array = [ 0xFF0000, 0x0000FF ];
			var alphas : Array = [ 1, 1 ];
			var ratios : Array = [ 0x00, 0xFF ];
			var matr : Matrix = new Matrix( );
			matr.createGradientBox( 20, 20, Math.PI / 2, 0, 0 );
			var spreadMethod : String = SpreadMethod.PAD;
			textureShape.graphics.beginGradientFill( fillType, colors, alphas, ratios, matr, spreadMethod );  
			textureShape.graphics.drawRect( 0, 0, 20, 20 );
			
			var bmd : BitmapData = new BitmapData( textureShape.width, textureShape.height );
			bmd.draw( textureShape );
			
			texture = new Bitmap( bmd );
		}

		protected var uiContainer : Sprite = new Sprite( );

		public function createBoxModelUI() : void
		{
			
			
			createControls( );

			// Configure
			addChild( uiContainer );
			onStageResize( );	
		}

		private function createControls() : void
		{
			backgroundGroup = new Sprite( );
			uiContainer.addChild( backgroundGroup );
			
			// BackgroundColor Selector
			colorSelector = new ColorChooser( backgroundGroup, 0, 0, camoDisplay.backgroundColor, onChangeColor );
			colorLabel = new Label( backgroundGroup, colorSelector.x, colorSelector.y + colorSelector.height, "Background Color" );
			
			colorAlpha = new HSlider( backgroundGroup, colorLabel.x, colorLabel.y + colorLabel.height, onChangeColorAlpha );
			colorAlpha.value = 100;
			
			colorAlphaLabel = new Label( backgroundGroup, colorAlpha.x, colorAlpha.y + colorAlpha.height, "Background Alpha 100" );
			
			backgroundImage = new CheckBox( backgroundGroup, 110, colorSelector.y + 5, "Background Image", onChangeBGImage );
			
			backgroundImageAlpha = new HSlider( backgroundGroup, colorAlpha.x + colorAlpha.width + 10, colorAlpha.y, onChangeBackgroundImageAlpha );
			backgroundImageAlpha.value = 100;
			
			backgroundImageAlphaLabel = new Label( backgroundGroup, backgroundImageAlpha.x, backgroundImageAlpha.y + backgroundImageAlpha.height, "BG Image Alpha 100" );
			
			bgRepeate = new RadioButton( backgroundGroup, 0, backgroundImageAlphaLabel.y + backgroundImageAlphaLabel.height + 10, "BG Repeat", true, onChangeBGRepete );
			_lastCheckedRepeatButton = bgRepeate;
			
			bgNoRepeat = new RadioButton( backgroundGroup, 110, bgRepeate.y, "BG No Repeat", false, onChangeBGRepete );
			
			bgRepeatX = new RadioButton( backgroundGroup, bgRepeate.x, bgRepeate.y + bgRepeate.height + 10, "BG Repeat X", false, onChangeBGRepete );
			
			bgRepeatY = new RadioButton( backgroundGroup, bgNoRepeat.x, bgNoRepeat.y + bgNoRepeat.height + 10, "BG Repeat Y", false, onChangeBGRepete );
			
			bgPositionX = new InputText( backgroundGroup, bgRepeatX.x, bgRepeatX.y + bgRepeatX.height + 10, "0", onChangeBGPositionX );
			bgPositionX.restrict = "0-9";
			bgPositionX.width = 90;
			bgPositionXLabel = new Label( backgroundGroup, bgPositionX.x, bgPositionX.y + bgPositionX.height, "BG Image X Position" );
			
			
			bgPositionY = new InputText( backgroundGroup, bgRepeatY.x, bgRepeatY.y + bgRepeatY.height + 10, "0", onChangeBGPositionY );
			bgPositionY.restrict = "0-9";
			bgPositionY.width = 90;
			bgPositionYLabel = new Label( backgroundGroup, bgPositionY.x, bgPositionY.y + bgPositionY.height, "BG Image Y Position" );
			
			borderColorSelector = new ColorChooser( backgroundGroup, bgPositionXLabel.x, bgPositionXLabel.y + bgPositionXLabel.height, 0x000000, onChangeBorderColor );
			borderColorLabel = new Label( backgroundGroup, borderColorSelector.x, borderColorSelector.y + borderColorSelector.height, "Border Color" );
			
			borderAlphaSlider = new HSlider( backgroundGroup, borderColorSelector.x + borderColorSelector.width + 10, borderColorSelector.y, onChangeBorderAlpha );
			borderAlphaSlider.value = 100;
			borderAlphaSlider.width = (borderAlphaSlider.width * 2) - (borderColorSelector.width);
			borderAlphaLabel = new Label( backgroundGroup, borderAlphaSlider.x, borderAlphaSlider.y + borderAlphaSlider.height, "Border Alpha " + borderAlphaSlider.value );
			
			borderSlider = new HSlider( backgroundGroup, borderColorLabel.x, borderColorLabel.y + borderColorLabel.height, onChangeBorder );
			borderSlider.width = borderSlider.width * 2 + 10;
			borderLabel = new Label( backgroundGroup, borderSlider.x, borderSlider.y + borderSlider.height, "Border" );
			
			borderTopSlider = new HSlider( backgroundGroup, borderLabel.x, borderLabel.y + borderLabel.height, onChangeTopBorder );
			borderTopLabel = new Label( backgroundGroup, borderTopSlider.x, borderTopSlider.y + borderTopSlider.height, "Top Border" );
			
			borderBottomSlider = new HSlider( backgroundGroup, borderTopLabel.x, borderTopLabel.y + borderTopLabel.height, onChangeBottomBorder );
			borderBottomLabel = new Label( backgroundGroup, borderBottomSlider.x, borderBottomSlider.y + borderBottomSlider.height, "Bottom Border" );
			
			borderRightSlider = new HSlider( backgroundGroup, borderTopSlider.x + borderTopSlider.width + 10, borderTopSlider.y, onChangeRightBorder );
			borderRightLabel = new Label( backgroundGroup, borderRightSlider.x, borderRightSlider.y + borderRightSlider.height, "Right Border" );
			
			borderLeftSlider = new HSlider( backgroundGroup, borderRightLabel.x, borderRightLabel.y + borderRightLabel.height, onChangeLeftBorder );
			borderLeftLabel = new Label( backgroundGroup, borderLeftSlider.x, borderLeftSlider.y + borderLeftSlider.height, "Left Border" );
			
			paddingSlider = new HSlider( backgroundGroup, borderBottomLabel.x, borderBottomLabel.y + borderBottomLabel.height, onChangePadding );
			paddingSlider.width = paddingSlider.width * 2 + 10;
			paddingLabel = new Label( backgroundGroup, paddingSlider.x, paddingSlider.y + paddingSlider.height, "Padding" );
			
			paddingTopSlider = new HSlider( backgroundGroup, paddingLabel.x, paddingLabel.y + paddingLabel.height, onChangeTopPadding );
			paddingTopLabel = new Label( backgroundGroup, paddingTopSlider.x, paddingTopSlider.y + paddingTopSlider.height, "Top Padding" );
			
			paddingBottomSlider = new HSlider( backgroundGroup, paddingTopLabel.x, paddingTopLabel.y + paddingTopLabel.height, onChangeBottomPadding );
			paddingBottomLabel = new Label( backgroundGroup, paddingBottomSlider.x, paddingBottomSlider.y + paddingBottomSlider.height, "Bottom Padding" );
			
			paddingDebugColorSelector = new ColorChooser( backgroundGroup, paddingBottomLabel.x, paddingBottomLabel.y + paddingBottomLabel.height, camoDisplay.debugPaddingColor, onChangePaddingDebugColor );
			paddingDebugColorLabel = new Label( backgroundGroup, paddingDebugColorSelector.x, paddingDebugColorSelector.y + paddingDebugColorSelector.height, "Padding Debug Color" );
			
			paddingRightSlider = new HSlider( backgroundGroup, paddingTopSlider.x + paddingTopSlider.width + 10, paddingTopSlider.y, onChangeRightPadding );
			paddingRightLabel = new Label( backgroundGroup, paddingRightSlider.x, paddingRightSlider.y + paddingRightSlider.height, "Right Padding" );
			
			paddingLeftSlider = new HSlider( backgroundGroup, paddingRightLabel.x, paddingRightLabel.y + paddingRightLabel.height, onChangeLeftPadding );
			paddingLeftLabel = new Label( backgroundGroup, paddingLeftSlider.x, paddingLeftSlider.y + paddingLeftSlider.height, "Left Padding" );
			
			paddingDebugMode = new CheckBox( backgroundGroup, paddingLeftLabel.x, paddingLeftLabel.y + paddingLeftLabel.height, "Padding Debug", onChangePaddingDebugMode );
			
			refresh = new PushButton( backgroundGroup, paddingDebugColorLabel.x, paddingDebugColorLabel.y + paddingDebugColorLabel.height, "Force Refesh", onForceRefesh );
			reset = new PushButton( backgroundGroup, refresh.x + refresh.width + 10, refresh.y, "Reset Box Model", onReset );
		}

		private function onChangeBGPositionX(event : Event) : void
		{
			camoDisplay.backgroundPositionX = Number( TextField( event.target ).text );
		}

		private function onChangeBGPositionY(event : Event) : void
		{
			camoDisplay.backgroundPositionY = Number( TextField( event.target ).text );
		}

		private function onChangeColorAlpha(event : Event) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.backgroundColorAlpha = (HSlider( event.target ).value / 100);
			colorAlphaLabel.text = "Background Alpha " + value;
		}

		private function onChangeBackgroundImageAlpha(event : Event) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.backgroundImageAlpha = (HSlider( event.target ).value / 100);
			backgroundImageAlphaLabel.text = "BG Image Alpha " + value;
		}

		protected function onChangeBGImage(event : Event) : void
		{
			var show : Boolean = CheckBox( event.target ).selected;
			
			if(show)	
				camoDisplay.backgroundImageBitmap = texture;
			else
				camoDisplay.backgroundImageBitmap = null;
		}

		private function onChangeBGRepete(event : Event) : void
		{
			if(_lastCheckedRepeatButton != event.target)
			{
				_lastCheckedRepeatButton.selected = false;
			
				_lastCheckedRepeatButton = event.target as RadioButton;
			
				switch(event.target)
				{
					case bgRepeate:
						camoDisplay.backgroundRepeat = CSSProperties.REPEAT;	
						break;
					case bgRepeatX:
						camoDisplay.backgroundRepeat = CSSProperties.REPEAT_X;
						break;
					case bgRepeatY:
						camoDisplay.backgroundRepeat = CSSProperties.REPEAT_Y;
						break;
					case bgNoRepeat:
						camoDisplay.backgroundRepeat = CSSProperties.NO_REPEAT;
						break;	
				}
			}
		}

		private function onChangePaddingDebugMode(event : Event) : void
		{
			camoDisplay.debugPadding = paddingDebugMode.selected;
		}

		private function onChangePaddingDebugColor(event : Event) : void
		{
			camoDisplay.debugPaddingColor = ColorChooser( event.target ).value;
		}

		private function onChangeBorderAlpha(event : Event) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.borderAlpha = (HSlider( event.target ).value / 100);
			borderAlphaLabel.text = "Border Alpha " + value;
		}

		private function onChangeBorderColor(event : Event) : void
		{
			camoDisplay.borderColor = ColorChooser( event.target ).value;
		}

		private function onChangeBorder(event : Event) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			borderLabel.text = "Border " + value;
			onChangeTopBorder( event, true );
			onChangeBottomBorder( event, true );
			onChangeRightBorder( event, true );
			onChangeLeftBorder( event, true );  
		}

		private function onChangeTopBorder(event : Event, external : Boolean = false) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.borderTop = HSlider( event.target ).value;
			borderTopLabel.text = "Top Border " + value;
			if(external)
			{
				borderTopSlider.value = value;
			}
		}

		private function onChangeBottomBorder(event : Event, external : Boolean = false) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.borderBottom = HSlider( event.target ).value;
			borderBottomLabel.text = "Bottom Border " + value;
			if(external)
			{
				borderBottomSlider.value = value;
			}
		}

		private function onChangeRightBorder(event : Event, external : Boolean = false) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.borderRight = HSlider( event.target ).value;
			borderRightLabel.text = "Right Border " + value;
			if(external)
			{
				borderRightSlider.value = value;
			}
		}

		private function onChangeLeftBorder(event : Event, external : Boolean = false) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.borderLeft = HSlider( event.target ).value;
			borderLeftLabel.text = "Left Border " + value;
			if(external)
			{
				borderLeftSlider.value = value;
			}
		}

		/** Padding Handlers **/
		private function onChangePadding(event : Event) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			paddingLabel.text = "Padding " + value;
			onChangeTopPadding( event, true );
			onChangeBottomPadding( event, true );
			onChangeRightPadding( event, true );
			onChangeLeftPadding( event, true );  
		}

		private function onChangeTopPadding(event : Event, external : Boolean = false) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.paddingTop = HSlider( event.target ).value;
			paddingTopLabel.text = "Top Padding " + value;
			if(external)
			{
				paddingTopSlider.value = value;
			}
		}

		private function onChangeBottomPadding(event : Event, external : Boolean = false) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.paddingBottom = HSlider( event.target ).value;
			paddingBottomLabel.text = "Bottom Padding " + value;
			if(external)
			{
				paddingBottomSlider.value = value;
			}
		}

		private function onChangeRightPadding(event : Event, external : Boolean = false) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.paddingRight = HSlider( event.target ).value;
			paddingRightLabel.text = "Right Padding " + value;
			if(external)
			{
				paddingRightSlider.value = value;
			}
		}

		private function onChangeLeftPadding(event : Event, external : Boolean = false) : void
		{
			var value : Number = Math.round( HSlider( event.target ).value );
			camoDisplay.paddingLeft = HSlider( event.target ).value;
			paddingLeftLabel.text = "Left Padding " + value;
			if(external)
			{
				paddingLeftSlider.value = value;
			}
		}

		protected function onChangeColor(event : Event) : void
		{
			trace( "Change" );
			camoDisplay.backgroundColor = ColorChooser( event.target ).value;
		}

		private function onReset(event : Event) : void
		{
			// Have to flesh this out
			paddingSlider.value = 0;
			paddingSlider.dispatchEvent( new Event( Event.CHANGE, true, true ) );
			
			paddingDebugMode.selected = false;
			paddingDebugMode.dispatchEvent( new Event( Event.CHANGE, true, true ) );
			camoDisplay.debugPadding = false;
			
			borderAlphaSlider.value = 100;
			borderAlphaSlider.dispatchEvent( new Event( Event.CHANGE, true, true ) );
			
			borderColorSelector.value = 0x000000;
			borderColorSelector.dispatchEvent( new Event( Event.CHANGE, true, true ) );
			
			borderSlider.value = 0;
			borderSlider.dispatchEvent( new Event( Event.CHANGE, true, true ) );
			
			backgroundImage.selected = false;
			backgroundImage.dispatchEvent( new Event( Event.CHANGE, true, true ) );
			camoDisplay.backgroundImageBitmap = null;
			
			backgroundImageAlpha.value = 100;
			backgroundImageAlpha.dispatchEvent( new Event( Event.CHANGE, true, true ) );
			
			colorAlpha.value = 100;
			colorAlpha.dispatchEvent( new Event( Event.CHANGE, true, true ) );
			
			colorSelector.value = 0xff0000;
			colorSelector.dispatchEvent( new Event( Event.CHANGE, true, true ) );

			bgRepeate.selected = true;
			bgRepeate.dispatchEvent( new Event( Event.CHANGE, true, true ) );
			
			bgPositionX.text = "0";
			camoDisplay.backgroundPositionX = 0;
			
			bgPositionY.text = "0";
			camoDisplay.backgroundPositionY = 0;
		}

		private function onForceRefesh(event : Event) : void
		{
			camoDisplay.refresh( );
		}
	}
}
