/**
 * Copyright hoooooonda ( http://wonderfl.net/user/hoooooonda )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4MIh
 */

package {
    import flash.net.*;
    import flash.utils.*;
    import flash.geom.*;
    import flash.ui.Mouse;
    import flash.events.*;
    import flash.display.*;
    public class FlashTest extends Sprite {
        public var spr:Sprite;
        public var colorBmd:BitmapData;  
        public var bmpList:Array;
        public const radius:int = 5;
        public const pixSize:int = 2;
        
        public var ball:Sprite;
        public var bBmpd:BitmapData;
        public var objList:Array;
        public var positionList:Array;
        public const gravity:Number = 0.5;
        
        public function FlashTest() {
            // write as3 code here..
            spr = new Sprite();
            var gr:Graphics = spr.graphics;
            gr.beginFill(0xdd00ee, 1);
            gr.drawCircle(radius,radius, radius);
            gr.endFill();
            //addChild(spr);                   
           
           ball = new Sprite();
           ball.graphics.beginFill(0x00ff00, 1);
           ball.graphics.drawCircle(20, 250, 20);
           ball.graphics.endFill();
           addChild(ball);           
           bBmpd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
           bBmpd.draw(ball);
           
           ball.addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
           ball.addEventListener(MouseEvent.MOUSE_UP, onMUp);
           setBMP();    
        }
                
        public function onMDown(e:MouseEvent):void
        {
            ball = e.target as Sprite;
            ball.startDrag();            
        }        
        public function onMUp(e:MouseEvent):void
        {
           ball = e.target as Sprite; 
           ball.stopDrag();
        }

       
        public function setBMP():void
        {
            var w:int = spr.width;
            var h:int = spr.height;            
            colorBmd = new BitmapData(w, h, true, 0x00000000);
            colorBmd.draw(spr);
            bmpList = new Array();
            objList = new Array();
            positionList = new Array();
            
            for(var i:int = 0; i < w; i++)
            {
                for(var j:int = 0; j < h; j++)
                {
                    var picColor:String = "0x" + colorBmd.getPixel32(i,j).toString(16);
                    if(picColor.indexOf("0x0") == -1)
                    {
                        var bmpd:BitmapData = new BitmapData(pixSize, pixSize, true, int(picColor));
                        var bmp:Bitmap = new Bitmap(bmpd);
                        bmp.x = i * pixSize + (stage.stageWidth/2 - w/2);
                        bmp.y = j * pixSize + (stage.stageHeight/2 - h/2);
                        addChild(bmp);
                        bmpList.push(bmp);
                        
                        var obj:Object = new Object();
                        obj["flag"] = false;
                        obj["vy"] = 0;
                        objList.push(obj);
                        positionList.push(new Point(Math.random()*4-2, Math.random()*10));
                    }
                }
            }
            addEventListener(Event.ENTER_FRAME, move);
        }
        
        public function move(e:Event):void
        {
            for(var i:int = 0; i < bmpList.length; i++)
            {
                var bmp:Bitmap = bmpList[i];
                var bmpd:BitmapData = bmp.bitmapData; 
                
                var mcRect:Rectangle = ball.getBounds(this);
                var bgRect:Rectangle = bmp.getBounds(this);                
                             
                var bounds:Rectangle = new Rectangle();;
                bounds.left = Math.max(mcRect.left,bgRect.left);
                bounds.right= Math.min(mcRect.right,bgRect.right);
                bounds.top = Math.max(mcRect.top,bgRect.top);
                bounds.bottom = Math.min(mcRect.bottom,bgRect.bottom);
                
                var hitBmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xffffffff);
                hitBmd.lock();
                var mt:Matrix = new Matrix();
                mt.tx = ball.x;
                mt.ty = ball.y;
                hitBmd.draw(ball, mt, new ColorTransform(1,0,0,1,0,0,0,0),null,bounds);        
                
                var mt2:Matrix = new Matrix();
                mt2.tx = bmp.x;
                mt2.ty = bmp.y;        
                hitBmd.draw(bmpd, mt2, new ColorTransform(0,1,0,1,0,0,0,0),BlendMode.MULTIPLY, bounds);
                
                var rect:Rectangle = hitBmd.getColorBoundsRect(0xFFFFFFFF, 0xFF000000, true);
                hitBmd.unlock();
                hitBmd.dispose();
                
                if(rect.width != 0)
                {
                    objList[i].flag = true;
                }
                if(objList[i].flag)
                {
                    objList[i].vy += gravity;
                    bmp.y += objList[i].vy + positionList[i].y;
                }

            }
        }
    }
}