/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4M9P
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.utils.getTimer;
	/**
	 * ...
	 * http://http.developer.nvidia.com/GPUGems/gpugems_ch01.html
	 * @author lizhi http://game-develop.net/
	 */
	public class SumSin extends Sprite
	{
		private var sins:Vector.<Sin>;
		public function SumSin() 
		{
			init();
		}
		
		private function init():void {
			sins = new Vector.<Sin>;
			var c:int = 30;
			var a:int = 100 / c;
			while (c-->0) {
				var sin:Sin = new Sin;
				sin.a = a*Math.random();
				sin.w = .1*Math.random();
				sin.s = 2*(Math.random()-.0);
				sin.l = 40*Math.random();
				sins.push(sin);
			}
			
			addEventListener(Event.ENTER_FRAME, enterFrame);
		}
		
		private function enterFrame(e:Event):void 
		{
			draw();
		}
		
		private function sumW(sins:Vector.<Sin>):Number {
			var value:Number = 0;
			for each(var sin:Sin in sins) {
				value += sin.value;
			}
			return value;
		}
		
		private function draw():void {
			graphics.clear();
			graphics.beginFill(0x0080FF);
			for (var x:int = 0; x < stage.stageWidth;x++ ) {
				for each(var sin:Sin in sins) {
					sin.d = x;
					sin.t = getTimer()/1000;
				}
				var y:Number = sumW(sins);
				if (x == 0) {
					graphics.moveTo(x, y + 150);
				}else {
					graphics.lineTo(x, y + 150);
				}
			}
			graphics.lineTo(stage.stageWidth, stage.stageHeight);
			graphics.lineTo(0, stage.stageHeight);
		}
	}

}
class Sin {
	public var a:Number;
	public var d:Number;
	public var w:Number;
	public var t:Number;
	public var s:Number;
	public var l:Number;
	
	public function get value():Number {
		var q:Number = s * 2 * Math.PI / l;
		return a * Math.sin(d * w + t * q);
	}
}