/**
 * Copyright akeyama ( http://wonderfl.net/user/akeyama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4LHb
 */

// forked from maccyan's 飛行機っていうか、戦闘機。
// キー押しっぱなしで加速　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
package {
    import flash.display.Sprite;
    import flash.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    public class FlashTest extends BasicView {
        private const guruguru:int = 5500;
        private var cnt:Number = 0;
        private var paperPlane:PaperPlane;
        private var vel:Number = 0;
        private var keyPush:Boolean = false;
        
        public function FlashTest() {
            // write as3 code here..
            super(0,0,true,false,CameraType.SPRING);
            var material:ColorMaterial = new ColorMaterial(0x3366FF);
            
            for (var i:int = 0; i < 200; i++){
            		var cube:Cube = new Cube(new MaterialsList({all:material}),100,250,10,1,1,1);
            		scene.addChild(cube);
            		
            		var angle:Number = (i / 200) * 360 * Math.PI / 180;
            		cube.x = Math.cos(angle) * guruguru;
            		cube.z = Math.sin(angle*2) * guruguru;
            		cube.y = 0.3 * Math.cos(angle*4) * guruguru;
            }
            
            paperPlane = new PaperPlane(new ColorMaterial(0xff3366));
            scene.addChild(paperPlane);
                        
            camera.target = paperPlane;
            SpringCamera3D(camera).mass = 30 ;
            SpringCamera3D(camera).damping = 10;
            SpringCamera3D(camera).stiffness = 1;
            SpringCamera3D(camera).positionOffset = new Number3D(0,200,0);
            SpringCamera3D(camera).lookOffset = new Number3D(0,0,0);

            
            addEventListener(Event.ENTER_FRAME,loop);
            stage.addEventListener(KeyboardEvent.KEY_DOWN,keyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP,keyUp);
            startRendering();
        }
        
        private function loop(e:Event):void{

                  const DECEL:Number = 0.95;        		

                  vel *= DECEL;
                  if(keyPush)
        		    vel += 0.2*(1-DECEL);
                  cnt += vel;

        		var angle:Number = (cnt / 100) * 360 * Math.PI / 180;
        		paperPlane.x = Math.cos(angle) * guruguru;
        		paperPlane.z = Math.sin(angle*2) * guruguru;
        		paperPlane.y = 0.3 * Math.cos(angle*4) * guruguru + 100;   
        }

        private function keyDown(e:KeyboardEvent):void
        {
            keyPush = true;
        }
        private function keyUp(e:KeyboardEvent):void
        {
             keyPush = false;
        }
        
    }
}