/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4LF4
 */

// 1. JapaninoPOVFirmataをJapaninoにアップロードする
// 2. Funnel Serverを起動してボードタイプとシリアルポートを選択する
// 3. 右側のボタンをクリックしてこのコンテンツを再生する
// 4. P.O.V.ユニットを回してCountが増加すること、Sendボタンを押すと
//    魚のパターンが表示されることを確認
// 
// 参考：セットアップ方法の詳細に関しては、以下のページでの説明を参照
// してください。
// 
// 大人の科学マガジンVol.27
// http://otonanokagaku.net/magazine/vol27/
// 
// wonderfl x japanino
// http://wonderfl.net/event/japanino/
// 
// 注意：光残像キットは、あまり激しく操作すると壊れてしまうことが
// ありますので注意してください。

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;

    import com.bit101.components.*;

    import funnel.*;

    public class JapaninoTest extends Sprite {
        // Japanino
        private var _japanino:Arduino;

        // カウントを表示するためのテキストフィールド
        private var _countLabel:Label;

        // 光残像キットのハンドルを回転させた回数
        private var _count:int = 0;

        public function JapaninoTest() {
            // Japaninoのインスタンスを生成
            _japanino = new Arduino(Arduino.FIRMATA);

            // カウントを表示するためのテキストフィールドを生成
            _countLabel = new Label(this, 180, 200);
            _countLabel.text = "Waiting...";
            _countLabel.scaleX = 2;
            _countLabel.scaleY = 2;
            addChild(_countLabel);

            // Japaninoの準備が完了した時に発生するイベントに対するイベントリスナをセット
            _japanino.addEventListener(FunnelEvent.READY, onReady);

            // JapaninoのFIRMATA_STRINGイベントに対するイベントリスナをセット
            _japanino.addEventListener(FunnelEvent.FIRMATA_STRING, onMessage);
        }

        // Japaninoの準備ができると呼ばれる
        private function onReady(event:FunnelEvent):void {
            // Japaninoの光残像キットにパターンを送信するためのボタンを追加
            addChild(new PushButton(this, 180, 250, "Send", onButtonPress));

            // Waiting...からSpin the handle!に変更する
            _countLabel.text = "Spin the handle!";
        }

        // Japaninoからメッセージを受信すると呼ばれる
        private function onMessage(event:FunnelEvent):void {
            // メッセージが"!"であれば
            if (event.message == "!") {
                // カウントを増やしてテキストフィールドの表示を更新
                _count++;
                _countLabel.text = "Count: " + _count;
            }
        }

        private function onButtonPress(event:MouseEvent):void {
            // 転送するパターンを用意する（15桁x7行）
            // ここでは二進数で記述しているがそれ以外の方法でも構わない
            var pattern:Array = [
                parseInt("0001000", 2),
                parseInt("0010100", 2),
                parseInt("0010100", 2),
                parseInt("0100010", 2),
                parseInt("0100010", 2),
                parseInt("0100010", 2),
                parseInt("1000001", 2),
                parseInt("1000001", 2),
                parseInt("1000001", 2),
                parseInt("0100010", 2),
                parseInt("0010100", 2),
                parseInt("0001000", 2),
                parseInt("0010100", 2),
                parseInt("0100010", 2),
                parseInt("1111111", 2),];

            // パターンをカスタムのメッセージとしてJapaninoに転送する
            _japanino.sendSysexMessage(0x10, pattern);
        }
    }
}
