/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4LAI
 */

// forked from Event's Button
package
{
    import flash.display.Sprite;
    
    [SWF(frameRate="30", background="0xffffff")]
    
    public class ButtonContainer extends Sprite
    {
        public function ButtonContainer()
        {
            var button:Button = new Button();
            this.addChild(button);
            
            stage.scaleMode = "noScale";
            stage.align = "tl";
        }
    }
}

import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;
import flash.net.URLRequest;
import flash.text.TextField;
import flash.text.TextFormat;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Back;

class Button extends Sprite
{
    private var label:TextField;
    private var c0:ColorTransform = new ColorTransform();
    private var c1:ColorTransform = new ColorTransform(1,1,1,1,32,32,32,0);
    
    public function Button()
    {
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, function():void{});
        
        label = new TextField();
        label.mouseEnabled = false;
        label.defaultTextFormat = new TextFormat("Arial", 16, 0xffffff, true);
        label.autoSize = "left";
        
        this.addChild(loader);
        this.addChild(label);
        this.buttonMode = true;
        
        loader.load(new URLRequest("http://wonderfl.net/img/common/play_button.png"));
        
        this.addEventListener(MouseEvent.ROLL_OVER, onRollOver);
        this.addEventListener(MouseEvent.ROLL_OUT, onRollOut);
        this.addEventListener(MouseEvent.CLICK, onClick);
    }
    
    private function onRollOver(e:MouseEvent):void
    {
        this.transform.colorTransform = c1;
    }
    
    private function onRollOut(e:MouseEvent):void
    {
        this.transform.colorTransform = c0;
    }
    
    private var count:int = 0;
    private function onClick(e:Event):void
    {
        label.text = "Thanks for your click ^_^";
        label.x = int((this.width - label.width) * .5);
        label.y = int((this.height - label.height) * .5) + 50;
        
        if(++count > 1) {
            this.removeChild(label);
            this.removeEventListener(MouseEvent.CLICK, onClick);
            BetweenAS3.serial(
                BetweenAS3.to(this, {rotationY: -180}, 1, Back.easeIn),
                BetweenAS3.removeFromParent(this)
            ).play();
        }
    }    
}