/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4KHq
 */

////////////////////////////////////////////////////////////////////
//CLASES
import org.papervision3d.view.Viewport3D;
import org.papervision3d.cameras.*;
import org.papervision3d.scenes.Scene3D;
import org.papervision3d.render.BasicRenderEngine;
import org.papervision3d.objects.primitives.Plane
import org.papervision3d.materials.MovieMaterial;
import org.papervision3d.materials.utils.MaterialsList;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.objects.DisplayObject3D;
 
import flash.display.Sprite;
import flash.events.*;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.media.SoundMixer;
import flash.net.URLRequest;
import flash.utils.Timer;
import flash.utils.ByteArray;
 
////////////////////////////////////////////////////////////////////
//VARIABLES
//Variables Flash
var url:String = "http://scfire-dtc-aa06.stream.aol.com:80/stream/1007";
var song:SoundChannel;
var soundFactory:Sound;
var FourierTransform:Boolean = false;
var arrayMixer:ByteArray = new ByteArray();
var pan:int = 0;
var porcentLoad:Number = 0;
//Variables 3D
var viewport:Viewport3D;
var renderer:BasicRenderEngine;
var escena:Scene3D;
var camara:FreeCamera3D;
var movieMaterial:MovieMaterial;
var plano:DisplayObject3D;
var ref_object3D:DisplayObject3D;
var calidad = 40;
var contador:Number = 0;
var xIni:Array = new Array();
var yIni:Array = new Array();
var zIni:Array = new Array();
stage.quality = StageQuality.LOW;
 
 
function Empezar(vpWidth:Number = 700, vpHeight:Number = 400):void {
    CrearPapervision(vpWidth, vpHeight);
    CrearObjetos();
    Crear3D();
    GuargarXIni();
    CrearEventos();
    CargarSong();
    PonerFrameRate();
}
 
function PonerFrameRate(){
    var FPS = new FrameRate();
    addChild(FPS);
}
function CargarSong():void {
    SoundMixer.stopAll();//Metodo de la clase SoundMixer, que nos permite detener todos los Sonidos que se esten reproduciendo
    soundFactory = new Sound();//Creamos una nueva instancia de la clase Sound
    var request:URLRequest = new URLRequest(url);//Hacemos la petición del mp3   
    //Luego asiganmos los Listener de la clase Sound();
    soundFactory.addEventListener(Event.COMPLETE, completeHandler);
    soundFactory.addEventListener(ProgressEvent.PROGRESS, progressHandler);
    soundFactory.load(request);//Cargamos la canción
}
 
function completeHandler(event:Event){
    //Una Vez que la canción se halla cargado por completo la reproducimos
    song = soundFactory.play(0,1000);//La ejecutamos
}
 
function progressHandler(event:ProgressEvent):void {
    //Mientras se carga, acutalizamos el valor de la variable porcentLoad   
    porcentLoad = Math.round((event.bytesLoaded*100)/event.bytesTotal);
}
 
//////////////////////////////////////////////////////////////////////////////////////
//FUNCIONES
//Esta función es la que invocamos al comenzar. Sería la constructora de la escena
 
//Crea los elementos necesarios de la escena PPV
function CrearPapervision(vpWidth:Number, vpHeight:Number):void {
    //Este va a ser el "contenedor" que nos va a permitir visualizar la escena. Es el
    //objeto a través del cual visualizamos la escena 3D. Hay que especificarle un ancho y un alto.
    viewport = new Viewport3D(vpWidth, vpHeight);
    addChild(viewport);
    //El renderer es el objeto que se encarga de renderizar la escena. Cada vez que se produce un cambio
    //Hay que volver a renderizar. Esto se hace en la funcion "Renderizar".
    renderer = new BasicRenderEngine();
    escena = new Scene3D();
    camara = new FreeCamera3D();
    camara.zoom = 3;
    camara.z = -1000
    camara.y = 100
}
 
//En esta función se añaden todos los objetos 3d a la escena
function Crear3D():void {
    escena.addChild(plano);
}
 
//Crea todos los objetos que queremos añadir a la escena (en este caso un cubo).
function CrearObjetos() {
    //Creo un material a partir de un clip que hay en el escenario
    var material:MovieMaterial = new MovieMaterial( Skin_mc, true, false, false );
    material.oneSide = false;
    plano = new Plane(material,1000,1000,10,10);
    plano.rotationX = 90;
}
 
//En esta función se realizan los movimientos de objetos de la escena antes de renderizar.
//En este caso muevo todos los vertices del cubo para generar el efecto de fluidez
function Mover() {
    SoundMixer.computeSpectrum(arrayMixer, true);
    var count = 0;
    for each (var vertex:Vertex3D in plano.geometry.vertices) {
        plano.geometry.vertices[count].z += (arrayMixer[count] - plano.geometry.vertices[count].z)/4
        count++;
    }
    plano.rotationY += ((mouseX - 300) - plano.rotationY)/9;
    plano.rotationX += ((mouseY - 300) - plano.rotationX)/9;
 
}
 
//Añade los eventos necesarios a la escena.
function CrearEventos():void {
    addEventListener(Event.ENTER_FRAME, Renderizar);
}
 
//Esta función la he hecho para guardar las coordenadas iniciales de todos los puntos del
//cubo que he creado para el efecto.
function GuargarXIni() {
    var count = 0;
    for each (var vertex:Vertex3D in plano.geometry.vertices){
        plano.geometry.vertices[count].z += 100 - Math.random()*200;
        zIni.push(plano.geometry.vertices[count].z);
        count++;
    }
}
 
//Hace los cambios necesarios en la escena a través de la función mover, y después
//renderiza la escena.
function Renderizar(e:Event):void {
    Mover();
    renderer.renderScene(escena, camara, viewport);
}
 
////////////////////////////////////////////////////////////////////////////////////////
//Empezamos
 
Empezar();