/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4KAM
 */

// forked from kuroclef's ゲージ増加量
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    
    public class Main extends Sprite {
        public const GAUGE_CONSTANT_A:Number = -7.46035e-4;
        public const GAUGE_CONSTANT_B:Number = 1.46138;
        
        private var textField:TextField;
        
        public function Main():void {
            textField = new TextField();
            textField.autoSize = "left";
            for (var i:int = 1000, n:int = 3000; i <= n; i += 100) {
                textField.appendText(i + " Notes: " + calc(i) + "\n");
            }
            
            textField.appendText("\n");
            textField.appendText("10 Notes: " + calc(10) + "\n");
            textField.appendText("100 Notes: " + calc(100) + "\n");
            textField.appendText("\n");
            textField.appendText("1957 Notes: " + calc(1957) + "\n");
            textField.appendText("1958 Notes: " + calc(1958) + "\n");
            textField.appendText("1959 Notes: " + calc(1959) + "\n");
            textField.appendText("1960 Notes: " + calc(1960));
            addChild(textField);
        }
        
        private function calc(n:int):Number {
            var t:Number;
            if (n >= 363) {
                t = (7.605 * n / (0.01 * n + 6.5));
            } else {
                t = (200 + (n / 5));
            }
            if (t < 200) t = 200;
            
            return t / n;
        }

    }
}