/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Jjw
 */

// forked from codeonwort's flash on 2012-1-4
package {
    
    import flash.display.Sprite
    import flash.events.MouseEvent
    import flash.events.Event
    
    // CLICK THE SCREEN
    
    public class Main extends Sprite {
        
        public function Main() {
            stage.frameRate = 60
            stage.addEventListener("mouseDown", md)
            stage.addEventListener("mouseUp", mu)
        }
        
        private function md(e:MouseEvent):void {
            addEventListener("enterFrame", ef)
        }
        private function mu(e:MouseEvent):void {
            removeEventListener("enterFrame", ef)
        }
        
        private function ef(e:Event):void {
            makeProj()
            makeProj()
            makeProj()
            makeProj()
            makeProj()
        }
        
        private function makeProj():void {
            var x0:Number = stage.stageWidth / 2
            var y0:Number = stage.stageHeight / 2
            var vx0:Number = (Math.random() - .5) * x0 * 4
            var vy0:Number = (Math.random() - .5) * y0 * 4
            var tp:TimedProjectile = new TimedProjectile(x0, y0, mouseX, mouseY, vx0, vy0)
            addChild(tp)
        }
        
    }
    
}

//package codeonwort.motion {
    
    import flash.geom.Point
    
    //public
    internal class ProjectileMotion {
        
        public var x0:Number, y0:Number
        public var x1:Number, y1:Number
        public var vx0:Number, vy0:Number
        
        private var ax:Number, ay:Number
        
        public function ProjectileMotion(x0:Number=0,y0:Number=0,
                                                    x1:Number=0,y1:Number=0,
                                                    vx0:Number=0,vy0:Number=0) {
            // constructor code
            start(x0, y0)
            end(x1, y1)
            velocity0(vx0, vy0)
        }
        
        public function start(x0:Number, y0:Number):void {
            this.x0 = x0
            this.y0 = y0
            precalc()
        }
        
        public function end(x1:Number, y1:Number):void {
            this.x1 = x1
            this.y1 = y1
            precalc()
        }
        
        public function velocity0(vx0:Number, vy0:Number):void {
            this.vx0 = vx0
            this.vy0 = vy0
            precalc()
        }
        
        private function precalc():void {
            ax = 2 * (x1 - x0 - vx0)
            ay = 2 * (y1 - y0 - vy0)
        }
        
        public function x(t:Number):Number {
            return x0 + vx0*t + 0.5*ax*t*t
        }
        public function y(t:Number):Number {
            return y0 + vy0*t + 0.5*ay*t*t
        }
        public function xy(t:Number):Point {
            var t2:Number = t * t
            return new Point(x0 + vx0*t + 0.5*ax*t2, y0 + vy0*t + 0.5*ay*t2)
        }

    }
    
//}

import flash.display.Shape
import flash.events.Event
internal class TimedProjectile extends Shape {
    
    private var p:ProjectileMotion
    private var prevx:Number, prevy:Number
    private var t:Number = 0
    
    public function TimedProjectile(x0:Number,y0:Number, x1:Number,y1:Number, vx0:Number,vy0:Number) {
        p = new ProjectileMotion(x0, y0, x1, y1, vx0, vy0)
        prevx = x0
        prevy = y0
        addEventListener("enterFrame", ef)
    }
    
    private function ef(e:Event):void {
        var newX:Number, newY:Number
        newX = p.x(t)
        newY = p.y(t)
        
        // draw
        graphics.clear()
        graphics.lineStyle(2, 0x0)
        graphics.moveTo(prevx, prevy)
        graphics.lineTo(newX, newY)
        
        prevx = newX
        prevy = newY
        
        t += 0.03
        if(t > 1){
            removeEventListener("enterFrame", ef)
            parent.removeChild(this)
        }
    }
    
}