/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4J4e
 */

// forked from lanaxuexihanyu's forked from: Tetris test
// forked from Cheshir's Tetris test
package {
    import flash.geom.Point;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.text.TextField;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var canvas:Bitmap;
        private var theme:uint = 0x9EFF30;    // Яркий
        private var sub_theme1:uint = 0x2D490E;    // Темный
        private var sub_theme2:uint = 0x5A911B;    // Средний
        
        private var points:uint =0;
        private var field:Array = [];
        private var rows:Array = [];
        
        private var pointsField:TextField = new TextField();
        private var freeBlock:Sprite = new Sprite();    // 1
        private var conectBlock:Sprite = new Sprite();    // 2
        private var deadBlock:Sprite = new Sprite();        // 3
        private var immortalBlock:Sprite = new Sprite();    //  4 
        // Зато пусть они будут управляемы... и взрываются при нажатии...
        private var boombs:uint = 3;
        
        private var timeUpdate:Timer = new Timer(50);
        
        public function FlashTest() {
            // write as3 code here..
            // Так ну окей, еще нужен подсчет очков...
            theme = 0x0086FE;
            sub_theme1 = 0x003E75;
            sub_theme2 = 0x0061B8;
            colorTr = new ColorTransform(0.9,0.9,1);
            
            pointsField.autoSize = 'left';
            pointsField.textColor = theme;
            pointsField.text = '0';
            pointsField.filters = [new GlowFilter(0)];
            
            this.graphics.beginFill(0);
            this.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            canvas = new Bitmap( new BitmapData(stage.stageWidth, 
                                        stage.stageHeight, true, 0) );
            canvas.x = 20; canvas.y = 20;
            addChild(canvas);
            freeBlock.graphics.lineStyle(2,theme);
            freeBlock.graphics.beginFill(sub_theme1);
            freeBlock.graphics.drawRect(0,0,10,10);
            freeBlock.graphics.endFill();
            freeBlock.graphics.lineStyle();
            freeBlock.graphics.beginFill(sub_theme2);
            freeBlock.graphics.drawRect(3,3,4,4);
            freeBlock.graphics.endFill();
            
            conectBlock.graphics.lineStyle(2,theme);
            conectBlock.graphics.beginFill(sub_theme1);
            conectBlock.graphics.drawRect(0,0,10,10);
            conectBlock.graphics.beginFill(theme);
            conectBlock.graphics.drawRect(3,3,4,4);
            conectBlock.graphics.endFill();
            
            deadBlock.graphics.lineStyle(2, theme);
            deadBlock.graphics.beginFill(sub_theme1);
            deadBlock.graphics.drawRect(0,0,10,10);
            deadBlock.graphics.endFill();
            
            immortalBlock.graphics.lineStyle(2,theme);
            immortalBlock.graphics.drawRect(0,0,10,10);
            immortalBlock.graphics.lineStyle();
            immortalBlock.graphics.beginFill(sub_theme2);
            immortalBlock.graphics.drawRect(3,3,4,4);
            immortalBlock.graphics.endFill();
            
            for(var tx:int=0; tx<42; tx++){
                field.push(new Array());
                rows.push(0);    // Значение строк, чтобы отслеживать очки.
                for(var ty:int=0; ty<42; ty++){    // 0 - пусто
                    field[tx][ty]=0;                // 1 - падающий блок
                }                                    // 2 - статичный блок
            }
            addEventListener(Event.ENTER_FRAME, redraw);
            timeUpdate.addEventListener(TimerEvent.TIMER, tickGame);
            timeUpdate.start();
            stage.addEventListener(KeyboardEvent.KEY_DOWN, correct);
            stage.addEventListener(MouseEvent.CLICK, boomThis);
        }
        private function boomThis(e:MouseEvent):void {
            var mx:int = Math.floor((mouseX-20)/10);
            var my:int = Math.floor((mouseY-20)/10);
            if(field[mx][my]==4 && boombs>0){
                field[mx-1][my-1]=0; field[mx][my-1]=0; field[mx+1][my-1]=0;
                field[mx-1][my]=0; field[mx][my]=0; field[mx+1][my]=0;
                field[mx-1][my+1]=0; field[mx][my+1]=0; field[mx+1][my+1]=0;
                boombs--;
            }
        }

        // Двигаем все кубики влево или вправо... 
        private var pointCell:Point = new Point();
        private function correct(e:KeyboardEvent):void {
            if(e.keyCode == Keyboard.LEFT){
                for(pointCell.x=0; pointCell.x < field.length; pointCell.x++){
                    for(pointCell.y=field[0].length-1; pointCell.y > 0; pointCell.y--){ // Так теперь...
                        if(field[pointCell.x][pointCell.y]!=0 && pointCell.x>0){
                            // Если слева пустая клетка... то перемещаем левее...
                            if(field[pointCell.x-1][pointCell.y]==0){
                                if(field[pointCell.x][pointCell.y]==1){
                                    field[pointCell.x-1][pointCell.y]=1;
                                    field[pointCell.x][pointCell.y]=0;
                                } else if(field[pointCell.x][pointCell.y]==4){
                                    field[pointCell.x-1][pointCell.y]=4;
                                    field[pointCell.x][pointCell.y]=0;
                                }
                            }
                        }
                    }
                }
            } else if(e.keyCode == Keyboard.RIGHT){
                for(pointCell.x=field.length-1; pointCell.x >= 0; pointCell.x-- ){
                    for(pointCell.y=field[0].length-1; pointCell.y > 0; pointCell.y-- ){
                        if(field[pointCell.x][pointCell.y]!=0 && pointCell.x < field.length-1){
                            if(field[pointCell.x+1][pointCell.y]==0){
                                if(field[pointCell.x][pointCell.y]==1){
                                    field[pointCell.x+1][pointCell.y]=1;
                                    field[pointCell.x][pointCell.y]=0;
                                } else if(field[pointCell.x][pointCell.y]==4){
                                    field[pointCell.x+1][pointCell.y]=4;
                                    field[pointCell.x][pointCell.y]=0;
                                }
                            }
                        }
                    }
                }
            } else if(e.keyCode == Keyboard.DOWN){
                for(pointCell.x=0; pointCell.x < field.length; pointCell.x++){
                    for(pointCell.y=0; pointCell.y < field[0].length; pointCell.y++){
                        if(field[pointCell.x][pointCell.y]== 4 && field[pointCell.x][pointCell.y+1] == 0 ){
                            field[pointCell.x][pointCell.y+1] = 4;
                            field[pointCell.x][pointCell.y] = 0;
                        }
                    }
                }
            } else if(e.keyCode == Keyboard.UP){
                for(pointCell.x=0; pointCell.x < field.length; pointCell.x++){
                    for(pointCell.y=0; pointCell.y < field[0].length; pointCell.y++){
                        if(field[pointCell.x][pointCell.y]== 4 && field[pointCell.x][pointCell.y-1] == 0){
                            field[pointCell.x][pointCell.y-1] = 4;
                            field[pointCell.x][pointCell.y] = 0;
                        }
                    }
                }
            }
        }
// Шаг игры...
        private var counter:int = 0;
        private var count100:int = 0;
        private function tickGame(e:TimerEvent):void {
            counter++;
            if(counter==10){ // Каждые 10 шагов добавляются блоки
                counter=0;
                var xpos:int = int(Math.random()*42+1);
                // Хочется больше разнообразия...
                var size:int = Math.round(Math.random()*4*Math.random());
                for(var si:int=0; si<size; si++){
                    field[xpos+si][1] = 1;
                }
                //field[xpos-1][1] = 1;
                // блоки по 2 единички...
            }
            for(var tx:int=field.length-1; tx>=0; tx--){
                for(var ty:int=field[0].length-1; ty>0; ty--){
                    // тут мы обновим положения снизу вверх...
                    // нужно проверить нет ли пустого места и если есть, то двинуть вниз...
                    if(field[tx][ty]==1 && field[tx][ty+1]==0){
                        field[tx][ty]=0;
                        field[tx][ty+1]=1;
                    } else if(field[tx][ty]==1 && field[tx][ty+1]!=0){ // Фиксация блока...
                        field[tx][ty]=Math.round(2+Math.random()*0.6);
                    }
                }
            }
            // Обнулим массив рядов
            for(var nr:int=0; nr<rows.length; nr++){
                rows[nr]=0;
            }
            // Запишем ряды которые набрали 42 кубика
            for(var zx:int=0; zx<field.length; zx++){    // Это колонка
                for(var zy:int=0; zy<field[0].length; zy++){    // Это ряд...
                    if(field[zx][zy]!=0){
                        rows[zy]++;
                    }
                }
            }
            for(var r:int=0; r<rows.length; r++){
                if(rows[r]==42){    // Ряд собран
                    for(var rx:int=0; rx<42; rx++){ // очищаем ряд... ну и можно наверное очков начислить...
                        if(field[rx][r]!=4){
                            points ++;
                            count100 ++;
                            if(count100>=100){
                                boombs++;
                                count100-=100;
                            }
                        }
                        if(field[rx][r]==3){    // 3 станет неубиваемым...
                           field[rx][r]=4;
                        } else {
                            field[rx][r] = 0;
                        }
                        pointsField.x = stage.stageWidth/2-pointsField.width/2;
                    }    // По идее нужно еще превратить все 2 в 1...
                    rows[r]=0;
                    for(var fx:int=0; fx<field.length; fx++){    // Обновляем падение
                        for(var fy:int=0; fy<field[0].length; fy++){
                            if(field[fx][fy]==2){
                                field[fx][fy]=1;
                            }
                        }
                    }
                }
                if(rows[r]>=5 && r == 1){
                    pointsField.text = points+' - game over';
                    timeUpdate.stop();
                    pointsField.y = stage.stageHeight/3;
                    pointsField.x = stage.stageWidth/2 - pointsField.width/2;
                    addChild(pointsField);
                }
            }
        }

// Тут у нас банально отрисовка и всякая красотулька..
        private var m:Matrix = new Matrix();
        private var c:ColorTransform = new ColorTransform(0.9,1,1,0.9);
        private function redraw(e:Event):void {
            //canvas.bitmapData.fillRect(canvas.bitmapData.rect,0x1a000000);
            // colorTransform(bit.rect, new ColorTransform(1, 1, 1, 0.96, red, green, blue, 0));
            canvas.bitmapData.colorTransform(canvas.bitmapData.rect, c);
            for(var tx:int=0; tx<field.length; tx++){
                for(var ty:int=0; ty<field[0].length; ty++){
                    m.tx = tx*10;
                    m.ty = ty*10;
                    if(field[tx][ty]==1){
                        canvas.bitmapData.draw(freeBlock, m);
                    } else if(field[tx][ty]==2){
                        canvas.bitmapData.draw(conectBlock, m);
                    } else if(field[tx][ty]==3){
                        canvas.bitmapData.draw(deadBlock, m);
                    } else if(field[tx][ty]==4){
                        canvas.bitmapData.draw(immortalBlock, m);
                    }
                }
            }
            pointsField.text = points+' you can blow up the moving unit '+boombs;
            canvas.bitmapData.draw(pointsField);
        }
        
    }
}
