/**
 * Copyright yonedashigeru ( http://wonderfl.net/user/yonedashigeru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4IyS
 */

// forked from checkmate's Checkmate vol.5 Sponser
package {
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.net.*;
	import flash.system.*;
	import jp.progression.commands.*;
	import jp.progression.commands.lists.*;
	import jp.progression.commands.display.*;
	import jp.progression.commands.net.*;
	import jp.progression.commands.tweens.*;
	import jp.progression.events.*;
	
	import caurina.transitions.*;
	public class Sponser extends Sprite {
		public static var GRAPHICS_URL:String = "http://swf.wonderfl.net/static/assets/checkmate05/humanSponser.swf";
		
		public var birthMotion:MovieClip;
		public var walkMotion:MovieClip;
		public var flyJumpMotion:MovieClip;
		public var turnLeftMotion:MovieClip;
		public var turnRightMotion:MovieClip;
		public var danceMotion:MovieClip;
		public var sitDownMotion:MovieClip;
		public var standUpMotion:MovieClip;
		public var quardMotion:MovieClip;
		public var takeShitMotion:MovieClip;
		public var deathMotion:MovieClip;
		public function Sponser(){
			super();
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var com:SerialList = new SerialList();
			com.addCommand(
				new LoadSWF( new URLRequest( GRAPHICS_URL ) ),
				function():void {
					var loader:Loader = Loader( this.latestData );
					var domain:ApplicationDomain = loader.contentLoaderInfo.applicationDomain;
					
					birthMotion = new ( domain.getDefinition( "BirthMotion" ) as Class );
					walkMotion = new ( domain.getDefinition( "WalkMotion" ) as Class );
					flyJumpMotion = new ( domain.getDefinition( "FlyMotion" ) as Class );
					turnLeftMotion = new ( domain.getDefinition( "TurnLeftMotion" ) as Class );
					turnRightMotion = new ( domain.getDefinition( "TurnRightMotion" ) as Class );
					danceMotion = new ( domain.getDefinition( "DanceMotion" ) as Class );
					sitDownMotion = new ( domain.getDefinition( "SitDownMotion" ) as Class );
					standUpMotion = new ( domain.getDefinition( "StandUpMotion" ) as Class );
					quardMotion = new ( domain.getDefinition( "QuardMotion" ) as Class );
					//takeShitMotion = new ( domain.getDefinition( "TakeShitMotion" ) as Class );
					deathMotion = new ( domain.getDefinition( "DeathMotion" ) as Class );
				}
			);
			com.addEventListener(ExecuteEvent.EXECUTE_COMPLETE,onLoadSWF);
			com.execute();
		}
		private function onLoadSWF(e:Event):void {
			var motionList:Array = [
				birthMotion,
				walkMotion,
				flyJumpMotion,
				turnLeftMotion,
				turnRightMotion,
				danceMotion,
				sitDownMotion,
				standUpMotion,
				quardMotion,
				//takeShitMotion,
				deathMotion
			];
			
			var hNum:int = 4;
			var cnt:int = 0;
			for each( var motion:MovieClip in motionList ) {
				addChild(motion);
				motion.x = cnt%hNum * 100 + 90;
				motion.y = Math.floor(cnt/hNum) * 140  + 150;
				
				motion.gotoAndStop(1);
				motion.addEventListener( MouseEvent.CLICK, clickHandler );
				motion.buttonMode = motion.useHandCursor = true;
				
				motion.scaleX = motion.scaleY = 0.5;
				
				cnt++;
			}
		}
		private function clickHandler(e:Event):void {
			var motion:MovieClip = e.currentTarget as MovieClip;
			
			motion.gotoAndPlay(1);
		}
	}
}