/**
 * Copyright atsumo ( http://wonderfl.net/user/atsumo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4IxB
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _ball:Ball;
        private var _count:int;
        private const A:int = 100;
        private const B:int = 50;
        public function FlashTest() {
            // write as3 code here..
            intialize();
        }
        
        private function intialize():void
        {
            _ball = new Ball();
            addChild(_ball);
            addEventListener(Event.ENTER_FRAME, handleEnterFrame);
        }
        
        private function handleEnterFrame(e:Event):void
        {
            _ball.x = A*Math.sin((++_count / 10)) + (stage.stageWidth - _ball.width)/2;
            _ball.y = B*Math.cos(2*(_count / 10) + Math.PI / 4) + (stage.stageHeight - _ball.height) /2;
        }


    }
}
import flash.display.Graphics;
import flash.display.Sprite;

class Ball extends Sprite
{
    private var _color:uint;
    private var _radius:int;
    
    public function Ball(color:uint = 0xFF0000, radius:int = 10)
    {
        _color = color;
        _radius = radius;
        draw();
    }
    
    private function draw():void
    {
        var g:Graphics = this.graphics;
        g.clear();
        g.beginFill(_color, 1);
        g.drawCircle(0,0,_radius);
        g.endFill();
    }
    
    internal function set color(value:uint):void
    {
        _color = value;
        draw();
    }
    
    internal function set radius(value:int):void
    {
        _radius = value;
        draw();
    }


}
