/**
 * Copyright goldsource ( http://wonderfl.net/user/goldsource )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4IRR
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    
    [SWF(backgroundColor="#000000", frameRate="100")]
    
    /**
     * FunWithColors
     * <p>Random shapes by random movement</p>
     * @author Nicholas Schreiber
     * @version 1  
     * @see FunWithColors.FunWithColors();
     * @see IBrush
     * @see Cursor
     **/
    public class FunWithColors extends Sprite
    {        
        
        // CONF ///////////////////////////////////////////////////////////////////////
        
        /**
         * Screen Height
         **/
        private static const WIDTH:int = 465;
        
        /**
         * Screen Width
         **/
        private static const HEIGHT:int = 465;
        
        /**
         * Background Color
         **/
        private static const BG_COLOR:int = 0x0;
        
        /**
         * amount of cursors
         **/
        private static const CURSORS:uint = 12;
        
        /**
         * color of cursors
         **/
        private static const CURSOR_COLOR:int = 0xFFFFFF;
        
        /**
         * screen Upscale used to blur
         **/
        private static const SCALE:uint = 4;
        
        /**
         * The selected Brush (0-3) 0=PointBrush, 1=XBrush, 2=PlusBrush, 3=SquareBrush
         * @see IBrush;
         * */
        private static const SELECTED_BRUSH:uint = 1; 
        
        
        // DECL ///////////////////////////////////////////////////////////////////////
        
        /**
         * implemented brushes
         * @see IBrush;
         * @see FunWithColors.SELECTED_BRUSH;
         * */
        private var __brushes:Vector.<Class> = new <Class>[PointBrush,XBrush,PlusBrush,SquareBrush];
        
        /**
         * the main screen
         * */
        private var __screen:Bitmap = new Bitmap(new BitmapData(WIDTH/SCALE,HEIGHT/SCALE,false,BG_COLOR),PixelSnapping.AUTO,true);
        
        /**
         * Cursor Layer
         * */
        private var __cursorScreen:Bitmap = new Bitmap(new BitmapData(WIDTH/SCALE,HEIGHT/SCALE,false,BG_COLOR),PixelSnapping.AUTO,true);
        
        /**
         * The cursor Instances
         * */
        private var __cursors:Vector.<Cursor> = new Vector.<Cursor>;
        
        
        // LOGIC ///////////////////////////////////////////////////////////////////////
        
        /**
         * Fun With Colors
         * @see FunWithColors
         * */
        public function FunWithColors()
        {
            super();
            var brush:IBrush = new __brushes[SELECTED_BRUSH](); // Instantiate selected brush
            for(var i:uint=0;i<CURSORS;i++)__cursors.push(new Cursor( int((Math.random()*WIDTH/SCALE)/2)*2,int((Math.random()*HEIGHT/SCALE)/2)*2,Math.random()*0xFFFFFF,brush)); // add cursors
            addChild(__screen); // append screen
            addChild(__cursorScreen); // append cursor layer
            __cursorScreen.blendMode = BlendMode.ADD; // Setting Cursor Layer blend mode
            __cursorScreen.scaleX = __cursorScreen.scaleY = __screen.scaleX = __screen.scaleY = SCALE; // Upscaling
            addEventListener(Event.ENTER_FRAME,__onEnterFrame); // and action
        }
        
        /**
         * Event Listener containing Main Render Procedure
         * @param $e Event dispatched displayObject
         * */
        private function __onEnterFrame($e:Event):void{
            __cursorScreen.bitmapData.applyFilter(__cursorScreen.bitmapData,__cursorScreen.bitmapData.rect,new Point(),new BlurFilter(1.1,1.1,3)); // blur fade the cursor layer
            for each(var cursor:Cursor in __cursors){ // run through the colors
                cursor.brush.draw(__screen.bitmapData,cursor.x,cursor.y,cursor.color); // drawing using brush
                if(cursor.x > 1 && cursor.x < WIDTH/SCALE-1){ // if cursor within horizontal boundaries
                    cursor.x +=(Math.random()>.5)?1:-1; // random horizontal Movement (x-Pattern -1 or 1)
                }else if(cursor.x<=1){
                    cursor.x +=1; // force dir
                }else{
                    cursor.x -=1; // force dir
                }
                if(cursor.y > 1 && cursor.y < HEIGHT/SCALE-1){ // if cursor within vertical boundaries        
                    cursor.y +=(Math.random()>.5)?1:-1; // random vertical Movement (x-Pattern -1 or 1)
                }else if(cursor.y<=1){
                    cursor.y +=1; // force dir
                }else{
                    cursor.y -=1; // force dir
                }
                __cursorScreen.bitmapData.setPixel(cursor.x,cursor.y,CURSOR_COLOR); // draw the cursor
            }
        }
    }
}

import flash.display.BitmapData;


// BRUSHES ///////////////////////////////////////////////////////////////////////

/**
 * Brush interface
 * only requires draw Method to be implemented
 * @see FunWithColors
 * @see Cursor
 * */
internal interface IBrush{        
    /**
     * @param $bitmapData Some BitmapData as canvas
     * @param $x horizontal center
     * @param $y vertical center
     * @param $color base color
     * */
    function draw($bitmapData:BitmapData,$x:uint,$y:uint,$color:uint):void        
}

/**
 * XBrush
 * @see IBrush
 * @see IBrush.draw()
 * */
internal class XBrush implements IBrush{
    /**
     * Draws a X Shape
     * @see IBrush
     * @see IBrush.draw()
     * */
    public function draw($bitmapData:BitmapData,$x:uint,$y:uint,$color:uint):void{
        $bitmapData.setPixel($x,$y,$color);    
        $bitmapData.setPixel($x+1,$y+1,$color);
        $bitmapData.setPixel($x+1,$y-1,$color);
        $bitmapData.setPixel($x-1,$y-1,$color);
        $bitmapData.setPixel($x-1,$y+1,$color);        
    }
}

/**
 * PlusBrush
 * @see IBrush
 * @see IBrush.draw()
 * */
internal class PlusBrush implements IBrush{
    /**
     * Draws a Plus Shape
     * @see IBrush
     * @see IBrush.draw()
     * */
    public function draw($bitmapData:BitmapData,$x:uint,$y:uint,$color:uint):void{
        $bitmapData.setPixel($x,$y,$color);    
        $bitmapData.setPixel($x,$y+1,$color);
        $bitmapData.setPixel($x,$y-1,$color);
        $bitmapData.setPixel($x+1,$y,$color);
        $bitmapData.setPixel($x-1,$y,$color);        
    }
}

/**
 * PointBrush
 * @see IBrush
 * @see IBrush.draw()
 * */
internal class PointBrush implements IBrush{
    /**
     * Draws a pixel
     * @see IBrush
     * @see IBrush.draw()
     * */
    public function draw($bitmapData:BitmapData,$x:uint,$y:uint,$color:uint):void{
        $bitmapData.setPixel($x,$y,$color);    
    }
}

/**
 * SquareBrush
 * @see IBrush
 * @see IBrush.draw()
 * */
internal class SquareBrush implements IBrush{
    /**
     * Draws a Square 
     * @see IBrush
     * @see IBrush.draw()
     * */
    public function draw($bitmapData:BitmapData,$x:uint,$y:uint,$color:uint):void{
        $bitmapData.setPixel($x-1,$y-1,$color);    
        $bitmapData.setPixel($x,$y-1,$color);    
        $bitmapData.setPixel($x+1,$y-1,$color);    
        $bitmapData.setPixel($x-1,$y,$color);    
        $bitmapData.setPixel($x+1,$y,$color);    
        $bitmapData.setPixel($x-1,$y+1,$color);    
        $bitmapData.setPixel($x,$y+1,$color);    
        $bitmapData.setPixel($x+1,$y+1,$color);    
    }
}


// CURSOR ///////////////////////////////////////////////////////////////////////

/**
 * Cursor DO
 * @see IBrush
 * @see FunWithColors
 * */
internal class Cursor{
    public var x:uint;
    public var y:uint;
    public var color:uint;
    public var brush:IBrush;
    public function Cursor($x:uint,$y:uint,$color:uint,$brush:IBrush):void{
        x = $x;
        y = $y;
        color = $color;
        brush = $brush;
    }
}