/**
 * Copyright Fricks ( http://wonderfl.net/user/Fricks )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4HEt
 */

package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.text.TextFieldAutoSize;
	import flash.events.Event;
	
	public class textFieldColumn extends Sprite {
		
		public function textFieldColumn()	{
			addEventListener(Event.ADDED_TO_STAGE,init);
		}
		
		private function init(e:Event):void {	
			removeEventListener(Event.ADDED_TO_STAGE,init);
			
			var txt:String="あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやいゆえよらりるれろわをん1 あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやいゆえよらりるれろわをん2 あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやいゆえよらりるれろわをん3 あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやいゆえよらりるれろわをん4"						;
			
			var format = new TextFormat();
			format.align = TextFormatAlign.JUSTIFY;
			format.font = "_ゴシック";
			format.size = 12;
			format.color = 0x000000;
			format.leading = 5;
			
			var column1 = new TextField();
			column1.defaultTextFormat = format;
			column1.x=15;
			column1.y=15;
			column1.width = (stage.stageWidth-30)*0.5;
			column1.autoSize = TextFieldAutoSize.LEFT;
			column1.wordWrap = true;
			column1.multiline = true;
			
			var column2 = new TextField();
			column2.defaultTextFormat = format;
			column2.x=15+(stage.stageWidth-30)*0.5+15;
			column2.y=15;
			column2.width = (stage.stageWidth-30)*0.5;
			column2.autoSize = TextFieldAutoSize.LEFT;
			column2.wordWrap = true;
			column2.multiline = true;
			column1.text = txt;
			
			var MAX_LINE:uint = Math.ceil(column1.numLines/2);
			var count = (txt.length*0.6)>>0;
			
			while(MAX_LINE<column1.numLines){	
				count--;	
				var cuttext = txt.substr(0,count);
				column1.text = cuttext;
			}
			
			column2.text = txt.substr(count,txt.length);
			
			addChild(column1);
			addChild(column2);
		}
	}
}