/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4H5C
 */






package {
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.filters.GlowFilter;
    import flash.geom.Rectangle;
    import com.bit101.components.*;
    import flash.events.Event;
    import flash.display.*;
    public class FlashTest extends Sprite {
        public var dots:Array = [];
        public var r:Rectangle = new Rectangle( 10, 10, 445, 420 );
        public var canvas:Sprite = new Sprite();
        public var target:Object;
        
        public function FlashTest() {
            addChild( new Bitmap( new BitmapData(465,465,false,0x111111) ) )
            addChild( canvas );
            var dot:Dot;
            
            for( var i:int = 0; i < 2; i++ ){
                dot = new Dot( 0xFF0000 );
                canvas.addChild( dot )
                dots.push( dot );
            }
            for( i = 0; i < 4; i++ ){
                dot = new Dot();
                dot.move( int( r.x + r.width* Math.random() ), int( r.y + r.height*Math.random() ) );
                dot.addEventListener( "mouseDown", start );
                dot.addEventListener( "mouseUp", stop );
                stage.addEventListener( "mouseMove", move );
                dot.buttonMode = true;
                canvas.addChild( dot );
                dots.push( dot );
            }
            
            update();
        }
        
        private function update():void{
            var g:Graphics = canvas.graphics;
            g.clear();
            var d:Dot;
            
            for( var i:int = 2; i < 6; i++ ){
                g.lineStyle( 3, [0x6666CC,0x66CC66][(i >> 1)-1], 1 );
                d = dots[i++];
                g.moveTo( d.x, d.y );
                d = dots[i];
                g.lineTo( d.x, d.y );
            }
            g.lineStyle( 3, 0x66CC66, 1 );
            d = dots[2];
            var r:Number = GeomUtil.distance( d.x, d.y, dots[3].x, dots[3].y )
            g.drawCircle( d.x, d.y, r );
            var ps:Vector.<Point> = GeomUtil.lineXCircle( 
                                            dots[4].x, dots[4].y,
                                            dots[5].x, dots[5].y,
                                            dots[2].x, dots[2].y, r);
            
            var pl:int = ps.length
            for( i = 0; i < pl; i++ ){
                var p:Point = ps[i]
                d = dots[i];
                d.visible = true;
                d.move( p.x, p.y );
                var div:Number = GeomUtil.divideRate( 
                                            dots[4].x, dots[4].y,
                                            dots[5].x, dots[5].y,
                                            d.x, d.y );
                if( 0 < div && div < 1 ){ d.alpha = 1; }
                else{ d.alpha = 0.5; }
            }for( ; i < 2; i++ ){
                d = dots[i];
                d.visible = false;
            }
        }
        
        private function start(e:Event):void{ 
            target = e.target;        
        }
        private function move(e:Event):void{ 
            if( target ){
                target.move( mouseX, mouseY );
                update();
            }          
        }
        
        private function stop(e:Event):void{
            target = null;
        }
    }
}
import flash.geom.Matrix;
import flash.text.AntiAliasType;

import flash.events.Event;
import flash.geom.Point;
import flash.display.Graphics;
import flash.display.Sprite;
import com.bit101.components.*;

class Dot extends Sprite{
    private var lbl:Label;
    function Dot( color:uint = 0x00FF00){
        var g:Graphics = graphics;
        g.beginFill( color, 1 );
        g.drawRect( -5, -5, 10, 10 );
        Style.LABEL_TEXT = 0xBB6666;
        lbl = new Label( this, 0, 0, "" )
        lbl.textField.antiAliasType = AntiAliasType.ADVANCED;
        move(x,y);
    }
    public function move(x:Number,y:Number):void{
        this.x = x; this.y = y; lbl.text = "(" + x.toFixed(1) + "," + y.toFixed(1) + ")";
    }
}

class GeomUtil{
    /** 三角形の面積 */
    static public function triangleSum( 
                                            ax:Number, ay:Number,
                                            bx:Number, by:Number, 
                                            cx:Number, cy:Number ):Number{
        var s:Number = 0.5 * ((cy-ay)*(bx-ax)-(cx-ax)*(by-ay)) 
        return s>0?s:-s;
    }
    /** 線分の交差判定 */
    static public function segmentHitTest( 
                                            sx1:Number, sy1:Number,
                                            ex1:Number, ey1:Number, 
                                            sx2:Number, sy2:Number, 
                                            ex2:Number, ey2:Number ):Boolean{
        var cx:Number, cy:Number, dx:Number, dy:Number;
        var r:Number = ( cx = sx1 - ex1 ) * ( dy = sy2 - ey2 ) - ( cy = sy1 - ey1 ) * ( dx = sx2 - ex2 );
        if( r == 0 ){ return false; }
        var ax:Number = sx1 - sx2;
        var ay:Number = sy1 - sy2;
        var s:Number = (dy * ax - dx * ay ) / r
        var t:Number = (cy * ax - cx * ay ) / r
        if( 0 <= t && t < 1 && 0 <= s  && s < 1 ){ return true; }
        return false;
    }
    
    /** 二つの直線の交点 */
    static public function lineXLine( 
                                            sx1:Number, sy1:Number,
                                            ex1:Number, ey1:Number, 
                                            sx2:Number, sy2:Number, 
                                            ex2:Number, ey2:Number ):Point{
        var cx:Number, cy:Number, dx:Number, dy:Number;
        var r:Number = ( cx = sx1 - ex1 ) * ( dy = sy2 - ey2 ) - ( cy = sy1 - ey1 ) * ( dx = sx2 - ex2 );
        if( r == 0 ){ return null; }
        var ax:Number = sx1 - sx2;
        var ay:Number = sy1 - sy2;
        var s:Number = (dx * ay - dy * ax) / r;
        return new Point( sx1 + s * cx, sy1 + s * cy ) ;
    }
    
    /** 直線と円の交点 */
    static public function lineXCircle( 
                                            sx:Number, sy:Number,
                                            ex:Number, ey:Number, 
                                            x:Number, y:Number, r:Number ):Vector.<Point>{
        var vec:Vector.<Point> = new Vector.<Point>;
        var p:Point = perpendicular( sx, sy, ex, ey, x, y );
        var dx:Number, dy:Number, px:Number, py:Number;
        var d:Number = (dx = x - (px = p.x)) * dx + (dy = y - (py = p.y)) * dy;
        var r2:Number = r * r 
        if( d == r2 ){ 
            vec.push( new Point(px, py) ); 
        }else if( d < r2 ){
            var ab:Number = Math.sqrt( (dx = sx - ex) * dx + (dy = sy - ey) * dy );
            d = Math.sqrt( r2 - d );
            dx = d * (dx / ab);
            dy = d * (dy / ab);
            vec.push( new Point( px + dx, py + dy), new Point( px - dx, py - dy) ); 
        }
        return vec;
    }
    
    /** 直線ABと点Cからの垂線の交点 */
    static public function perpendicular( 
                                            ax:Number, ay:Number,
                                            bx:Number, by:Number, 
                                            cx:Number, cy:Number ):Point {
        var dx:Number, dy:Number;
        var al:Number = (dx = bx - ax) * dx + (dy = by - ay) * dy;
        if( al == 0 ){ return null; }
        var k:Number = - (dx * (ax - cx) + dy * (ay - cy)) / al
        return new Point( k * dx + ax, k * dy + ay );
    }
    
    
    /** 線分ABの内分点(0<r<1)、外分点(r<0,1<r) */
    static public function divide(
                                            ax:Number, ay:Number,
                                            bx:Number, by:Number,
                                            r:Number = 0.5):Point {
        return new Point( ax + r * (bx - ax), ay + r * (by - ay) );
    }
    /** AC/AB */
    static public function divideRate(
                                            ax:Number, ay:Number,
                                            bx:Number, by:Number, 
                                            cx:Number, cy:Number):Number {
        var dx:Number = (cx - ax) / (bx - ax);
        var dy:Number = (cy - ay) / (by - ay);                               
        if( dx == dy ){ return dx }
        else if( isNaN( dx ) ){ return dy; }
        else if( isNaN( dy ) ){ return dx; }
        else{ return dx; }
    }
    
    /** 点Aを中心とする回転行列を生成 */
    static public function rotate(
                                            ax:Number, ay:Number,
                                            d:Number = 90):Matrix {
        var r:Number = Math.PI * d / 180;
        var s:Number = Math.sin( r ), c:Number = Math.cos( r );
        return new Matrix( c, -s, s, c, ax - c * ax + s * ay, ay - s * ax - c * ay );
    }
    
    /** 2点間の距離 */
    static public function distance( 
                            ax:Number, ay:Number,
                            bx:Number, by:Number):Number{
        return Math.sqrt((ax = ax - bx) * ax + (ay = ay - by) * ay);
    }
}