/**
 * Copyright Albert ( http://wonderfl.net/user/Albert )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4G2K
 */

// Copy from here: http://www.emanueleferonato.com/2012/12/14/box2d-flying-arrow-engine-first-attempt/

package {

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.events.MouseEvent;

    import Box2D.Dynamics.*;

    import Box2D.Collision.*;

    import Box2D.Collision.Shapes.*;

    import Box2D.Common.Math.*;
    import Box2D.Common.Math.b2Vec2;    

    //import Box2D.Dynamics.Contacts.b2ContactListener;

    public class Main extends Sprite {

        private var world:b2World;

        private var worldScale:int=30;

        private var arrowVector:Vector.<b2Body>=new Vector.<b2Body>();

        //private var customContact=new b2ContactListener();

        public function Main():void {

            var worldAABB:b2AABB = new b2AABB();

            worldAABB.lowerBound.Set(-100, -100);

            worldAABB.upperBound.Set(100, 100);
            world=new b2World(worldAABB, new b2Vec2(0,0), true);            

            //world.SetContactListener(customContact);

            debugDraw();

            wall(640,470,1280,20);

            wall(1270,240,20,4800);

            for (var i:Number=1; i<=10; i++) {
            /*var boxBodyDef:b2BodyDef = new b2BodyDef();
            boxBodyDef.position.Set(Math.random()*500+640,Math.random()*400);*/
                crate(Math.random()*500+640,Math.random()*400,80,80);

            }

            addEventListener(Event.ENTER_FRAME, update);

            stage.addEventListener(MouseEvent.CLICK,addArrow);

        }

        private function addArrow(e:MouseEvent):void {

            /*var angle:Number=Math.atan2(mouseY-240,mouseX-50);

            var vertices:Vector.<b2Vec2>=new Vector.<b2Vec2>();

            vertices.push(new b2Vec2(-1.4,0));

            vertices.push(new b2Vec2(0,-0.1));

            vertices.push(new b2Vec2(0.6,0));

            vertices.push(new b2Vec2(0,0.1));

            var bodyDef:b2BodyDef= new b2BodyDef();

            bodyDef.position.Set(50/worldScale,240/worldScale);

            bodyDef.type=b2Body.b2_dynamicBody;

            bodyDef.userData={name:"arrow",freeFlight:false,follow:true};

            bodyDef.bullet=true;

            var polygonShape:b2PolygonShape = new b2PolygonShape();

            polygonShape.SetAsVector(vertices,4);

            var fixtureDef:b2FixtureDef = new b2FixtureDef();

            fixtureDef.shape=polygonShape;

            fixtureDef.density=1;

            fixtureDef.friction=0.5;

            fixtureDef.restitution=0.5;

            var body:b2Body=world.CreateBody(bodyDef);

            body.CreateFixture(fixtureDef);

            body.SetLinearVelocity(new b2Vec2(30*Math.cos(angle),30*Math.sin(angle)));

            body.SetAngle(angle);

            for (var i:Number=0; i<arrowVector.length; i++) {

                arrowVector[i].GetUserData().follow=false;

            }

            arrowVector.push(body);*/

        }

        private function debugDraw():void {

            var debugDraw:b2DebugDraw=new b2DebugDraw();

            var debugSprite:Sprite=new Sprite();

            addChild(debugSprite);

            debugDraw.m_sprite = this; //debugSprite;

            debugDraw.m_drawScale = worldScale;
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit|b2DebugDraw.e_jointBit;

            debugDraw.m_fillAlpha = 0.5;

            world.SetDebugDraw(debugDraw);

        }

        private function wall(pX:Number,pY:Number,w:Number,h:Number):void {

            var bodyDef:b2BodyDef=new b2BodyDef();

            bodyDef.position.Set(pX/worldScale,pY/worldScale);


           /* fixtureDef.shape=polygonShape;

            fixtureDef.density=0.2;

            fixtureDef.restitution=0.4;

            fixtureDef.friction=0.5;*/

            var theWall:b2Body=world.CreateBody(bodyDef);

            //theWall.CreateFixture(fixtureDef);

        }

        private function crate(pX:Number,pY:Number,w:Number,h:Number):void {

            var bodyDef:b2BodyDef=new b2BodyDef();

            bodyDef.position.Set(pX/worldScale,pY/worldScale);

            bodyDef.userData={name:"crate"};

            /*bodyDef.type=b2Body.b2_dynamicBody;

            var polygonShape:b2PolygonShape=new b2PolygonShape();

            polygonShape.SetAsBox(w/2/worldScale,h/2/worldScale);

            var fixtureDef:b2FixtureDef=new b2FixtureDef();

            fixtureDef.shape=polygonShape;

            fixtureDef.density=0.2;

            fixtureDef.restitution=0.4;

            fixtureDef.friction=0.5;*/

            var theWall:b2Body=world.CreateBody(bodyDef);

            //theWall.CreateFixture(fixtureDef);

        }

        private function update(e : Event):void {

            world.Step(1/30,5);

            //world.ClearForces();

            for (var i:Number=arrowVector.length-1; i>=0; i--) {

                var body:b2Body=arrowVector[i];

                //if (body.GetType()==b2Body.b2_dynamicBody)
                {

                    if (! body.GetUserData().freeFlight) {

                        var flyingAngle:Number=Math.atan2(body.GetLinearVelocity().y,body.GetLinearVelocity().x);

                        //body.SetAngle(flyingAngle);

                    }

                }

                /*else {

                    arrowVector.splice(i,1);

                    body.SetBullet(false);

                    body.GetUserData().follow=false;

                }*/

                if (body.GetUserData().follow) {

                    var posX:Number=body.GetPosition().x*worldScale;

                    posX=stage.stageWidth/2-posX;

                    if (posX>0) {

                        posX=0;

                    }

                    if (posX<-640) {

                        posX=-640;

                    }

                    x=posX;

                }

            }

            world.DrawDebugData();

        }

    }
    
}

    import Box2D.Dynamics.*;

    import Box2D.Collision.*;

    import Box2D.Dynamics.Joints.*;

    import Box2D.Dynamics.Contacts.*;
    //import Box2D.Dynamics.Contacts.b2ContactListener;    

    import Box2D.Common.Math.b2Vec2;

    //class CustomContactListener extends b2ContactListener {

        /*override public function PreSolve(contact:b2Contact, oldManifold:b2Manifold):void {                   if (! objA.freeFlight) {

                        weldJointDef = new b2WeldJointDef();

                        weldJointDef.Initialize(bodyA,bodyB,bodyB.GetWorldCenter());

                        bodyA.GetWorld().CreateJoint(weldJointDef);

                    }

                }

                if (objA.name=="crate"&&objB.name=="arrow") {

                    contactPoint=contact.GetManifold().m_points[0].m_localPoint;

                    if (! objB.freeFlight&&Math.round(contactPoint.x*10)==6) {

                        weldJointDef = new b2WeldJointDef();

                        weldJointDef.Initialize(bodyB,bodyA,bodyA.GetWorldCenter());

                        bodyB.GetWorld().CreateJoint(weldJointDef);

                    }

                }

                if (objB.name=="crate"&&objA.name=="arrow") {

                    contactPoint=contact.GetManifold().m_points[0].m_localPoint;

                    if (! objA.freeFlight&&Math.round(contactPoint.x*10)==6) {

                        weldJointDef = new b2WeldJointDef();

                        weldJointDef.Initialize(bodyA,bodyB,bodyB.GetWorldCenter());

                        bodyA.GetWorld().CreateJoint(weldJointDef);

                    }

                }

                if (objB.name=="arrow") {

                    objB.freeFlight=true;

                }

                if (objA.name=="arrow") {

                    objA.freeFlight=true;

                }

            }*/

        //}
    //}    

