/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Frm
 */

// forked from tkinjo's ラングトンのアリ
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    
    [SWF(width=465,height=465,frameRate=60,backgroundColor=0xffffff)]
    /**
     * ラングトンのアリ
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private const SPEED:uint = 100;
        
        private const DIRECTION_TOP:uint    = 0;
        private const DIRECTION_RIGHT:uint  = 1;
        private const DIRECTION_BOTTOM:uint = 2;
        private const DIRECTION_LEFT:uint   = 3;
        
        private var stageWidth:Number = stage.stageWidth;
        private var stageHeight:Number = stage.stageHeight;
        private var stageCenter:Point = new Point( stageWidth / 2, stageHeight / 2 );
        
        private var gridSize:Number = 5;
        private var numGrid:uint = stageWidth / gridSize;
        private var gridCenter:Number = uint( numGrid / 2 ) * gridSize;
        
        private var ant:Point;
        private var gridMap:Vector.<Vector.<Boolean>>;
        private var direction:int = DIRECTION_TOP;
        
        private var textField:TextField;
        private var count:uint = 0;
        
        public function Main() 
        {
            ant = new Point();
            
            gridMap = new Vector.<Vector.<Boolean>>();
            for ( var i:uint = 0; i < numGrid; i++ )
                gridMap.push( new Vector.<Boolean>( numGrid ) );
            
            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
            
            textField = new TextField();
            addChild( textField );
        }
        
        
        /**
         * 
         * @param    event
         */
        private function enterFrameHandler( event:Event ):void {
            
            for ( var i:uint = 0; i < SPEED; i++ ) {
                
                if ( 0 > antMapPosition.x || numGrid <= antMapPosition.x || 
                    0 > antMapPosition.y || numGrid <= antMapPosition.y )
                    return;
                
                if ( isMassBlack() ) 
                    turnRight();
                
                else
                    turnLeft();
                
                graphics.beginFill( isMassBlack() ? 0xffffff : 0x0 );
                graphics.drawRect( gridCenter + ant.x * gridSize, gridCenter - ant.y * gridSize, gridSize, gridSize );
                graphics.endFill();
                
                massFlip();
                move();
                
                count++;
                textField.text = count.toString();
            }
        }
        
        private function isMassBlack():Boolean {
            
            return gridMap[ antMapPosition.x ][ antMapPosition.y ];
        }
        
        /**
         * 90°右に方向転換
         */
        private function turnRight():void {
            
            direction++;
            if ( direction > DIRECTION_LEFT )
                direction = DIRECTION_TOP;
        }
        
        /**
         * 90°左に方向転換
         */
        private function turnLeft():void {
            
            direction--;
            if ( direction < DIRECTION_TOP )
                direction = DIRECTION_LEFT;
        }
        
        /**
         * 1マス前進
         */
        private function move():void {
            
            switch( direction ) {
                
                case DIRECTION_TOP:
                    ant.y++;
                    break;
                
                case DIRECTION_RIGHT:
                    ant.x++;
                    break;
                
                case DIRECTION_BOTTOM:
                    ant.y--;
                    break;
                
                case DIRECTION_LEFT:
                    ant.x--;
                    break;
            }
        }
        
        /**
         * マスの色を反転
         */
        private function massFlip():void {
            
            gridMap[ antMapPosition.x ][ antMapPosition.y ] = !isMassBlack();
        }
        
        private function get antMapPosition():Point {
            return new Point( uint( numGrid / 2 ) + ant.x, uint( numGrid / 2 ) + ant.y );
        }
    }
}