/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Fqa
 */

//マウスを押しっぱなしにしてパワーを集めろ！
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Rectangle;

	[SWF(frameRate='60', width='465', height='465', backgroundColor='0x0')]

	public class ParticleTest2 extends Sprite
	{
		private var _bmp:Bitmap;
		private var _bmd:BitmapData;
		private var _bmdRect:Rectangle;
		private var _colorTransform:ColorTransform = new ColorTransform(1, 0.99, 0.8, 0.98);

		private var _nodeArray:Array = [];
		private var _powerArray:Array = [];
		private var _maxNum:int = 10000;

		private var _mouseDown:Boolean = false;

		public function ParticleTest2()
		{
			this.stage.align = StageAlign.TOP_LEFT;
			this.stage.scaleMode = StageScaleMode.NO_SCALE;

			addEventListener(Event.ADDED_TO_STAGE, init);
		}

		private function init(evt:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);

			_bmd = new BitmapData(465, 465, false, 0x000000);
			_bmp = new Bitmap(_bmd);
			addChild(_bmp);
			this._bmdRect = new Rectangle(0, 0, 465, 465);

			for (var i:int = 0; i < 5; i++)
			{
				//たったの5か・・・ゴミめ
				var n:Node = new Node();
				n.pos.x = Math.random() * 465;
				n.pos.y = Math.random() * 465;
				this._powerArray.push(n);
			}

			addEventListener(Event.ENTER_FRAME, onEnter);
			this.stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
			this.stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
		}

		private function onDown(evt:MouseEvent):void
		{
			this._mouseDown = true;
		}

		private function onUp(evt:MouseEvent):void
		{
			this._mouseDown = false;
		}

		private function onEnter(evt:Event):void
		{
			this._bmd.colorTransform(this._bmdRect, this._colorTransform);

			var gravPoint:Point = new Point(mouseX, mouseY);
			for (var i:int = 0; i < this._powerArray.length; i++)
			{
				var n:Node = this._powerArray[i] as Node;
				var diff:Point = new Point(gravPoint.x - n.pos.x, gravPoint.y - n.pos.y);
				var distance:Number = Math.sqrt(diff.x * diff.x + diff.y * diff.y);

				n.acc.x = (n.pos.x < gravPoint.x) ? 1 : -1;
				n.acc.y = (n.pos.y < gravPoint.y) ? 1 : -1;
				if(distance > 10)
				{
					n.acc.x *= 3;
					n.acc.y *= 3;
				}

				n.v.x += n.acc.x;
				n.v.y += n.acc.y;
				(n.v.x > 10) ? n.v.x = 10 : (n.v.x < -10) ? n.v.x = -10 : 0;
				(n.v.y > 10) ? n.v.y = 10 : (n.v.y < -10) ? n.v.y = -10 : 0;
				n.pos.x += n.v.x;
				n.pos.y += n.v.y;

				this._bmd.fillRect(new Rectangle(n.pos.x, n.pos.y, 1, 1), 0xffffff);
			}
			for (i = 0; i < this._nodeArray.length; i++)
			{
				n = this._nodeArray[i] as Node;
				diff = new Point(gravPoint.x - n.pos.x, gravPoint.y - n.pos.y);
				var rad:Number = Math.atan2(diff.y, diff.x);
				distance = Math.sqrt(diff.x * diff.x + diff.y * diff.y);
				var grav:Number = 20 / distance;

				if (distance > 20)
				{
					n.acc.y = Math.sin(rad) * grav;
					n.v.y += n.acc.y;
					n.pos.x += Math.cos(rad) * distance/20;
					n.pos.y += n.v.y;

					n.acc.x *= 0.98;
					n.acc.y *= 0.98;
					n.v.x *= 0.96;
					n.v.y *= 0.96;
					if (n.pos.x > 465)
						n.pos.x = 0;
					else if (n.pos.x < 0)
						n.pos.x = 465;
					if (n.pos.y > 465)
						n.pos.y = 0;
					else if (n.pos.y < 0)
						n.pos.y = 465;
				}
				else
				{
					this._nodeArray.splice(i, 1);
					i--;
					if(this._powerArray.length < this._maxNum)
					{
						this._powerArray.push(n);
					}
				}


				this._bmd.fillRect(new Rectangle(n.pos.x, n.pos.y, 1, 1), 0xffffff);
			}

			//マウス
			if (this._mouseDown)
			{
				for (i = 0; i < 3; i++)
				{
					var newN:Node = new Node();
					newN.pos.x = Math.random() * this.stage.stageWidth;
					newN.pos.y = Math.random() * this.stage.stageHeight;
					this._nodeArray.push(newN);
				}
			}
		}
	}
}

import flash.geom.Point;

class Node
{
	public var acc:Point;
	public var v:Point;
	public var pos:Point;

	public function Node()
	{
		this.acc = new Point();
		this.v = new Point();
		this.pos = new Point();
	}
}
