/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Fin
 */

// kana revised


package  
{
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensyGroup;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.Shape;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.utils.Timer;
	import org.papervision3d.core.math.Matrix3D;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.typography.*
	import org.papervision3d.view.layer.ViewportLayer;

	[SWF(width=465, height=465, frameRate=30, backgroundColor=0xffffff)]
	public class KanaRev extends BasicView
	{
		
		private const GroundWidth:int = 1200;
		private const GroundHeight:int = 1200;
		private const PlaneWidth:int = 600;
		private const PlaneHeight:int = 600;
		
		private const MouseMargin:int = 120;
		private const ForwardBackSpeed:int = 3;
		private const RightLeftSpeed:int = 3;
		
		private const TextAlpha:Number = 1;
		private const TextColor:uint = 0x403933;
		private var tween:TweensyGroup;
		
		private var textMat:Letter3DMaterial;
		
		private var cm:ColorMaterial;
		private var plane:Plane;
		private var cube:Cube;
		private var mat:FlatShadeMaterial;
		private var bitMat:BitmapMaterial;
		private var groundData:BitmapData;
		private var groundDataInternal:BitmapData;
		private var timer:Timer = new Timer(80);
		private var xx:int = 0;
		private var yy:int = 0;
		private var typeface:Font3D = new HiraFont();
		private var kkana:Text3D;
		private var count:int = 1;
		private var clickCount:int = 1;
		private var scaleNumber:Number = 5;
		
		private var layer1:ViewportLayer;		
		private var textLayer:DisplayObject3D = new DisplayObject3D();
		
		private var textObjects:Vector.<Text3D>;
		private var edgeBitmap:BitmapData;
		private var textView:BasicView;
		
		private var pool:Pool;
		[SWF(width=465, height=465, frameRate=30, backgroundColor=0x221100)]
		public function KanaRev(viewportWidth:Number = 465, viewportHeight:Number = 465, scaleToStage:Boolean = true, interactive:Boolean = false, cameraType:String = "Target") 
		{
                         Wonderfl.capture_delay( 33);
                         
			tween = new TweensyGroup(true);
			tween.smartRotate = false;
			
			super(viewportWidth, viewportHeight, scaleToStage, interactive, cameraType);
			textView = new BasicView(viewportWidth, viewportHeight, scaleToStage, interactive, cameraType);
			this.addChild(textView);
			addEventListener(Event.ADDED_TO_STAGE, onInit);			
		}
		
		private function onInit(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, onInit);
			stage.quality = StageQuality.BEST;
			stage.addEventListener(MouseEvent.CLICK, onClick);
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			
			textMat = new Letter3DMaterial(TextColor, TextAlpha*TextAlpha);
			textMat.doubleSided = true;
			pool = new Pool(typeface, textMat, true);
			
			
			groundData = new BitmapData(GroundWidth, GroundWidth, true , 0xccffdddd);
			groundDataInternal = new BitmapData(GroundWidth, GroundWidth,true, 0xccffdddd);
			bitMat = new BitmapMaterial(groundData,true);
			plane = new Plane(bitMat, PlaneWidth, PlaneHeight,25,25);
			plane.rotationX = 90;
			scene.addChild(plane);
			
			textView.scene.addChild(textLayer);
			
			var mm:Matrix = new Matrix();
			mm.createGradientBox(GroundWidth, GroundHeight,1.4);
			var sh:Shape = new Shape();
			sh.graphics.beginGradientFill(GradientType.LINEAR,[0xf5e5bf,0xeeddaa] ,[1,1],[140, 255],mm);
			sh.graphics.drawRect(0,0,GroundWidth, GroundHeight);
			groundData.draw(sh);
			
			
			var light:PointLight3D = new PointLight3D(true);
			light.x = -300;
			light.z = -300;
			light.y = 300;
			scene.addChild(light);
			mat = new FlatShadeMaterial(light, 0xffffff, 0x11ff0000, 0);
			
			
			cube = new Cube(new MaterialsList( { all:mat } ), 80, 80, 80);
			//scene.addChild(cube);
			
			camera.z = textView.camera.z = -70;
			camera.y = textView.camera.y = 550;
			
			var offset:int = 50;
			var margin:int = 100;
			
			edgeBitmap = new BitmapData(GroundWidth, GroundHeight, true,0xffaaaaaa);
			var ma:Shape = new Shape();
			ma.graphics.beginFill(0x0000ff);
			ma.graphics.drawRect(0, 0, GroundWidth, GroundHeight);
			ma.graphics.beginFill(0xff0000);
			ma.graphics.drawCircle(GroundWidth / 2, GroundHeight / 2, GroundWidth / 2 - offset);
			//ma.graphics.drawRoundRect(offset, offset, GroundWidth - offset * 2, GroundHeight - offset * 2, 1200, 1200);
			edgeBitmap.draw(ma);
			edgeBitmap.threshold(edgeBitmap, edgeBitmap.rect, new Point(0, 0), ">", 0xdd0000, 0x00ffffff, 0x00ff0000);
			//plane.material = new BitmapMaterial(edgeBitmap);
			ma.graphics.clear();
			ma = null;
			
			
			startRendering();
			textView.startRendering();
			trace("start");

			timer.start();
		}
		
		private function onClick(e:MouseEvent):void 
		{
			clickCount += 1;
			if (clickCount % 2 == 0) {
				typeface = new SiddhamFont();
			}else {
				typeface = new HiraFont();
			}
			
			
			groundData.dispose();
			groundDataInternal.dispose();
			tween.stopAll();
			tween.dispose();
			tween = new TweensyGroup();
			pool.clearPool();
			
			pool = new Pool(typeface, textMat);
			textView.scene.removeChild(textLayer);
			textLayer = new DisplayObject3D();
			textView.scene.addChild(textLayer);
			count = 1;
			scaleNumber = 5;
			groundData = new BitmapData(GroundWidth, GroundWidth, true , 0xccffdddd);
			plane.material = new BitmapMaterial(groundData , true);
			groundDataInternal = new BitmapData(GroundWidth, GroundWidth, true, 0xccffdddd);
			
			var mm:Matrix = new Matrix();
			mm.createGradientBox(GroundWidth, GroundHeight,1.4);
			var sh:Shape = new Shape();
			sh.graphics.beginGradientFill(GradientType.LINEAR,[0xf5e5bf,0xeeddaa] ,[1,1],[140, 255],mm);
			sh.graphics.drawRect(0,0,GroundWidth, GroundHeight);
			groundData.draw(sh);
                        sh.graphics.clear();

		}
		
		private function onTimer(e:TimerEvent):void 
		{
			if (mouseY > 465 - MouseMargin) {
				cameraB();
			}else if (mouseY < MouseMargin) {
				cameraF();
			}
/*			if (mouseX > 465 - MouseMargin) {
				camera.moveRight(RightLeftSpeed);
				textView.camera.moveRight(RightLeftSpeed);
			}else if (mouseX < MouseMargin) {
				camera.moveLeft(RightLeftSpeed);
				textView.camera.moveLeft(RightLeftSpeed);
			}
*/
			count += 1;
			var str:String = getChar();

			var sh:Shape = new Shape();
			sh.graphics.lineStyle(2);
			var sc:Number;
			sc = scaleNumber;
			var rot:Number = Math.random() * Math.PI * 2;
			var b:Bitmap = createTextBitmap( sc , str, rot);
			rot = rot * 360 / (2 * Math.PI);

			var off:int = 50;
			if (count < 30) {
				off = 250;
			}
			
			
			for (var t:int = 0; t < 90; t++)
			{
				b.x = Math.random() * (GroundWidth-off*2) + off -b.width/2;
				b.y = Math.random() * (GroundHeight-off*2) + off -b.height/2;
				if ( hitText(b) )
				{
					groundDataInternal.draw(b , new Matrix(1, 0, 0, 1, b.x, b.y));
					startRain(b, str,sc, rot);
					return;
				}
				
			}
			// position failed
			if (count < 30) {
				scaleNumber = scaleNumber * 0.90;
			}else{
				scaleNumber = scaleNumber * 0.98;
			}
			b.bitmapData.dispose();

		}
		private function startRain(bitmap:Bitmap, str:String, sc:Number, rot:Number = 0 ):void
		{
			
			var kana:Text3D;
			kana = pool.getText(str);
			
			var n:Number3D = new Number3D((bitmap.x-GroundWidth/2)*PlaneWidth/GroundWidth, 0,(bitmap.y-GroundHeight/2)*PlaneHeight/GroundHeight);
			Matrix3D.multiplyVector(plane.world, n );
			kana.rotationX = 90;
			kana.rotationY = rot;
			
			kana.scaleY = sc/2;
			kana.scaleX = sc/2;
			kana.x = n.x + 50*sc/2;
			kana.z = n.y - 50*sc/2;
			kana.y = -0.2;
			
			tween.from(kana, { y:600, rotationY:"-300,300", rotationX:"-300,300" , rotationZ:"-300,300" }, 1.5, null, 0, null, drawTextToPlane, new Array(bitmap, kana));
			
			textLayer.addChild(kana);
			
		}
		//private function getTextObject(ss:String):Text3D
		//{
			//var i:int = hiraString.indexOf(ss);
			//var t:Text3D = (textObjects[i] as Text3D);
			//return t;
		//}
		private function drawTextToPlane(bb:Bitmap, kk:Text3D):void
		{
			groundData.draw(bb , new Matrix(1, 0, 0, 1, bb.x, bb.y), new ColorTransform(1, 1, 1, TextAlpha), null, null);
			textLayer.removeChild(kk);
			pool.disposeText(kk);
			bb.bitmapData.dispose();
			bb = null;

		}
		private function hitText(b:Bitmap):Boolean
		{
			var bd1:BitmapData = b.bitmapData;
			var textHit:Boolean = bd1.hitTest(new Point(b.x, b.y), 200, groundDataInternal, new Point(0, 0), 220);
/*			var edgeHit1:Boolean = bd1.hitTest(new Point(b.x, b.y), 200, rec1, new Point(0, 0));
			var edgeHit2:Boolean = bd1.hitTest(new Point(b.x, b.y), 200, rec2, new Point(0, 0));
			var edgeHit3:Boolean = bd1.hitTest(new Point(b.x, b.y), 200, rec3, new Point(0, 0));
			var edgeHit4:Boolean = bd1.hitTest(new Point(b.x, b.y), 200, rec4, new Point(0, 0));
*/			
			var edgeHit5:Boolean = bd1.hitTest(new Point(b.x, b.y), 200, edgeBitmap, new Point(0, 0), 220);
			
			var result:Boolean = (!textHit) && (!edgeHit5);//(!textHit) && (!edgeHit1) && (!edgeHit2) && (!edgeHit3) && (!edgeHit4)
			return result;
		}
		
		
		override protected function onRenderTick(e:Event = null):void
		{
			super.onRenderTick(e);
		}
		private function cameraF():void
		{
			if (camera.distanceTo(cube) > 230) {
				this.camera.moveForward(3);
				this.camera.moveUp(0.3);
				
				textView.camera.moveForward(3);
				textView.camera.moveUp(0.3);
			
			}
		}
		private function cameraB():void
		{   
			if (camera.distanceTo(cube) < 900){
				this.camera.moveBackward(3);
				this.camera.moveDown(0.3);
			
				textView.camera.moveBackward(3);
				textView.camera.moveDown(0.3);
				
			}		
		}
		private function createTextBitmap(sc:Number, str:String, rot:Number):Bitmap
        {
            var textShape:Shape = new Shape();   //TODO make 3D shape -> 2d shape -> draw bitmap
            drawFont2D(textShape, str);
			
			var mat:Matrix = new Matrix();
             
            mat.translate( -50, -50);
			mat.scale(sc,sc);
            mat.rotate(rot);
            mat.translate(50*sc, 50*sc);
			var bmd:BitmapData = new BitmapData(100 * sc, 100 * sc, true, 0x000000);
			
			if (sc > 0.7) {
				bmd.draw(textShape, mat,new ColorTransform(1,1,1,TextAlpha),null,null);
			}else {
				bmd.draw(textShape, mat,new ColorTransform(0.9,0.9,0.9,TextAlpha),null,null);
			}
			textShape.graphics.clear();
			textShape = null;
			
            var bm:Bitmap = new Bitmap( bmd, "auto");
			var bl:BlurFilter = new BlurFilter(2, 2, 2);
			bm.filters =  [bl];

            return bm;
        }

		private function drawFont2D(sh:Shape, str:String):void
		{
			 var obj:Object = typeface.motifs;
			 
			 sh.graphics.beginFill(TextColor);
			 var ar:Array = obj[str];
			for (var i:int=0; i<ar.length; i++) {
				switch (ar[i][0]) 
				{
					case "M":
						sh.graphics.moveTo(ar[i][1][0], ar[i][1][1]);
						break;
					case "L":
						sh.graphics.lineTo(ar[i][1][0], ar[i][1][1]);
						break;
					case "C":
						sh.graphics.curveTo(ar[i][1][0], ar[i][1][1], ar[i][1][2], ar[i][1][3]);
						break;
				}
			}
		}

		 
		 
		 private function getChar():String
		 {
			   var chars:String;
			   if (typeface is SiddhamFont) {
				   chars = "アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘ";
			   }else {
				   	chars = "あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやゆよわをん"
			   }
			   return chars.charAt( Math.floor(Math.random() * chars.length) ); 
		 }
		 
			
		
		
	}

}

import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.typography.Font3D;
import org.papervision3d.typography.Text3D;


	class Pool
	{
		private static var poolArray:Vector.<Text3D> = new Vector.<Text3D>();
		private var f:Font3D;
		private var m:MaterialObject3D;
		private var chars:String = "あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやゆよわをん";

		public function Pool(font:Font3D, mat:MaterialObject3D, start:Boolean = false):void
		{
			f = font;
			m = mat;
			if (start) 
			{
				for (var i:int = 0; i < chars.length; i++) 
				{
					var text:Text3D = new Text3D(chars.charAt(i), f, m);
					poolArray.push(text);
				}

			}
		}
		
		public function getText(str:String):Text3D
		{
			var len:int = poolArray.length;
			for (var i:int = 0; i < len; i++) {
				var p:Text3D = poolArray[i];

				if (p.text == str) {
					poolArray.splice(i, 1);
					
					trace("text from pool");
					return p;
				}
			}	
			return new Text3D(str, f, m);
		}
		public function disposeText(p:Text3D):void
		{
			poolArray.push(p);	
		}
		public function clearPool():void
		{
			poolArray.length = 0;
		}
	}

	class SiddhamFont extends Font3D{

		static public var __motifs:Object = {};
		static public var __widths:Object = {};
		static public var __heights:Number = 100;
		static public var __initialized:Boolean = false;
		override public function get motifs():Object
		{
		 if(!__initialized)initialize();
		 return __motifs;
		}
		override public function get widths():Object
		{
		 if(!__initialized)initialize();
		 return __widths;
		}
		override public function get height():Number
		{
		 if(!__initialized)initialize();
		 return __heights;
		}

		static public function initialize():void {
			initializeMotifs();
			initializeWidths();
			__initialized = true;
		}
		
		static private function initializeMotifs():void {
			__motifs["ア"] = [['M',[86.8,12.1]],['C',[88.2,13.5,88.95,15.35]],['C',[84.45,16.7,82.9,20.45]],['C',[81.35,24.25,81.95,29.5]],['L',[82.8,48.35]],['L',[86.6,81.35]],['C',[86.35,82.05,86.4,83]],['C',[86.45,84,86.5,85.3]],['C',[86.6,86.65,86.45,87.55]],['C',[86.35,88.5,86.05,89.15]],['C',[87.8,90.75,88.8,91.7]],['C',[89.85,92.7,90.7,93.55]],['C',[91.6,94.45,92.5,95.15]],['C',[93.35,95.8,94.15,96.25]],['C',[94.9,96.7,95.75,97.05]],['C',[96.6,97.35,97.2,97.6]],['C',[97.85,97.85,97.95,98.05]],['C',[98.05,98.25,97.85,98.45]],['C',[91.6,97.85,85.85,96.6]],['C',[80.1,95.3,76.45,93.55]],['C',[72.85,91.8,70.6,90.5]],['C',[68.35,89.15,65.35,87.2]],['C',[62.3,85.25,59.95,83.9]],['C',[57.6,82.55,55.2,81.45]],['C',[56.35,79.6,58.1,78.5]],['C',[59.85,77.45,62,76.95]],['C',[64.15,76.45,66.45,76.4]],['C',[68.75,76.4,71.9,76.3]],['C',[71.7,73.15,71.4,70.15]],['C',[71.1,67.1,70.65,62.75]],['C',[70.2,58.4,69.85,55.45]],['C',[69.55,52.45,69.45,49.7]],['C',[66.4,47.75,63.25,46.2]],['C',[60.05,44.65,56.9,43.45]],['C',[53.7,42.3,50.7,41.3]],['C',[47.65,40.35,43.35,39.25]],['C',[43.15,49.5,42.65,56.2]],['C',[42.1,62.9,39.85,70.5]],['C',[37.6,78.15,32.9,84]],['C',[28.2,89.85,20.4,90.95]],['C',[18.35,90.95,16.1,90.3]],['C',[13.85,89.65,12.1,88.4]],['C',[10.35,87.1,9.35,85.35]],['C',[8.3,83.6,8.5,81.45]],['C',[8.1,79.9,8.6,78.45]],['C',[9.1,76.95,10.15,75.95]],['C',[11.25,74.9,12.65,74.5]],['C',[14.05,74.15,15.7,74.5]],['L',[17.6,76.1]],['C',[26.05,71.6,28.95,62.35]],['C',[31.85,53.15,31.85,40.85]],['L',[22.05,50.4]],['C',[21.6,50.5,21.1,50.5]],['C',[20.6,50.5,19.8,50.45]],['C',[19.05,50.4,18.55,50.3]],['C',[18.05,50.2,17.6,50.2]],['C',[15.7,48.35,14.35,46.8]],['C',[13,45.2,12.1,43.85]],['C',[13.55,41.5,15.35,39.45]],['C',[17.1,37.4,18.95,35.4]],['C',[20.8,33.4,22.7,31.4]],['C',[24.6,29.4,26.55,27.45]],['C',[24.8,25.8,23.7,24.65]],['C',[22.55,23.55,21.35,22.25]],['C',[20.1,20.9,19.1,19.6]],['C',[18.05,18.25,17.3,17]],['C',[18.95,14.25,21,12.25]],['C',[23.05,10.25,25.6,9.75]],['C',[28.7,10.35,31.7,10.8]],['C',[34.65,11.25,38.1,11.25]],['C',[40.65,11.25,43,10.95]],['C',[45.4,10.65,47.6,10.2]],['C',[49.8,9.75,53.15,9.1]],['C',[56.55,8.4,58.5,8.1]],['C',[59.1,8.7,60.85,10.25]],['C',[62.6,11.85,63.65,13.1]],['C',[64.75,14.35,65.3,15.95]],['C',[65.8,17.5,65.65,19.25]],['C',[64.95,20.05,64.25,20.45]],['C',[63.55,20.9,62.85,21]],['C',[62.1,21.1,60.9,21.15]],['C',[59.65,21.2,58.95,21.35]],['C',[58.2,21.5,57.35,21.7]],['C',[56.55,21.9,55.8,22.25]],['C',[55.1,22.65,54.35,23]],['C',[53.6,23.35,53,23.75]],['C',[52.35,24.15,51.2,24.5]],['C',[50.1,24.9,49.3,25.35]],['C',[48.55,25.8,47.95,26.35]],['C',[47.35,26.85,46.7,27.75]],['C',[52.25,29.5,57.85,32.15]],['C',[63.5,34.75,68.75,38]],['C',[68.45,36.15,68.4,34.35]],['C',[68.35,32.55,68.35,30.35]],['C',[68.35,28.15,68.35,26.55]],['C',[68.35,25,68.15,23.55]],['C',[68.35,20.05,68.55,17.45]],['C',[68.75,14.85,69.5,12.5]],['C',[70.2,10.15,71.95,8.3]],['C',[73.75,6.45,76.65,5.85]],['C',[77.75,6.45,80.1,7.65]],['C',[82.4,8.9,83.95,9.8]],['C',[85.45,10.75,86.8,12.1]]];
			__motifs["イ"] = [['M',[87.7,6.45]],['C',[90.45,8.1,92.5,11.05]],['C',[91.8,12,90.8,12.75]],['C',[89.85,13.5,88.4,14.55]],['C',[86.9,15.65,85.9,16.35]],['C',[84.85,17.1,83.8,18.45]],['C',[82.7,19.85,82.3,22.45]],['C',[81.85,25.1,81.75,28.9]],['C',[81.25,37,85.2,44.2]],['C',[89.15,51.4,97.55,53.25]],['C',[95.6,54.5,93.75,54.2]],['C',[90.9,54.1,88.55,53.3]],['C',[86.25,52.45,84.15,51.3]],['C',[82.05,50.1,80.35,48.75]],['C',[78.7,47.35,76.05,45.15]],['L',[76.55,50.9]],['C',[77.35,59,78.15,65.7]],['C',[78.9,72.35,80.1,78.7]],['C',[80,80.6,79.5,83.4]],['C',[83.1,87.6,86.95,90.7]],['C',[90.8,93.75,95.3,95.5]],['C',[92.3,96,89.9,95.8]],['C',[87.5,95.6,83.65,94.85]],['C',[79.8,94.05,75.9,92.6]],['C',[71.95,91.1,69.1,89.3]],['C',[66.2,87.5,63.1,84.9]],['C',[59.95,82.35,58.15,80.85]],['C',[56.35,79.4,53.75,77.7]],['C',[51.15,76,48.55,74.9]],['C',[49.8,72.85,51.6,71.7]],['C',[53.4,70.5,55.55,70.1]],['C',[57.7,69.65,59.75,69.45]],['C',[61.8,69.25,64.95,69.15]],['L',[63.3,45.6]],['C',[56.85,42.9,51,40.85]],['C',[45.1,38.8,39.15,37.2]],['C',[39.05,39.65,38.95,44.65]],['C',[38.85,49.6,38.65,52.9]],['C',[38.5,56.15,38.05,59.8]],['C',[37.6,63.5,36.25,69.7]],['C',[34.85,75.9,30.25,81.7]],['C',[25.7,87.5,17.6,87.9]],['C',[15.65,87.9,13.6,87.2]],['C',[11.6,86.55,10.05,85.3]],['C',[8.5,84.1,7.6,82.5]],['C',[6.75,80.85,7.05,79]],['C',[6.85,78.15,6.9,77.45]],['C',[6.95,76.75,7.15,76.3]],['C',[7.3,75.8,7.6,74.95]],['C',[7.9,74.15,8.1,73.85]],['C',[9,72.85,9.85,72.55]],['C',[10.75,72.25,11.7,72.75]],['C',[11.8,72.85,11.8,73.25]],['C',[11.8,73.65,11.95,73.9]],['C',[12.1,74.15,12.35,74.4]],['C',[12.6,74.7,13.2,75]],['C',[18.45,73.85,21.45,69.6]],['C',[24.4,65.35,25.95,59.65]],['C',[27.45,53.9,27.8,48.65]],['C',[28.15,43.35,27.75,38]],['C',[26.45,38.8,25.45,39.8]],['C',[24.4,40.85,22.8,42.4]],['C',[21.2,43.95,20.2,44.85]],['C',[19.25,45.7,18.05,46.5]],['C',[15.05,46.2,12.95,43.95]],['C',[10.85,41.7,9.85,38.95]],['C',[10.85,37.2,12.25,35.6]],['C',[13.65,34,15.35,32.4]],['C',[17,30.75,19.45,28.55]],['C',[21.9,26.4,22.55,25.6]],['C',[21.3,24.05,20.4,22.9]],['C',[19.55,21.8,18.7,20.7]],['C',[17.85,19.65,17.15,18.5]],['C',[16.4,17.4,15.9,16.2]],['C',[17,13.5,19.1,11.25]],['C',[21.2,9,23.95,8.9]],['C',[26.35,9.1,29.1,9.35]],['C',[31.85,9.6,34.95,9.75]],['C',[38.85,9.6,42.55,9]],['C',[46.2,8.4,49.6,7.25]],['C',[51.05,8.2,52.35,9.1]],['C',[53.6,9.95,54.85,11.1]],['C',[56.05,12.2,56.95,13.7]],['C',[57.8,15.15,58.1,16.7]],['L',[56.55,18.85]],['C',[51.85,19.85,47.95,21.7]],['C',[44.05,23.55,40.8,26.3]],['C',[47.35,28.7,52.35,30.8]],['C',[57.3,32.9,62.1,35.25]],['C',[62.1,33.6,62,32.05]],['C',[61.9,30.5,61.8,28.4]],['C',[61.7,26.3,61.65,24.75]],['C',[61.6,23.25,61.6,21.9]],['C',[61.6,15.55,63.05,11.45]],['C',[64.45,7.35,69.35,5.6]],['C',[70.1,5.5,70.7,5.65]],['C',[71.3,5.85,72.15,6.3]],['C',[73.05,6.75,73.7,7.15]],['C',[74.3,7.55,75.1,7.7]],['C',[76.85,5.85,78.3,4.95]],['C',[79.8,4,81.85,4]],['C',[84.95,4.8,87.7,6.45]]];
			__motifs["ウ"] = [['M',[27.2,23.8]],['C',[26,24.25,25.05,25.15]],['C',[24.1,26.1,23.6,27.35]],['C',[23.05,28.6,23.35,30.3]],['C',[23.35,31.35,23.85,32.4]],['C',[24.3,33.4,25.25,34.2]],['C',[26.15,34.95,27.4,35.35]],['C',[28.6,35.75,30,35.65]],['C',[30.65,35.65,31.45,35.45]],['C',[32.25,35.25,32.85,34.85]],['C',[33.5,34.5,34.35,33.85]],['C',[35.15,33.2,35.55,33]],['C',[35.55,32.55,35.7,32]],['C',[35.85,31.45,35.95,31.2]],['C',[36.05,30.95,36.2,30.4]],['C',[36.35,29.8,36.35,29.5]],['C',[36.05,27.15,34.15,25.25]],['C',[32.25,23.35,30.1,23.35]],['C',[28.4,23.35,27.2,23.8]],['M',[41.35,41.55]],['C',[38.85,43.75,35.65,44.9]],['C',[32.4,46,29.3,45.7]],['C',[26,46,22.7,44.95]],['C',[19.45,43.85,16.8,41.8]],['C',[14.15,39.75,12.75,36.85]],['C',[11.35,33.9,11.6,30.6]],['C',[11.7,24.05,16,19.45]],['C',[20.3,14.85,27.25,11.85]],['C',[34.85,13,40.9,17.75]],['C',[46.95,22.45,46.6,30.1]],['C',[46.7,33.4,45.25,36.4]],['C',[43.85,39.35,41.35,41.55]],['M',[52.85,48.35]],['C',[61.05,48.35,67.25,55.1]],['C',[73.45,61.85,73.55,70.6]],['C',[73.75,74.6,72.05,78.55]],['C',[70.4,82.55,67.4,85.55]],['C',[64.35,88.6,60.45,90.25]],['C',[56.55,91.9,52.35,91.6]],['C',[46.6,91.3,41.5,88.9]],['C',[36.45,86.55,33.45,83.5]],['C',[30.45,80.5,28.75,78.3]],['C',[27.05,76.1,25.85,74.35]],['C',[24.6,72.65,22.4,69.4]],['C',[20.2,66.1,17.7,62.6]],['C',[15.25,59.1,11.15,55.7]],['C',[7.05,52.35,2.25,51.3]],['C',[8.7,51.45,14.5,54.95]],['C',[20.3,58.4,25.2,63]],['C',[30.1,67.6,32.35,69.85]],['C',[34.65,72.1,37.35,74.2]],['C',[40.05,76.3,43.25,77.75]],['C',[46.5,79.2,50.1,79.8]],['C',[54.2,79.1,57.35,75.6]],['C',[60.55,72.1,60.45,67.9]],['C',[60.55,65.35,59.35,63.35]],['C',[58.1,61.35,56.25,60.65]],['C',[55.2,60.45,54.45,60.6]],['C',[53.7,60.75,53.2,61.25]],['C',[52.05,62.6,51.6,63.65]],['C',[51.15,64.65,51.15,66.4]],['C',[51,66.7,51.15,67.25]],['C',[51.35,67.8,51.6,68.25]],['C',[51.85,68.75,51.9,69.2]],['C',[51.95,69.65,51.65,70.2]],['C',[48.35,70.9,45.2,70.3]],['C',[42.1,69.75,39.55,68.35]],['L',[39.05,63.3]],['C',[38.85,60.25,39.8,57.4]],['C',[40.7,54.5,42.7,52.25]],['C',[44.75,50,47.25,48.95]],['C',[49.8,47.85,52.85,48.35]],['M',[74.7,23.25]],['C',[71.95,22.85,70.05,24.9]],['C',[68.15,26.95,67.95,29.8]],['C',[67.95,30.75,68.4,31.75]],['C',[68.85,32.7,69.65,33.5]],['C',[70.4,34.3,71.55,34.75]],['C',[72.65,35.15,74.1,35.15]],['C',[75.3,35.15,76.5,34.65]],['C',[77.75,34.1,78.65,33.3]],['C',[79.6,32.55,80.15,31.4]],['C',[80.65,30.3,80.65,29]],['C',[80.65,27.65,80.2,26.55]],['C',[79.7,25.5,78.8,24.6]],['C',[77.95,23.75,76.8,23.35]],['C',[75.7,22.95,74.7,23.25]],['M',[91.4,30.3]],['C',[91.6,33.6,90.15,36.55]],['C',[88.65,39.45,86.25,41.45]],['C',[83.8,43.45,80.65,44.55]],['C',[77.55,45.6,74.4,45.5]],['C',[71.1,45.6,67.75,44.5]],['C',[64.45,43.35,61.75,41.35]],['C',[59.1,39.35,57.65,36.5]],['C',[56.25,33.6,56.55,30.3]],['C',[56.55,24.05,61.45,18.5]],['C',[66.3,13,72.65,11.75]],['C',[80,12.1,85.8,17.4]],['C',[91.6,22.65,91.4,30.3]]];
			__motifs["エ"] = [['M',[28.7,22.85]],['C',[26,22.85,24.25,24.9]],['C',[22.55,26.95,22.35,29.9]],['C',[22.45,31.25,23.35,32.25]],['C',[24.2,33.2,25.6,33.75]],['C',[26.95,34.3,28.5,34.35]],['C',[30.1,34.4,31.75,34.3]],['C',[33.1,33.1,33.9,32]],['C',[34.65,30.85,34.55,29.4]],['C',[34.65,28.25,34.2,27.05]],['C',[33.7,25.9,32.75,24.95]],['C',[31.85,24.05,30.75,23.45]],['C',[29.7,22.85,28.7,22.85]],['M',[43.15,35.95]],['C',[41.8,38.5,39.55,40.3]],['C',[37.3,42.1,34.4,43.15]],['C',[31.55,44.25,28.7,44.15]],['C',[25.5,44.25,22.25,43.1]],['C',[19.05,42,16.6,39.75]],['C',[14.15,37.5,12.8,34.7]],['C',[11.45,31.85,11.8,28.9]],['C',[11.45,22.75,16.25,18.1]],['C',[21.1,13.5,27.55,11.65]],['C',[34.65,13.9,39.75,18.8]],['C',[44.8,23.75,44.55,30.6]],['C',[44.55,33.4,43.15,35.95]],['M',[49.7,45.05]],['C',[57.25,45.2,62.9,51.55]],['C',[68.55,57.9,68.55,65.65]],['C',[68.45,66.9,68.2,69]],['C',[67.95,71.1,67.75,72.55]],['C',[67.6,74.05,67.45,75.45]],['C',[67.3,76.85,67.2,78.5]],['C',[67.2,84.6,70.7,90.2]],['C',[74.2,95.8,80,97.75]],['C',[76.05,97.75,73,96.4]],['C',[69.9,95.05,67.05,92.6]],['C',[64.15,90.15,61.85,87.35]],['C',[59.55,84.6,58,81.45]],['C',[56.45,78.35,55.75,74.9]],['C',[55.1,71.5,55.1,68.4]],['C',[55.1,65.35,55.1,63.75]],['C',[55.1,62.1,54.65,60.7]],['C',[54.2,59.3,53.15,58.45]],['C',[52.05,57.65,50,57.65]],['C',[48.35,58.7,47.95,60.45]],['C',[47.55,62.2,47.65,64.75]],['C',[47.55,66,47.7,67.35]],['C',[47.85,68.65,48.25,70.15]],['C',[48.35,70.2,48.45,70.3]],['C',[48.55,70.4,48.75,70.5]],['C',[48.95,70.6,49.15,70.65]],['C',[49.4,70.7,49.7,70.6]],['C',[49.1,71.2,48.25,71.75]],['C',[47.35,72.25,46.5,72.35]],['C',[45.4,72,43.55,71.75]],['C',[41.7,71.5,40.7,71.3]],['C',[39.75,71.1,38.6,70.6]],['C',[37.5,70.15,36.7,69.25]],['C',[36.05,67.4,35.7,65.85]],['C',[35.35,64.25,35.15,62.7]],['C',[34.95,59.3,35.9,56.05]],['C',[36.8,52.85,38.7,50.3]],['C',[40.65,47.75,43.4,46.3]],['C',[46.2,44.85,49.7,45.05]],['M',[71.2,23.25]],['C',[68.75,23.75,67.1,25.8]],['C',[65.45,27.85,65.65,30.4]],['C',[65.9,32.25,67.7,33.5]],['C',[69.45,34.75,71.7,34.75]],['C',[73.85,34.85,76,33.45]],['C',[78.15,32.05,78.3,29.9]],['C',[78.4,28.35,77.75,27.1]],['C',[77.05,25.9,76.05,24.85]],['C',[75,23.85,73.7,23.4]],['C',[72.35,22.95,71.2,23.25]],['M',[88,30]],['C',[88.1,33,86.75,35.7]],['C',[85.45,38.4,83.15,40.4]],['C',[80.85,42.4,77.95,43.35]],['C',[75,44.35,72.05,44.15]],['C',[68.75,44.55,65.7,43.45]],['C',[62.7,42.4,60.4,40.25]],['C',[58.1,38.1,56.85,35.2]],['C',[55.55,32.35,55.55,29.4]],['C',[55.55,22.65,60.9,17.65]],['C',[66.2,12.6,73.25,11.65]],['C',[79.2,14.15,83.7,18.95]],['C',[88.2,23.75,88,30]]];
			__motifs["オ"] = [['M',[85.35,20.2]],['C',[77.45,20.9,70.2,25.7]],['C',[63,30.5,59.2,37.6]],['C',[69.05,42.3,76.25,49.9]],['C',[83.5,57.55,83.8,66.9]],['C',[83.5,76.85,74.35,84.2]],['C',[65.25,91.5,54.6,91.8]],['C',[49.7,91.8,45.7,90.3]],['C',[41.7,88.8,38.4,86.35]],['C',[35.05,83.9,32.55,81.1]],['C',[30.1,78.35,24.8,71.85]],['C',[19.55,65.35,14.25,59.95]],['C',[9,54.6,2.05,50.8]],['C',[9.4,51.45,15.9,54.85]],['C',[22.45,58.2,26,61.5]],['C',[29.5,64.75,33.15,68.3]],['C',[36.8,71.9,39.55,74]],['C',[42.3,76.1,45.7,77.5]],['C',[49.1,78.9,53.3,79]],['C',[58.8,78.9,63.65,74.75]],['C',[68.55,70.6,68.95,65.35]],['C',[68.75,59.6,63.9,54.6]],['C',[59.1,49.6,53.3,48.85]],['C',[50.7,49.15,48.9,50.45]],['C',[47.05,51.75,46.1,53.3]],['C',[45.1,54.8,43.4,57.55]],['C',[41.7,60.25,40.45,61.55]],['C',[36.6,61.15,33.5,58.7]],['C',[30.35,56.25,28.9,52.85]],['C',[30,50.6,31.2,48.5]],['C',[32.4,46.4,34.55,43.25]],['C',[36.7,40.15,38.1,38.15]],['C',[39.45,36.15,40.8,34.1]],['C',[37.1,31.15,33.85,27.65]],['C',[30.55,24.15,27.75,20.15]],['C',[28.4,18.35,29.2,17]],['C',[30,15.65,31.1,14.3]],['C',[32.25,13,33.55,12]],['C',[34.85,11.05,36.6,10.65]],['C',[40.65,11.05,44.7,11.4]],['C',[48.75,11.75,52.95,12]],['C',[58.6,11.75,63.65,10.8]],['C',[68.75,9.85,73.25,8]],['C',[77.95,9.95,81.7,13.1]],['C',[85.45,16.2,85.35,20.2]]];
			__motifs["カ"] = [['M',[86.8,78.05]],['C',[88.2,79.8,88.65,81.85]],['C',[88.1,84.1,86.6,86.1]],['C',[85.15,88.1,83.2,89.15]],['C',[82.05,89.15,81.5,89.05]],['C',[80.95,88.95,80.45,88.8]],['C',[79.6,84.4,78.2,80.9]],['C',[76.85,77.45,74.6,74.9]],['C',[71.95,80.85,65.9,84.65]],['C',[59.85,88.4,53.3,88.1]],['C',[47.55,88.3,42.35,85.85]],['C',[37.1,83.4,33.9,80.4]],['C',[30.65,77.35,29.05,75.35]],['C',[27.45,73.35,25.4,70.55]],['C',[23.35,67.8,21.85,65.65]],['C',[20.3,63.5,17.7,60.25]],['C',[15.05,57.05,10.75,53.5]],['C',[6.45,49.9,1.65,47.75]],['C',[5.85,47.75,10.2,49.55]],['C',[14.55,51.4,18.6,54.1]],['C',[22.65,56.85,26.05,59.75]],['C',[29.5,62.6,32.75,65.7]],['C',[36.05,68.75,37.7,70.15]],['C',[39.35,71.6,41.25,72.9]],['C',[43.15,74.25,45.4,75.05]],['C',[47.65,75.9,50.3,75.9]],['C',[52.75,76,55.1,75]],['C',[57.4,74.05,59.25,72.25]],['C',[61.05,70.4,62.1,68.1]],['C',[63.2,65.85,63.1,63.5]],['C',[62.3,58.4,58.7,54.65]],['C',[55.1,50.9,50.3,49.7]],['C',[48.35,50.1,47.05,51.25]],['C',[45.8,52.35,45.1,53.6]],['C',[44.45,54.9,43.3,57.1]],['C',[42.2,59.3,41.3,60.45]],['C',[39.45,59.6,38.1,59]],['C',[36.7,58.4,35.45,57.65]],['C',[34.2,56.85,33.1,55.8]],['C',[32.05,54.8,31.55,53.5]],['C',[33.3,48.35,35.2,43.75]],['C',[37.1,39.15,39.05,34.95]],['C',[35.85,32.25,33.35,29.1]],['C',[30.85,26,27.85,21.5]],['C',[29.3,17.9,31.1,15.65]],['C',[32.9,13.4,35.85,13.3]],['C',[36.6,13.4,37.45,13.5]],['C',[38.3,13.6,39.45,13.8]],['C',[40.65,13.95,41.75,14.1]],['C',[42.85,14.25,43.95,14.15]],['C',[51.05,13.95,57.8,13.05]],['C',[64.55,12.1,70.7,10.25]],['C',[74.8,12.1,77.75,14.35]],['C',[80.65,16.6,81.25,20.15]],['C',[80.95,20.4,80.9,20.7]],['C',[80.85,21,80.7,21.4]],['C',[80.55,21.8,80.3,22.25]],['C',[80.1,22.75,80,23.15]],['C',[71.95,22.25,64.8,26.5]],['C',[57.6,30.75,54.7,38]],['C',[63.95,42.5,70.2,49.75]],['C',[76.45,57.05,76.45,66.2]],['L',[76,70.15]],['C',[76.65,70.6,79.3,72.15]],['C',[81.95,73.65,83.7,74.95]],['C',[85.45,76.3,86.8,78.05]]];
			__motifs["キ"] = [['M',[92.5,32.65]],['C',[95.2,35.85,95.6,39.85]],['C',[93.95,40.55,92.3,41.8]],['C',[90.65,43.1,89.1,44.75]],['C',[87.6,46.4,86.3,48.05]],['C',[84.95,49.7,83.2,51.85]],['L',[58.5,85.85]],['C',[58.3,86.15,58.45,86.35]],['C',[58.6,86.55,58.8,86.7]],['C',[59,86.85,59.2,87.15]],['C',[59.4,87.5,59.4,87.9]],['C',[59,89.75,57.65,91.05]],['C',[56.35,92.4,54.5,92.4]],['C',[52.45,92.2,50.85,91.1]],['C',[49.2,90.05,47.5,88.4]],['C',[45.8,86.75,44.4,85.4]],['C',[42.95,84.1,40.9,82.25]],['C',[38.85,80.4,37.8,79.45]],['C',[36.7,78.5,35.25,77.2]],['C',[33.8,75.9,33.05,75.2]],['C',[32.3,74.5,31.7,73.95]],['C',[31.05,73.35,29.95,72.35]],['C',[28.8,71.4,28.15,70.9]],['C',[27.55,70.4,26.35,69.55]],['C',[25.2,68.65,24.75,68.25]],['C',[24.3,67.9,23.15,67.05]],['C',[21.95,66.2,21.15,65.5]],['C',[20.3,64.75,19.55,64.05]],['C',[18.75,63.4,17.95,62.75]],['C',[17.2,62.1,16.25,61.6]],['C',[15.35,61.05,14.45,60.7]],['C',[13.55,60.35,12.2,59.95]],['C',[10.85,59.6,9.95,59.3]],['C',[9.1,59,8.2,58.55]],['C',[7.3,58.1,6.45,57.2]],['C',[5.55,56.25,5.15,54.1]],['C',[4.7,51.95,4.7,49.7]],['C',[4.6,48.65,4.65,48.05]],['C',[4.7,47.45,5.2,47]],['L',[6.95,46.2]],['C',[12.8,48.15,18.3,51.4]],['C',[23.85,54.6,28.25,58.2]],['C',[32.7,61.85,39.35,67.8]],['C',[46,73.75,49.6,76.75]],['L',[76.05,41.9]],['L',[71.95,41.4]],['C',[69.8,41.5,68.55,41.55]],['C',[67.3,41.6,66.25,41.65]],['C',[65.25,41.7,63.5,41.7]],['C',[61.7,41.7,60.85,41.9]],['C',[58.7,41.7,54.85,41.7]],['C',[51,41.7,48.8,41.65]],['C',[46.6,41.6,44,41.55]],['C',[41.4,41.5,37.3,41.4]],['C',[36.35,41.2,35.75,41.6]],['C',[35.15,42,34.65,42.9]],['C',[34.2,43.85,34.15,45.75]],['C',[34.1,47.65,34.2,49.9]],['C',[32.7,51,30.5,51.35]],['C',[28.3,51.65,27.25,50.9]],['C',[25.1,49.7,23.75,48.95]],['C',[22.35,48.15,21.3,47.25]],['C',[20.4,43.95,21.25,40.15]],['C',[22.05,36.35,24.2,34.2]],['C',[26.35,32.05,29.55,31.3]],['C',[32.7,30.6,35.4,30.6]],['C',[38.1,30.6,40.3,30.7]],['C',[42.5,30.85,44.1,30.9]],['C',[45.7,30.95,47.3,30.95]],['C',[48.95,30.95,50.7,30.85]],['C',[50.5,27.25,48.5,25.9]],['C',[46.5,24.5,42.55,23.5]],['C',[38.55,22.45,36.6,21.1]],['C',[34.65,19.75,34.65,16.4]],['C',[36.25,10.75,41.6,8.6]],['C',[46.95,6.45,53.9,6.15]],['C',[59.65,6.25,63.8,8.05]],['C',[67.95,9.85,68.55,14.85]],['C',[68.15,17.6,65.65,19.4]],['C',[63.1,21.2,60.15,21.2]],['C',[58.8,21.1,57.6,20.55]],['C',[56.45,20.05,55.95,19.55]],['C',[57.6,19.55,58.9,19.1]],['C',[60.15,18.65,61.35,17.5]],['C',[61.6,16.2,61.2,15.3]],['C',[60.75,14.35,59.75,13.85]],['C',[58.8,13.3,57.65,13]],['C',[56.55,12.7,55.55,12.7]],['C',[51.55,12.9,49.05,13.55]],['C',[46.6,14.15,44.9,16]],['C',[44.35,17.1,44.8,17.9]],['C',[45.3,18.65,46.25,19.2]],['C',[47.15,19.75,49.05,20.55]],['C',[51,21.4,52.05,22.15]],['C',[53.15,22.85,53.9,23.95]],['C',[54.7,25,55.2,26]],['C',[55.65,26.95,56.35,28.65]],['C',[57.05,30.4,57.7,31.25]],['C',[60.45,30.85,63.7,30.7]],['C',[67,30.6,71.4,30.45]],['C',[75.8,30.3,79.25,30.05]],['C',[82.7,29.8,86.05,29.2]],['C',[89.75,29.4,92.5,32.65]]];
			__motifs["ク"] = [['M',[86.85,12.25]],['C',[88.2,13.3,89.05,14.7]],['C',[89.95,16.1,90.05,18]],['L',[89.85,20.7]],['C',[88.85,21.2,87.65,21.55]],['C',[86.45,21.9,85.65,22]],['C',[84.85,22.1,83.2,22.25]],['C',[81.55,22.45,80.2,22.9]],['C',[78.8,23.35,77.05,24.65]],['C',[75.3,26,73.4,27.9]],['C',[71.5,29.8,69.9,31.45]],['C',[68.35,33.1,66.8,35.05]],['C',[65.25,37,63.85,39]],['C',[62.5,41,61.45,43.1]],['C',[67.85,48.25,71.7,55.2]],['C',[75.5,62.1,74.4,69.75]],['C',[75.3,70.5,77.7,71.95]],['C',[80.1,73.35,81.6,74.4]],['C',[83.1,75.5,84.35,77.05]],['C',[85.55,78.6,86.05,80.6]],['C',[86.05,83.6,84.25,86.45]],['C',[82.4,89.25,79.8,89.25]],['C',[78.4,84.95,76.75,81.75]],['C',[75.1,78.5,72.55,76.1]],['C',[70.7,80.95,66,84.25]],['C',[61.35,87.5,56.35,87.5]],['C',[48.45,87.5,42.55,83.25]],['C',[36.6,79,31.3,73]],['C',[26,67,23.55,64.35]],['C',[21.1,61.75,18.15,59.2]],['C',[15.25,56.65,11.95,54.65]],['C',[8.7,52.65,5,51.45]],['C',[12.5,51.75,20.1,55.65]],['C',[27.75,59.6,34.45,65.75]],['C',[37.1,67.9,38.9,69.4]],['C',[40.7,70.9,42.8,72.25]],['C',[44.9,73.55,47.3,74.35]],['C',[49.7,75.2,52.45,75.4]],['C',[56.55,75,59.1,71.3]],['C',[61.6,67.6,61.45,63.4]],['C',[61.25,60.75,60,58.3]],['C',[58.8,55.85,56.85,54.9]],['C',[55.65,54.9,54.8,55.25]],['C',[53.9,55.6,53.3,56.3]],['C',[52.75,57.05,52.1,58.2]],['C',[51.45,59.4,51.15,59.75]],['C',[48.05,60.35,45,58.15]],['C',[42,55.95,40.9,52.85]],['C',[41.2,49.6,59.55,24.25]],['C',[56.95,24.35,54.2,24.2]],['C',[51.45,24.05,49.25,23.85]],['C',[47.05,23.65,43,23.2]],['C',[38.95,22.75,36.8,22.65]],['C',[34.95,22.25,33.4,22.8]],['C',[31.85,23.35,30.35,24.6]],['C',[29.8,25.2,29.65,26.25]],['C',[29.5,27.25,29.5,28.25]],['C',[29.3,28.5,29.4,29.05]],['C',[29.5,29.6,29.65,30.4]],['C',[29.8,31.15,29.8,31.7]],['C',[29.8,32.25,29.7,32.9]],['C',[28.7,33.7,27.7,34.15]],['C',[26.65,34.6,25.2,34.95]],['C',[22.45,34.4,20.15,33.05]],['C',[17.85,31.75,16.3,29.9]],['C',[15.65,26.45,16.1,22.9]],['C',[16.6,19.35,18.25,16.4]],['C',[19.9,13.5,22.75,11.85]],['C',[25.6,10.25,29.5,10.85]],['C',[31.35,11.05,34.8,11.45]],['C',[38.3,11.85,40.65,12.1]],['C',[42.95,12.4,45.2,12.55]],['C',[47.45,12.7,49.8,12.9]],['C',[55,12.6,58.55,12.35]],['C',[62.1,12.1,65.75,11.7]],['C',[69.45,11.25,73.35,10.55]],['C',[77.25,9.85,80.95,9]],['C',[82.7,9.85,84.15,10.55]],['C',[85.55,11.25,86.85,12.25]]];
			__motifs["ケ"] = [['M',[83.2,96.65]],['C',[77.45,95.4,74,93.6]],['C',[70.6,91.8,67.25,89.65]],['C',[63.85,87.5,61.65,86.35]],['C',[59.45,85.15,57,84.3]],['C',[54.5,83.4,51.95,83.4]],['C',[52.25,80.95,53.65,79.5]],['C',[55.1,78.05,57.15,77.35]],['C',[59.2,76.65,61.5,76.45]],['C',[63.85,76.3,66.7,76]],['C',[66.8,72.95,66.5,70.05]],['C',[66.2,67.1,65.75,63]],['C',[65.35,58.9,65.1,56]],['C',[64.85,53.15,64.85,50.4]],['C',[60.35,47.65,52.8,43.7]],['C',[45.2,39.75,40.45,38.1]],['C',[39.55,38.95,39.95,41.5]],['C',[40.35,49.05,39.7,55.8]],['C',[39.05,62.6,36.8,69.75]],['C',[34.55,76.85,30.2,82.3]],['C',[25.8,87.7,19.05,89.25]],['C',[17.1,89.25,15.2,88.4]],['C',[13.3,87.5,11.8,86.05]],['C',[10.35,84.6,9.55,82.75]],['C',[8.8,80.95,9.1,79.1]],['C',[8.7,76.75,9.8,74.8]],['C',[10.95,72.85,13.1,72.25]],['C',[13.3,72.25,13.5,72.35]],['C',[13.65,72.45,13.9,73]],['C',[14.15,73.55,14.35,73.85]],['C',[14.55,74.15,15.05,74.5]],['C',[19.45,72.85,22.1,69]],['C',[24.8,65.15,26.6,59.8]],['C',[28.4,54.5,29.1,49.8]],['C',[29.8,45.15,29.6,40.55]],['L',[20.7,49.7]],['C',[19.25,49.9,17.9,49.3]],['C',[16.6,48.65,15.55,47.6]],['C',[14.45,46.6,13.55,45.45]],['C',[12.7,44.35,11.6,43]],['C',[12.8,41,14.3,38.9]],['C',[15.8,36.85,17.15,35.35]],['C',[18.45,33.9,20.7,31.3]],['C',[22.95,28.7,24.1,27.45]],['C',[22.85,26,21.95,25]],['C',[21.1,24.05,20.25,23]],['C',[19.45,22,18.65,21.1]],['C',[17.85,20.2,16.7,19.15]],['C',[17.1,18.45,18.15,16.15]],['C',[19.25,13.9,20.25,12.5]],['C',[21.3,11.15,22.75,10.25]],['C',[24.2,9.4,26.15,9.5]],['C',[27.25,9.6,28.45,9.75]],['C',[29.7,9.85,31.15,9.9]],['C',[32.6,9.95,33.75,10.05]],['C',[34.85,10.15,35.95,10.35]],['C',[39.95,9.95,44,9.35]],['C',[48.05,8.7,53.3,7.65]],['C',[55.1,8.7,56.5,9.6]],['C',[57.9,10.45,59.25,11.7]],['C',[60.55,12.9,61.45,14.5]],['C',[62.3,16.1,62.3,18.1]],['C',[56.35,18.95,51.7,21.05]],['C',[47.05,23.15,43.45,26.85]],['C',[45.6,28.05,47.95,29.2]],['C',[50.3,30.4,53.75,32.15]],['C',[57.25,33.9,59.5,35.1]],['C',[61.8,36.35,64.05,38]],['C',[63.95,33.5,63.75,28.45]],['C',[63.55,23.35,63.5,18.35]],['C',[63.65,15.85,63.85,13.8]],['C',[64.05,11.75,64.7,9.85]],['C',[65.35,8,66.65,6.65]],['C',[67.95,5.3,70.1,5]],['C',[74.2,6.35,77.35,8.3]],['C',[80.45,10.25,81.95,13.4]],['C',[79.1,13.95,77.35,16.45]],['C',[75.6,18.95,75.8,22]],['L',[77.75,52.35]],['C',[77.95,55.5,78.25,58.8]],['C',[78.6,62.1,78.9,65.7]],['C',[79.2,69.25,79.65,74.2]],['C',[80.1,79.1,80.35,81.45]],['L',[79.7,86.85]],['C',[82.6,90.25,86.6,93.1]],['C',[90.65,95.9,95.2,97.85]],['C',[88.95,97.85,83.2,96.65]],['M',[94.15,57.65]],['C',[95.1,58.5,95.65,59.75]],['C',[96.2,61.05,96.2,62.5]],['C',[96.3,64.45,94.85,66.45]],['C',[93.45,68.45,92.3,68.95]],['L',[89.75,69.65]],['C',[88.3,69.75,87.05,69.25]],['C',[85.85,68.75,84.8,67.95]],['C',[83.8,67.1,83.25,65.95]],['C',[82.7,64.75,82.8,63.5]],['C',[82.7,62,83.2,60.65]],['C',[83.7,59.3,84.6,58.25]],['C',[85.55,57.25,86.85,56.75]],['C',[88.2,56.25,89.75,56.45]],['C',[90.8,56.25,92,56.55]],['C',[93.15,56.85,94.15,57.65]],['M',[95.7,32.15]],['C',[95.7,33.4,95.1,34.45]],['C',[94.55,35.45,93.6,36.3]],['C',[92.7,37.1,91.5,37.55]],['C',[90.35,38,89.35,38]],['C',[86.6,38,84.45,36.05]],['C',[82.3,34.1,82.25,31.65]],['C',[82.25,30.3,82.75,29]],['C',[83.3,27.75,84.35,26.8]],['C',[85.35,25.9,86.65,25.4]],['C',[88,24.9,89.35,25]],['C',[92,25,93.85,27.1]],['C',[95.7,29.2,95.7,32.15]]];
			__motifs["コ"] = [['M',[92.5,45.2]],['C',[92.2,46.8,91,47.9]],['C',[89.85,49.05,88.5,48.85]],['C',[86.45,47.25,85,46.6]],['C',[83.6,45.9,82.05,46.2]],['C',[80.2,46.6,79,48.35]],['C',[77.85,50.1,78.15,52.15]],['C',[78.3,52.65,79.05,53.55]],['C',[79.8,54.5,80.1,54.9]],['C',[80.35,55.3,81.05,56.25]],['C',[81.75,57.25,82.05,58]],['C',[81.55,59.6,80,60.8]],['C',[78.4,62,76.45,62.9]],['C',[75.6,62.1,72.5,59.25]],['C',[69.45,56.35,67.4,54.8]],['C',[65.35,53.25,62.9,52.25]],['C',[60.45,51.3,57.7,51.45]],['L',[57.7,78.7]],['C',[57.7,81.15,57.05,82.9]],['C',[61.25,87.4,65.8,91]],['C',[70.4,94.65,75.6,97.2]],['C',[68.35,97.2,61.65,95.4]],['C',[55,93.65,51.2,91.1]],['C',[47.45,88.6,43.9,85.45]],['C',[40.35,82.35,38.3,80.65]],['C',[36.25,79,33.35,77.55]],['C',[30.45,76.1,27.35,75.8]],['C',[30.95,72.75,35.35,71.25]],['C',[39.75,69.75,44.45,70.15]],['L',[44.45,49.35]],['C',[42.95,49.15,41.4,49.2]],['C',[39.85,49.25,38.25,49.45]],['C',[36.6,49.7,35.15,50.05]],['C',[33.7,50.4,32.25,50.9]],['C',[30.65,50.5,29.45,49.5]],['C',[28.2,48.55,27.35,47.3]],['C',[26.45,46.1,25.4,44.3]],['C',[24.3,42.5,23.95,42]],['C',[27.95,38.95,32.95,37.85]],['C',[38,36.75,44.25,37.2]],['C',[44.35,27.15,44.15,24.7]],['C',[43.95,22.25,43.5,21.95]],['C',[43.05,21.6,42.7,21.4]],['C',[42.3,21.2,41.55,20.95]],['C',[40.8,20.7,40.4,20.55]],['C',[39.95,20.4,39.3,20.1]],['C',[38.65,19.75,37.95,19.5]],['C',[37.2,19.25,36.15,19]],['C',[35.05,18.75,33.85,18.55]],['C',[32.6,18.35,31.25,18.25]],['C',[30.2,18.85,29.85,19.9]],['C',[29.5,20.9,29.4,22.05]],['C',[29.3,23.15,29.45,24.9]],['C',[29.6,26.65,29.6,27.25]],['C',[28.8,27.65,28.35,27.85]],['C',[27.95,28.05,27.65,28.15]],['C',[27.35,28.25,27,28.4]],['C',[26.65,28.5,25.8,28.7]],['C',[24.4,28.35,23.3,27.8]],['C',[22.15,27.25,21.2,26.55]],['C',[20.2,25.9,19.3,25.25]],['C',[18.35,24.6,17.6,24.05]],['C',[17.6,22.85,17.45,20.8]],['C',[17.3,18.75,17.3,17.5]],['C',[17.3,16.2,17.45,14.9]],['C',[17.6,13.6,18.4,11.85]],['C',[19.25,10.15,21.85,8.6]],['C',[24.4,7.05,27.35,7.35]],['C',[30.85,7.25,42.2,8.6]],['C',[44.75,8.2,49.45,7.85]],['C',[54.2,7.55,56.95,7.15]],['C',[59.65,6.75,63,6.1]],['C',[66.3,5.5,69.45,4.5]],['C',[71.3,5.5,72.75,6.3]],['C',[74.2,7.15,75.75,8.25]],['C',[77.25,9.4,78.35,10.8]],['C',[79.5,12.2,80,14.15]],['C',[78.7,14.45,76.7,15.05]],['C',[74.7,15.65,73.55,15.95]],['C',[72.35,16.2,70.9,16.75]],['C',[69.45,17.3,67,18.2]],['C',[64.55,19.15,62.05,20.9]],['C',[59.55,22.65,58.65,24.55]],['C',[57.7,26.45,57.45,28.25]],['C',[57.25,30,57.15,31.55]],['C',[57.05,33.1,57.2,35.55]],['C',[57.3,38,57.3,38.8]],['C',[61.05,39.75,64.1,41.05]],['C',[67.2,42.4,70.1,44.55]],['C',[70.8,40.85,73.7,38.5]],['C',[76.55,36.15,80.2,36.25]],['C',[84.45,36.75,88.15,38.95]],['C',[91.8,41.2,92.5,45.2]]];
			__motifs["サ"] = [['M',[84.7,59.1]],['C',[83.5,61.85,80.65,62.7]],['C',[80.1,61.35,78.9,58.2]],['C',[77.75,55.1,76.7,53.05]],['C',[75.7,51,74.05,49.15]],['C',[72.45,47.25,70.1,46.1]],['C',[69.75,47.25,69.55,48.6]],['C',[69.35,49.9,69.2,51.1]],['C',[69.05,52.25,69.05,54.2]],['C',[69.05,56.15,68.95,57.15]],['C',[69.75,70.4,73.3,80.35]],['C',[76.85,90.25,86.25,96.3]],['C',[71.3,92,64.3,79.2]],['C',[57.3,66.4,57.6,51.75]],['C',[57.6,49.15,57.65,46.7]],['C',[57.7,44.25,57.9,42.65]],['C',[58.1,41,58.35,37.75]],['C',[58.6,34.5,58.7,32.65]],['C',[59,29.6,58.4,26.9]],['C',[57.8,24.25,56.3,22.15]],['C',[54.8,20.05,52.55,18.8]],['C',[50.3,17.6,47.55,17.6]],['C',[40.7,17.9,38.3,23.3]],['C',[35.85,28.7,35.85,36.15]],['C',[35.45,37.9,35.7,39.7]],['C',[35.95,41.5,36.8,43.65]],['C',[37.8,44.75,34.4,45.2]],['C',[32.3,45.15,30.7,44.65]],['C',[29.1,44.15,27.75,43.3]],['C',[26.35,42.5,24.65,41.1]],['C',[22.95,39.75,22.45,39.35]],['C',[21.7,32.9,22.35,27.25]],['C',[23.05,21.6,26,16.6]],['C',[28.9,11.65,34.65,8.35]],['C',[40.45,5.1,46.95,5.5]],['C',[56.75,5.6,63.45,10.85]],['C',[70.1,16.1,71.6,21.9]],['C',[72.15,24.9,72.3,27.75]],['C',[72.45,30.6,72.25,32.9]],['C',[72.05,35.25,71.7,37.8]],['C',[71.3,40.35,71.2,41]],['C',[76.85,43.1,81,45.85]],['C',[85.15,48.65,86.45,52.75]],['C',[85.95,56.35,84.7,59.1]]];
			__motifs["シ"] = [['M',[56.8,40.1]],['C',[52.75,44.85,52.55,50.5]],['C',[52.35,53.5,53.65,56.5]],['C',[55,59.5,57.3,61.85]],['C',[59.55,64.15,62.65,65.35]],['C',[65.7,66.5,68.85,66.2]],['C',[69.25,63.3,66.7,31.85]],['C',[60.85,35.35,56.8,40.1]],['M',[92.55,9.15]],['C',[95.1,11.85,94.55,15.65]],['C',[90.25,15.55,86.3,17.65]],['C',[82.3,19.75,78.8,23.65]],['C',[80.45,64.75,82.4,75]],['C',[83.3,81.15,86.85,86.75]],['C',[90.45,92.3,95.8,94.45]],['C',[95.1,94.75,91.8,93.95]],['C',[88.5,93.15,84.7,91.5]],['C',[80.95,89.85,77.8,86.45]],['C',[74.6,83,72.05,76.4]],['C',[65.45,76.4,59.6,74.95]],['C',[53.8,73.55,49.55,70.1]],['C',[45.3,66.6,42.95,60.8]],['C',[40.65,55,40.65,49.15]],['C',[40.35,44.55,42.05,40.55]],['C',[43.75,36.55,46.55,33.15]],['C',[49.3,29.8,52.5,27]],['C',[55.65,24.25,59.95,20.6]],['C',[56.55,20.6,53.1,20.35]],['C',[49.6,20.15,46.95,19.85]],['C',[44.35,19.55,39.5,18.95]],['C',[34.65,18.35,32.05,18.25]],['C',[30.65,18.85,30.2,20.3]],['C',[29.7,21.8,30,23.25]],['C',[31.35,24.9,32.25,27.15]],['C',[33.1,29.4,33.8,32.35]],['C',[33.8,35.85,32.6,38.9]],['C',[31.45,41.9,29.2,46.1]],['C',[29.8,47.65,30.2,49.55]],['C',[30.65,51.45,30.95,53.5]],['C',[31.25,55.5,31.35,57.4]],['C',[31.45,59.3,31.55,62.2]],['C',[31.35,70.05,29.85,75.7]],['C',[28.3,81.35,23.95,85.45]],['C',[21.6,84.75,20.2,83.05]],['C',[18.85,81.35,18.2,79.3]],['C',[17.6,77.25,17.4,75.1]],['C',[17.2,72.95,17,70.15]],['C',[19.35,67.5,20.45,64.1]],['C',[21.6,60.75,22.15,56.25]],['C',[22.15,55.3,22,54.4]],['C',[21.9,53.5,21.6,53.05]],['C',[20.4,53.15,19.7,53.35]],['C',[18.95,53.5,18.1,53.7]],['C',[17.3,53.9,16.6,54]],['C',[15.9,54.1,15.35,54.2]],['C',[13.5,54.4,11.9,53.85]],['C',[10.35,53.35,9.05,52.55]],['C',[7.7,51.75,6.1,50.5]],['C',[4.5,49.25,3.9,48.85]],['C',[11.6,45.9,17.6,39.45]],['C',[23.55,33,23.95,25.2]],['C',[21,23.65,19.3,22.1]],['C',[17.6,20.5,17.95,18.1]],['C',[17.7,15.65,18.6,13.25]],['C',[19.55,10.85,21.3,9.1]],['C',[23.05,7.35,25.45,6.45]],['C',[27.85,5.6,30.45,5.95]],['C',[33.3,6.15,35.4,6.3]],['C',[37.5,6.45,40.2,6.75]],['C',[42.85,7.05,45,7.2]],['C',[47.15,7.35,49.4,7.65]],['C',[51.35,7.55,57.65,7.4]],['C',[63.95,7.25,68.3,7]],['C',[72.65,6.75,77.2,6.1]],['C',[81.75,5.5,86.05,4.5]],['C',[89.95,6.45,92.55,9.15]]];
			__motifs["ス"] = [['M',[88.1,9.55]],['C',[90.8,12.6,91.3,16.4]],['C',[88.5,16.6,86.3,19]],['C',[84.1,21.4,84,24.25]],['C',[83.8,37.7,83.9,46.35]],['C',[84,55,84.2,59.5]],['C',[84.4,63.95,84.5,66.1]],['C',[84.65,68.25,84.85,69.65]],['C',[85.05,71,85.25,73.1]],['C',[85.45,75.2,85.75,76.7]],['C',[86.05,78.25,86.55,79.95]],['C',[87.1,81.65,88.35,84.2]],['C',[89.55,86.75,92,90.05]],['C',[94.45,93.35,95.8,94.15]],['C',[93.45,93.75,90.8,92.45]],['C',[88.2,91.1,85.85,89.35]],['C',[83.5,87.6,81.55,85.55]],['C',[79.6,83.5,78.65,81.9]],['C',[77.75,80.3,76.9,78.6]],['C',[76.05,76.95,75.45,76.05]],['C',[74.8,75.1,73.95,74.2]],['C',[73.05,73.25,71.4,72.3]],['C',[69.75,71.4,66.45,70.8]],['C',[63.2,70.2,60.85,70.2]],['C',[59.85,70.2,58.8,70.35]],['C',[57.7,70.5,57.05,70.75]],['C',[56.35,71,55.05,71.25]],['C',[53.7,71.5,53.15,71.6]],['C',[50.8,71.8,48.75,70.8]],['C',[46.7,69.85,45.2,68.25]],['C',[43.75,66.7,42.95,64.7]],['C',[42.2,62.7,42.6,60.75]],['C',[41.7,60.25,40.7,60.05]],['C',[39.75,59.85,38.75,59.75]],['C',[37.8,59.6,36.45,59.6]],['C',[35.15,59.6,34.65,59.5]],['C',[34,59.5,33.2,59.65]],['C',[32.4,59.75,31.5,59.95]],['C',[30.55,60.15,29.85,60.3]],['C',[29.1,60.45,28.4,60.45]],['C',[20.8,59.1,18.25,51.7]],['C',[15.7,44.35,16.6,35.85]],['C',[15.25,34.75,14.1,33.75]],['C',[13,32.7,11.75,31.65]],['C',[10.55,30.6,9.6,29.6]],['C',[8.7,28.6,8.2,27.85]],['C',[8.6,27.35,9.75,25.45]],['C',[10.95,23.55,12,22.45]],['C',[13.1,21.4,14.6,20.9]],['C',[16.1,20.4,17.95,20.9]],['L',[21.95,21.1]],['C',[22.95,21,23.8,20.85]],['C',[24.6,20.7,25.5,20.55]],['C',[26.35,20.4,27.25,20.1]],['C',[28.15,19.75,28.8,19.35]],['C',[29.5,19.65,32,20.15]],['C',[34.45,20.7,36.1,21.35]],['C',[37.7,22,38.85,23.35]],['C',[40.05,24.7,40.35,26.85]],['L',[38.1,29.5]],['C',[34.95,28.9,33,30.1]],['C',[31.05,31.25,30,33.35]],['C',[28.9,35.45,28.65,38.05]],['C',[28.4,40.65,28.6,43.35]],['C',[28.4,45.5,28.85,47.2]],['C',[29.3,48.85,30.1,49.35]],['C',[30.85,49.9,31.55,50.05]],['C',[32.25,50.2,32.9,50.2]],['C',[33.6,50.2,34.75,50.15]],['C',[35.95,50.1,37,50.1]],['C',[38.1,50.1,39.65,50.5]],['C',[41.2,50.9,42.7,51.75]],['L',[42.7,17.4]],['C',[41.8,15.25,41.1,13.75]],['C',[40.45,12.2,39.85,11.15]],['C',[40.35,9.6,41.5,8.85]],['C',[42.7,8.1,44.45,8]],['C',[46.2,8.6,47.8,9.25]],['C',[49.4,9.85,51.1,10.8]],['C',[52.85,11.75,54.25,12.85]],['C',[55.65,13.95,56.95,15.55]],['C',[57.05,15.85,56.9,16.2]],['C',[56.75,16.6,56.5,17.1]],['C',[56.25,17.6,56.15,18]],['C',[56.05,18.35,56.35,18.85]],['L',[56.25,57.25]],['C',[56.25,58.1,56.6,58.75]],['C',[56.95,59.4,57.5,59.65]],['C',[58.1,59.85,59.1,60.1]],['C',[60.05,60.35,60.35,60.45]],['C',[62.2,60.25,63.55,60.2]],['C',[64.95,60.15,65.95,60.3]],['C',[67,60.45,67.5,60.55]],['C',[67.95,60.65,68.45,60.9]],['C',[68.95,61.15,70.05,61.6]],['C',[71.2,62,71.9,62.2]],['C',[71.3,59.5,71.2,56.8]],['C',[71.1,54.1,71.05,50]],['C',[71,45.9,71,43.1]],['C',[71,40.35,70.8,37.6]],['C',[71,35.45,71,33.35]],['C',[71,31.25,71,28.1]],['C',[71,24.9,71,22.75]],['C',[71,20.6,71.5,16.8]],['C',[71.95,13,74.2,9.25]],['C',[76.45,5.5,81.55,4.8]],['C',[85.35,6.45,88.1,9.55]]];
			__motifs["セ"] = [['M',[48.35,59.4]],['L',[48.35,35.85]],['L',[34,49.05]],['C',[37.2,50.8,40.6,53.2]],['C',[43.95,55.6,48.35,59.4]],['M',[84,15.35]],['C',[76.95,16.5,71.35,18.95]],['C',[65.7,21.4,61.25,25.6]],['L',[61.25,62.1]],['C',[61.25,73.55,64.1,82.65]],['C',[67,91.8,74.8,97.55]],['C',[72.35,97.55,69.95,96.9]],['C',[67.6,96.2,65.45,95]],['C',[63.3,93.75,61.4,92.2]],['C',[59.45,90.65,57.9,88.9]],['C',[56.35,87.2,55.1,85.2]],['C',[53.8,83.2,53.15,81.8]],['C',[52.45,80.4,51.75,78.85]],['C',[51.05,77.35,50.6,76.4]],['C',[50.1,75.4,49.5,74.45]],['C',[48.95,73.55,47.95,72.25]],['C',[46.95,70.9,45.25,69.45]],['C',[43.55,68,41.95,66.85]],['C',[40.35,65.75,39,64.85]],['C',[37.7,63.95,36.85,63.45]],['C',[36.05,62.9,35,62.3]],['C',[34,61.75,32.3,61]],['C',[30.55,60.25,27.85,59.75]],['C',[25.1,59.3,21.5,59.3]],['C',[17,59.4,13.9,54.95]],['C',[10.85,50.5,10.75,46.2]],['C',[17.85,43,24.35,38]],['C',[30.85,33,38,26.1]],['C',[35.85,24.15,34.55,22.85]],['C',[33.3,21.6,31.95,20.2]],['C',[30.55,18.85,29.4,17.5]],['C',[28.2,16.1,27.25,14.75]],['C',[28.2,12.7,29,11.15]],['C',[29.8,9.6,31,8.3]],['C',[32.25,7.05,33.85,6.25]],['C',[35.45,5.5,37.5,5.85]],['C',[39.15,5.95,41.05,6.1]],['C',[42.95,6.25,45.9,6.55]],['C',[48.85,6.85,50.7,7]],['C',[52.55,7.15,54.5,7.35]],['C',[56.35,7.05,59.75,6.7]],['C',[63.2,6.35,65.1,6.1]],['C',[67,5.85,69.35,5.25]],['C',[71.7,4.6,73.95,3.6]],['C',[77.35,4,80.55,6.35]],['C',[83.8,8.7,84.45,12.2]],['L',[84,15.35]]];
			__motifs["ソ"] = [['M',[91.45,6.55]],['C',[94.45,9.5,95.4,13.6]],['C',[89.55,14.85,86.15,20]],['C',[82.7,25.1,82.6,31.45]],['C',[82.7,39.15,86.55,46.4]],['C',[90.45,53.6,96.95,58.6]],['C',[94.35,59.1,89.75,57.55]],['C',[85.15,55.95,80.8,52.3]],['C',[76.45,48.65,73.6,42.15]],['C',[70.7,35.65,70.2,25.6]],['C',[70.1,23.65,70.7,19.75]],['C',[64.05,20.5,57.7,23.25]],['C',[51.35,26,46.7,30.3]],['C',[56.55,37.9,63.65,48.95]],['C',[70.8,59.95,72.95,72.1]],['C',[72.65,73.65,71.3,74.95]],['C',[69.9,76.3,68.45,76.3]],['C',[64.85,75.8,62.85,73.6]],['C',[60.85,71.4,60,68.8]],['C',[59.2,66.2,58.85,64.75]],['C',[58.5,63.3,58.1,61.55]],['C',[57.7,59.75,57.45,58.5]],['C',[57.25,57.25,56.6,55.25]],['C',[55.95,53.25,54.45,50.7]],['C',[52.95,48.15,50.75,45.45]],['C',[48.55,42.8,46.2,40.55]],['C',[43.85,38.3,41.2,36.85]],['C',[38.5,40.25,35.1,43.2]],['C',[31.75,46.2,27.75,49.15]],['C',[37.1,55.85,43.4,66.25]],['C',[49.7,76.65,51.35,88.3]],['C',[51,90.25,50.05,91.7]],['C',[49.1,93.15,47.35,93.15]],['C',[44.45,92.8,42.2,90.85]],['C',[39.95,88.9,38.85,86.75]],['C',[37.8,84.6,37.35,83.2]],['C',[36.9,81.85,36.65,80.85]],['C',[36.45,79.9,35.95,78]],['C',[35.45,76.1,34.8,74.25]],['C',[34.2,72.35,32.75,69.9]],['C',[31.35,67.4,29.75,65.15]],['C',[28.15,62.9,26.65,61.45]],['C',[25.2,59.95,23.85,59.35]],['C',[22.45,58.7,20.95,58.6]],['C',[19.45,58.5,17.6,58.6]],['C',[13.55,58.2,10.5,54.65]],['C',[7.4,51.1,6.95,47.35]],['C',[7.6,46.4,8.6,45.6]],['C',[9.55,44.85,10.7,44.15]],['C',[11.8,43.45,13.55,42.7]],['C',[15.25,41.9,16.7,41]],['C',[18.15,40.15,20.3,38.5]],['C',[22.45,36.85,25.15,34.5]],['C',[27.85,32.15,29.55,30.4]],['C',[31.25,28.6,32.7,26.65]],['C',[30,24.25,27.6,21.8]],['C',[25.2,19.35,23.75,17.1]],['C',[25,13.8,27.55,11]],['C',[30.1,8.2,33.3,8]],['C',[34.45,8.1,36.45,8.4]],['C',[38.5,8.7,39.7,8.9]],['C',[40.9,9.1,42.6,9.3]],['C',[44.25,9.5,46,9.5]],['C',[52.85,9.5,58.7,8.4]],['C',[64.55,7.35,69.75,4.9]],['C',[70.6,4.9,71.35,5.25]],['C',[72.05,5.6,72.7,6.15]],['C',[73.35,6.75,74.3,7.7]],['C',[75.3,8.7,76.05,9.3]],['C',[77.55,6.75,79.75,4.95]],['C',[81.95,3.15,84.55,2.45]],['C',[88.5,3.6,91.45,6.55]]];
			__motifs["タ"] = [['M',[85.7,42.1]],['C',[87.3,43.35,88.35,45.15]],['C',[89.35,47,89.35,49.35]],['L',[88.85,52.85]],['C',[88.5,53.05,88.15,53.3]],['C',[87.8,53.5,87.35,53.8]],['C',[86.9,54.1,86.55,54.3]],['C',[86.25,54.5,85.95,54.5]],['C',[84.55,54.1,83.85,53.45]],['C',[83.1,52.75,82.4,51.6]],['C',[81.75,50.5,81.05,49.9]],['C',[80.35,49.35,79.2,49.35]],['C',[77.25,49.35,75.95,50.4]],['C',[74.6,51.45,74.2,53.5]],['C',[74.4,54,75.1,55.75]],['C',[75.8,57.55,76.2,58.85]],['C',[76.65,60.15,77,61.65]],['C',[77.35,63.1,77.35,64.75]],['L',[76.85,68.75]],['C',[76.15,69.35,75.45,69.8]],['C',[74.7,70.2,74.1,70.5]],['C',[71.2,70.15,68.8,68.5]],['C',[66.4,66.9,65.5,65.25]],['C',[64.55,63.6,64.2,62.45]],['C',[63.85,61.35,63.45,59.65]],['C',[63,57.9,62.6,56.65]],['C',[62.2,55.4,61.7,54.25]],['C',[61.25,53.15,60.55,52.05]],['C',[59.85,51,58.75,49.55]],['C',[57.6,48.15,56.95,47.25]],['C',[56.25,46.4,55.65,45.5]],['C',[55.45,49.25,55.45,52.35]],['C',[55.45,55.5,55.55,57.7]],['C',[55.65,59.95,55.8,63.05]],['C',[55.95,66.1,56.15,69.1]],['C',[56.35,72.1,56.2,76.5]],['C',[56.05,80.95,55.65,83]],['C',[60.45,88.5,66.25,92.15]],['C',[72.05,95.8,78.6,97.25]],['C',[78.15,97.25,77.5,97.3]],['C',[76.85,97.35,76,97.5]],['C',[75.1,97.65,74.6,97.7]],['C',[74.1,97.75,73.55,97.75]],['C',[67.95,97.2,64.5,96.5]],['C',[61.05,95.8,58.3,94.95]],['C',[55.55,94.05,53.55,93.25]],['C',[51.55,92.5,49.7,91.5]],['C',[47.85,90.55,45.9,89.2]],['C',[43.95,87.9,42.15,86.2]],['C',[40.35,84.5,39.15,83.4]],['C',[38,82.35,36.25,81.2]],['C',[34.45,80.1,32.05,79.1]],['C',[29.6,78.15,26.35,77.35]],['C',[27.35,75.2,29,74]],['C',[30.65,72.75,32.75,72.2]],['C',[34.85,71.6,36.95,71.5]],['C',[39.05,71.4,42.7,71.2]],['C',[42.95,69.35,43.15,66]],['C',[43.35,62.6,43.35,58.95]],['C',[43.35,55.3,43.25,49.35]],['C',[43.15,43.45,43.1,40.35]],['C',[43.05,37.2,43.05,34.25]],['C',[43.05,31.25,43,27.75]],['C',[42.95,24.25,42.9,23]],['C',[42.85,21.8,42.7,21.2]],['C',[41.4,20.9,40.65,20.75]],['C',[39.85,20.6,39.2,20.4]],['C',[38.55,20.2,37.95,20.2]],['C',[37.3,20.2,36.85,20.15]],['C',[36.45,20.05,36.1,19.95]],['C',[35.75,19.85,35.4,19.8]],['C',[35.05,19.75,34.8,19.75]],['C',[34.55,19.75,34.1,19.9]],['C',[33.6,20.05,33,20.35]],['C',[32.4,20.7,32.1,21.55]],['C',[31.75,22.35,31.75,24]],['C',[31.75,25.6,32.3,29]],['C',[31.75,29.4,31.3,29.7]],['C',[30.85,30,30.3,30.25]],['C',[29.8,30.5,29.3,30.6]],['C',[28.8,30.75,28.6,30.85]],['C',[26.65,30.3,24.95,29.65]],['C',[23.25,29,21.75,28.1]],['C',[20.2,27.15,19.55,25.65]],['C',[18.85,24.15,19.45,22.1]],['C',[19.45,20.2,19.45,18.85]],['C',[19.45,17.5,19.6,16.1]],['C',[19.75,14.75,20.05,13.5]],['C',[20.4,12.2,21.45,10.75]],['C',[22.45,9.3,25.2,8.4]],['C',[27.95,7.55,30.85,8]],['L',[42.3,9.5]],['C',[49.4,9.4,55.8,8]],['C',[62.2,6.65,67.6,3.6]],['C',[68.15,4,70.4,5.15]],['C',[72.65,6.25,74.1,7.35]],['C',[75.6,8.4,76.65,9.95]],['C',[77.75,11.55,77.95,13.6]],['C',[77.85,14.65,77.45,15.7]],['C',[77.05,16.7,76.55,18]],['C',[75.8,18.1,73,18.2]],['C',[70.2,18.35,68.25,18.65]],['C',[66.3,18.95,64.45,19.6]],['C',[62.6,20.2,60.15,21.95]],['C',[57.7,23.65,56.1,27.75]],['C',[54.5,31.85,55.55,36.05]],['C',[57.05,36.65,58.5,37.7]],['C',[59.95,38.8,61.5,40]],['C',[63.1,41.2,64.45,42.55]],['C',[65.8,43.85,67.95,46]],['C',[69.75,43,72.6,41.4]],['C',[75.5,39.85,78.6,40.15]],['C',[80.35,39.85,82.25,40.35]],['C',[84.1,40.85,85.7,42.1]]];
			__motifs["チ"] = [['M',[44.6,24.2]],['C',[42.2,25.4,40.4,26.55]],['C',[38.55,27.75,37.6,28.45]],['C',[36.6,29.1,35.5,30.05]],['C',[34.4,30.95,33.15,32.2]],['C',[31.95,33.4,29.4,36.1]],['C',[26.85,38.8,24.2,43.45]],['C',[21.6,48.15,21.3,54.2]],['C',[21.3,58.9,23.65,63.65]],['C',[26,68.35,29.6,70.95]],['C',[33.2,73.55,37.65,74.35]],['C',[42.1,75.1,48.55,75.2]],['C',[59,75.4,68,69.35]],['C',[77.05,63.3,77.95,53.15]],['C',[77.35,42.4,69.35,33.45]],['C',[61.35,24.5,51,21.8]],['C',[46.95,22.95,44.6,24.2]],['M',[87.05,68.5]],['C',[83.3,74.9,77.05,79.15]],['C',[70.8,83.4,63.55,85.55]],['C',[56.25,87.7,49.3,88]],['C',[40.45,87.9,32.3,85.4]],['C',[24.1,82.9,18.55,77.4]],['C',[13,71.9,10.45,63.25]],['C',[7.9,54.6,9.55,47]],['C',[13.2,33.9,23.7,24.5]],['C',[34.2,15.15,49.1,7.7]],['C',[65.7,13.95,77.85,26]],['C',[89.95,38,90.65,53.9]],['C',[90.8,62.1,87.05,68.5]]];
			__motifs["ツ"] = [['M',[81.35,19.35]],['C',[71.7,20.5,64.25,27.3]],['C',[56.85,34.1,55.45,43.45]],['C',[60.95,42.6,65.95,42.8]],['C',[71,43,75.35,44.25]],['C',[79.7,45.5,83.3,47.95]],['C',[86.9,50.4,89.05,53.3]],['C',[91.2,56.15,92.1,59.4]],['C',[92.95,62.6,93.05,65.65]],['C',[93.15,68.65,92.7,70.7]],['C',[92.3,72.75,90.8,75.65]],['C',[89.35,78.5,86.65,80.6]],['C',[84,82.7,79.5,83]],['C',[75.7,83,71.8,80]],['C',[67.85,76.95,67.85,73.35]],['C',[67.85,72,68,70.85]],['C',[68.15,69.75,68.7,69]],['C',[69.25,68.25,70.15,67.9]],['C',[71.1,67.5,72.45,67.8]],['C',[72.45,68.45,72.45,69]],['C',[72.45,69.55,72.7,70.05]],['C',[72.95,70.5,73.65,70.85]],['C',[74.3,71.2,75.7,71.2]],['L',[76.25,70.9]],['C',[76.85,70.6,77.4,69.95]],['C',[77.95,69.25,78.35,68]],['C',[78.8,66.7,78.7,64.95]],['C',[77.95,61.65,74.6,59]],['C',[71.3,56.35,67,55.95]],['C',[59,55.95,54.05,58.3]],['C',[49.1,60.65,46.8,64.35]],['C',[44.45,68.1,44,72.35]],['C',[43.55,76.65,44.75,82.05]],['C',[43.45,84.4,40.9,84.85]],['C',[39.45,84.85,38.15,84.4]],['C',[36.8,83.9,35.3,82.95]],['C',[33.8,82.05,32.65,81.3]],['C',[31.55,80.6,30.45,80.4]],['C',[27.55,71.5,28.15,69.35]],['C',[21.1,69.35,15.75,67.5]],['C',[10.45,65.65,9.2,60.75]],['C',[13.85,61.35,19.25,60.6]],['C',[24.6,59.85,28.95,56.9]],['C',[33.3,53.9,36.65,47.35]],['C',[40.05,40.85,43.05,30.4]],['C',[30.65,21.9,30.65,20.2]],['C',[31.25,15.75,34.1,12.75]],['C',[36.9,9.75,41.1,10.35]],['C',[47.45,12.1,51.05,11.9]],['C',[54.6,11.75,57.55,10.65]],['C',[60.55,9.6,63.2,8.8]],['C',[65.8,8,67.1,7.6]],['C',[68.35,7.15,69.7,6.8]],['C',[71,6.45,71.6,6.45]],['C',[73.85,6.45,78.05,9.45]],['C',[82.25,12.4,82.8,16.1]],['C',[83.1,17.1,81.35,19.35]]];
			__motifs["テ"] = [['M',[83.5,11.15]],['C',[84.55,12.7,84.65,14.75]],['L',[84,17.5]],['C',[76.35,17.5,69.9,19.3]],['C',[63.5,21.1,58.7,25.4]],['C',[59.2,26.85,59.65,28.6]],['C',[60.15,30.4,60.7,32.45]],['C',[61.25,34.5,61.5,36.2]],['C',[61.8,37.9,62.5,40.65]],['C',[62.6,41.7,62.95,45.45]],['C',[63.3,49.25,63.55,51.85]],['C',[63.85,54.5,64,57.25]],['C',[64.15,59.95,64.05,62.9]],['C',[63.65,68.65,63.25,72.55]],['C',[62.8,76.45,62.05,80.6]],['C',[61.35,84.75,59.7,88.75]],['C',[58.1,92.7,55.55,96.2]],['C',[53.4,96.2,52.05,96.1]],['C',[50.7,96,50.1,95.9]],['C',[49.7,95.8,48.6,95.65]],['C',[47.45,95.5,46.4,95.2]],['C',[45.3,94.95,44.65,94.55]],['C',[43.95,94.15,43.75,93.65]],['C',[44.9,88,45.8,84]],['C',[46.7,80,47.35,75.75]],['C',[48.05,71.5,48.6,67.3]],['C',[49.1,63.1,48.95,59]],['C',[48.95,52.45,48.45,47.05]],['C',[47.95,41.6,46.9,36.75]],['C',[45.8,37.6,44.15,39.15]],['C',[42.5,40.75,41.35,41.75]],['C',[40.25,42.8,39.1,43.7]],['C',[38,44.65,37.15,45.5]],['C',[36.35,46.4,34.9,48]],['C',[33.5,49.6,32.45,50.65]],['C',[31.45,51.65,30.2,52.5]],['C',[28.9,53.35,27.55,53.9]],['C',[23.45,52.25,20.45,49.8]],['C',[17.5,47.35,17,44.25]],['C',[17.85,43.35,20.7,40.25]],['C',[23.55,37.1,25.3,35.3]],['C',[27.05,33.5,28.95,31.7]],['C',[30.85,29.9,33.8,27.15]],['C',[31.85,25.4,30.1,23.85]],['C',[28.3,22.25,26.75,20.75]],['C',[25.2,19.25,24.25,18.1]],['C',[23.35,16.9,23.45,16.4]],['C',[23.95,15.75,25.3,13.45]],['C',[26.65,11.15,27.95,9.75]],['C',[29.2,8.4,30.95,7.55]],['C',[32.7,6.65,34.85,6.75]],['C',[35.85,6.85,36.9,7.1]],['C',[38,7.35,39.4,7.65]],['C',[40.8,8,42.1,8.2]],['C',[43.35,8.4,44.8,8.4]],['C',[46.3,8.2,51.4,7.85]],['C',[56.55,7.55,60,7.15]],['C',[63.5,6.75,67.05,5.9]],['C',[70.6,5.1,73.85,3.7]],['C',[74.8,4.5,77.2,5.85]],['C',[79.6,7.25,81,8.4]],['C',[82.4,9.6,83.5,11.15]]];
			__motifs["ト"] = [['M',[81.95,15.7]],['C',[81.85,16,81.65,16.3]],['C',[81.45,16.6,81.2,17.1]],['C',[80.95,17.6,80.85,17.9]],['C',[73.55,18.95,67.15,21.1]],['C',[60.75,23.25,56.95,25.9]],['C',[53.15,28.5,50.75,30.7]],['C',[48.35,32.9,45.5,35.9]],['C',[42.7,38.9,40.6,40.95]],['C',[38.5,43,36.35,44.85]],['C',[38,45.6,39.7,46.7]],['C',[41.4,47.75,43.1,49]],['C',[44.8,50.2,46.55,51.45]],['C',[48.25,52.75,49.8,54.1]],['C',[54.3,46.8,62.1,41.8]],['C',[69.9,36.85,80,33.5]],['C',[83.1,35.45,85.6,38.5]],['C',[88.1,41.5,88.65,44.85]],['C',[88.55,45.4,88.4,45.65]],['C',[88.2,45.9,87.85,45.95]],['C',[87.5,46,87.15,45.95]],['C',[86.8,45.9,86.2,45.75]],['C',[85.55,45.6,84.75,45.6]],['C',[84,45.6,82.05,46]],['C',[80.1,46.4,77.45,47.25]],['C',[74.8,48.15,70.95,50.4]],['C',[67.1,52.65,63.75,56.85]],['C',[60.45,61.05,59.4,68.35]],['C',[58.5,75.4,62.3,83.9]],['C',[66.1,92.4,72.45,96.8]],['C',[66.3,96.5,61.4,93.55]],['C',[56.45,90.65,53.15,85.9]],['C',[49.8,81.15,48.2,75.6]],['C',[46.6,70.05,46.95,64.75]],['C',[41.3,59.6,36.4,57.1]],['C',[31.45,54.6,25.2,54.6]],['C',[24.2,54.5,23.3,54.7]],['C',[22.35,54.9,21.5,55.15]],['C',[20.6,55.4,19.5,55.9]],['C',[18.35,56.45,17.95,56.65]],['C',[16.8,56.45,16.05,56]],['C',[15.35,55.6,14.6,54.9]],['C',[13.85,54.2,13.35,53.5]],['C',[12.8,52.85,12.25,52.15]],['C',[11.7,51.45,10.85,50.5]],['C',[9.95,49.5,9.45,48.85]],['C',[9,48.15,8.75,47.5]],['C',[8.5,46.9,8.5,46.1]],['C',[13.1,43.45,16.4,41.55]],['C',[19.75,39.65,23.15,37.25]],['C',[26.55,34.85,29.75,32.15]],['C',[32.9,29.4,35.45,26.3]],['C',[34.55,25.2,32.8,23.35]],['C',[31.05,21.5,30,20.2]],['C',[28.9,18.95,27.95,17.6]],['C',[26.95,16.2,26.15,14.85]],['C',[26.65,14.25,28.2,12.55]],['C',[29.8,10.85,30.9,9.85]],['C',[32.05,8.9,33.55,8.25]],['C',[35.05,7.65,36.9,8]],['C',[38.2,8.1,39.45,8.25]],['C',[40.7,8.4,42.55,8.55]],['C',[44.35,8.7,45.7,8.9]],['C',[47.05,9.1,48.55,9.1]],['C',[56.25,9,62.05,8]],['C',[67.85,7.05,72.45,4.1]],['C',[72.95,4.5,74.95,6.05]],['C',[76.95,7.65,78.3,8.9]],['C',[79.7,10.15,80.7,11.8]],['C',[81.75,13.4,82.05,15.25]],['C',[82.05,15.35,81.95,15.7]]];
			__motifs["ナ"] = [['M',[16.5,43.1]],['C',[16.2,43.65,16.2,44.15]],['C',[16.2,44.65,16.3,45.15]],['C',[16.4,45.6,16.7,46.2]],['C',[17,46.8,17.35,47.25]],['C',[17.7,47.65,18.2,47.9]],['C',[18.75,48.15,19.5,48.05]],['C',[20.2,47.95,21.3,47.65]],['C',[22.35,47.35,22.95,47]],['C',[23.05,43.85,22.6,42.8]],['C',[22.15,41.7,21.3,41.4]],['C',[20.4,41.1,19.7,41.05]],['C',[18.95,41,18.3,41.25]],['C',[17.7,41.5,17.25,42]],['C',[16.8,42.5,16.5,43.1]],['M',[86.7,14.85]],['C',[86.6,15.55,86.25,16.3]],['C',[85.85,17.1,85.45,17.9]],['C',[77.05,18.1,69.45,21.4]],['C',[61.8,24.7,57.25,30.75]],['C',[58.3,32.7,59.15,35.05]],['C',[59.95,37.4,60.5,39.9]],['C',[61.05,42.4,61.4,44.45]],['C',[61.7,46.5,61.95,49.15]],['C',[62.2,51.75,62.25,55.15]],['C',[62.3,58.5,61.8,63.95]],['C',[60.75,76.4,65.7,84.6]],['C',[70.7,92.8,79.5,97.85]],['C',[70.3,97.85,62,92.3]],['C',[53.7,86.75,51.2,80.8]],['C',[48.75,74.9,48.3,70.8]],['C',[47.85,66.7,47.85,61.1]],['C',[47.85,55.5,47.75,51.55]],['C',[47.65,47.65,47.05,44.15]],['C',[42.2,51.3,37.2,55.35]],['C',[32.25,59.4,23.75,59.85]],['C',[21,59.95,17.9,58.65]],['C',[14.85,57.35,12.35,54.85]],['C',[9.85,52.35,8.8,48.95]],['C',[7.7,45.5,9,41.5]],['C',[10.05,38.3,12.55,36.2]],['C',[15.05,34.1,18.05,34.3]],['C',[20.8,33.9,22.9,35.25]],['C',[25,36.65,25.7,38.65]],['C',[26.35,40.65,26.05,42.45]],['C',[25.7,44.25,25,46]],['C',[27.35,44.25,29.35,42.2]],['C',[31.35,40.15,33,37.9]],['C',[34.65,35.65,36.9,32.45]],['C',[39.15,29.2,40.35,27.85]],['C',[36.35,24.35,33.45,21.4]],['C',[30.55,18.45,28.8,15.55]],['C',[31.95,11.65,35,9.25]],['C',[38.1,6.85,41.6,6.85]],['C',[43.35,7.05,45.2,7.15]],['C',[47.05,7.25,49.25,7.6]],['C',[51.45,7.9,53.2,8.15]],['C',[55,8.4,56.85,8.6]],['C',[61.45,8.6,66,7.45]],['C',[70.6,6.25,75.6,4.2]],['C',[79.1,5,82.25,8.05]],['C',[85.35,11.15,86.7,14.85]]];
			__motifs["ニ"] = [['M',[86.8,15.65]],['C',[86.05,16.2,85.05,16.65]],['C',[84.1,17.1,83.5,17.3]],['C',[80.85,18.65,79.65,21.95]],['C',[78.4,25.2,78.25,29.15]],['C',[78.15,33.1,78.35,38.55]],['C',[78.6,43.95,78.6,45.15]],['C',[78.7,46.6,78.8,53.1]],['C',[78.9,59.6,79.5,65]],['C',[80.1,70.4,81.6,76.3]],['C',[83.1,82.15,86.25,87.5]],['C',[87.7,90.65,94.05,95.5]],['C',[92.6,95.8,90.45,95.45]],['C',[88.3,95.15,86.45,94.5]],['C',[84.55,93.85,83.05,93.1]],['C',[81.55,92.3,79.75,90.9]],['C',[77.95,89.45,76.15,87.8]],['C',[74.4,86.15,73.4,84.6]],['C',[72.35,83,71.6,81.75]],['C',[70.8,80.5,70.3,79.6]],['C',[69.8,78.7,68.85,77.15]],['C',[67.85,75.6,66.8,74.3]],['C',[65.7,72.95,63.75,71.75]],['C',[61.8,70.5,60,69.75]],['C',[58.2,68.95,56.95,68.65]],['C',[55.65,68.35,54.25,68.15]],['C',[52.85,68,51.2,68.1]],['C',[49.6,68.25,48.15,68.6]],['C',[46.7,68.95,45.75,69.4]],['C',[44.8,69.85,43.2,70.35]],['C',[41.6,70.9,40.3,71.2]],['C',[38.95,71.5,37.6,71.5]],['C',[31.85,71.8,27.45,68.5]],['C',[23.05,65.25,21.3,61.45]],['C',[19.55,57.65,18.85,55.05]],['C',[18.15,52.45,17.85,49.9]],['C',[17.6,47.35,17.45,45.1]],['C',[17.3,42.8,17.2,39.35]],['L',[17.5,31.75]],['C',[16.2,30.85,15.2,30]],['C',[14.15,29.1,13.35,28.4]],['C',[12.5,27.65,11.25,26.4]],['C',[9.95,25.2,9.55,24.9]],['C',[9.95,21.2,12.25,18.1]],['C',[14.55,14.95,17.95,13.95]],['C',[18.75,14.15,20.2,14.4]],['C',[21.7,14.65,22.6,14.75]],['C',[23.55,14.85,24.65,15.05]],['C',[25.8,15.25,27.05,15.15]],['C',[28.6,15.15,30.1,14.9]],['C',[31.55,14.65,33.1,14.45]],['C',[34.65,14.25,37,13.9]],['C',[39.35,13.5,40.65,13.4]],['C',[41.4,14.15,43.25,15.55]],['C',[45.1,16.9,46.25,17.9]],['C',[47.35,18.85,48.35,20.15]],['C',[49.3,21.5,49.8,23.25]],['C',[49.4,24.9,48.4,25.7]],['C',[47.35,26.45,46.15,26.65]],['C',[44.9,26.85,42.6,26.75]],['C',[40.25,26.65,38.1,26.95]],['C',[35.95,27.25,33.75,29.5]],['C',[31.55,31.75,31.45,34.5]],['C',[30.95,39.35,30.9,41.85]],['C',[30.85,44.35,30.95,47.4]],['C',[31.05,50.5,31.65,52.9]],['C',[32.25,55.3,34.1,56.45]],['C',[35.05,57.25,36.85,57.3]],['C',[38.65,57.35,41.75,57.2]],['C',[44.8,57.05,47.2,56.85]],['C',[49.6,56.65,51.85,57.05]],['C',[53.4,57.25,55.1,57.65]],['C',[56.75,58,58.45,58.55]],['C',[60.15,59.1,62.05,59.9]],['C',[63.95,60.75,65.7,61.75]],['C',[65.45,57.35,65.35,54.55]],['C',[65.25,51.75,65.05,49.2]],['C',[64.85,46.6,64.8,44.15]],['C',[64.75,41.7,64.55,38.9]],['C',[64.75,37.7,64.45,31.55]],['C',[64.15,25.4,64.9,20.25]],['C',[65.65,15.15,67.95,10.7]],['C',[70.3,6.25,75.1,4.4]],['C',[80.1,6.65,83.5,9.35]],['C',[86.9,12,86.8,15.65]]];
			__motifs["ヌ"] = [['M',[83.8,17.4]],['C',[83.6,18.1,83.3,18.75]],['C',[75.3,19.55,67.7,22.75]],['C',[60.05,26,51.8,31.1]],['C',[43.55,36.25,37.55,41.1]],['C',[31.55,46,26.95,51.85]],['C',[25.2,54.4,26.1,56.3]],['C',[27.05,58.2,28.8,59.45]],['C',[30.55,60.65,33.6,62.5]],['C',[36.6,64.35,37.1,65.85]],['C',[39.85,56.35,47.25,49.2]],['C',[54.7,42,64.35,42.8]],['C',[69.35,42.8,73.95,44.7]],['C',[78.6,46.6,82.1,50.25]],['C',[85.55,53.9,87.55,58.9]],['C',[89.55,63.9,89.55,69.75]],['C',[89.55,72.45,88.55,75.15]],['C',[87.5,77.85,85.6,79.95]],['C',[83.7,82.05,81.3,83.25]],['C',[78.9,84.5,76.45,84.5]],['C',[72.45,84.6,69.3,82.05]],['C',[66.1,79.5,65.9,75.8]],['C',[65.8,74.6,66.05,73.55]],['C',[66.3,72.45,66.95,71.7]],['C',[67.6,70.9,68.45,70.45]],['C',[69.35,70.05,70.3,70.2]],['C',[69.9,71.4,70.1,72.15]],['C',[70.3,72.85,70.95,73.35]],['C',[71.6,73.85,72.2,74.1]],['C',[72.85,74.35,73.75,74.5]],['C',[75.6,74.35,76.85,72.6]],['C',[78.15,70.9,78.15,69.15]],['C',[78.2,66.4,77.1,63.95]],['C',[76,61.55,74.15,59.75]],['C',[72.35,57.9,70,57.05]],['C',[67.7,56.15,65.45,56.35]],['C',[57.4,56.85,52.4,63.95]],['C',[47.35,71.1,47.65,76.85]],['C',[47.35,79.1,47.6,81]],['C',[47.85,82.9,48.35,85.05]],['C',[48.85,87.2,49,88.35]],['C',[49.2,89.45,49.1,90.65]],['C',[48.35,90.95,47.85,91]],['C',[47.35,91.1,46.95,91.25]],['C',[46.6,91.4,45.9,91.6]],['C',[45.2,91.8,44.9,91.9]],['C',[43.35,91.4,42.15,90.65]],['C',[40.9,89.85,39.55,88.45]],['C',[38.2,87,37.25,86.15]],['C',[36.35,85.25,35.15,84.5]],['C',[35.45,81.75,34.1,78.9]],['C',[32.7,76.1,30.7,73.85]],['C',[28.7,71.6,26.9,70.35]],['C',[25.1,69.15,23.85,68.6]],['C',[22.55,68.1,21.05,67.6]],['C',[19.55,67.1,18.55,66.75]],['C',[17.6,66.4,16.7,65.9]],['C',[15.8,65.35,14.55,64]],['C',[13.3,62.7,12.3,59.9]],['C',[11.35,57.15,11.7,54.9]],['C',[11.9,50.9,13.85,47.4]],['C',[15.8,43.95,18.4,41.25]],['C',[21,38.6,25.1,34.95]],['C',[29.2,31.35,30.85,29.9]],['C',[28.4,27.35,26.35,24.6]],['C',[24.3,21.9,22.85,19.35]],['C',[24.2,17.4,25.3,15.85]],['C',[26.35,14.25,27.65,12.9]],['C',[28.9,11.55,30.55,10.7]],['C',[32.25,9.85,34.2,9.85]],['C',[35.45,9.95,37.85,10.2]],['C',[40.25,10.45,41.45,10.6]],['C',[42.7,10.75,44.5,10.9]],['C',[46.3,11.05,48.25,10.85]],['C',[56.85,10.75,63.15,9.65]],['C',[69.45,8.5,75.1,5]],['C',[77.75,6.25,80.1,9.45]],['C',[82.4,12.6,84,16.1]],['C',[84,16.7,83.8,17.4]]];
			__motifs["ネ"] = [['M',[28.9,58.2]],['C',[28.9,60.45,29.35,61.8]],['C',[29.8,63.1,31.1,64.8]],['C',[32.4,66.5,34.4,67.4]],['C',[36.35,68.25,39.85,67.6]],['C',[41.1,67.1,42.15,66.45]],['C',[43.15,65.85,44.15,65.1]],['C',[45.1,64.35,46,63.55]],['C',[46.9,62.7,48.35,61.35]],['C',[47.85,59.3,47.65,38.95]],['C',[42.1,41.1,35.45,46.5]],['C',[32.05,49.25,30.45,52.3]],['C',[28.9,55.4,28.9,58.2]],['M',[82,15.05]],['C',[81.95,15.25,81.85,15.55]],['C',[81.75,15.85,81.65,16.15]],['C',[81.55,16.5,81.55,16.9]],['C',[78.15,17.6,75.75,18.25]],['C',[73.35,18.95,70.9,19.85]],['C',[68.45,20.7,66.2,21.95]],['C',[63.95,23.15,62.1,24.9]],['L',[62.1,64.35]],['C',[61.7,74.6,66.9,83.85]],['C',[72.05,93.1,81.75,97.25]],['C',[70.7,97.25,61.55,91.7]],['C',[52.45,86.15,51.15,76.3]],['C',[47.95,78.5,44.6,79.85]],['C',[41.2,81.15,37.6,81.15]],['C',[32.3,81.25,27.9,79.3]],['C',[23.45,77.35,20.3,73.75]],['C',[17.2,70.15,15.75,64.95]],['C',[14.35,59.75,15.25,53.5]],['C',[16.6,47.75,19.8,43.5]],['C',[22.95,39.25,25.9,36.85]],['C',[28.8,34.5,30.2,33.55]],['C',[31.55,32.65,33.75,31.2]],['C',[35.95,29.8,37.25,28.75]],['C',[38.55,27.75,40.05,26.65]],['C',[38.55,25.5,37.25,24.25]],['C',[35.95,22.95,34.7,21.4]],['C',[33.5,19.85,32.4,18.55]],['C',[31.35,17.3,30.35,15.75]],['C',[31.85,12,34.55,9.2]],['C',[37.3,6.35,40.7,6.15]],['C',[42.2,6.35,43.9,6.55]],['C',[45.6,6.75,47,6.9]],['C',[48.45,7.05,50.8,7.3]],['C',[53.15,7.55,54.3,7.65]],['C',[55.35,7.55,58.4,7.35]],['C',[61.45,7.15,63.6,6.9]],['C',[65.8,6.65,68,6.05]],['C',[70.2,5.5,71.95,4.5]],['C',[75.6,5.85,78.65,8.6]],['C',[81.75,11.35,82.05,14.75]],['C',[82.05,14.85,82,15.05]]];
			__motifs["ノ"] = [['M',[94.8,95.8]],['C',[93.75,96.7,91.4,96.95]],['C',[89.05,97.2,85.75,96.8]],['C',[82.4,96.4,79.3,95.15]],['C',[76.15,93.85,72.55,90.9]],['C',[68.95,87.9,66,82.2]],['C',[63.1,76.45,62.1,67.6]],['C',[61.7,62.6,61.3,59.8]],['C',[60.85,57.05,59.5,54.35]],['C',[58.2,51.65,55.8,49.8]],['C',[53.4,47.95,50,48.15]],['C',[44.25,48.55,42.3,51.4]],['C',[40.35,54.2,39.7,58.55]],['C',[39.05,62.9,39,65.9]],['C',[38.95,68.85,39.35,71.9]],['C',[36.6,71.9,34.95,71.65]],['C',[33.3,71.4,31.4,70.9]],['C',[29.5,70.4,28.2,69.7]],['C',[26.95,68.95,26.65,67.8]],['C',[26.35,66.6,26.4,64.95]],['C',[26.45,63.3,26.3,62.2]],['C',[26.15,61.15,25.75,60]],['C',[25.3,58.9,24.4,58.1]],['C',[18.35,58.5,13.3,56.25]],['C',[8.2,54,6.95,49.15]],['C',[9.45,49.25,13.35,48.6]],['C',[17.2,47.95,21.4,46.15]],['C',[25.6,44.35,29.2,40.3]],['C',[32.8,36.25,35.45,28.9]],['C',[32.4,26.95,29.9,24.2]],['C',[27.35,21.4,25.6,18.35]],['C',[26.35,17.4,27.65,15.15]],['C',[28.9,12.9,29.75,11.65]],['C',[30.55,10.35,31.95,9.3]],['C',[33.3,8.2,35.45,8]],['L',[46.9,8.9]],['C',[48.45,8.5,52,8.25]],['C',[55.55,8,57.85,7.65]],['C',[60.15,7.25,62.55,6.4]],['C',[64.95,5.6,67.1,4.2]],['C',[68.05,4.4,68.95,4.75]],['C',[69.8,5.1,70.65,5.65]],['C',[71.5,6.25,72.65,7.25]],['C',[73.85,8.2,74.2,8.6]],['C',[74.6,9,75.85,10]],['C',[77.05,11.05,77.75,11.85]],['C',[78.4,12.6,78.85,13.55]],['C',[79.3,14.45,79.2,15.75]],['C',[67.7,19.35,60.3,23.5]],['C',[52.95,27.65,49.6,35.15]],['C',[55.1,34.5,60.2,36.2]],['C',[65.35,37.9,69.15,41.7]],['C',[72.95,45.5,75,50.95]],['C',[77.05,56.35,76.65,63.1]],['C',[76.05,68.85,76.3,73]],['C',[76.55,77.15,78.15,81.7]],['C',[79.8,86.25,83.55,89.95]],['C',[87.3,93.65,94.8,95.8]]];
			__motifs["ハ"] = [['M',[93.05,94.65]],['C',[89.85,94.75,86.4,93.7]],['C',[82.9,92.7,80.15,90.85]],['C',[77.35,88.95,75.15,86.3]],['C',[72.95,83.6,71.7,81.35]],['C',[70.4,79.1,69.5,76.85]],['C',[68.55,74.6,67.85,73.3]],['C',[67.2,72,66.25,70.65]],['C',[65.35,69.35,63.55,67.75]],['C',[61.7,66.1,58.2,65]],['C',[54.7,63.9,51.45,63.9]],['C',[45.3,63.9,39.5,65.25]],['C',[33.7,66.6,29.3,69.65]],['C',[28.2,70.15,27.2,70.95]],['C',[26.15,71.8,25,72.95]],['C',[23.85,74.15,23,74.85]],['C',[22.15,75.6,21.3,76.1]],['C',[17.7,75.5,14.55,72.3]],['C',[11.45,69.15,9.55,65.55]],['C',[17.85,59.3,22.65,54.2]],['C',[27.45,49.15,28.7,42.1]],['C',[28.8,40.65,27.95,38.05]],['C',[27.05,35.45,25.9,33.3]],['C',[24.7,31.15,23.8,29.9]],['C',[22.85,28.6,21.9,27.8]],['C',[21,26.95,19.8,26.05]],['C',[18.55,25.1,17.85,24.4]],['C',[17.2,23.75,16.7,22.85]],['C',[16.2,22,16.1,21.2]],['C',[16.6,19.25,17.05,17.9]],['C',[17.5,16.5,18.2,15.15]],['C',[18.95,13.8,20.1,12.9]],['C',[21.3,12,23.05,11.85]],['C',[23.75,12,25.3,12.1]],['C',[26.85,12.2,27.65,12.35]],['C',[28.4,12.5,29.55,12.6]],['C',[30.65,12.7,32.3,12.9]],['C',[33.5,12.6,35.65,12.5]],['C',[37.8,12.4,39.1,12.2]],['C',[40.45,12,41.8,11.6]],['C',[43.15,11.15,44.45,10.35]],['C',[45.2,10.75,47.85,11.75]],['C',[50.5,12.7,52.15,13.75]],['C',[53.8,14.75,55.05,16.4]],['C',[56.25,18.1,56.35,20.5]],['L',[54.7,22.65]],['C',[54.1,22.75,53.65,22.7]],['C',[53.2,22.65,52.9,22.5]],['C',[52.55,22.35,52.1,22.25]],['C',[51.65,22.1,51.45,22.1]],['C',[45.8,22.1,41.3,24.6]],['C',[36.8,27.15,36.7,32.65]],['C',[36.7,34.1,37.2,35.55]],['C',[37.7,37,38.75,39.2]],['C',[39.85,41.4,40.4,43]],['C',[40.9,44.55,40.9,46.2]],['L',[40.35,50.5]],['C',[40.8,50.5,41.5,50.45]],['C',[42.2,50.4,43.3,50.3]],['C',[44.45,50.2,45.25,50.15]],['C',[46.1,50.1,46.95,50.4]],['C',[51.45,50.5,55.9,51.8]],['C',[60.35,53.15,64.75,55.75]],['C',[64.45,52.35,64.3,50.7]],['C',[64.15,49.05,63.9,45.65]],['C',[63.65,42.3,63.5,39.95]],['C',[63.3,37.6,63.2,35.25]],['C',[63.2,29.8,63.35,25.8]],['C',[63.5,21.8,63.9,16.95]],['C',[64.35,12.1,65.75,8.7]],['C',[67.2,5.3,71.3,3.9]],['C',[75.7,5.4,79.05,7.65]],['C',[82.4,9.85,84,13.5]],['C',[80.85,14.35,79.2,16.5]],['C',[77.55,18.65,77.05,21.5]],['C',[76.55,24.35,76.5,29.3]],['C',[76.45,34.3,76.35,35.75]],['C',[76.55,43.95,77.15,51.6]],['C',[77.75,59.3,78.95,68.35]],['C',[80.2,77.45,83.1,84.3]],['C',[86.05,91.1,93.05,94.65]]];
			__motifs["ヒ"] = [['M',[93.45,93.35]],['C',[93.55,93.55,93.3,93.7]],['C',[93.05,93.85,92.45,94.05]],['C',[91.8,94.25,90.9,94.4]],['C',[90.05,94.55,89.15,94.55]],['C',[85.75,94.55,82.3,93.85]],['C',[78.9,93.15,75.9,92.4]],['C',[72.85,91.6,70.4,91]],['C',[67.95,90.45,66.15,90.05]],['C',[64.35,89.65,62.8,89.4]],['C',[61.25,89.15,58.75,88.75]],['C',[56.25,88.3,52.55,87.95]],['C',[48.85,87.6,46,87.5]],['C',[43.15,87.4,41.7,87.3]],['C',[40.25,87.2,38.7,87.1]],['C',[37.2,87,34.75,86.8]],['C',[32.3,86.55,29.35,86]],['C',[26.35,85.45,22.7,84.2]],['C',[19.05,82.9,16.7,80.5]],['C',[14.35,78.05,13.15,74.35]],['C',[11.9,70.7,11.45,66.2]],['C',[10.55,55.3,15.45,45.95]],['C',[20.3,36.65,28.3,35.45]],['C',[33.2,35.15,36.4,36.85]],['C',[39.55,38.5,40.75,40.5]],['C',[42,42.5,42.45,43.8]],['C',[42.85,45.15,43,46.45]],['C',[43.15,47.75,43.25,49.8]],['C',[43.35,51.85,43.45,52.65]],['C',[43.35,55.4,42.7,58.5]],['C',[42.1,61.65,41.2,64.85]],['C',[42.85,64.95,44.55,64.9]],['C',[46.2,64.85,47.65,64.65]],['C',[48.25,63.8,48.5,62.5]],['C',[48.75,61.25,48.75,59.7]],['C',[48.75,58.1,48.6,55.85]],['C',[48.45,53.6,48.45,52.75]],['C',[48.05,44.55,47.55,25.6]],['L',[38.55,17.3]],['C',[38.65,14.85,39.9,12.65]],['C',[41.1,10.45,42.5,9.75]],['C',[43.85,9.1,44.95,9]],['C',[46.1,8.9,47.05,8.95]],['C',[48.05,9,49.8,9.15]],['C',[51.55,9.3,52.65,9.3]],['C',[53.7,9.3,54.85,9.15]],['C',[55.95,9,56.95,8.8]],['C',[57.9,8.6,59.45,8.4]],['C',[61.05,8.2,62.25,8.05]],['C',[63.5,7.9,64.55,7.65]],['C',[65.65,7.35,66.8,7.1]],['C',[67.95,6.85,69.05,6.55]],['C',[70.1,6.25,71.2,5.75]],['C',[71.95,6.35,74,7.55]],['C',[76.05,8.7,77.15,9.5]],['C',[78.2,10.25,79.1,11.6]],['C',[80,12.9,79.8,14.85]],['C',[78.15,15.65,74.55,16.95]],['C',[71,18.25,68.8,19.35]],['C',[66.6,20.4,64.7,22.25]],['C',[62.8,24.15,62.1,26.95]],['L',[62.1,69.35]],['C',[61.25,71.4,59.05,72.85]],['C',[56.85,74.35,54.7,74.35]],['C',[50.5,71.6,47.2,69.75]],['C',[43.95,67.9,40.7,66.2]],['L',[39.45,68.85]],['C',[38.85,68.95,38.05,69.05]],['C',[37.2,69.15,36.6,69.2]],['C',[36.05,69.25,35.7,69.25]],['C',[35.35,69.25,34.55,69.25]],['C',[33.7,68.65,33,67.9]],['C',[32.3,67.1,31.85,66.4]],['C',[31.35,65.75,30.55,64.8]],['C',[29.8,63.9,29.6,63.5]],['C',[29.3,62.1,29.65,60.85]],['C',[30,59.6,30.7,57.85]],['C',[31.45,56.15,31.85,55.05]],['C',[32.25,53.9,32.05,52.65]],['C',[32.05,51.85,31.7,51.2]],['C',[31.35,50.5,30.85,50.05]],['C',[30.35,49.6,29.75,49.55]],['C',[29.1,49.5,28.6,50]],['C',[26.05,51,24.9,55.45]],['C',[23.75,59.85,24.1,64.95]],['C',[24.6,68.75,26.25,71.3]],['C',[27.95,73.85,30.4,75.15]],['C',[32.9,76.45,35.7,77.25]],['C',[38.5,78.05,42.3,78.6]],['C',[46.1,79.2,48.85,79.75]],['C',[51.55,80.3,54.45,80.85]],['C',[57.3,81.45,60.25,82.35]],['C',[63.2,83.2,65.8,84.35]],['C',[68.45,85.45,72.95,87.45]],['C',[77.45,89.45,80.3,90.65]],['C',[83.2,91.8,86.6,92.7]],['C',[90.05,93.55,93.45,93.35]]];
			__motifs["フ"] = [['M',[86.75,11.25]],['C',[88.2,12.5,89.2,14.05]],['C',[90.25,15.65,90.65,17.8]],['C',[90.65,18,90.45,18.35]],['C',[90.25,18.75,90.05,19]],['C',[89.85,19.25,89.65,19.55]],['C',[89.45,19.85,89.05,20.5]],['C',[85.95,20.5,83.95,21.9]],['C',[81.95,23.25,80.8,25.95]],['C',[79.7,28.6,79.3,32.4]],['C',[78.9,36.15,79.1,40.85]],['C',[79.1,52.75,79.2,58.55]],['C',[79.3,64.35,80.2,71.8]],['C',[81.05,79.2,83.55,85.7]],['C',[86.05,92.2,92.85,96.5]],['C',[83.6,97,76.55,90.25]],['C',[69.55,83.5,67.85,74.5]],['C',[64.95,75.9,60.45,76.65]],['C',[55.95,77.45,51.95,77.35]],['C',[41.8,77.15,35.7,74.05]],['C',[29.6,70.9,26.25,66]],['C',[22.95,61.15,21.9,55.2]],['C',[20.8,49.25,21.3,38.6]],['C',[18.05,36.35,15.45,33.45]],['C',[12.8,30.6,11.25,27.75]],['C',[11.7,26.95,12.6,25.6]],['C',[13.5,24.25,14,23.5]],['C',[14.55,22.75,15.35,21.9]],['C',[16.1,21,17.2,20.5]],['L',[19.9,20.05]],['C',[21.3,20.2,22.85,20.55]],['C',[24.4,20.9,26.55,21.2]],['C',[27.95,21,30.85,20.75]],['C',[33.8,20.5,35.75,20.3]],['C',[37.7,20.15,39.85,19.7]],['C',[42,19.25,43.85,18.45]],['C',[46.1,19.65,47.6,20.4]],['C',[49.1,21.2,50.5,22.45]],['C',[51.85,23.75,52.8,25.5]],['C',[53.7,27.25,53.9,29.6]],['C',[52.45,30.4,50.85,31]],['C',[49.2,31.65,47.85,32.1]],['C',[46.5,32.55,44.3,33.1]],['C',[42.1,33.7,40.35,34.55]],['C',[38.55,35.35,37,37.1]],['C',[35.45,38.9,34.55,41.25]],['C',[33.7,43.65,33.4,46.25]],['C',[33.1,48.85,33.4,51.45]],['C',[33.7,54.1,34.4,56.5]],['C',[35.15,58.9,36.4,60.65]],['C',[37.6,62.4,39.35,63.6]],['C',[41.1,64.75,43.7,65.5]],['C',[46.3,66.2,49.7,66.35]],['C',[53.15,66.5,58.5,65.55]],['C',[55.55,59.95,51.2,55.2]],['C',[46.9,50.4,42.2,48.15]],['C',[43.95,47.35,47.2,47.75]],['C',[50.5,48.15,52.95,49.35]],['C',[55.35,50.1,59.3,52.75]],['C',[63.2,55.4,66.3,58.5]],['C',[65.05,39.95,65.45,24.05]],['C',[65.8,17.6,69.95,12.35]],['C',[74.1,7.15,80.35,6.85]],['C',[82.4,8.1,83.9,9.05]],['C',[85.35,9.95,86.75,11.25]]];
			__motifs["ヘ"] = [['M',[53.65,2.95]],['C',[54.6,3.7,55.15,4.8]],['C',[55.65,5.85,55.65,7.15]],['C',[55.65,8.2,55.2,9.35]],['C',[54.7,10.45,53.9,11.3]],['C',[53.15,12.1,52.1,12.7]],['C',[51.05,13.3,50.1,13.3]],['C',[48.85,13.3,47.65,12.7]],['C',[46.5,12.1,45.5,11.25]],['C',[44.55,10.35,44.15,9.2]],['C',[43.75,8,43.85,7.05]],['C',[43.95,4.8,45.55,3.15]],['C',[47.15,1.45,49.3,1.4]],['C',[50.5,1.4,51.6,1.75]],['C',[52.75,2.15,53.65,2.95]],['M',[69.55,24.5]],['C',[66.7,24.9,64.2,25.6]],['C',[61.7,26.3,60.15,27.7]],['C',[58.6,29.1,58.1,31.25]],['C',[57.6,33.4,57.5,35.7]],['C',[57.4,38,57.4,39.5]],['C',[57.4,41,57.5,42.7]],['C',[57.6,44.35,57.6,45.65]],['C',[57.6,47,57.4,48.75]],['C',[56.75,49.05,55.7,49.8]],['C',[54.7,50.6,54.05,51]],['C',[53.4,51.4,52.65,51.75]],['C',[51.85,52.15,51,52.25]],['C',[50,51.65,48.55,50.4]],['C',[47.05,49.15,46.2,48.4]],['C',[45.3,47.65,44.25,47.15]],['C',[43.15,46.6,42,46.9]],['L',[40.05,49.6]],['C',[37.6,49.6,35.65,48.55]],['C',[33.7,47.45,32.8,45.7]],['C',[33.1,45.15,33.6,44.45]],['C',[34.1,43.75,34.35,43.35]],['C',[34.55,43,34.7,42.7]],['C',[34.85,42.4,35.1,41.8]],['C',[35.35,41.2,35.35,40.8]],['C',[35.35,40.35,35.15,40.05]],['C',[34.95,39.75,34.4,39.55]],['C',[33.8,39.35,33.1,39.25]],['C',[31.35,39.35,29.9,40.85]],['C',[28.4,42.3,27.65,44.25]],['C',[26.85,46.2,26.95,48.2]],['C',[27.05,50.2,28.4,51.45]],['C',[30.55,54.6,42.5,53.9]],['C',[43.55,53.9,45.9,53.75]],['C',[48.25,53.6,49.6,53.45]],['C',[51,53.25,52.8,53.15]],['C',[54.6,53.05,56.55,52.85]],['C',[59.55,54.6,59.45,55.6]],['C',[58.3,57.9,57.85,61.15]],['C',[57.4,64.35,57.3,67.55]],['C',[57.25,70.7,57.3,75.15]],['C',[57.4,79.6,57.3,81.45]],['C',[55.1,84.1,53.55,85.35]],['C',[52.05,86.65,50.5,87]],['C',[49.4,86.35,47.95,84.95]],['C',[46.5,83.6,45.5,82.8]],['C',[44.55,82.05,43.3,81.5]],['C',[42.1,80.95,40.8,80.95]],['C',[40.35,81.35,40.05,81.8]],['C',[39.75,82.25,39.35,82.8]],['C',[38.95,83.4,38.6,83.7]],['C',[38.3,84,38,84.3]],['C',[36.7,84.3,35.6,83.85]],['C',[34.45,83.4,33.4,82.65]],['C',[32.3,81.85,31.8,80.9]],['C',[31.25,80,31.25,79]],['C',[31.75,78.5,32.1,77.9]],['C',[32.4,77.25,32.6,76.65]],['C',[32.8,76.1,32.75,75.75]],['C',[32.7,75.4,32.3,75.2]],['C',[31.95,75,31.2,75.1]],['C',[30.45,75.2,29.55,76.05]],['C',[28.6,76.85,28,78.4]],['C',[27.35,79.9,27.75,82.15]],['C',[28.4,86.55,31.55,88.25]],['C',[34.65,89.95,38.2,90.3]],['C',[41.7,90.65,43.45,90.8]],['C',[45.2,90.95,47.85,91]],['C',[50.5,91,52.3,91]],['C',[54.1,91,57,91.15]],['C',[59.85,91.3,63.65,91.55]],['C',[67.5,91.8,72,92.55]],['C',[76.55,93.25,80.35,94.65]],['C',[84.2,96,86.7,98.95]],['C',[83.7,97.25,80.1,96.85]],['C',[76.45,96.4,71.5,96.3]],['C',[67.6,96,63.8,96.25]],['C',[60.05,96.5,55.2,97.15]],['C',[50.3,97.75,46.7,98.2]],['C',[43.05,98.65,39.85,98.95]],['C',[35.95,98.95,31.85,97.9]],['C',[27.75,96.9,24.15,94.85]],['C',[20.6,92.8,18.4,89.3]],['C',[16.2,85.85,16.3,81.15]],['C',[16.4,76.95,17.95,73.7]],['C',[19.55,70.4,22.25,68.1]],['C',[25,65.75,28.45,64.8]],['C',[31.95,63.9,35.85,64.35]],['C',[39.35,64.65,41.45,66.95]],['C',[43.55,69.25,43.55,73.25]],['C',[43.35,77.75,41.6,79.6]],['L',[45.7,79.6]],['C',[45.8,75,45.7,70.6]],['C',[45.6,66.2,45.3,62.5]],['C',[44.55,62.5,42.95,62.45]],['C',[41.4,62.4,40.45,62.3]],['C',[39.45,62.2,38.2,62.2]],['C',[36.9,62.2,35.45,62.3]],['C',[34,62.4,32.85,62.4]],['C',[31.75,62.4,30.3,62.2]],['C',[28.9,62,27.5,61.6]],['C',[26.05,61.15,23.35,59.65]],['C',[20.6,58.1,18.35,53.7]],['C',[16.1,49.35,17.6,42.4]],['C',[19.25,37.2,23.05,33.75]],['C',[26.85,30.3,32.6,29.9]],['C',[36.8,29.9,39.95,31.8]],['C',[43.05,33.7,43.55,36.65]],['C',[44.45,38.4,43.95,41.15]],['C',[43.45,43.95,42.3,45.15]],['C',[43.05,45.4,44.15,45.2]],['C',[45.2,45.05,46.5,44.65]],['C',[46.3,35.25,46,30.6]],['C',[43.45,28.9,41.05,27]],['C',[38.65,25.1,36.8,23.15]],['C',[37.8,20.4,39.45,18.55]],['C',[41.1,16.7,43.55,17.1]],['C',[44.25,16.9,44.9,16.9]],['C',[45.6,16.9,46.6,17]],['C',[47.55,17.1,48.4,17.2]],['C',[49.2,17.3,50.1,17.3]],['C',[51.55,17.1,53.05,16.8]],['C',[54.5,16.5,55.85,16.1]],['C',[57.25,15.75,58.6,15.35]],['C',[59.95,14.95,61.9,14.35]],['C',[64.45,15.25,67,17.55]],['C',[69.55,19.85,70.4,22.45]],['C',[70.4,23.15,69.55,24.5]]];
		}

		static private function initializeWidths():void {
			__widths["ア"] = 100;
			__widths["イ"] = 100;
			__widths["ウ"] = 100;
			__widths["エ"] = 100;
			__widths["オ"] = 100;
			__widths["カ"] = 100;
			__widths["キ"] = 100;
			__widths["ク"] = 100;
			__widths["ケ"] = 100;
			__widths["コ"] = 100;
			__widths["サ"] = 100;
			__widths["シ"] = 100;
			__widths["ス"] = 100;
			__widths["セ"] = 100;
			__widths["ソ"] = 100;
			__widths["タ"] = 100;
			__widths["チ"] = 100;
			__widths["ツ"] = 100;
			__widths["テ"] = 100;
			__widths["ト"] = 100;
			__widths["ナ"] = 100;
			__widths["ニ"] = 100;
			__widths["ヌ"] = 100;
			__widths["ネ"] = 100;
			__widths["ノ"] = 100;
			__widths["ハ"] = 100;
			__widths["ヒ"] = 100;
			__widths["フ"] = 100;
			__widths["ヘ"] = 100;
		}

	}


	class HiraFont extends Font3D{

		static public var __motifs:Object = {};
		static public var __widths:Object = {};
		static public var __heights:Number = 100;
		static public var __initialized:Boolean = false;
		override public function get motifs():Object
		{
		 if(!__initialized)initialize();
		 return __motifs;
		}
		override public function get widths():Object
		{
		 if(!__initialized)initialize();
		 return __widths;
		}
		override public function get height():Number
		{
		 if(!__initialized)initialize();
		 return __heights;
		}

		static public function initialize():void {
			initializeMotifs();
			initializeWidths();
			__initialized = true;
		}
		
		static private function initializeMotifs():void {
			__motifs["あ"] = [['M',[50.4,51.85]],['C',[48.25,52.35,46.2,53.35]],['C',[45.9,55.95,45.9,59.8]],['C',[48.55,56.05,50.4,51.85]],['M',[38,66.15]],['C',[37.6,62,37.8,56.95]],['C',[33.9,58.8,30,62.2]],['C',[25.1,66.5,25.1,69.85]],['C',[25.1,73.15,29.1,73.15]],['C',[34.75,70.5,38,66.15]],['M',[66.6,22.75]],['C',[69.8,24.45,69.8,26.75]],['L',[69.8,27.05]],['C',[68.15,30.1,59.85,32.9]],['C',[53.9,34.8,48.05,36.65]],['C',[46.95,40.95,46.8,44.75]],['C',[49.5,43.95,53.05,43]],['C',[53.9,41.3,53.9,39.35]],['C',[53.9,38.2,53.6,36.95]],['L',[54.4,36.05]],['C',[56.85,36.95,59.3,37.9]],['C',[61.7,38.9,62.5,41.6]],['L',[61.8,43.35]],['C',[70.5,44.15,76.45,47.55]],['C',[84.2,51.95,84.2,59.6]],['C',[84.2,70.4,77.05,78.65]],['C',[69.75,87.1,59,87.1]],['C',[56.55,87.1,53.7,86.75]],['L',[53.05,86.25]],['C',[73.65,72.1,73.65,60.25]],['C',[73.65,55.75,68.65,53.15]],['C',[64.65,51.1,59.65,51.1]],['C',[55.95,57.75,54.1,60.75]],['C',[50.8,66.15,47.75,70.05]],['C',[47.85,71.2,48.55,74.35]],['C',[49.1,77.05,49.1,78.65]],['C',[49.1,79.8,48.65,80.75]],['C',[47.95,81.25,47.05,81.25]],['C',[45,81.25,42.8,79.4]],['C',[40.65,77.55,40.05,75.5]],['C',[37.9,77.85,34.45,80.2]],['C',[30.35,83.2,28.3,83.2]],['C',[26.15,83.2,24.6,81.35]],['C',[19.15,74.8,19.15,70.7]],['C',[19.15,64.65,25.9,57.25]],['C',[31.45,51.1,38,47.3]],['C',[38.5,43,39.45,38.2]],['C',[38,38.3,35.35,39.4]],['C',[32.7,40.55,32.25,40.55]],['C',[30.65,40.55,27.55,36.45]],['C',[25.1,33.2,23.95,30.85]],['L',[24.4,30.5]],['C',[27.35,31.45,30,31.45]],['C',[34.4,31.45,41.3,27.55]],['C',[42.95,19.55,42.95,17.8]],['C',[42.95,15.35,41.1,11.95]],['L',[42.3,11.35]],['C',[45.4,11.45,48.95,12.7]],['C',[53.05,14.25,54,16.5]],['C',[54,17.9,52.95,19.15]],['C',[51.55,20.9,51.35,21.4]],['C',[50.6,23.15,50.2,25.6]],['C',[50.3,25.6,55.75,23.05]],['C',[59.65,21.4,61.25,21.4]],['C',[63.85,21.4,66.6,22.75]]];
			__motifs["い"] = [['M',[43.35,47.1]],['C',[43.35,57.75,43.45,59.95]],['C',[43.95,66.7,43.95,71.1]],['C',[43.95,76.85,42.1,78.9]],['C',[41.4,79.2,40.55,79.2]],['C',[38.65,79.2,36.15,78.05]],['C',[32.3,76.4,29.5,73.05]],['C',[24.6,67.5,20.5,52.35]],['C',[17.85,40.95,15.25,29.4]],['L',[16.2,29.2]],['C',[24.7,31.55,27.75,37.5]],['C',[28.6,39.45,30.55,49.25]],['C',[32.05,56.75,36.25,60.55]],['C',[38.95,56.45,42.85,46.4]],['L',[43.35,47.1]],['M',[83.3,59]],['C',[81.05,62.3,77.95,62.3]],['C',[76,62.3,74.4,58.9]],['C',[73.65,57.05,73.25,51.65]],['C',[72.75,45.35,70.2,39.35]],['C',[67.4,32.85,63.1,29]],['C',[72.15,30.4,78.6,36.95]],['C',[85.35,43.75,85.35,52.75]],['C',[85.35,56.05,83.3,59]]];
			__motifs["う"] = [['M',[44,43.25]],['C',[38.85,45.6,35.75,48.55]],['C',[33.7,50.8,30.1,53.7]],['C',[28.5,53.7,25.4,48.05]],['C',[23.55,44.35,21.6,40.75]],['L',[22.05,40.05]],['C',[24,40.55,26,40.55]],['C',[27.55,40.55,28.4,40.25]],['C',[28.6,40.25,33.6,37.5]],['C',[48.05,29.7,55.25,29.7]],['C',[63.4,29.7,68.35,35.45]],['C',[73.05,40.95,73.05,49.15]],['C',[73.05,65.45,62.8,76.75]],['C',[52.25,88.5,36.15,88.5]],['C',[46.2,79.2,48.25,77.15]],['C',[55.65,69.65,58.2,64.1]],['C',[62,55.85,62,50.3]],['C',[62,40.85,53.05,40.85]],['C',[49.1,40.85,44,43.25]],['M',[60.75,24.45]],['C',[58.7,24.45,54.55,23.65]],['C',[50.4,22.85,48.25,22.85]],['C',[47.95,22.85,42.95,23.75]],['L',[45.6,20.4]],['C',[45.2,18.85,41.8,17]],['C',[38.4,15.15,37.6,13.5]],['L',[37.7,12.6]],['L',[38.4,12.7]],['C',[40.45,12.7,44.35,11.7]],['C',[48.25,10.65,50.2,10.65]],['C',[54.3,10.65,59.3,13.8]],['C',[64.85,17.2,64.85,21]],['C',[64.85,24.45,60.75,24.45]]];
			__motifs["え"] = [['M',[51.25,12.1]],['C',[62.1,15.65,62.1,21.8]],['C',[62.1,24.8,57.05,24.8]],['C',[46,24.8,39.05,11.45]],['L',[38.95,10.65]],['C',[41.5,11.75,49.2,11.75]],['C',[49.9,11.75,51.25,12.1]],['M',[81.75,85.25]],['C',[77.05,87.3,66.4,87.3]],['C',[47.95,87.3,47.15,71.2]],['L',[47.15,65.45]],['C',[47.15,63.9,47.05,61.85]],['C',[46.7,61.65,46.2,61.65]],['C',[43.35,61.65,38.95,67.6]],['C',[37,70.25,31.65,78.9]],['C',[27.65,85.55,26.15,86.35]],['L',[25.9,86.35]],['C',[24,86.45,22.75,83.3]],['C',[21.9,80.85,21.9,78.55]],['C',[21.9,76,23.05,74.35]],['C',[23.25,73.95,30.75,65.15]],['L',[36.9,57.85]],['C',[41.2,52.25,49.1,43.35]],['C',[43.75,44.75,41.9,45.25]],['C',[37.7,46.5,34.85,47.95]],['C',[30.65,50.3,30.2,50.3]],['C',[28.15,50.3,25.4,45.05]],['C',[23.45,41.2,22.45,37.8]],['L',[22.85,37.3]],['C',[24.2,37.3,26.75,38.05]],['C',[29.3,38.8,30.65,38.8]],['C',[34.85,38.8,50.2,32.85]],['C',[52.35,31.85,54.5,30.85]],['C',[57.6,29.5,58.5,29.5]],['C',[61.35,29.5,65,31.65]],['C',[68.65,33.8,69.35,36.45]],['C',[68.55,37.4,64.55,39.75]],['C',[61.25,41.8,56.9,46.25]],['C',[52.55,50.7,50.9,53.9]],['C',[55.2,55.7,55.2,61.75]],['C',[55.2,63.3,54.8,66.4]],['C',[54.4,69.55,54.4,71.1]],['C',[54.4,75.9,59,75.9]],['C',[61.15,75.9,65.3,74.8]],['C',[69.45,73.75,71.5,73.75]],['C',[75.4,73.75,77.65,75]],['C',[83.4,78.25,83.4,81.65]],['C',[83.4,83.3,81.75,85.25]]];
			__motifs["お"] = [['M',[35.35,63.7]],['C',[26.65,67.9,26.05,71.3]],['C',[28.5,73.85,32.7,74.45]],['C',[34.2,73.35,34.85,69.45]],['C',[35.05,66.6,35.35,63.7]],['M',[46.4,18.2]],['C',[46.4,18.95,45.9,20.6]],['C',[45.4,22.3,45.3,22.95]],['C',[45.1,24.35,45,28.35]],['C',[49,26.85,52.55,26.85]],['C',[55.85,26.85,57.9,29.2]],['C',[58.1,30.1,58.1,30.85]],['C',[58.1,34.3,52.45,36.95]],['C',[45.8,39.85,44.9,41.3]],['C',[44.45,46.3,43.95,49.9]],['C',[54.5,44.95,63.2,44.95]],['C',[70.4,44.95,76.75,49.15]],['C',[83.9,53.9,83.9,60.85]],['C',[83.9,69.65,78.35,75.6]],['C',[72.85,81.55,64.15,81.55]],['C',[59,81.55,52.15,77.95]],['L',[51.85,77.15]],['C',[60.95,76,66.2,72.1]],['C',[68.55,70.35,70.4,67.5]],['C',[72.55,64.25,72.55,61.75]],['C',[72.55,53.7,60.65,53.7]],['C',[53.3,53.7,43.35,59.8]],['C',[43.25,71.1,41.9,78.25]],['C',[40.45,85.75,35.65,85.75]],['C',[33,85.75,30.25,83.6]],['C',[28.15,81.65,26,79.6]],['C',[23.15,78.15,18.85,74.8]],['C',[18.25,73.95,18.25,72.55]],['C',[18.25,70.4,19.15,68.25]],['C',[20.3,65.25,26.55,60.35]],['C',[31.55,56.35,35.95,53.9]],['C',[36.35,49.05,36.45,43.65]],['C',[36.25,43.65,32.3,45.7]],['C',[29.2,47.2,28.4,47.2]],['C',[25.9,47.2,19.9,37.9]],['L',[20.5,37.4]],['L',[26.05,37.7]],['C',[27.45,37.7,31.45,35.6]],['C',[35.45,33.5,36.6,32.25]],['C',[36.35,30.2,36.45,26.15]],['C',[36.5,22.1,36.15,20.05]],['C',[34.75,18.35,32.05,17.5]],['L',[31.75,16.6]],['C',[32.15,16.3,33.8,14.35]],['C',[35.15,12.6,35.75,12.6]],['C',[38.2,12.6,42,14.15]],['C',[46.4,16.05,46.4,18.2]],['M',[81.15,37.5]],['C',[77.05,37.5,73.35,34.4]],['C',[71.8,33,67.3,27.75]],['C',[63.55,23.45,60.85,22]],['L',[61.35,21.6]],['C',[64.35,21.1,67,21.1]],['C',[77.65,21.1,82.4,27.85]],['C',[84.65,30.95,84.65,33.4]],['C',[84.65,37.5,81.15,37.5]]];
			__motifs["か"] = [['M',[45.1,24.45]],['L',[42.5,32.85]],['C',[47.45,31.05,50,31.05]],['C',[51,31.05,51.75,31.35]],['L',[52.45,31.25]],['C',[55.75,31.05,59.5,35.4]],['C',[63.3,39.75,63.3,43.35]],['C',[63.3,47,60.25,57.05]],['C',[57.15,67.6,53.15,75.3]],['C',[46.9,87.4,40.45,88.5]],['C',[38.1,87.6,36.9,85.35]],['C',[36.25,83.8,34.95,80.75]],['C',[31.55,74.15,29.6,68.2]],['L',[29.9,67.2]],['C',[37.1,71.4,39.65,71.4]],['C',[43.75,71.4,47.85,59.6]],['C',[51.25,49.7,51.25,45.4]],['C',[51.25,42.7,49.9,42.1]],['C',[49.4,40.75,46.95,40.75]],['C',[42.2,40.75,37.8,43.85]],['C',[35.05,50.6,31.35,58.9]],['C',[29.5,63.2,25.5,71.4]],['C',[23.95,74.15,21.7,76.6]],['C',[18.55,79.9,16.5,79.9]],['C',[13.95,78.55,13.95,72.85]],['C',[13.95,70.5,14.2,69.6]],['C',[14.45,68.65,16.2,66.6]],['C',[19.9,62.3,27.55,47.75]],['L',[21.5,49.9]],['C',[19.25,49.35,16.45,47.05]],['C',[13.65,44.75,12.3,42.5]],['L',[13,41.9]],['L',[17.2,41.8]],['C',[21,41.7,32.7,35.75]],['C',[34.1,31.45,35.65,22.95]],['L',[34.4,17.4]],['L',[34.55,16.8]],['C',[35.15,16.7,35.85,16.7]],['C',[41.3,16.7,44.25,21.5]],['C',[45.4,23.45,45.1,24.45]],['M',[90.15,47.85]],['C',[90.15,54.4,85.65,54.4]],['C',[83.4,54.4,77.55,50.9]],['C',[74.4,49.8,69.45,47]],['C',[75.5,46.3,76.25,42.7]],['C',[74.9,39.55,71.6,35.45]],['C',[66.3,29.3,66,28.8]],['L',[66.9,28.45]],['C',[75.3,29.6,82.15,34.4]],['C',[90.15,40.15,90.15,47.85]]];
			__motifs["き"] = [['M',[27.15,74.45]],['C',[27.15,71.9,28.7,69.35]],['C',[30.25,66.85,32.45,65.9]],['C',[32.4,66.35,32.4,69.05]],['C',[32.4,76.5,42.75,76.5]],['C',[44.8,76.5,48.9,75.7]],['C',[52.95,74.9,55,74.9]],['C',[65.25,74.9,65.25,81.25]],['C',[65.25,81.75,65.15,82.25]],['C',[61.9,88.2,48.45,88.2]],['C',[40.15,88.2,34.45,85.35]],['C',[27.15,81.85,27.15,74.45]],['M',[46.5,12]],['C',[49.3,13.6,49.6,15.15]],['C',[50.6,20.35,52.25,24.25]],['C',[57.05,22.2,59.45,22.2]],['C',[62,23.15,64.55,24.15]],['C',[67.75,25.8,67.75,28.05]],['C',[67.75,31.05,62.7,32.75]],['C',[58.9,33.8,55.1,34.9]],['L',[58.3,39.85]],['C',[59.65,39.65,63.3,38]],['C',[66.5,36.45,68.05,36.45]],['C',[71.4,36.45,74.3,37.8]],['C',[77.95,39.45,77.95,42.5]],['C',[77.95,43.35,77.65,43.85]],['C',[77.15,44.95,71.9,46.3]],['C',[65.65,47.85,64.75,48.35]],['C',[72.45,56.55,72.45,61.95]],['C',[72.45,64.45,69.8,64.45]],['C',[68.95,64.45,67.4,64]],['C',[65.35,63.4,65.05,63.3]],['C',[61.05,62.6,57.05,61.85]],['C',[52.35,60.95,49.2,59.7]],['C',[54.9,57.25,56.85,54.8]],['C',[56.65,52.55,54.1,50.7]],['C',[48.05,52.25,36.25,56.15]],['C',[30.65,58.3,30.35,58.3]],['C',[29,58.3,25.3,54.4]],['C',[22.15,51.1,21,49.15]],['L',[21.6,48.55]],['L',[27.95,49.05]],['C',[30.1,48.15,37.5,46.3]],['C',[43.85,44.75,49.4,42.8]],['L',[46.5,37.1]],['L',[36.8,38.8]],['C',[32.05,39.55,24.8,30.2]],['L',[25.9,30.4]],['C',[29.7,30.4,34.85,28.9]],['C',[42.4,26.75,43.45,26.6]],['C',[42.1,23.45,39.05,17.2]],['L',[34.75,14.55]],['L',[34.95,13.5]],['C',[35.75,13.2,38.1,11.65]],['C',[39.95,10.25,41.6,10.25]],['C',[43.25,10.25,46.5,12]]];
			__motifs["く"] = [['M',[48.55,12.1]],['L',[49,11.65]],['C',[52.65,13.1,56.15,15.95]],['C',[60.65,19.55,60.65,22.45]],['C',[60.65,24.7,55.2,31.65]],['C',[51.45,36.05,47.75,40.45]],['C',[44.05,44.85,37.1,53.8]],['C',[44.75,57.05,49,59.9]],['C',[55.75,64.15,60.75,69.85]],['C',[67.2,77.25,67.2,83.3]],['C',[67.2,88.4,63.5,88.4]],['C',[60.45,88.4,54.7,82.35]],['C',[50.9,77.95,47.15,73.55]],['C',[38.5,63.9,29.7,61.85]],['C',[26.15,61.05,24.8,60.25]],['C',[22.35,58.9,22.35,56.25]],['C',[22.35,54.6,26.05,50.8]],['C',[41.5,35.25,48.85,20.15]],['L',[48.55,12.1]]];
			__motifs["け"] = [['M',[24.6,32.8]],['C',[26.05,24.5,26.05,22.45]],['L',[25.3,17.7]],['L',[26.35,17.4]],['C',[30.35,20.25,31.75,22.2]],['C',[33.7,24.9,33.7,29]],['C',[33.7,30.75,33,35.85]],['C',[32.05,41.6,31.05,47.4]],['C',[29.9,55.1,29.9,58.5]],['C',[29.9,60.45,30.35,61.25]],['C',[33,58.3,36.9,52.15]],['C',[36.8,52.55,35.85,59.3]],['C',[35.25,62.2,34.2,68.25]],['C',[33.8,71.6,32.5,78.25]],['C',[31.75,81.05,30.45,82.15]],['C',[25.3,80.7,22.45,75.6]],['C',[19.8,70.9,19.8,65.25]],['C',[19.8,59.5,21.7,49.15]],['C',[23.15,41.05,24.6,32.8]],['M',[81.65,38.6]],['C',[77.85,38.8,73.95,39.1]],['C',[74,42.5,74,45.6]],['C',[74,85.95,55.25,85.95]],['L',[54,85.85]],['C',[60.45,75.1,62.8,63.5]],['C',[64.65,54.3,64.65,39.45]],['L',[63.95,39.45]],['C',[60.15,39.35,53.3,41.05]],['C',[48.05,42.3,42.85,43.55]],['L',[41.9,43.35]],['C',[50.1,32.85,64.55,28.15]],['L',[64.65,26.95]],['C',[64.65,22.55,63.45,20.05]],['C',[62.2,17.5,58.7,14.65]],['L',[58.5,13.8]],['C',[62.7,11.65,64.35,11.65]],['C',[66.3,11.65,70.1,13.5]],['C',[74.4,15.55,74.4,17.4]],['L',[74.1,26.6]],['C',[86.6,27.45,86.6,34.9]],['C',[86.6,38,81.65,38.6]]];
			__motifs["こ"] = [['M',[25.2,67.5]],['C',[25.2,63,28.8,59.2]],['C',[29.1,61.25,30.35,65.25]],['C',[32.05,68.55,37,69.55]],['C',[39.65,70.15,45.4,70.15]],['C',[50.4,70.15,53.3,69.65]],['C',[53.8,69.55,61.05,68.1]],['C',[65.65,67,68.75,67]],['C',[71.6,67,73.95,68.25]],['C',[76.75,69.75,76.75,72.4]],['C',[76.75,73.95,74.9,76.6]],['C',[70.1,83.5,51.25,83.5]],['C',[42,83.5,34.55,80.1]],['C',[25.2,75.7,25.2,67.5]],['M',[67.3,32.35]],['C',[67,32.45,62,32.45]],['C',[53.3,32.45,41,38]],['L',[43.35,33.2]],['C',[33.5,29.7,30.75,20.9]],['L',[31.85,20.9]],['C',[32.7,20.9,34.4,21.05]],['C',[36.15,21.2,37,21.2]],['C',[40.35,21.2,47.1,20.65]],['C',[53.9,20.15,57.25,20.15]],['C',[62,20.15,66,22.45]],['C',[70.6,25.2,71.2,29.5]],['C',[70.5,31.85,67.3,32.35]]];
			__motifs["さ"] = [['M',[25.9,70.9]],['C',[25.9,65.85,30.95,63.5]],['C',[31.15,64.1,31.15,65.45]],['C',[31.15,71.6,36.6,73.45]],['C',[39.55,74.45,47.35,74.45]],['C',[49.3,74.45,53.1,74.25]],['C',[56.85,74.05,58.8,74.05]],['C',[61.8,74.05,64.35,75.5]],['C',[67.5,77.15,67.5,80]],['C',[67.5,87.7,52.05,87.7]],['C',[42.2,87.7,35.05,84.2]],['C',[25.9,79.7,25.9,70.9]],['M',[72.45,23.95]],['C',[75.9,25.4,75.9,27.65]],['C',[74.4,31.45,70.2,33.7]],['C',[63.2,37.4,63,37.5]],['C',[63,37.6,69.45,47.3]],['C',[73.85,53.8,73.85,57.15]],['C',[73.85,61.15,69.9,61.15]],['C',[66.7,61.15,61.8,60.25]],['C',[57.8,59.5,53.8,58.8]],['C',[50.6,58.7,44.35,57.85]],['C',[46.4,56.35,49.2,55.3]],['C',[52.05,54.2,55.1,53.15]],['C',[59,51.4,58.9,49.05]],['L',[58.8,48.55]],['C',[56.65,44.65,53.5,40.85]],['C',[48.05,42.9,37.4,47.45]],['C',[34.85,49.05,29.7,51.6]],['C',[25.1,50.4,18.65,40.65]],['L',[19.05,40.05]],['C',[21.6,40.85,23.95,40.85]],['C',[25.4,40.85,35.55,36.65]],['C',[44.45,32.9,47.75,31.25]],['C',[46.7,27.35,43.25,21.9]],['C',[40.15,19.75,36.05,18.1]],['L',[35.95,16.8]],['C',[38.3,14.75,42.75,11.95]],['C',[42.85,12,48.35,13.1]],['C',[52.35,13.9,53.2,15.75]],['C',[52.95,16.6,52.95,17.6]],['C',[52.95,20.35,56.85,26.85]],['C',[58.1,26.5,61.35,24.35]],['C',[63.5,22.75,67,22.75]],['C',[69.75,22.75,72.45,23.95]]];
			__motifs["し"] = [['M',[46.8,24.15]],['C',[46.8,25.5,45.5,28.35]],['C',[44.05,31.85,43.85,32.75]],['C',[39.15,51.85,39.15,64]],['C',[39.15,68.25,41.3,71.2]],['C',[43.75,74.5,47.85,74.5]],['C',[56.95,74.5,67.7,62.3]],['C',[73.45,55.75,81.75,42.4]],['C',[79,68.55,64.65,80.4]],['C',[61.6,82.85,56.75,84.55]],['C',[51.85,86.25,47.85,86.25]],['C',[39.35,86.25,34.2,80.5]],['C',[29.2,75,29.2,66.4]],['C',[29.2,60.15,30.45,51.65]],['C',[31.65,44.45,32.8,37.1]],['C',[33.5,32.65,34.85,23.75]],['L',[33.1,14.85]],['L',[33.9,14.15]],['C',[38.4,14.45,45.9,21.8]],['C',[46.8,22.65,46.8,24.15]]];
			__motifs["す"] = [['M',[49.5,47.75]],['C',[47.45,47.75,44.9,49.55]],['C',[42.4,51.4,41,53.25]],['C',[39.45,55.5,39.45,58.7]],['C',[39.45,61.05,44.05,61.05]],['C',[52.45,61.05,52.45,52.65]],['C',[52.45,49.6,51.55,48.35]],['C',[50.5,47.75,49.5,47.75]],['M',[83.75,36.75]],['C',[82.05,37.8,80,37.8]],['L',[77.15,37.9]],['C',[75,37.9,70.9,37.35]],['C',[66.8,36.85,64.75,36.85]],['C',[62.9,36.85,61.35,37.2]],['C',[60.85,40.35,60.85,40.85]],['C',[60.85,42.8,62.05,47.5]],['C',[63.3,52.25,63.3,54.9]],['C',[63.3,69.35,56.35,78.8]],['C',[48.65,89.35,34.75,89.25]],['L',[34.2,89.25]],['L',[33.5,89.1]],['C',[47.85,77.55,50.7,66.7]],['C',[44.75,68.35,41.4,68.35]],['C',[32.05,68.35,32.05,59.95]],['C',[32.05,52.95,38,47.1]],['C',[43.65,41.5,50.8,40.35]],['L',[50.9,38.2]],['C',[33.2,40.15,20.7,47.55]],['C',[17.4,47.55,11.05,36.75]],['L',[12.1,36.55]],['L',[17.85,37.1]],['C',[37.8,32.15,52.45,29.2]],['C',[52.85,24.5,52.85,21.6]],['L',[52.75,19.25]],['C',[50.7,16.9,47.85,15.25]],['L',[48.05,14.1]],['C',[48.95,13.8,51.05,12.2]],['C',[52.95,10.85,53.8,10.85]],['C',[55.75,10.85,59.75,12.4]],['C',[64.25,14.1,64.25,15.65]],['C',[64.25,16.6,63.55,18]],['C',[62.5,20.05,62.5,20.15]],['C',[62.1,21.2,62.1,27.35]],['C',[71.2,25.8,71.9,25.8]],['C',[75.7,25.8,80.2,27.85]],['C',[85.45,30.4,85.45,33.7]],['C',[85.45,35.65,83.75,36.75]]];
			__motifs["せ"] = [['M',[85.85,37.6]],['C',[85.85,41.05,65.8,44.55]],['C',[65.35,50.7,64.75,56.85]],['C',[63.4,64.35,57.8,65.45]],['C',[55.95,64.95,53.4,61.85]],['C',[49.9,57.45,49.6,57.15]],['C',[48.25,55.85,45.7,54.4]],['L',[45.2,53.35]],['C',[47.95,53.7,51.05,53.7]],['C',[52.65,53.7,54.4,53.65]],['L',[55.25,45.4]],['C',[46.5,47.4,37.9,49.9]],['C',[37.2,56.45,37.2,60.35]],['C',[37.2,66.4,38.75,69.25]],['C',[40.9,73.05,46.4,73.05]],['C',[50.9,73.05,61.9,71]],['C',[66.5,70.15,67.75,70.15]],['C',[70.9,70.15,73.75,71.4]],['C',[77.25,73.05,77.25,75.8]],['C',[77.25,80,68.65,82.25]],['C',[63.5,83.5,56.85,83.9]],['C',[54.8,84,52.95,84]],['C',[29,84,29.2,62.8]],['L',[29.2,52.35]],['C',[27.85,52.35,25,53.6]],['C',[22.15,54.8,21.5,54.8]],['C',[19.65,54.8,15.7,50.9]],['C',[12.2,47.3,11.05,45.05]],['L',[11.8,44.35]],['C',[14.45,45.15,16.7,45.15]],['C',[18.75,45.15,30,41.7]],['C',[30.45,37,30.45,36.65]],['C',[30.45,34.9,29.4,32.15]],['C',[28.2,28.9,28.05,27.75]],['L',[28.5,27.15]],['C',[35.35,27.65,37.4,30.6]],['C',[38.95,32.9,38.95,39.65]],['C',[46,38.6,55.55,35.65]],['C',[55.85,33.4,55.85,28.7]],['C',[55.85,27.35,55.75,24.5]],['C',[55.75,21.7,55.75,20.35]],['C',[53.9,17.1,50.9,14.95]],['L',[51.15,14]],['C',[51.55,13.9,54.2,12.6]],['C',[56.15,11.75,57.25,11.75]],['C',[58.9,11.75,62.85,14.4]],['C',[66.8,17.1,67.1,18.65]],['C',[67.2,18.85,67.2,19.95]],['L',[66.1,33.2]],['C',[68.35,32.55,70.7,31.85]],['C',[73.55,31.05,75.3,31.05]],['C',[78.4,31.05,81.85,32.85]],['C',[85.85,34.9,85.85,37.6]]];
			__motifs["そ"] = [['M',[34.85,36.65]],['C',[32.4,36.65,30.55,33]],['C',[29.4,30.85,27.75,25.6]],['C',[26.15,20.7,25.4,19.45]],['L',[26.55,19.25]],['C',[29.7,19.25,33.65,22.15]],['C',[37.6,25,38.75,27.95]],['C',[39.25,29.3,39.25,31.35]],['C',[39.25,36.65,34.85,36.65]],['M',[71.6,24.25]],['C',[68.65,25.9,67.95,26.4]],['C',[64.95,28.65,54.6,38.3]],['C',[66.5,33.5,67.85,33.5]],['C',[68.35,33.5,68.65,33.7]],['C',[69.15,33.6,69.8,33.6]],['C',[72.95,33.6,76.45,35.65]],['C',[80,37.7,80,40.35]],['C',[80,42.3,78.05,43.2]],['C',[68.45,43.95,60.15,48.65]],['C',[56.45,50.7,53.9,53.8]],['C',[50.9,57.55,50.9,61.35]],['C',[50.9,66.8,56.15,70.8]],['C',[61.05,73.85,65.8,76.85]],['C',[71.1,80.3,71.1,84.3]],['C',[71.1,89.15,66.1,89.1]],['L',[65.65,89.1]],['C',[56.45,88.8,49.65,81.9]],['C',[42.85,75,42.85,65.55]],['C',[42.85,55.2,48.55,48.75]],['C',[38.95,53.05,31.65,56.85]],['C',[28.4,58.7,21.9,61.85]],['C',[20.8,62.2,20.1,62.2]],['C',[18.65,61.45,18.65,57.55]],['C',[18.65,54.4,20.9,50.8]],['C',[21.4,50,23.95,49.85]],['C',[26.55,49.7,27.25,49.35]],['C',[33.9,45.5,46,34.8]],['C',[54.5,27.35,61.15,18.45]],['C',[60.15,15.35,56.15,13.6]],['L',[56.35,12.8]],['C',[56.75,12.8,57.15,12.8]],['C',[58.2,12.8,60.3,12]],['C',[62.4,11.25,63.55,11.25]],['C',[64.25,11.25,64.85,11.45]],['L',[65.05,11.45]],['C',[66.9,11.45,71.35,14.85]],['C',[75.8,18.25,75.8,20.05]],['C',[75.8,20.7,74.8,21.8]],['C',[73.85,22.85,71.6,24.25]]];
			__motifs["た"] = [['M',[80.65,72]],['C',[84.3,73.65,84.45,76.75]],['C',[81.85,84,68.05,84]],['C',[66.4,84,62.3,82.95]],['C',[58.2,81.95,56.45,81.15]],['C',[48.25,77.35,48.25,70.15]],['C',[48.25,68.85,48.55,67.4]],['L',[49.4,67.7]],['C',[52.65,71.7,61.35,71.7]],['C',[63.5,71.7,67.8,71.15]],['C',[72.15,70.6,74.3,70.6]],['C',[77.85,70.6,80.65,72]],['M',[55.45,22.2]],['C',[57.8,22.1,61.6,23.75]],['C',[65.8,25.7,65.8,27.65]],['C',[65.8,30.3,60.9,32.4]],['C',[55.95,34.5,51,36.45]],['C',[44.9,39.25,43.05,43]],['C',[38,54.4,32.8,65.95]],['C',[24.5,84.6,22.35,85.75]],['C',[17.2,85.05,17.2,75.8]],['C',[17.2,73.65,18.05,71.5]],['C',[18.15,71.2,21.1,66.5]],['C',[21.9,64.85,23.65,61.55]],['C',[27.05,55.6,33.2,43.2]],['C',[26.35,42.6,19.55,36.45]],['L',[20.3,35.25]],['C',[28.2,34.7,39.55,29.2]],['C',[40.8,26.2,43.35,15.85]],['C',[42.3,12.3,41,9.95]],['L',[42.1,9.2]],['C',[45.3,10.05,48.65,10.95]],['C',[52.05,12.4,52.55,16.05]],['C',[49.5,22.2,49.3,25.1]],['C',[52.25,23.75,55.1,22.3]],['L',[55.45,22.2]],['M',[81.15,50.2]],['C',[80.75,50.4,73.55,51.95]],['C',[65.9,53.65,60.85,55.85]],['L',[60.25,55.85]],['C',[63.75,52.55,64.95,49.8]],['L',[58.8,50.3]],['C',[55.65,50.3,53.3,48.95]],['C',[50.6,47.4,50.2,44.65]],['C',[56.55,43.45,62.15,41.45]],['C',[67.75,39.45,70,39.45]],['C',[72.85,39.45,77.55,42]],['C',[82.6,44.75,82.6,47.2]],['C',[82.6,48.55,81.15,50.2]]];
			__motifs["ち"] = [['M',[40.8,12.8]],['L',[40.9,11.75]],['C',[41.8,11.65,44.15,10.85]],['C',[46.2,10.15,47.45,10.15]],['C',[49.3,10.15,52.3,12.75]],['C',[55.25,15.35,55.95,17.1]],['C',[55.35,19.25,52.75,23.55]],['C',[49.8,28.25,49,30.3]],['C',[50.4,29.9,57.05,26.6]],['C',[61.9,24.15,65.35,24.15]],['C',[67.95,24.15,71.6,26.1]],['C',[75.6,28.35,75.6,30.7]],['C',[75.6,31.35,75.3,32.05]],['C',[73.45,33.6,66.6,35.55]],['C',[61.7,36.85,56.85,38.1]],['C',[50.4,39.85,45.6,42]],['C',[43.05,44.55,40.15,52.35]],['C',[46.6,48.65,56.15,48.65]],['C',[64.15,48.65,69.75,51.95]],['C',[76.25,55.95,76.25,63.6]],['C',[76.25,73.55,66.8,80.2]],['C',[58.3,86.15,47.95,86.15]],['C',[42.3,86.15,34.1,84.9]],['L',[33.1,84.2]],['C',[60.15,75.8,64.95,67.1]],['C',[66.5,64.35,66.5,63]],['C',[66.5,59.6,63.2,57.65]],['C',[60.45,56.05,56.85,56.05]],['C',[45.9,56.05,30.75,69.95]],['C',[30.35,70.05,30,70.05]],['C',[28.05,70.05,26.75,66.4]],['C',[25.8,63.5,25.8,61.05]],['C',[25.8,58.7,26.55,57.25]],['C',[27.95,55.3,30.35,51.6]],['C',[32.3,48.35,33.9,44.65]],['C',[32.05,44.75,28.2,45.8]],['C',[24.4,46.9,23.25,46.9]],['C',[20.1,46.9,14.75,34.1]],['L',[15.55,33.6]],['C',[17.6,34.6,20.6,35.75]],['C',[32.7,34.2,38.75,32.85]],['C',[42.3,26,44.05,19.05]],['C',[43.75,15.15,40.8,12.8]]];
			__motifs["つ"] = [['M',[69.7,39.3]],['C',[66.8,36.65,63,36.65]],['C',[55,36.65,41.8,41.9]],['C',[31.55,46.2,21.2,50.6]],['C',[18.45,50.5,15.05,46.7]],['C',[12.5,43.85,10.65,40.45]],['L',[11.05,39.65]],['L',[18.75,40.85]],['C',[22.95,39.85,33,35.45]],['C',[52.25,27.05,63.85,27.05]],['C',[72.55,27.05,79,32.95]],['C',[85.45,38.9,85.45,47.45]],['C',[85.45,59.3,76.25,67.1]],['C',[65.7,76.2,53.7,76.2]],['C',[47.45,76.2,40.7,72.85]],['L',[40.15,72.1]],['C',[65.05,62.2,70.4,54]],['C',[72.55,50.7,72.55,45.8]],['C',[72.55,42,69.7,39.3]]];
			__motifs["て"] = [['M',[78.5,26]],['C',[63.65,33.4,59.4,36.85]],['C',[49.6,44.55,49.6,55.6]],['C',[49.6,59.9,52.85,64.1]],['C',[55.45,67.6,58.1,69.05]],['C',[62.9,71.5,67.7,73.95]],['C',[73.05,77.45,73.05,82.55]],['C',[73.05,84.2,72,85.7]],['C',[71,87.2,69.45,87.2]],['C',[57.15,87.2,49,77.65]],['C',[41.4,68.65,41.4,56.15]],['C',[41.4,44.35,49.4,34.9]],['C',[45.3,35.85,41.6,37.1]],['C',[34.45,39.85,26,42.6]],['C',[20,39.85,13.55,30.5]],['L',[14.15,30.2]],['C',[15.65,30.2,18.5,30.85]],['C',[21.4,31.55,22.75,31.55]],['C',[24.8,31.55,32.7,28.9]],['C',[38,27.25,43.25,25.5]],['C',[47.35,24.45,55.25,22]],['C',[56.35,21.6,61.35,19.05]],['C',[65.55,17,67,17]],['C',[69.75,17,74,19.45]],['C',[78.8,22.2,78.8,24.6]],['C',[78.8,25.3,78.5,26]]];
			__motifs["と"] = [['M',[62.8,21.7]],['C',[66.3,22.55,69.8,23.45]],['C',[73.85,24.5,75.9,27.35]],['C',[77.15,29.1,77.15,30.75]],['C',[77.15,33,74.3,35.55]],['C',[72.35,37.4,61.35,44.75]],['C',[49.5,52.65,44.15,57.05]],['C',[35.65,64.1,35.65,67.7]],['C',[35.65,69.75,36.35,70.5]],['C',[38.85,73.55,44.55,73.55]],['C',[50,73.55,56.45,71.7]],['C',[59.2,70.7,62,69.85]],['C',[65.25,68.85,67.7,68.85]],['C',[71.2,68.85,74.3,70.5]],['C',[77.85,72.45,78.5,75.6]],['C',[75.1,84.6,50.1,84.6]],['C',[42.3,84.6,35.15,81.25]],['C',[26.35,77.05,26.35,70.25]],['C',[26.35,63.5,30.45,57.45]],['C',[34.75,52.15,39.15,47]],['C',[37.5,44.25,34,35.95]],['C',[32.15,31.05,30.2,26.1]],['C',[27.65,20.9,23.05,18.65]],['L',[23.65,17.9]],['C',[26,16.6,28.9,16.6]],['C',[32.8,16.6,36.15,19.25]],['C',[40.65,22.75,42.95,29.1]],['C',[45,34.8,47.05,40.45]],['C',[57.3,33.3,61.15,27.75]],['C',[62.5,25.8,62,22.2]],['L',[62.8,21.7]]];
			__motifs["な"] = [['M',[43.95,70.6]],['C',[43.95,72.2,45.95,74.65]],['C',[47.95,77.15,49.5,77.65]],['C',[53.7,76.3,55.25,71.5]],['C',[51.85,69.65,46.9,69.65]],['C',[45.1,69.65,44.05,70.15]],['C',[43.95,70.35,43.95,70.6]],['M',[62.4,45.35]],['C',[62.9,47.65,65.55,54.8]],['C',[67.7,60.35,67.4,64.65]],['C',[73.75,67.6,75.9,69.05]],['C',[80.55,72.4,80.55,76.6]],['C',[80.55,80.5,76.35,80.5]],['C',[72.35,80.5,65.25,76.95]],['C',[64.25,77.85,61.45,81.55]],['C',[57.15,87.1,49.3,88.9]],['C',[45.8,88.2,44.15,85.65]],['C',[43.45,84.6,41,78.25]],['C',[38.75,72.2,38.5,71]],['C',[38,69.15,38,68.1]],['C',[38,65.25,40.9,63.6]],['C',[43.35,62.2,46.5,62.2]],['C',[49.5,62.2,56.75,62.8]],['C',[57.3,61.65,57.8,54.6]],['C',[58.2,48.55,61.35,45.7]],['L',[62.4,45.35]],['M',[47.05,23.65]],['C',[48.35,23.45,49,23.45]],['C',[51.65,23.45,53.7,24.45]],['C',[56.25,25.7,56.25,27.95]],['C',[56.25,31.35,49.3,34.7]],['C',[41.3,38.6,39.65,41.4]],['C',[37,45.8,33,53.7]],['C',[28.5,62.8,26.65,66.15]],['C',[22.65,73.45,20,73.45]],['C',[17.95,73.45,17,69.05]],['C',[16.2,66.05,16.2,62.6]],['C',[16.2,61.05,21.9,52.55]],['C',[25.6,47.1,29.2,41.7]],['C',[18.45,40.55,15.9,32.9]],['L',[16.1,31.95]],['C',[17.4,32.25,19.05,32.25]],['C',[26.55,32.25,35.05,27.85]],['C',[36.45,23.85,36.45,20.15]],['C',[36.45,17.5,35.05,12.2]],['L',[35.75,11.65]],['C',[45.3,12.6,45,23.85]],['C',[45.5,23.75,47.05,23.65]],['M',[86.05,42.2]],['C',[84.75,44.85,80.2,44.85]],['C',[75.9,44.85,70.2,40.75]],['C',[62.7,35.35,60.95,34.6]],['L',[61.5,33.7]],['C',[66.2,31.75,70.7,31.75]],['C',[76.65,31.75,80.75,33.5]],['C',[86.25,36.05,86.05,41.15]],['L',[86.05,42.2]]];
			__motifs["に"] = [['M',[23.45,36.75]],['C',[24.6,30.5,24.6,26]],['C',[24.6,23.15,24.2,19.35]],['L',[25.1,18.85]],['C',[29.3,22.45,30.85,27.65]],['C',[31.95,31.45,31.95,38.3]],['C',[31.95,42,31.25,48.15]],['C',[30.25,55.95,30.1,58]],['L',[35.15,55.6]],['C',[34.2,58.7,32.3,64.95]],['C',[31.05,70.5,29.8,76.1]],['C',[27.75,84.95,26.75,85.85]],['C',[26,85.95,25.3,85.95]],['C',[18.45,85.95,18.45,68.85]],['C',[18.45,66.15,19.65,58.4]],['C',[20.1,54.7,21.2,47.4]],['C',[22.35,42,23.45,36.75]],['M',[73.1,39]],['C',[66.1,40.25,62.8,42.1]],['L',[61.7,42.1]],['L',[66.3,37]],['C',[53.5,35.75,48.45,30.2]],['C',[55.65,29,61.5,26.65]],['C',[68.75,23.85,71.1,23.85]],['C',[74.6,23.85,78.8,26.85]],['C',[83,29.9,83,33.2]],['C',[83,35.95,80.95,37.1]],['C',[80.1,37.7,73.1,39]],['M',[86.15,74.6]],['C',[84.65,78.15,79,80]],['C',[74.7,81.45,69.8,81.45]],['C',[55.2,81.45,50.7,72.85]],['C',[49.1,69.85,49.1,63.2]],['L',[49.8,62]],['C',[53.3,69.55,62.6,69.55]],['C',[64.95,69.55,69.55,68.3]],['C',[74.1,67.1,76.45,67.1]],['C',[79.9,67.1,82.7,69.25]],['C',[85.55,71.4,86.15,74.6]]];
			__motifs["ぬ"] = [['M',[38.95,48.45]],['L',[40.05,52.65]],['C',[41.6,49.7,42.6,46.1]],['C',[40.55,47.4,38.95,48.45]],['M',[67.75,66.2]],['C',[64.15,61.65,61.15,61.65]],['C',[58.5,61.65,58.4,64.85]],['C',[58.2,65.15,58.2,65.45]],['C',[58.2,66.4,59.8,67.9]],['C',[61.45,69.35,62.4,69.35]],['C',[64.85,69.35,67.75,66.2]],['M',[34.3,62.4]],['C',[32.25,58.5,30.65,53.05]],['C',[25.8,56.95,25.3,57.45]],['C',[22.25,60.45,22.25,63.3]],['C',[22.25,65.25,23.75,67.05]],['C',[25.2,68.85,27.15,69.35]],['C',[29.7,68.1,34.3,62.4]],['M',[81.75,79.4]],['C',[78.3,78.35,74.3,74.8]],['C',[65.8,80.5,61.6,80.4]],['L',[61.15,80.3]],['C',[56.85,79.7,53.4,72.85]],['C',[50.6,66.9,50.6,62]],['C',[50.6,52.65,61.25,52.65]],['C',[66.2,52.65,73.05,58.5]],['C',[74.3,54,74.3,49.45]],['C',[74.3,43.55,72.15,41.15]],['C',[69.75,38.3,63.95,38.3]],['C',[57.8,38.3,53.8,41.2]],['C',[50.4,48.25,43.25,62]],['C',[43.55,63.1,44.8,66.6]],['C',[45.9,69.55,45.9,71.2]],['C',[45.9,76.3,42.85,76.3]],['C',[41.6,76.3,39.25,74.45]],['C',[38,73.45,36.7,71.2]],['C',[35.85,71.8,31.25,76.5]],['C',[27.55,80.3,25.8,80.4]],['C',[24.7,80,23.85,79.3]],['C',[21.5,77.45,16.6,71.1]],['C',[14.95,68.85,14.95,66.5]],['C',[14.95,56.05,29,46.1]],['C',[26.95,40.95,25.9,30.85]],['L',[26.55,29.6]],['C',[27.05,30.1,35.45,40.65]],['C',[42.1,36.55,47.25,33.8]],['C',[49.9,26.3,51,24.25]],['L',[51.05,24.05]],['C',[51.05,21.5,46.5,18.75]],['L',[46.1,17.8]],['C',[47.25,17.7,49.8,16.85]],['C',[52.35,16.05,53.8,16.05]],['C',[55.95,16.05,59.7,18.05]],['C',[63.5,20.05,63.5,22]],['C',[63.5,22.45,61.7,25.8]],['C',[59.75,29.4,59.55,30.4]],['C',[61.7,30.1,63.75,30.1]],['C',[72.85,30.1,78.7,35.8]],['C',[84.55,41.5,84.55,50.5]],['C',[84.55,56.65,81.65,65.25]],['C',[86.15,70.4,86.15,74.7]],['C',[86.15,79.2,81.75,79.4]]];
			__motifs["ね"] = [['M',[68.25,69.15]],['C',[67.2,66.6,64.65,64.45]],['C',[61.8,62.2,59.3,62.2]],['C',[56.05,62.2,56.05,64.75]],['C',[56.05,67.5,58.15,69.05]],['C',[60.25,70.6,63.1,70.6]],['C',[64.65,70.6,68.25,69.15]],['M',[84.2,80.1]],['C',[82.7,82.45,80.65,82.45]],['C',[78.9,82.45,76.55,80.1]],['C',[74.6,78.25,73.65,76.3]],['C',[70.4,79.9,63.95,79.9]],['C',[57.3,79.9,53.25,75.6]],['C',[49.2,71.3,49.2,64.65]],['C',[49.2,57.75,55.1,54.8]],['C',[56.75,54,60.05,54]],['C',[63,54,66.5,55.75]],['C',[67.5,56.15,72.35,59.1]],['C',[73.65,55,73.65,47.1]],['C',[73.65,31.65,70.3,30.5]],['C',[69.65,30.3,68.55,30.3]],['C',[63.85,30.3,52.95,41.8]],['C',[49.8,45.15,39.45,57.35]],['C',[39.65,73.55,39.65,74.15]],['C',[39.65,81.95,36.6,83.8]],['C',[30,81.95,28.9,72.55]],['C',[30.45,66.6,30.45,62.7]],['C',[27.55,64.95,23.85,69.85]],['C',[19.45,75.6,17.7,77.45]],['L',[17,77.45]],['C',[14.95,77.55,13.55,74.8]],['C',[12.4,72.45,12.4,70.15]],['C',[12.4,68.85,12.8,67.7]],['C',[13.55,65.25,17.1,60.15]],['C',[19.75,56.45,22.35,52.75]],['C',[23.35,51.4,28.8,42]],['L',[23.75,43.1]],['C',[18.25,42.3,15.25,37.3]],['L',[15.65,36.65]],['C',[18.05,36.15,24,32.65]],['C',[28.15,30.1,32.3,27.55]],['L',[32.3,25.9]],['C',[32.5,18.35,29.7,14.35]],['L',[30.1,13.1]],['C',[30.75,13,31.45,13]],['C',[34.3,13,38.2,14.45]],['C',[42.75,16.3,42.75,18.65]],['C',[42.75,19.35,41.95,21.4]],['C',[41.1,23.45,41.1,24.45]],['C',[41.1,25.2,41.4,25.9]],['C',[45.9,27.05,45.9,30.1]],['C',[45.9,32.9,42.55,37.15]],['C',[39.15,41.4,39.15,43.35]],['L',[39.55,45.8]],['C',[42.75,43,47.85,37.7]],['C',[56.85,28.45,58.3,27.15]],['C',[65.35,21.1,71.3,21.1]],['C',[77.95,21.1,80.95,28.9]],['C',[83.2,34.5,83.2,42.3]],['C',[83.2,58.9,81.15,67.3]],['C',[85.35,72.45,85.35,75.8]],['C',[85.35,78.05,84.2,80.1]]];
			__motifs["の"] = [['M',[42.7,32.55]],['C',[35.05,34,29.2,40.25]],['C',[23.05,46.9,23.05,54.4]],['C',[23.05,63.6,26.15,66.05]],['L',[26.45,66.05]],['C',[29.7,66.15,36.45,51.3]],['C',[42.85,37.1,42.7,32.9]],['L',[42.7,32.55]],['M',[66.45,36.2]],['C',[61.6,31.45,54.5,31.45]],['C',[52.65,31.45,50.6,31.75]],['C',[51.05,33.1,51.05,34.9]],['C',[51.05,41.2,45.8,53.25]],['C',[41.2,63.8,36.5,70.35]],['C',[31.55,77.25,25.4,79.4]],['C',[22.45,78.9,21.2,75.4]],['C',[20.3,72.3,19.55,69.25]],['C',[18.35,66.8,16.3,61.75]],['C',[15.8,59.95,15.8,57.35]],['C',[15.8,49.6,18.15,44.45]],['C',[24,31.35,37.4,25.4]],['C',[44.65,22.2,54.8,22.2]],['C',[66.6,22.2,75,30.6]],['C',[83.4,39,83.4,50.8]],['C',[83.4,62.8,76.05,72.2]],['C',[68.25,82.35,56.65,82.35]],['C',[53.5,82.35,49.6,81.45]],['C',[59,75.1,64.55,67.2]],['C',[71.3,57.85,71.3,48.05]],['C',[71.3,40.95,66.45,36.2]]];
			__motifs["は"] = [['M',[22.75,37.5]],['C',[23.95,31.35,23.95,26.75]],['C',[23.95,23.95,23.55,20.15]],['L',[24.4,19.65]],['C',[28.6,23.25,30.2,28.25]],['C',[31.25,31.95,31.25,38.7]],['C',[31.25,42.6,30.45,49.6]],['C',[29.6,57.25,29.5,60.65]],['L',[34.45,58]],['C',[32.6,63.7,31.85,67.3]],['C',[30.65,72.45,29.5,77.65]],['C',[27.45,85.85,26.05,86.65]],['C',[25.3,86.85,24.7,86.85]],['C',[17.75,86.85,17.75,69.65]],['C',[17.75,67.8,19.05,59.2]],['C',[19.45,55.5,20.5,48.15]],['C',[21.7,42.9,22.75,37.5]],['M',[51.35,73.05]],['C',[53.9,74.8,56.45,74.8]],['C',[60.75,74.8,63,71.8]],['C',[56.65,66.5,51.75,66.5]],['C',[49.1,66.5,48.35,68.75]],['C',[48.45,71.2,51.35,73.05]],['M',[83.6,83.5]],['C',[82.25,83.5,78.2,80.85]],['C',[75.7,79.1,73.05,77.35]],['C',[68.75,81.25,66.9,82.35]],['C',[63.5,84.4,59.2,84.4]],['C',[56.15,84.4,51.65,82.45]],['C',[43.15,78.7,43.15,68.25]],['C',[43.15,64.55,45.85,62]],['C',[48.55,59.4,52.35,59.4]],['C',[57.05,59.4,64.55,62]],['L',[64.95,43.1]],['C',[52.35,44.15,38.3,47.3]],['L',[37.4,46.9]],['C',[39.25,43.1,41.5,40.95]],['C',[48.05,34.8,64.95,31.15]],['L',[65.05,27.15]],['C',[65.05,23.75,60.05,19.85]],['L',[60.05,18.85]],['C',[60.25,18.75,62.5,17.3]],['C',[64.15,16.2,64.95,16.2]],['C',[67,16.2,70.9,18.35]],['C',[75.3,20.7,75.3,22.75]],['C',[75.3,22.95,74.8,30]],['C',[83.9,32.65,84.55,37.9]],['C',[83.2,40.45,75,42.1]],['C',[74.9,42.6,74.9,44.45]],['C',[74.9,46.3,75,50.05]],['C',[75.1,53.8,75.1,55.7]],['C',[75.1,61.35,74.8,64.85]],['C',[79.4,67.3,81.35,68.55]],['C',[84.75,70.9,86.8,73.65]],['C',[87.4,75.7,87.4,77.45]],['C',[87.4,83.5,83.6,83.5]]];
			__motifs["ひ"] = [['M',[82.3,56.65]],['C',[73.65,56.65,68.55,45.9]],['C',[67,56.45,65.05,62.1]],['C',[60.55,74.8,51.95,81.75]],['C',[47.35,85.45,40.55,85.45]],['C',[33,85.45,27.75,79.3]],['C',[23.05,73.85,21.9,66.05]],['C',[21.4,62.7,21.4,58.5]],['C',[21.4,45.6,29.1,34.9]],['C',[28.2,35.05,27.35,35.05]],['C',[23.55,35.05,19.8,31.35]],['C',[16.4,27.95,15.35,23.95]],['L',[15.7,23.25]],['C',[20.7,25.2,21.5,25.2]],['C',[24.7,25.2,31.5,22.4]],['C',[38.3,19.55,40.45,19.55]],['C',[42.85,19.55,46.4,21.95]],['C',[49.9,24.35,49.9,26.6]],['C',[49.9,27.55,46.5,29.9]],['C',[44.35,31.35,42.2,32.75]],['C',[40.05,34.5,38.65,36.35]],['C',[33.8,43.25,31.75,48.25]],['C',[29,54.6,29,61.75]],['C',[29,67,31.65,70.7]],['C',[34.65,74.9,39.75,74.9]],['C',[47.05,74.9,52.35,65.35]],['C',[56.15,58.6,59.45,45.4]],['C',[61.6,36.65,63.75,27.95]],['C',[65.8,21.8,67.5,21.8]],['C',[70.3,21.8,72.6,24.55]],['C',[74.9,27.35,74.9,30.2]],['C',[74.9,30.7,74.7,31.8]],['C',[74.5,32.9,74.5,33.4]],['C',[74.5,37.4,77.95,40.85]],['C',[81.05,43.55,84.2,46.2]],['C',[87.5,49.35,87.5,52.45]],['C',[87.5,56.65,82.3,56.65]]];
			__motifs["ふ"] = [['M',[30.95,71.7]],['C',[35.95,73.15,39.55,73.15]],['C',[48.45,73.15,48.45,66.5]],['C',[48.45,63.8,43.85,57.55]],['C',[39.25,51.3,39.25,46.9]],['C',[39.25,42.6,41.6,39.35]],['C',[43.45,42.6,48.85,49.6]],['C',[52.85,54.3,56.75,59]],['C',[60.65,64.25,60.65,70.5]],['C',[60.65,73.05,58.9,76.75]],['C',[55.25,84,46.7,84]],['C',[39.75,84,35.25,79.6]],['C',[31.45,75.8,30.55,72.65]],['L',[30.95,71.7]],['M',[32.4,57.75]],['C',[32.15,59.7,28.9,65.05]],['C',[26.65,68.75,24.3,72.45]],['C',[23.25,74.5,20.9,78.55]],['C',[19.35,81.05,17.95,81.85]],['C',[15.35,81.25,13.5,77.05]],['C',[11.9,73.55,11.9,70.35]],['C',[11.9,68.35,13.95,58.8]],['C',[17.5,61.15,19.25,64.65]],['L',[19.45,64.75]],['C',[21.1,64.85,26,61.85]],['C',[29.2,59.8,32.4,57.75]],['M',[56.95,35.95]],['C',[57.15,35.95,53.15,35.25]],['C',[47.05,34.3,43.55,34.4]],['L',[42.75,34]],['C',[46.8,31.35,47.45,29]],['C',[46.1,26.75,41.7,23.15]],['C',[35.95,18.35,35.25,17.7]],['L',[35.75,17.2]],['C',[37.9,16.8,40.05,16.8]],['C',[45.1,16.8,50.3,18.65]],['C',[56.05,20.8,58.95,24.45]],['C',[61.8,28.05,61.8,30.5]],['C',[61.8,35.95,56.95,35.95]],['M',[87,75.1]],['C',[85.85,77.65,84.2,77.65]],['C',[80.85,77.65,78.6,74.8]],['C',[77.35,73.15,75.6,68.9]],['C',[73.85,64.65,71.9,61.55]],['C',[68.55,56.45,63.95,51.85]],['L',[64.65,51.4]],['C',[73.25,51.75,80.25,57.05]],['C',[88.1,62.8,88.1,71.1]],['C',[88.1,72.85,87,75.1]]];
			__motifs["へ"] = [['M',[84,71.2]],['C',[79.3,71.2,70.4,63.9]],['C',[62.6,57.05,54.8,50.2]],['C',[45.7,42.9,40.65,42.9]],['C',[37,42.9,28.9,51.6]],['C',[20.8,60.35,20.1,60.35]],['C',[17.85,60.35,14.45,55.95]],['C',[11.6,52.35,10.35,49.5]],['L',[10.55,48.35]],['L',[16.3,48.35]],['C',[17.3,48.35,21.5,44.35]],['C',[27.15,38.9,29.8,36.85]],['C',[35.05,32.85,38.65,32.85]],['C',[45.6,32.85,62.7,43.25]],['C',[78.6,52.95,84.4,59.3]],['C',[87.5,62.8,88.3,67.8]],['C',[87,71.2,84,71.2]]];
			__motifs["ほ"] = [['M',[22.05,37.3]],['C',[23.25,31.05,23.25,26.6]],['C',[23.25,23.75,22.95,19.85]],['L',[23.75,19.45]],['C',[31.25,25.1,31.25,34.3]],['C',[31.25,38.9,30.1,47.4]],['C',[28.9,56.25,28.8,60.35]],['L',[33.8,57.9]],['C',[32.8,60.75,31.15,66.8]],['C',[29.5,75,29,76.65]],['C',[27.15,84.5,26,85.35]],['C',[17.1,84.6,17.1,68.85]],['C',[17.1,66.6,18.35,59]],['C',[18.75,55.4,19.8,47.95]],['C',[21,42.6,22.05,37.3]],['M',[68.55,17.9]],['C',[71.8,17.9,74.9,19.55]],['C',[78.05,21.2,79.5,23.85]],['C',[79.1,25.7,77.95,26.5]],['C',[76.35,27.45,69.25,28.65]],['C',[62.8,29.6,59.85,29.6]],['C',[49.4,29.6,46.1,24.7]],['C',[46.4,24.45,55.2,21.5]],['C',[63.95,18.55,65.25,18.25]],['C',[67.1,17.9,68.55,17.9]],['M',[49.6,72.85]],['C',[52.15,74.6,54.7,74.6]],['C',[59,74.6,61.35,71.7]],['C',[55.1,66.3,50.5,66.3]],['C',[47.45,66.3,46.7,68.55]],['C',[46.8,70.9,49.6,72.85]],['M',[81.85,83.3]],['C',[80.35,83.3,71.4,77.05]],['C',[67.4,80.75,65.15,82.05]],['C',[61.7,84.1,57.5,84.1]],['C',[53.15,84.1,48.95,81.65]],['C',[44.45,79.2,42.7,75.4]],['C',[41.5,73.05,41.5,68]],['C',[41.5,64.25,44.2,61.7]],['C',[46.9,59.1,50.5,59.1]],['C',[55.1,59.1,62.8,61.95]],['C',[63.2,59.5,63.2,56.65]],['C',[63.2,54.2,62.9,51.3]],['C',[59.4,52.05,55.75,52.85]],['C',[50.3,54,49.1,54]],['C',[46.8,54,44.9,51.75]],['C',[43.05,49.5,43.05,47.1]],['C',[43.05,43.55,45.4,40.85]],['L',[46.1,41.5]],['C',[46.5,43.35,48.15,44.15]],['C',[54.8,43.25,62.8,40.25]],['L',[62.9,36.95]],['C',[62.9,34,59.4,31.95]],['L',[59.55,31.05]],['L',[63.65,30.6]],['C',[70.2,30.6,71.8,38.2]],['L',[77.55,36.35]],['C',[84.2,37.8,84.2,41.15]],['C',[84.2,45.25,72.65,49.05]],['C',[73.45,58.2,73.15,64.55]],['C',[77.85,67.2,79.6,68.35]],['C',[83.1,70.7,85.15,73.35]],['C',[85.65,75.4,85.65,77.25]],['C',[85.65,83.3,81.85,83.3]]];
			__motifs["ま"] = [['M',[28.05,72.85]],['C',[28.15,77.95,35.45,77.95]],['C',[42.75,77.95,44.55,72.75]],['C',[39.95,70.25,34.45,70.25]],['C',[29.4,70.25,28.05,72.85]],['M',[59.65,23.05]],['C',[62.8,23.05,66.2,24.8]],['C',[70,26.85,70.6,29.6]],['C',[69.55,32.45,64.55,34.3]],['C',[60.45,35.45,56.45,36.65]],['L',[56.45,40.95]],['C',[59.75,40.05,60.45,40.05]],['C',[63.1,40.05,66.4,41.2]],['C',[70.6,42.7,70.6,44.75]],['C',[70.6,48.15,64.45,50.3]],['C',[60.05,51.75,55.65,53.15]],['L',[55.45,64.65]],['C',[63.4,66.9,64.45,67.3]],['C',[69.45,69.25,72.25,72.1]],['C',[75.3,75.2,76,77.55]],['C',[76,77.85,76,78.9]],['C',[76,83.3,72.05,83.3]],['C',[69.05,83.3,63.5,79.9]],['C',[56.85,75.8,54.7,75.2]],['C',[53.2,80.7,48.25,83.9]],['C',[43.65,86.85,37.8,86.85]],['C',[26.05,86.85,21.7,79.8]],['C',[19.75,76.75,19.75,73.85]],['C',[19.75,62.5,34.85,62.5]],['C',[39.65,62.5,45.9,63.7]],['C',[46.4,59.9,46.3,56.95]],['L',[46.3,54.8]],['C',[37.7,57.25,35.35,57.25]],['C',[32.4,57.25,29.1,53.35]],['C',[26.55,50.2,25.1,46.7]],['L',[25.3,46.2]],['C',[28.5,47.1,31.85,47.1]],['C',[35.75,47.1,46.3,43.2]],['L',[46.3,38.2]],['L',[45,38.3]],['C',[40.8,38.4,36.5,36.55]],['C',[34.75,35.65,32.25,34]],['C',[29.2,31.95,28.6,30.75]],['L',[28.15,29.7]],['C',[40.55,27.95,46.7,25.1]],['L',[46.4,19.05]],['C',[44.65,16.5,42.3,15.55]],['L',[42.3,14.55]],['C',[46.8,11.85,47.55,11.85]],['C',[49.3,11.85,52.55,13.35]],['C',[55.75,14.85,56.65,16.3]],['C',[56.85,16.7,56.95,18.85]],['L',[57.25,23.25]],['C',[58.5,23.05,59.65,23.05]]];
			__motifs["み"] = [['M',[34,59.1]],['L',[33.6,59.1]],['C',[30.55,59,26.85,61.35]],['C',[22.75,63.8,22.75,66.7]],['C',[22.75,69.55,24.6,69.55]],['C',[25.7,69.55,27.75,68.25]],['C',[29.8,66.9,31.35,64.1]],['C',[32.7,61.65,34,59.1]],['M',[85.55,77.85]],['C',[83.2,77.85,78.7,75]],['C',[75.4,72.85,72.15,70.7]],['C',[64.75,86.35,51.45,86.35]],['L',[50.3,85.85]],['C',[59,76,62.6,66.05]],['C',[53.6,62,43.95,61.25]],['C',[37.9,70.7,35.35,73.55]],['C',[29.9,79.8,23.15,81.95]],['C',[20.9,81.05,19.8,78.15]],['C',[18.95,75.7,18.05,73.15]],['C',[17.1,71.5,16.1,69.7]],['C',[15.15,67.9,15.15,65.85]],['C',[15.15,62.3,18.75,59.1]],['C',[26,52.55,37.7,51.85]],['C',[43.15,39.35,45.4,31.15]],['C',[43.15,31.95,38.95,33.6]],['C',[35.35,32.65,31.65,29.45]],['C',[27.95,26.3,26.75,22.95]],['L',[27.25,22.1]],['L',[34.1,24.15]],['C',[40.45,22.45,50.8,16.4]],['C',[54,16.7,58.2,18.25]],['C',[63.3,20.25,64.05,22.4]],['C',[63.1,23.95,60.65,26.6]],['C',[58.2,29.2,57.25,30.75]],['C',[53.2,37.1,46.6,52.55]],['C',[56.35,53.45,65.45,56.55]],['C',[67.75,51.3,69.15,44.35]],['C',[68.25,42.8,65.65,41.3]],['L',[65.45,40.55]],['C',[66.5,40.25,68.6,38.65]],['C',[70.7,37,71.3,37]],['C',[71.6,37,71.95,37.2]],['C',[73.85,37.4,77.4,39.85]],['C',[80.95,42.3,80.95,43.85]],['C',[80.95,45.25,78.6,51.5]],['C',[76,58.4,75.6,59.8]],['C',[82.3,63.3,84.45,65.05]],['C',[89.05,68.85,89.05,73.85]],['C',[89.05,77.85,85.55,77.85]]];
			__motifs["む"] = [['M',[24.9,60.35]],['C',[21,63.9,20.8,68.35]],['C',[21.9,69.85,23.75,69.85]],['C',[25.4,69.85,28.2,67.8]],['C',[32.8,64.55,33.1,56.05]],['C',[28.3,57.35,24.9,60.35]],['M',[46.25,21.85]],['C',[44.9,25.2,44.9,27.15]],['C',[44.9,27.75,45,28.45]],['C',[47.15,27.95,49.2,27.95]],['C',[56.65,27.95,59.1,32.55]],['C',[59.1,35.65,56.55,37]],['C',[54.7,38,49.7,39.65]],['C',[45.1,41.2,42.85,42.7]],['L',[42,48.55]],['C',[44.8,50.6,44.8,56.55]],['C',[44.8,59,42.1,63.8]],['C',[39.35,68.55,39.35,70.4]],['C',[39.35,77.75,47.45,77.75]],['C',[55.65,77.75,61.05,68.45]],['C',[63.75,63.8,67.3,52.05]],['L',[67.95,51.75]],['C',[70.7,57.05,70.7,62.3]],['C',[70.7,74.35,63.95,81.95]],['C',[59.3,87.3,49.7,87.3]],['C',[43.55,87.3,38.5,84.3]],['C',[33.1,81.05,31.45,75.5]],['C',[27.25,78.35,22.65,78.35]],['C',[18.75,78.35,16.2,75.45]],['C',[13.65,72.55,13.65,68.55]],['C',[13.65,54.9,32.7,47.2]],['L',[32.9,44.25]],['C',[31.65,44.45,28.9,45.6]],['C',[26.15,46.8,24.6,46.9]],['C',[17.4,44.65,12,38]],['C',[13.5,37.8,16.5,37.5]],['C',[27.15,36.45,35.25,32.15]],['C',[35.75,27.95,36.25,19.45]],['C',[35.05,17.1,32.3,16.3]],['L',[31.95,15.25]],['C',[33.7,13.9,38.1,11.95]],['C',[47.55,14.55,47.55,17.8]],['C',[47.55,18.45,46.25,21.85]],['M',[84.45,53.7]],['C',[80.85,53.7,77.65,49.5]],['C',[76.15,47.65,72.65,40.95]],['C',[69.75,35.35,67.6,33.7]],['L',[67.2,32.85]],['C',[75.1,33.6,80.85,37.1]],['C',[88,41.5,88,48.65]],['C',[88,53.7,84.45,53.7]]];
			__motifs["め"] = [['M',[38.1,48.15]],['L',[38.75,52.05]],['C',[40.65,49.5,42,45.7]],['L',[38.1,48.15]],['M',[32.15,61.65]],['C',[30.35,57.55,29.3,51.65]],['C',[21.8,58.3,21.8,62]],['C',[21.8,63.8,22.65,65.25]],['C',[23.65,67.1,25.3,67.1]],['C',[27.35,67.1,32.15,61.65]],['M',[81.35,69.45]],['C',[80.75,70.4,78.05,73.75]],['C',[72.25,80.5,61.7,80.5]],['C',[59,80.5,57.4,80.3]],['C',[66.5,72.3,69.75,67.6]],['C',[74.8,60.25,74.8,50.9]],['C',[74.8,45.8,71.1,42.9]],['C',[67.75,40.15,62.5,40.15]],['C',[57.8,40.15,53.8,42.2]],['C',[49.7,48.95,41.3,62.2]],['C',[41.4,63.4,42.4,66.8]],['C',[43.15,69.75,43.15,71.5]],['C',[43.15,77.25,39.65,77.15]],['C',[35.75,75.1,33.8,71]],['C',[33.1,71.4,28.6,75.4]],['C',[25,78.65,23.25,78.55]],['L',[22.75,78.45]],['C',[20.7,77.45,19.8,75.75]],['C',[18.95,74.05,17.95,72.3]],['C',[16.6,70.35,15.35,68.45]],['C',[14.05,66.6,14.05,63.7]],['C',[14.05,52.95,28.15,44.15]],['C',[26.55,38.9,26.55,32.05]],['L',[26.55,28.05]],['L',[27.25,26.95]],['C',[32.9,32.55,35.25,39.35]],['C',[42.2,36.05,47.85,33.5]],['C',[48.75,31.85,50.4,28.65]],['C',[51.05,27.05,52.45,24.25]],['L',[52.55,24.05]],['C',[52.55,21.3,48.35,18]],['L',[48.15,17]],['L',[48.85,17]],['C',[50,17,52.25,16.45]],['C',[54.5,15.95,55.55,15.95]],['C',[57.8,15.95,61.45,18.5]],['C',[65.15,21.1,65.15,23.15]],['C',[65.15,24.05,63,27.2]],['C',[60.85,30.4,60.65,31.55]],['L',[61.9,31.55]],['C',[72.05,31.35,78.7,37]],['C',[85.65,43,85.65,53.25]],['C',[85.65,61.35,81.35,69.45]]];
			__motifs["も"] = [['M',[42.3,14.65]],['L',[42.3,13.8]],['C',[43.15,13.6,45.5,12.4]],['C',[47.55,11.35,48.85,11.35]],['C',[50.2,11.35,53.15,13.7]],['C',[56.05,16.05,56.05,17.3]],['C',[56.05,17.4,54.05,22.3]],['C',[52.05,27.15,51.75,28.25]],['L',[56.95,27.05]],['C',[60.55,27.05,63.4,28.15]],['C',[67.1,29.7,67,32.75]],['L',[67,33.4]],['C',[64.35,37,58.4,39.35]],['C',[53.4,41.2,48.45,43.1]],['C',[47.55,45.9,46.1,51.75]],['L',[52.75,48.85]],['L',[54.3,48.85]],['C',[64.55,48.65,64.55,53.7]],['C',[64.55,57.75,56.55,60.85]],['C',[50.8,63,45.1,65.15]],['C',[45.2,70.5,47.35,73.75]],['C',[50,77.55,54.1,77.55]],['C',[59.75,77.55,63.75,74.15]],['C',[68.85,69.75,70.2,58.7]],['C',[70.8,53.9,70.7,41.2]],['C',[74.2,44.05,76.45,51]],['C',[78.5,57.05,78.5,62.4]],['C',[78.5,72.2,73.15,80.2]],['C',[67,89.1,57.6,89.1]],['C',[49,89.1,42.7,82.55]],['C',[36.8,76.3,35.95,67.5]],['L',[29.8,69.15]],['C',[28.05,69.65,23.85,64.85]],['C',[20.2,60.85,18.85,58.3]],['L',[19.65,58.1]],['C',[21.8,58.8,24.1,58.8]],['C',[27.95,58.8,36.6,55]],['C',[37.9,48.95,39.35,43.95]],['C',[35.05,43.55,31.35,40.15]],['C',[28.15,37.1,26.35,32.75]],['L',[27.35,32.65]],['C',[27.75,32.65,28.75,32.8]],['C',[29.8,32.9,30.25,32.9]],['C',[32.9,32.9,41.3,30.95]],['C',[44.35,22.95,44.35,19.95]],['C',[44.35,16.8,42.3,14.65]]];
			__motifs["や"] = [['M',[34.1,27.85]],['C',[33.5,27.85,32.9,28.15]],['C',[32.8,28.65,32.8,29.1]],['C',[32.8,32.25,37.7,39]],['C',[41.4,37.4,45.9,35.55]],['C',[43.55,34.9,39.15,31.15]],['C',[34.95,27.85,34.1,27.85]],['M',[47.65,16.8]],['C',[51.75,16.8,55.35,19.05]],['C',[59.45,21.7,60.05,25.5]],['C',[60.45,27.35,60.15,30.2]],['C',[65.65,29,69.05,29]],['C',[75.7,29,80.2,32.55]],['C',[85.05,36.35,85.05,42.8]],['C',[85.05,49.9,80.45,54.95]],['C',[75.9,59.95,68.75,59.95]],['C',[61.45,59.95,53.15,52.25]],['L',[52.65,51.2]],['C',[56.95,51.75,60.05,51.75]],['C',[64.75,51.75,68.65,49.7]],['C',[73.45,47.2,73.45,42.9]],['C',[73.45,40.95,71.8,39.25]],['C',[69.8,38.3,67.7,38.3]],['C',[63.55,38.3,54.6,42.4]],['C',[46.95,45.9,42,49.15]],['C',[44.15,53.8,48.25,60.15]],['C',[51.65,65.55,55.1,70.8]],['C',[57.6,74.8,57.6,78.7]],['C',[57.6,81.45,56.95,83.9]],['C',[55.95,87.4,54,87.4]],['C',[51.55,87.4,47.75,82.65]],['C',[43.55,77.35,39.35,68]],['C',[36.15,60.15,32.9,52.25]],['C',[30.75,52.75,27.45,54.9]],['C',[24.1,57.05,22.95,57.35]],['C',[20.2,56.65,16.5,53.7]],['C',[13.2,50.9,11.35,48.35]],['L',[12.6,47.85]],['L',[13.5,47.85]],['C',[20.2,48.05,30.55,42]],['C',[28.9,39.35,27.5,34.6]],['C',[26.05,29.8,26.05,26.75]],['C',[26.05,24.25,27.5,22.5]],['C',[28.9,20.8,31.35,20.8]],['C',[33.7,20.8,38.2,22.55]],['C',[41.5,24.05,44.9,25.5]],['C',[47.25,26.3,49.9,26.95]],['C',[51.55,26.5,51.55,25]],['C',[51.55,22.3,46.7,17]],['L',[47.65,16.8]]];
			__motifs["ゆ"] = [['M',[72.55,35.75]],['C',[69.65,33.3,64.45,33.4]],['L',[63,33.5]],['C',[62.8,36.35,62.8,40.05]],['L',[62.8,48.35]],['C',[62.7,54,62.2,57.9]],['C',[62.9,58,63.55,58]],['C',[69.15,58,72.65,53.55]],['C',[75.9,49.35,75.9,43.55]],['C',[75.9,38.4,72.55,35.75]],['M',[86.05,45.15]],['C',[86.05,51.4,83.7,56.55]],['C',[80.75,63,74.7,65.75]],['C',[70.1,67.8,61.8,68.45]],['C',[59.95,76.75,55.2,81.45]],['C',[49.8,86.65,41.7,86.45]],['C',[46.1,80.85,48.15,77.45]],['C',[51.95,71.3,52.15,67.4]],['C',[43.25,61.95,41.6,55.7]],['L',[41.7,54.9]],['C',[46.3,57.65,50.7,57.65]],['C',[51.55,57.65,52.45,57.55]],['C',[52.95,49.9,52.95,41.8]],['C',[52.95,38.9,52.85,36.25]],['C',[45.9,38.4,41.5,43.65]],['C',[38.1,47.75,35.25,55]],['C',[32.9,61.45,30.45,67.9]],['C',[29.2,71.1,26.85,75.6]],['C',[26,76.1,25.1,76.1]],['C',[21.95,76.1,19.55,72.2]],['C',[17.3,68.75,17.3,65.45]],['C',[17.3,63.5,18.05,57.9]],['C',[20.6,39.55,20.6,35.75]],['C',[20.6,32.25,19.9,25.9]],['L',[20.2,24.9]],['C',[24.2,26.5,26.85,29.6]],['C',[29.8,33.1,29.8,37]],['C',[29.8,37.8,29.7,38.6]],['L',[26.55,62.3]],['C',[34.3,35.15,53.15,26.85]],['L',[53.15,23.95]],['C',[53.15,20.35,47.85,19.05]],['L',[47.45,18.45]],['C',[47.55,18.35,49.9,15.65]],['C',[51.35,13.8,52.75,13.8]],['C',[55.75,13.8,58.8,15.15]],['C',[62.4,16.8,63.1,19.35]],['C',[63.55,21.5,63.3,25.1]],['C',[69.05,25.4,72.25,26.1]],['C',[78.9,27.55,82.6,33]],['C',[86.05,38.1,86.05,45.15]]];
			__motifs["よ"] = [['M',[28.05,66.35]],['C',[26.55,67.3,26.55,68.95]],['C',[26.55,71.3,30.45,73.65]],['C',[34,75.8,36.6,75.8]],['C',[39.55,75.8,42.15,73.95]],['C',[44.75,72.1,45.4,69.35]],['C',[38,65.45,31.15,65.45]],['C',[29.5,65.45,28.05,66.35]],['M',[44.75,15.15]],['C',[47.65,15.15,51.35,17.2]],['C',[55.55,19.35,55.55,22]],['C',[54.1,25,54.1,32.45]],['C',[54.1,33.8,54.2,35.35]],['C',[56.45,35.35,60.55,33.45]],['C',[64.65,31.55,66.9,31.55]],['C',[70.3,31.55,73.05,33.2]],['C',[76.15,35.15,76.15,38.4]],['C',[74.9,41.7,68.25,44.75]],['C',[62.2,47.4,58.1,47.4]],['C',[56.25,47.4,54.2,47.1]],['C',[54.4,56.25,54.8,62.2]],['C',[62.1,64.65,68.05,68]],['C',[77.25,73.15,77.25,77.65]],['C',[77.25,79.4,75.4,80.6]],['C',[73.55,81.75,71.6,81.75]],['C',[68.55,81.75,54.1,73.15]],['C',[51.85,79.7,48.55,82.45]],['C',[44.8,85.45,38.1,85.45]],['C',[30.35,85.45,24.9,80.7]],['C',[19.45,75.9,19.45,68.35]],['C',[19.45,62.6,22.25,60.25]],['C',[25.1,57.9,30.95,57.9]],['C',[36.35,57.9,45.7,60.65]],['L',[45.5,43.25]],['C',[41.5,41.15,39.85,39]],['C',[42.7,38.2,44.8,37]],['L',[44.8,33.3]],['C',[44.9,29.3,44.45,25.5]],['C',[44.25,22.85,42.7,21.6]],['C',[41.7,20.7,38.75,19.75]],['L',[38.3,18.95]],['C',[39.85,17.8,41.3,16.5]],['C',[43.25,15.15,44.75,15.15]]];
			__motifs["わ"] = [['M',[83.7,69.45]],['C',[76.45,80.1,57.7,80.1]],['C',[52.25,80.1,50.4,78.65]],['C',[56.45,76.6,63.55,72.1]],['C',[70.6,67.6,73.95,62.8]],['C',[77.75,57.15,77.75,49.35]],['C',[77.75,45.4,75.4,43]],['C',[73.05,40.55,69.05,40.55]],['C',[64.15,40.55,57.3,43.85]],['C',[51.45,46.8,47.05,50.7]],['C',[43.15,54,38.95,60.05]],['L',[39.55,75.9]],['C',[39.65,78.65,38.75,81.55]],['C',[37.5,85.25,35.45,85.75]],['C',[33.1,84.95,31.55,81.85]],['C',[30.2,79.1,30.2,76.3]],['C',[30.2,74.8,30.45,71.8]],['C',[30.75,68.75,30.75,67.2]],['C',[29.6,68.2,24.8,73.65]],['C',[20.6,78.55,19.65,78.8]],['C',[16.4,77.95,16.4,69.55]],['C',[16.4,68.25,16.65,67.35]],['C',[16.9,66.4,23,58.25]],['C',[29.1,50.1,31.85,43.25]],['C',[29,43.85,26.15,46.7]],['C',[23.85,46.5,20.8,43.95]],['C',[17.95,41.7,16.6,39.35]],['L',[17.1,38.7]],['C',[25.1,36.85,33.4,31.35]],['C',[33.8,27.95,33.8,25.1]],['C',[33.8,23.45,33.7,22]],['L',[30.45,19.25]],['L',[30.35,18.1]],['C',[31.25,17.8,33.8,15.65]],['C',[36.05,13.7,36.8,13.7]],['C',[38.2,13.7,40.9,15.25]],['C',[43.35,16.7,44.75,17.9]],['C',[44.55,18.65,42.95,22]],['C',[42,24.25,42,26.75]],['C',[42,27.75,42.1,28.8]],['C',[47.75,29.1,47.75,33.3]],['C',[47.75,34.5,47.45,35.1]],['C',[47.15,35.75,44.2,38.3]],['C',[41.2,40.85,40.35,42.2]],['L',[40.35,47.1]],['C',[58,32.9,69.75,32.9]],['C',[78.2,32.9,83.6,40.15]],['C',[88.55,46.7,88.55,55.4]],['C',[88.55,62.3,83.7,69.45]]];
			__motifs["を"] = [['M',[43.85,11.45]],['L',[44.25,11.45]],['C',[44.9,11.45,46.25,11.1]],['C',[47.55,10.75,48.25,10.75]],['C',[48.55,10.75,48.95,10.95]],['C',[51.65,10.95,54.35,12.65]],['C',[57.05,14.35,56.85,16.9]],['L',[56.85,17.4]],['C',[55.55,19.25,53.6,23.15]],['C',[57.8,21.1,61.05,21.1]],['C',[64.85,21.1,67.75,24.9]],['L',[67.75,27.75]],['C',[66.1,29.2,58.9,31.55]],['C',[53.15,33.3,48.95,34.2]],['C',[42.85,39,40.55,42.3]],['C',[42,42.1,43.35,42.1]],['C',[51.95,42.1,53.9,49.25]],['C',[58.5,46.2,67.95,41.15]],['C',[70.7,41.15,74.6,42.9]],['C',[79.1,44.85,79.1,47.1]],['C',[76.05,50.5,67.2,53.55]],['C',[57.5,56.85,54.6,59.2]],['C',[53.9,62.3,53.2,65.35]],['C',[52.15,69.75,49.5,69.75]],['C',[45.9,69.75,45.6,63.5]],['C',[35.65,68.75,35.65,74.35]],['C',[35.65,75.7,37.1,76.55]],['C',[38.55,77.35,40.15,77.35]],['C',[45.9,77.35,53.4,74.25]],['C',[54.4,73.85,56.25,73.25]],['C',[60.25,73.75,64.35,74.35]],['C',[69.75,75.5,69.75,79.3]],['C',[69.75,83.9,60.95,86.45]],['C',[54.7,88.2,48.45,88.2]],['C',[29.3,88.2,29.3,76.85]],['C',[29.3,65.25,43.85,55]],['C',[43.95,53.9,43.95,53.05]],['C',[43.95,49.05,41.3,49.05]],['C',[38.1,49.05,26.25,55.2]],['C',[25,54.6,24.5,53]],['C',[24,51.4,23.65,49.9]],['C',[23.85,48.15,27.95,43.65]],['C',[30.65,40.75,33.5,37.7]],['C',[27.95,36.85,21.8,29.2]],['L',[22.55,28.55]],['C',[24.4,28.8,26.45,28.8]],['C',[31.55,28.8,40.8,26.5]],['C',[42.1,25,44.55,20.8]],['C',[46.95,16.6,47.35,16.2]],['C',[46.9,14.25,43.65,11.95]],['L',[43.85,11.45]]];
			__motifs["ん"] = [['M',[87.2,44.65]],['C',[87.2,67.2,75.3,77.85]],['C',[72.65,80.2,68.4,81.65]],['C',[64.15,83.1,60.55,83.1]],['C',[52.65,83.1,48.45,78.05]],['C',[44.65,73.25,44.65,65.25]],['C',[44.65,61.95,45.2,57.65]],['C',[44.9,56.95,44.35,56.95]],['C',[39.05,56.95,27.35,73.85]],['C',[24.6,77.85,20.3,82.15]],['C',[19.8,82.25,19.45,82.25]],['C',[17.1,82.25,16.4,78.8]],['C',[16.1,77.45,16.1,73.55]],['C',[16.1,72.65,16.2,71.6]],['C',[18.45,68.35,28.5,52.15]],['C',[35.05,41.4,48.25,19.85]],['L',[45.8,16.2]],['L',[46.3,15.45]],['C',[46.9,15.65,47.35,15.65]],['C',[48.35,15.65,50.2,15]],['C',[52.05,14.35,53.05,14.35]],['C',[56.15,15.35,59.4,16.5]],['C',[62.6,17.7,64.05,21]],['L',[63.75,23.05]],['C',[58.6,25.6,51.65,34.5]],['C',[46.7,41.6,41.7,48.65]],['L',[49.2,45.6]],['C',[52.65,46.3,56.15,46.9]],['C',[60.85,48.15,60.85,51]],['C',[60.85,52.25,58.9,53.35]],['L',[55.95,55]],['C',[51.85,58.5,51.85,65.95]],['C',[51.85,68.55,53.4,70.45]],['C',[55,72.4,57.6,72.4]],['C',[60.25,72.4,64.35,69.95]],['C',[70.7,66.2,77.45,57.25]],['C',[83.2,49.5,86.9,41.4]],['C',[87.2,42.1,87.2,44.65]]];
		}

		static private function initializeWidths():void {
			__widths["あ"] = 100;
			__widths["い"] = 100;
			__widths["う"] = 100;
			__widths["え"] = 100;
			__widths["お"] = 100;
			__widths["か"] = 100;
			__widths["き"] = 100;
			__widths["く"] = 100;
			__widths["け"] = 100;
			__widths["こ"] = 100;
			__widths["さ"] = 100;
			__widths["し"] = 100;
			__widths["す"] = 100;
			__widths["せ"] = 100;
			__widths["そ"] = 100;
			__widths["た"] = 100;
			__widths["ち"] = 100;
			__widths["つ"] = 100;
			__widths["て"] = 100;
			__widths["と"] = 100;
			__widths["な"] = 100;
			__widths["に"] = 100;
			__widths["ぬ"] = 100;
			__widths["ね"] = 100;
			__widths["の"] = 100;
			__widths["は"] = 100;
			__widths["ひ"] = 100;
			__widths["ふ"] = 100;
			__widths["へ"] = 100;
			__widths["ほ"] = 100;
			__widths["ま"] = 100;
			__widths["み"] = 100;
			__widths["む"] = 100;
			__widths["め"] = 100;
			__widths["も"] = 100;
			__widths["や"] = 100;
			__widths["ゆ"] = 100;
			__widths["よ"] = 100;
			__widths["わ"] = 100;
			__widths["を"] = 100;
			__widths["ん"] = 100;
		}

	}



	