/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4FHr
 */


package {
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
    	
    		private var _ball:Sprite;
    		private var _moveBall:Sprite;
    		private var _dropBall:Sprite;
    		private var _mouseTracerBall:Sprite;
    		
        public function FlashTest() {
        		//止まっているボール
            _ball = new BallSprite(0x0000ff);
            addChild(_ball);
            
            //移動するボール（不変速）
            _moveBall = new MoveBallSprite(0x00ff00);
            addChild(_moveBall);
            
            //落下するボール
           　_dropBall = new DropBallSprite(0xff0000);
           addChild(_dropBall);
           
           //マウスについていくボール
           _mouseTracerBall = new MouseTracerBallSprite(0x00ffff);
           addChild(_mouseTracerBall);
        }
    }
}

import flash.display.*;
import flash.events.*;

class BallSprite extends Sprite {
	public function BallSprite(color:uint) {
		super();
		
		graphics.beginFill(color);
		graphics.drawCircle(0,0,10);
		graphics.endFill();
	}
}


class MoveBallSprite extends BallSprite {
	public var velocityX:Number = 4;
	public var velocityY:Number = 1;
	public function MoveBallSprite(color:uint) {
		super(color);
		addEventListener(Event.ENTER_FRAME, updatePosition);
	}
	
	private function updatePosition(e:Event):void {
		x += velocityX;
		y += velocityY;
	}
}


class DropBallSprite extends MoveBallSprite {
	public var gravity:Number = 0.6;
	public function DropBallSprite(color:uint) {
		super(color);
		addEventListener(Event.ENTER_FRAME, updateVelocity);
	}
	
	private function updateVelocity(e:Event):void {
		velocityY += gravity;
	}
}


class MouseTracerBallSprite extends DropBallSprite {
	public function MouseTracerBallSprite(color:uint) {
		super(color);
		addEventListener(Event.ENTER_FRAME, updateVelocity);
	}
	
	private function updateVelocity(e:Event):void {
		//velocityX = mouseX * 0.1;
		//velocityY = mouseY * 0.1;
		
		velocityX = ( root.mouseX - x ) * 0.1;
		velocityY = ( root.mouseY - y ) * 0.1;
	}
} 
	