/**
 * Copyright mirkofresa ( http://wonderfl.net/user/mirkofresa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4FG8
 */

// forked from mirkofresa's forked from: SiON Tenorion
// forked from keim_at_Si's SiON Tenorion
// SiON TENORION for v0.57
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.TextField;
    import org.si.sion.*;
    import org.si.sion.events.*;
    import org.si.sion.utils.SiONPresetVoice;
    
    [SWF(backgroundColor="#ffffff")]
    public class Tenorion extends Sprite {
        // driver
        public var driver:SiONDriver = new SiONDriver();
        
        // preset voice
        public var presetVoice:SiONPresetVoice = new SiONPresetVoice();
        
        // voices, notes and tracks
        public var voices:Vector.<SiONVoice> = new Vector.<SiONVoice>(16);
        public var notes :Vector.<int> = Vector.<int>([36,48,60,72, 43]);
        public var length:Vector.<int> = Vector.<int>([ 1, 1, 1, 1,  1]);
        
        // beat counter
        public var beatCounter:int;
        
        // control pad
        public var matrixPad:MatrixPad;
        
        // constructor
        function Tenorion() {
            var i:int;
            
            // set voices from preset
            var percusVoices:Array = presetVoice["valsound.percus"];
          
	  voices[1] = percusVoices[0];  // bass drum
            voices[2] = percusVoices[27]; // snare drum
            voices[3] = percusVoices[16]; // close hihat
            voices[4] = percusVoices[22]; // open hihat
            // listen
            driver.setBeatCallbackInterval(1);
            driver.addEventListener(SiONTrackEvent.BEAT, _onBeat);
            driver.setTimerInterruption(1, _onTimerInterruption);
            
            // control pad
            with(addChild(matrixPad = new MatrixPad(stage))) {
                x = y =  0;
            }

            // start streaming
            beatCounter = 0;
            driver.play();
        }
        
        
        // _onBeat (SiONTrackEvent.BEAT) is called back in each beat at the sound timing.
        private function _onBeat(e:SiONTrackEvent) : void 
        {
            matrixPad.beat(e.eventTriggerID & 15);
        }
        
        
        // _onTimerInterruption (SiONDriver.setTimerInterruption) is called back in each beat at the buffering timing.
        private function _onTimerInterruption() : void
        {
            var beatIndex:int = beatCounter & 15;
            for (var i:int=0; i<16;  i++) {
                if (matrixPad.sequences[i] & (1<<beatIndex)) driver.noteOn(notes[i], voices[i], length[i]);
            }
            beatCounter++;
        }
    }
}



import flash.display.*;
import flash.events.*;
import flash.geom.*;

class MatrixPad extends Bitmap {
    public var sequences:Vector.<int> = new Vector.<int>(16);
    private var canvas:Shape = new Shape();
    private var buffer:BitmapData = new BitmapData(576, 120, true, 0);
    private var padOn:BitmapData  = _pad(0x4b7322, 0x4b7322);
    private var padOff:BitmapData = _pad(0xcccccc,0XFFFFfF);
    private var pt:Point = new Point();
    private var colt:ColorTransform = new ColorTransform(1,1,1,0.1)
    
    
    function MatrixPad(stage:Stage) {
        super(new BitmapData(576, 120, false, 0));
        var i:int;
        for (i=0; i<96; i++) {
            pt.x = (i&15)*36;
            pt.y = (i&240)*1.25;
            buffer.copyPixels(padOff, padOff.rect, pt);
            bitmapData.copyPixels(padOff, padOff.rect, pt);
        }
        for (i=0; i<16; i++) sequences[i] = 0;
        addEventListener("enterFrame", _onEnterFrame);
        stage.addEventListener("click",  _onClick);
    }
    
    
    private function _pad(border:int, face:int) : BitmapData {
        var pix:BitmapData = new BitmapData(36, 20, false, 0);
        canvas.graphics.clear();
        canvas.graphics.lineStyle(1, border);
        canvas.graphics.beginFill(face);
        canvas.graphics.drawRect(0, 0, 36,20);
        canvas.graphics.endFill();
        pix.draw(canvas);
        return pix;
    }
    
    
    private function _onEnterFrame(e:Event) : void {
        bitmapData.draw(buffer, null, colt);
    }
    
    
    private function _onClick(e:Event) : void {
        if (mouseX>=0 && mouseX<576 && mouseY>=0 && mouseY<120) {
            var track:int = 15-int(mouseY*0.05), beat:int = int(mouseX*0.027);
            sequences[track] ^= 1<<beat;
            pt.x = beat*36;
            pt.y = (15-track)*20;
            if (sequences[track] & (1<<beat)) buffer.copyPixels(padOn, padOn.rect, pt);
            else buffer.copyPixels(padOff, padOff.rect, pt);
        }
    }
    
    
    public function beat(beat16th:int) : void {
        for (pt.x=beat16th*36, pt.y=0; pt.y<120; pt.y+=20) bitmapData.copyPixels(padOn, padOn.rect, pt);
    }
}
