/**
 * Copyright _perfect ( http://wonderfl.net/user/_perfect )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4F52
 */

// forked from _azzip's 動体検知てきなのとSiON
/**
 * 
 * 秋だし、なんとなく動体検知がやってみたくて、せっかくだからSiONもやって見ようかと思い、せっかくだからJAMのやつにチャレンジ
 *
 * 最初が　ガ－－！ってうるさいんですけど、時間がたてばじゃっかんいい感じに。なると思います。
 *  
 * 最初に 準備中... ってでるのは、まあいろいろあってああなってます、、
 * 
 * 結果的によくわかんない感じで終わったんですが、カメラの前でゴニョゴニョしてもらうと明るくなったところで音がなります。
 * 
 * なんかmacとwinでぜんぜん違うっぽいです。
 * 
 * あんま動き回ってると重くなって動かなくなるんで、注意が必要です。。
 * 
 * 
 * ■動体検知的なのはwonderfl本を参考にしました
 * 
 * ■SiONはいろいろな先人の方々のソースを参考にしました
 * 
 * 
 */

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.text.*;
    import flash.utils.*;
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.easing.*;
    import org.si.sion.*;
    import org.si.sion.events.*;
    import org.si.sion.utils.*;
    
    /**
     * ...
     * @author _azzip.azzip | hirofumi kaneko
     */
    public class Main extends Sprite 
    {
        private const _W:Number = 465;
        private const _H:Number = 465;
        private var _canvasBmd:BitmapData;
        private var _canvas:Bitmap;
        private var _point:Point;
        private var _matrix:Matrix;
        private var _camera:Camera;
        private var _video:Video;
        
        private var _perlinNoise:PerlinNoiseGenerateC;
        private var _nowBmd:BitmapData;
        private var _prevBmd:BitmapData;
        private var _eraseBmd:BitmapData;
        
        
        private var _b:BallBright;
        private const _LEN:uint = 8;        
        private var _beatCount:uint = 0;
        
        private var _pianoVoice:SiONVoice;
        private var _sionDriber:SiONDriver;
        private var _sionData:SiONData;        
        private var _presetVoice:SiONPresetVoice = new SiONPresetVoice();
        private var _note:Vector.<int> = Vector.<int>([ 70 , 67 , 65 , 60 ,  55 , 53 , 48, 45 ]);
        private var _BallList:Array = [];
        
        private var _isSetup:Boolean = false;
        private var _tf:TextField;
        
        
        public function Main() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * init
         */
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);            
            stage.align = "TL";
            stage.scaleMode = "noScale";
            
            
            //camera
            _camera = Camera.getCamera();
            _camera.setMode(_W, _H, 30);
            
            _video = new Video(_W, _H);
            _video.attachCamera(_camera);
            
            
            //canvas
            _canvasBmd = new BitmapData(_W, _H,true,0x000000);
            _canvas = addChild(new Bitmap(_canvasBmd)) as Bitmap;
            
            
            //動体検知用のBitmapData
            _nowBmd = new BitmapData(_W, _H);
            _prevBmd = new BitmapData(_W, _H);
            _eraseBmd = new BitmapData(_W, _H);
            
            
            _perlinNoise = new PerlinNoiseGenerateC(new BitmapData(100, 100));
            var _maskBmp:Bitmap = addChild(new Bitmap(_perlinNoise.bmd)) as Bitmap;
            _maskBmp.width = _W;
            _maskBmp.height = _H;
            
            
            var _sp:Sprite = new Sprite();
            var _g:Graphics = _sp.graphics;
            _g.beginFill(0x000000);
            _g.drawRect(0, 0, _maskBmp.width, _maskBmp.height);
            addChild(_sp);
            _sp.cacheAsBitmap = true;
            
            var _erase:Bitmap = _sp.addChild(new Bitmap(_eraseBmd)) as Bitmap;
            
            
            
            _point = new Point();
            
            _matrix = new Matrix();
            _matrix.scale( -1, 1);
            _matrix.translate(_W, 0);
            
            //enterFrame
            addEventListener(Event.ENTER_FRAME, enterFrameHandler, false, 0, true);
            
            
            _tf = new TextField();
            var _fmt:TextFormat = new TextFormat("Arial", 12, 0x333333);
            _tf.defaultTextFormat = _fmt;
            _tf.text = "準備中...";
            _tf.autoSize = TextFieldAutoSize.LEFT;
            _tf.x = (_W - _tf.width) / 2;
            _tf.y = (_H - _tf.height) / 2;
            addChild(_tf);
            
            //最初の準備中のタイマー、、　無理やり背景が黒くなるの待ち、、、
            var _timer:Timer = new Timer(12000, 1);
            _timer.addEventListener(TimerEvent.TIMER, timerHandler);
            _timer.start();
        }
        
        private function timerHandler(e:TimerEvent):void 
        {
            addEventListener(MouseEvent.MOUSE_DOWN, mouseEventHandler, false, 0, true);
            _tf.text = "click start.";
            _tf.textColor = 0xFFFFFF;
            var _timer:Timer = e.target as Timer;
            _timer.removeEventListener(TimerEvent.TIMER, timerHandler);
            _timer.stop();
            _timer = null;
            //sionSetup();
        }
        
        private function mouseEventHandler(e:MouseEvent):void 
        {
            removeChild(_tf);
            _tf = null;
            
            sionSetup();            
        }
        
        
        private function sionSetup():void
        {
            _isSetup = true;
            
            //Ball
            for (var i: int = 0; i < _LEN; i++) 
            {
                _BallList[i] = [];
                        
                for (var j: int = 0; j < _LEN; j++) 
                {
                    _b = new BallBright();
                    _b.filters = [ new BlurFilter(2, 2, 2) ];
                    
                    _b.x = j * (_b.width + 15)+35;
                    _b.y = i * (_b.height + 15)+35;
                    addChild(_b);
                    _b.alpha = 0;
                    
                    _BallList[i][j] = _b;
                    
                }
            }
            
            /**
             * SiON
             */
            _sionDriber = new SiONDriver(); 
            
            _pianoVoice = _presetVoice["valsound.piano12"];
            
            _sionDriber.setBeatCallbackInterval(1);
            _sionDriber.addEventListener(SiONTrackEvent.BEAT, beatHander);
            _sionDriber.setTimerInterruption(1, timerInterruption);
            
            _sionDriber.bpm = 132;
            _sionDriber.play(); 
            
            
            //debug
            //this.addChild( new Stats() );            
            
            
        }
        
        
        
        
        /**
         * beat　
         * @param    e
         */
        private function beatHander(e:SiONTrackEvent):void 
        {
            var _index:int = e.eventTriggerID & 7;
            for (var i: int = 0; i < _LEN; i++) 
            {
                BetweenAS3.delay(BetweenAS3.tween(_BallList[i][_index], { scaleX:0.2, scaleY:0.2 }, { scaleX:0.6, scaleY:0.6 }, 0.4, Back.easeOut), 0.0).play();                    
            }
            
        }
        
        /**
         * callBack 関数
         */
        private function timerInterruption():void
        {
            //trace("callBack");
            //var _index:uint = _beatCount  & 8;
            var _index:int = _beatCount & 7;
            
            for (var i: int = 0; i < _LEN; i++) 
            {
                if(_BallList[i][_index].isMove) 
                {
                    _sionDriber.noteOn(_note[i], _pianoVoice, 1);
                }
            }
            
            _beatCount ++;
            
        }
        
        
        
        
        
        private function enterFrameHandler(e:Event):void 
        {
            _canvasBmd.lock();
            _nowBmd.lock();
            _prevBmd.lock();
            _eraseBmd.lock();
            
            _canvasBmd.draw(_video, _matrix);
            _perlinNoise.move(true,false,BitmapDataChannel.ALPHA);
            _nowBmd.copyPixels(_canvasBmd, _canvasBmd.rect, _point);            
            _nowBmd.draw(_prevBmd, null, null, BlendMode.DIFFERENCE);
            _nowBmd.threshold(_nowBmd, _nowBmd.rect, _point, ">", 0xFFBBBBBB, 0xFF666666);
            _nowBmd.threshold(_nowBmd, _nowBmd.rect, _point, "<", 0xFF111111, 0xFF000000);
            _prevBmd.copyPixels(_canvasBmd, _canvasBmd.rect, _point);
            
            _eraseBmd.draw(_nowBmd, null, new ColorTransform(Math.random() * 1, Math.random() * 1, Math.random() * 1, 0.8), BlendMode.ADD);
            _eraseBmd.fillRect(new Rectangle(0, _eraseBmd.height-5 , _eraseBmd.width, 5),0x00000000);
            _eraseBmd.applyFilter(_eraseBmd, _eraseBmd.rect, _point, new BlurFilter(6, 6, 1));
            
            
            if(_isSetup) 
            {
                for (var i: int = 0; i < _LEN; i++) 
                {
                    for (var j: int = 0; j < _LEN; j++) 
                    {
                        if(_eraseBmd.getPixel(_BallList[i][j].x,_BallList[i][j].y) > 6000000 && _eraseBmd.getPixel(_BallList[i][j].x,_BallList[i][j].y) < 14000000) 
                        {
                            _BallList[i][j].isMove = true;
                            BetweenAS3.delay(BetweenAS3.tween(_BallList[i][j], { alpha:0.8, scaleX:0.8, scaleY:0.8 }, {alpha:0, scaleX:1.2, scaleY:1.2}, 0.4, Back.easeOut), 0.0).play();
                        }
                        else
                        {
                            _BallList[i][j].isMove = false;                        
                            BetweenAS3.delay(BetweenAS3.tween(_BallList[i][j], { alpha:0.1, scaleX:0.2,scaleY:0.2 }, null, 0.4, Back.easeOut), 0.0).play();                    
                        }
                    }
                }
            }
            
            _canvasBmd.unlock();
            _nowBmd.unlock();
            _prevBmd.unlock();
            _eraseBmd.unlock();
        }
    }
}


import flash.display.*;
import flash.geom.*;

class BallBright extends Sprite
{
    public var id:uint = 0;
    public var isMove:Boolean = false;
    
    public function BallBright()
    {
        draw();
    }
    
    private function draw():void
    {
        graphics.beginFill(0xFFFFFF, 0.2);
        graphics.lineStyle(1, 0xff0099, 0.8);
        graphics.drawCircle(0, 0, 20);
        
        graphics.beginFill(0xFF0099, 0.4);
        graphics.lineStyle(1, 0xff0099, 0.6);
        graphics.drawCircle(0, 0, 10);
    }
}


class PerlinNoiseGenerateC extends Sprite  
    {
        
    private var _bmd:BitmapData;
    private var _w:Number = 200;
    private var _h:Number = 200;
    private var _octaves:int = 6;
    private var _seed:Number = Math.floor(Math.random() * 0xffffff);
    private var _stitch:Boolean = false;
    private var _fractalNoise:Boolean = true;
    private var _channel:uint = BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE;
    private var _grayScale:Boolean = false;
    private var _offsets:Array = [];
    private var _offXY:Array = [];
    
    private var _distX:uint = 4;
    private var _distY:uint = 4;
    private var _distRateX:uint = _distX / 2;
    private var _distRateY:uint = _distY / 2;
    
    public function PerlinNoiseGenerateC(bmd:BitmapData):void
    {
        _bmd = bmd;
        init();
    }
    
    private function init():void
    {
        //初期設定
        setup();
    }
    
    public function setup(distX:uint = 4, distRateX:uint = 2, distY:uint = 4, distRateY:uint = 2 ):void
    {
        //x
        _distX = distX;
        _distRateX = distRateX;
        //y
        _distY = distY;
        _distRateY = distRateY;
        
        
        var _len:uint = _octaves;
        for (var i: int = 0; i < _len; i++) 
        {
            //初期位置
            _offsets[i] = new Point(Math.random() * _w , Math.random() * _h);
            
            //向き・速度の設定
            _offXY[i] = new Array(2);
            _offXY[i][0] = Math.random() * _distX - _distRateX;
            _offXY[i][1] = Math.random() * _distY - _distRateY;
        }    
    }
    
    public function move(fractalNoise:Boolean = true, grayScale:Boolean = false, channel:uint = 7):void
    {
        _fractalNoise = fractalNoise;
        _grayScale = grayScale;
        _channel = channel;
        
        var _len:uint = _octaves;
        for (var i: int = 0; i < _len; i++) 
        {
            //値の代入
            _offsets[i].x += _offXY[i][0];
            _offsets[i].y += _offXY[i][1];
        }
        
        //perlinNoiseの生成
        _bmd.perlinNoise(_w, _h, _octaves, _seed, _stitch, _fractalNoise, _channel, _grayScale, _offsets);
        
    }
    
    
    public function get bmd():BitmapData { return _bmd; }
    
    public function set bmd(value:BitmapData):void 
    {
        _bmd = value;
    }
}






