/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Ewu
 */

package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import sliz.miniui.Label;
    import sliz.miniui.Silder;
    /**
     * ...
     * @author sliz http://game-develop.net/blog/
     */
    public class TestPerspectiveProjection extends Sprite
    {
        private var l:Label;
        private var pp:PerspectiveProjection;
        
        public function TestPerspectiveProjection() 
        {
            pp = new PerspectiveProjection();
            l = new Label("", this);
            addEventListener(Event.ENTER_FRAME, update);
            var silder:Silder  = new Silder(0, 100, this,"num",show);        
        }
        
        private function show(v:Number):String 
        {
            var rv:Number = 1 + v * 178;
            pp.fieldOfView = rv;
            return rv + "";
        }
        
        private function update(e:Event):void 
        {
            l.text = ppToString(pp);
        }
        public function ppToString(pp:PerspectiveProjection):String {
            return "focalLength = stageWidth/2 * (cos(fieldOfView/2) / sin(fieldOfView/2)\nfieldOfView:" + pp.fieldOfView + "\nfocalLength:" + pp.focalLength + "\nmyFocalLength" + getFocalLength(pp.fieldOfView) + "\nprojectionCenter:" + pp.projectionCenter + "\nmatrix3d:" + matrix3dToString(pp.toMatrix3D());
        }
        private function matrix3dToString(m:Matrix3D):String {
            return  ""+m.rawData;
        }
		private function getFocalLength(fo:Number):Number {
			var hfoc:Number = fo * Math.PI / 180 / 2;
			//return 250 * Math.cos(hfoc) / Math.sin(hfoc);
			return 250 / Math.tan(hfoc);
		}
    }

}