/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Enh
 */

// forked from ahchang's StarsShow
/**
 *  DisplayObject とかには addChild の他に addChildAt ってやつがあるよ。
 *
 *  @see http://tirirenge.undo.jp/?p=1896
 */
package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.geom.Point;
    import frocessing.color.ColorHSV;
    import flash.display.DisplayObjectContainer;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="465",height="465",frameRate="30",backgroundColor="0x000000")]
    
    public class StarsShow extends Sprite
    {
        private var sw:Number = stage.stageWidth;
        private var sh:Number = stage.stageHeight;
        private var cx:Number = sw/2;
        private var cy:Number = sh/2;
        private const CORNER:int = 5;
        private const RADIUS1:Number = 50;
        private const RADIUS2:Number = 20;
        private var hsv:ColorHSV;
        private var s_array:Array = new Array();
        
        public function StarsShow()
        {
            init();
        }
        
        private function init():void
        {
            for (var i:int=0; i<15; i++)
            {
                var star:Sprite = new Sprite();
                star.graphics.lineStyle(0.1, 0xffffff);//, 0.1);
                
                hsv = new ColorHSV(0, 1, 1, 1);
                hsv.h = Math.random() * 240 + 180;
                star.graphics.beginFill(hsv.value, hsv.a);//, 0.1);
                          
                var angle:Number = 2 * Math.PI / CORNER;
                var p1:Point, p2:Point;
                star.graphics.moveTo(RADIUS1, 0);
                                
                for (var j:int=0; j<CORNER; j++)
                {
                    p1 = Point.polar(RADIUS2, angle * (j + 0.5));
                    p2 = Point.polar(RADIUS1, angle * (j + 1));
                    star.graphics.lineTo(p1.x, p1.y);
                    star.graphics.lineTo(p2.x, p2.y);
                }
                
                star.x = cx;
                star.y = cy;
                star.rotation = -90;
                star.scaleX = star.scaleY = 0.8 * i;
                //addChild(star);
                //  どんどこ一番下に滑り込ませる。
                addChildAt(star, 0);
            }
        }
    }
}



