/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4E8l
 */

// forked from zahir's 速度比較用テンプレ
package {
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.utils.getTimer;
    
    public class FlashTest extends Sprite {
        private const LOOP:int = 100;
        private var t:TextField;
        public function FlashTest() {
            addChild( ( t= new TextField() ) ).width = t.height = 465;
            addEventListener( MouseEvent.CLICK, onClick );
            ex();
        }
        
        private function onClick( e:MouseEvent ):void
        {
            ex();
        }

        private function ex():void
        {
            var i:int = 0;                                      
            var time1:int;
            var time2:int;
            var recode:Array = [];
            var count:int = 0;
            t.text = "各 " + LOOP + " 回ループ\n\n";
            
            // ここから処理
            var w:int = 640;
            var h:int = 480;
            var bd:BitmapData = new BitmapData(w,h, false, 0xFF0000);
            var clone:BitmapData = bd.clone();
            var rect:Rectangle = clone.rect;
            var p:Point = new Point();
            
            time1 = getTimer();
            for( i = 0; i<LOOP; i++ )
            {
                bd.dispose();
                bd = clone.clone();
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData( "clone", time2, "" );
            
            time1 = getTimer();
            for( i = 0; i<LOOP; i++ )
            {
                bd.dispose();
                bd = new BitmapData( clone.width, clone.height, false );
                bd.copyPixels( clone, clone.rect, new Point() );
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData( "new -> copy", time2, "" );
            
            time1 = getTimer();
            for( i = 0; i<LOOP; i++ )
            {
                bd.dispose();
                bd = new BitmapData( w, h, false );
                bd.copyPixels( clone, rect, p );
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData( "new -> copy 使い回し", time2, "" );
            
            time1 = getTimer();
            for( i = 0; i<LOOP; i++ )
            {
                bd.dispose();
                bd = new BitmapData( w, h, false );
                bd.lock();
                bd.copyPixels( clone, rect, p );
                bd.unlock();
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData( "new -> copy 使い回し + lock", time2, "" );
            
            
            bd.dispose();
            clone.dispose();
            
            // ここまで処理
            
            /* templete
            time1 = getTimer();
            for( i = 0; i<LOOP; i++ )
            {
                
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData( "", time2, "" );
            */
            
            if( recode.length )
            {
                $( recode );
            }
            
            t.appendText("clickで再計算");
        }
        private function $( recode:Array ):void
        {
            var str:String = "";
            recode.sortOn( "time", Array.NUMERIC );
            var max:int = (recode[ recode.length - 1 ] as TimeData).time;
            for( var i:int = 0, len:int = recode.length; i<len; i++)
            {
                var data:TimeData = recode[i] as TimeData;
                var n:int = max / data.time * 100;
                str += data.title + " :: " + data.time + " ms\n\t\t最低速に比べて約 " + n + " %高速 \n";
                if(data.ms == "") str += "\n";
                else str += "\t\t" + data.ms  + "\n\n";
            }
            t.appendText( str );
        }
    }
}
import flash.geom.Matrix3D;
class TimeData
{
    public var title:String;
    public var time:int;
    public var ms:String; // なんか、おまけ要素
    public function TimeData( title:String = "", time:int = 0 , ms:String = "")
    {
        this.title = title;
        this.time = time;
        this.ms = ms;
    }
}