/**
 * Copyright mitien ( http://wonderfl.net/user/mitien )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4E5y
 */

// forked from sakef's Pixel3Dの座標⇒普通のxy座標
/*
   Pixel3Dの座標を2次元にする方法。
   色々方法あると思うんですけど、こんな感じでいいのかな・・。

   「Pixel3Dって要はBitmapDataに点打ってるんだからそこのソース見て勉強すればいいよね」
   って発想で、RenderPixels.asの中身を参考にさせてもらいました。

   各Pixel3Dの座標を、同じ色のShapeが追ってます。
 */

package
{
    import flash.display.Shape;
    import flash.display.StageQuality;
    import flash.events.Event;

    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.core.geom.renderables.Vertex3DInstance;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
    public class Main extends BasicView
    {
        private const RADIUS:int=140;
        private var pixels:Pixels;
        private var sphere:Sphere;
        private var ary:Array;

        // コンストラクタ
        public function Main()
        {
            // もろもろの準備
            stage.quality=StageQuality.HIGH;
            super(0, 0, true, true);

            var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE, true);
            layer.clearBeforeRender=true;
            viewport.containerSprite.addLayer(layer);

            camera.z=-500;
            sphere=new Sphere(new WireframeMaterial(0xdddddd, 0.1, 1), Math.sqrt(RADIUS * RADIUS * 3), 10, 10);
            sphere.material.doubleSided=true;
            scene.addChild(sphere);

            pixels=new Pixels(layer);
            scene.addChild(pixels);

            // とりあず、Pixelを4点打つ
            var p:Pixel3D=new Pixel3D(0xffff0000, RADIUS, RADIUS, RADIUS);
            pixels.addPixel3D(p);

            p=new Pixel3D(0xff00ff00, RADIUS, RADIUS, -RADIUS);
            pixels.addPixel3D(p);

            p=new Pixel3D(0xffffff00, RADIUS, -RADIUS, -RADIUS);
            pixels.addPixel3D(p);

            p=new Pixel3D(0xffff00ff, -RADIUS, -RADIUS, -RADIUS);
            pixels.addPixel3D(p);

            // Shapeを4つ作る。それぞれPixelを追いかける
            ary=[];
            var colors:Array=[0xff0000, 0x00ff00, 0xffff00, 0xff00ff]
            var sp:Shape;
            for (var i:int=0; i < 4; i++)
            {
                sp=new Shape;
                sp.graphics.beginFill(colors[i], 0.2);
                sp.graphics.drawCircle(0, 0, 10);
                sp.graphics.endFill();
                addChild(sp);
                ary[i]=sp;
            }

            // Let's レンダリング！
            startRendering();
            addEventListener(Event.ENTER_FRAME, onFrame);
        }

        // エンターフレーム
        private function onFrame(e:Event):void
        {
            sphere.rotationX=pixels.rotationY+=0.5;
            sphere.rotationY=pixels.rotationX+=0.5;

            // Pixelの座標をスクリーン座標にしてShapeに適用
            // RenderPixels.asを参考にしました。っていうかほぼそのまま。
            var offsetX:Number=stage.stageWidth >> 1;
            var offsetY:Number=stage.stageHeight >> 1;

            var v3d:Vertex3DInstance;
            var i:int=0;
   
            for each (var p:Pixel3D in pixels.pixels)
            {
                v3d=p.vertex3D.vertex3DInstance;
                if (v3d.visible)
                {
                    (ary[i] as Shape).x=v3d.x + offsetX;
                    (ary[i] as Shape).y=v3d.y + offsetY;
                    i++;
                }
            }
        }
    }
}
