/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4DxF
 */

package
{
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2Shape;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.Joints.b2DistanceJoint;
    import Box2D.Dynamics.Joints.b2DistanceJointDef;
    import Box2D.Dynamics.Joints.b2GearJoint;
    import Box2D.Dynamics.Joints.b2GearJointDef;
    import Box2D.Dynamics.Joints.b2Joint;
    import Box2D.Dynamics.Joints.b2PrismaticJoint;
    import Box2D.Dynamics.Joints.b2PrismaticJointDef;
    import Box2D.Dynamics.Joints.b2PulleyJoint;
    import Box2D.Dynamics.Joints.b2PulleyJointDef;
    import Box2D.Dynamics.Joints.b2RevoluteJoint;
    import Box2D.Dynamics.Joints.b2RevoluteJointDef;
    import flash.display.Sprite;
    //import org.papervision3d.cameras.Camera3D;
    //import org.papervision3d.render.BasicRenderEngine;
    //import org.papervision3d.scenes.Scene3D;
    //import org.papervision3d.view.Viewport3D;
    //import org.papervision3d.objects.DisplayObject3D;
    //import org.papervision3d.objects.primitives.Sphere;
    //import org.papervision3d.view.BasicView;
    //import org.papervision3d.core.geom.TriangleMesh3D;
    //import org.papervision3d.cameras.SpringCamera3D;
    import org.papervision3d.core.math.Number3D;
    import flash.events.*;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.events.FileLoadEvent;
    import org.papervision3d.cameras.SpringCamera3D;
    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.events.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    import flash.ui.Keyboard;
    public class test0 extends BasicView implements IEventDispatcher
    //public class test0 extends Sprite
    { 
        private var model : DisplayObject3D;
        private var worldActorsArray : Array = [];
        //private var model2 : ArbitraryActor3;
        private var keyRight : Boolean;
        private var keyLeft : Boolean;
        private var keyForward : Boolean;
        private var keyBackward : Boolean;
        public function test0()
        {
            setupWorld();
            setupPapervision3D();
            setupDebugDraw();
            super(stage.stageWidth, stage.stageHeight, true, false, CameraType.SPRING);
            initCameraControll();
            var camera : SpringCamera3D = SpringCamera3D(camera);
            camera.mass = 20; 
            camera.damping = 4;
            camera.stiffness = 1; 
            camera.positionOffset = new Number3D(0, 50, 150);
            camera.lookOffset = new Number3D(0, 0, 50);
            model = new DAE(true, null, true);
            model.addEventListener(FileLoadEvent.LOAD_COMPLETE,ModelWasLoaded);
            model.addEventListener(FileLoadEvent.ANIMATIONS_COMPLETE, myOnAnimationsCompleteHandler);
            model.addEventListener(FileLoadEvent.ANIMATIONS_PROGRESS, myOnAnimationsProgressHandler);
            model.scale = 3;
            model.rotationY = (-90);
            DAE(model).load("model/Sarutobi/SarutobiRun/SarutobiRun.dae");
            startRendering();
        }
        private function myOnAnimationsCompleteHandler(e : FileLoadEvent) : void
        {
        }
        private function myOnAnimationsProgressHandler(e : FileLoadEvent) : void
        {
        }
        private function initCameraControll() : void
        {
            stage.addEventListener(KeyboardEvent.KEY_DOWN,keyDownHandler);
            stage.addEventListener(KeyboardEvent.KEY_UP,keyUpHandler);
        }
        private function keyDownHandler(e : KeyboardEvent) : void
        {
            switch (e.keyCode)
            {
            case "W".charCodeAt() :
            case Keyboard.UP :
               keyForward = true;
            break;
            case "S".charCodeAt() :
            case Keyboard.DOWN :
                keyBackward = true;
            break;
            case "A".charCodeAt() :
            case Keyboard.LEFT :
                keyLeft = true;
            break;
            case "D".charCodeAt() :
            case Keyboard.RIGHT :
                keyRight = true;
            break;
            }
        }
        private function keyUpHandler(e : KeyboardEvent) : void
        {
            switch (e.keyCode)
            {
            case "W".charCodeAt() :
            case Keyboard.UP :
                keyForward = false;
            break;
            case "S".charCodeAt() :
            case Keyboard.DOWN :
                keyBackward = false;
            break;
            case "A".charCodeAt() :
            case Keyboard.LEFT :
                keyLeft = false;
                break;
            case "D".charCodeAt() :
            case Keyboard.RIGHT :
                keyRight = false;
            break;
            }
        }
        private function moveObject() : void
        {
            if (keyForward)
            {
                //model2.getBody().SetLinearVelocity(new b2Vec2(4,0));
            }
            else if (keyBackward)
            {
                 //model2.mesh.moveBackward(30);
            }
        }
        private function goPlayer(e : Event) : void
        {
        }
        public function ModelWasLoaded(e : FileLoadEvent) : void
        {
            scene.addChild(model);
            //knopka.addEventListener(MouseEvent.CLICK, createWorldBox);
        }
        private function setupPapervision3D() : void
        {
        }
        private function createBigSphere() : void
        {
            //model2 = new ArbitraryActor3(scene, Globals.STAGE_WIDTH * .3, Globals.STAGE_HEIGHT * .5, 100, 100, 1000, model);
            //worldActorsArray.push(model2);
            //camera.target = model2.mesh;
        }
        override protected function onRenderTick(e : Event = null) : void
        {
            if (keyForward)
            {
                //model2.getBody().SetLinearVelocity(new b2Vec2(4, 0));
            }
            else if (keyBackward)
            {
                //model2.getBody().SetLinearVelocity(new b2Vec2(-4, 0));
            }
            //PhysiVals.world.Step(1/stage.frameRate, 10);
            for (var i : int = 0; i < worldActorsArray.length; i++)
            {
                worldActorsArray[i].updateNow();
            }
            super.onRenderTick();
        }
        private function createWorldBox(e : MouseEvent) : void
        {
            //var wall2 : ArbitraryActor2 = new ArbitraryActor2(scene, 0, 700, 1300, 10, 20);
            //wall2.setUserData = "DOWN";
            //worldActorsArray.push(wall2);
            createBigSphere();
        }
        private function setupDebugDraw() : void
        {
            var spriteToDrawOn : Sprite = new Sprite();
            addChild(spriteToDrawOn);
            var artistForHire : b2DebugDraw = new b2DebugDraw();
            artistForHire.m_sprite = spriteToDrawOn;
            artistForHire.m_drawScale = PhysiVals.RATIO;
            artistForHire.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
            artistForHire.m_lineThickness = 2.0;
            artistForHire.m_fillAlpha = 0.6;
            PhysiVals.world.SetDebugDraw(artistForHire);
        }
        private function setupWorld() : void
        {
            var worldBounds : b2AABB = new b2AABB();
            worldBounds.lowerBound.Set(-5000 / PhysiVals.RATIO, -5000 / PhysiVals.RATIO);
            worldBounds.upperBound.Set(5000 / PhysiVals.RATIO, 5000 / PhysiVals.RATIO);
            var gravity : b2Vec2 = new b2Vec2(0, 9.8);
            var isSleep : Boolean = false;
            PhysiVals.world = new b2World(worldBounds, gravity, isSleep);
            //PhysiVals.world.SetContactListener(new myContactListener());
        }
    }
}
    import Box2D.Dynamics.b2World; 
    class PhysiVals
    {
        public static const STAGE_HALF_WIDTH : int = 323;
        public static const STAGE_HEIGHT : int = 603;
        private static var _instance : PhysiVals;
        public static const RATIO : Number = 30;
        public static const FRAME_RATE : Number = 30;
        private static var _world : b2World;
        public function PhysiVals(pvt : PhysiValsPrivateClass)
        {
        }
        public static function getInstance() : PhysiVals
        {
            if (PhysiVals._instance == null)
            {
                PhysiVals._instance = new PhysiVals(new PhysiValsPrivateClass());
            }
            return PhysiVals._instance;
        }
        public static function get world() : b2World    
        {
            return _world
        }
        public static function set world(world : b2World) : void    
        {
            _world = world;
        }
    }
class PhysiValsPrivateClass
{
    public function PhysiValsPrivateClass()
    {
    }
}
