/**
 * Copyright _53 ( http://wonderfl.net/user/_53 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Duv
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    public class ObjectMove extends Sprite {
        
        /*円を描画されるオブジェクト*/
        private var childSprite:Sprite;
        
        /*マウスカーソルの位置*/
        private var thisX:Number, thisY:Number;
        
        /*円オブジェクトの位置*/
        private var circleX:Number, circleY:Number;
        
        
        public function ObjectMove() {
            
            /*円を描画するchildSprite（Sprite)を表示リストに追加する*/
            childSprite = new Sprite();
            childSprite.x = 60;
            childSprite.y = 60;
            addChild(childSprite);
            
            /*childSpriteに円を描画する*/
            childSprite.graphics.beginFill(0x000000);
            childSprite.graphics.drawCircle(0, 0, 40);
            childSprite.graphics.endFill();
            
            /*マウスダウン時のイベントハンドラーを設定*/
            addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            /*マウスムーブ時のイベントハンドラーを設定*/
            addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
        
        /*マウスダウン時にマウスの位置と、円の位置を取得する。*/
        private function mouseDownHandler(event:MouseEvent):void{
            thisX = this.mouseX;
            thisY = this.mouseY;
            circleX =　childSprite.x;
            circleY = childSprite.y;
        }
        
        /*マウスが動いた時に、円を移動させる。*/
        private function mouseMoveHandler(event:MouseEvent):void{
            if(!event.buttonDown) return;
            childSprite.x = this.mouseX - thisX + circleX;
            childSprite.y = this.mouseY - thisY + circleY;
        }
    }
}