/**
 * Copyright kakarlus ( http://wonderfl.net/user/kakarlus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4DPH
 */

package {
    import flash.display.*;
    import com.greensock.*;
    import com.greensock.easing.*;
    import flash.text.*;

    [SWF(width='800', height='600', backgroundColor='#eeeeee', frameRate='60')]
    public class BezierExperiment extends Sprite{
        private var imgs: Array;
        private var tf: TextField;
        private var particleCount:int = 1000;
        public function BezierExperiment(){
            tf = new TextField();
            tf.text = "hello godless world";

            imgs = new Array();

            addChild(tf);

            graphics.lineStyle(0x000000);
            graphics.drawRect(300, 200, 200, 200);
            initRects();
            animate();
        }

        private function animate():void{
            var delay: Number = 0.01;
            for (var i:int = 0; i < particleCount; i++){
                var randScale: Number = getRandRange(1000,300)/1000;
                
                TweenMax.to(imgs[i], 2, {  //x: getRandRange(800), y: getRandRange(600), 
                                                      scaleX: randScale, scaleY: randScale, 
                                                      rotationX: 0, rotationY: 0, rotationZ: 0,
                                                      alpha: 1,
                                                      delay: 2+(delay*i),
                                                      bezier: [{x: getRandRange(800), y: getRandRange(600) },
                                                                  {x: getRandRange(800), y: getRandRange(600) },
                                                                  {x: getRandRange(800), y: getRandRange(600) }],
                                                      ease: Sine.easeOut

                                                      });
            }
        }

        private function getRandRange(upperLimit: int, lowerLimit: int = 0):int{
            return lowerLimit + Math.round(Math.random()*(upperLimit - lowerLimit));
        }

        private function initRects():void{
            for (var i:int = 0; i < particleCount; i++){
                var spr:Sprite = newRect(40, 30);
                imgs.push(spr);
                spr.x = getRandRange(500, 300);
                spr.y = getRandRange(400, 200);

                spr.rotationX = getRandRange(360);
                spr.rotationY = getRandRange(360);
                spr.rotationZ = getRandRange(360);
                spr.scaleX = spr.scaleY = 0.15;
                spr.alpha = 0.15;
                addChild(spr);
            }
        }

        private function newRect(w: int, h: int):Sprite{
            var spr: Sprite = new Sprite();
            spr.graphics.lineStyle(0, 0x000000, 1);
            spr.graphics.beginFill(0x000000);
            spr.graphics.drawRect(-20, -15, w, h);
            
            return spr;
        }
    }
}
