/**
 * Copyright hide091 ( http://wonderfl.net/user/hide091 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4DKu
 */

// forked from ahosuke007's ザ・シュールタイピングゲー
// forked from ahosuke007's forked from: タイピング
// forked from ahosuke007's タイピング
//無駄に難しい単語ばかりを入れ込んだ。
//台詞は全部ふざけたやつ。


package{
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.*;
    
    
    [SWF(width=465, height=465, backgroundColor = 0xffffff, frameRate = 60)]
    public class Game extends Sprite{
        
        //Typingクラスのオブジェクトを作成します。
            public var typing:Typing = new Typing();
            
            
            //結果表示用の変数
            public var textField:TextField = new TextField();
            public var baseData:String = "";
            public var typeData:String = "";
            public var wordData:String = "";
            
            
            public function Game() {
                
                 //単語（敬語）リスト
              var list:Array=[
                { word : "俺が皿洗いで許してもらうから。" ,      kana : "おれがさらあらいでゆるしてもらうから。" },
                { word : "しないほうがいいんじゃない？" ,      kana : "しないほうがいいんじゃない？" },
                { word : "相棒ーっ！" ,      kana : "あいぼうーっ！" },
                { word : "埋ってる俺でよかったらだけどさ" ,      kana : "うまってるおれでよかったらだけどさ" },
                { word : "女に惚れさす名言" ,      kana : "おんなにほれさすめいげん" },
                { word : "若いって聞いたよ" ,      kana : "わかいってきいたよ" },
                { word : "全部俺が片付けてやるよ" ,      kana : "ぜんぶおれがかたづけてやるよ" },
                { word : "今度は君の瞳に吸い込まれたい" ,      kana : "こんどはきみのひとみにすいこまれたい" },
                { word : "ダメージ俺、ジーンズ" ,      kana : "だめーじおれ、じーんず" },
                { word : "禁断のダメージジーンズ" ,      kana : "きんだんのだめーじじーんず" },
                { word : "ねぇ、今実行委員呼んでた？" ,      kana : "ねぇ、いまじっこういいんよんでた？" },
                { word : "私は下に何も履いてませんね" ,      kana : "わたしはしたになにもはいてませんね" },
                { word : "今からバックさせるけど、" ,      kana : "いまからばっくさせるけど、" },
                { word : "虎になりてぇ" ,      kana : "とらになりてぇ" },
                { word : "明日からお前が俺の上司だ。" ,      kana : "あしたからおまえがおれのじょうしだ。" },
                { word : "限界だと思ってないよな？" ,      kana : "げんかいだとおもってないよな？" },
                { word : "集まらなくて大丈夫だから" ,      kana : "あつまらなくてだいじょうぶだから" },
                { word : "君に油を塗りたい" ,      kana : "きみにあぶらをぬりたい" },
                { word : "イタリアのこと考えてた" ,      kana : "いたりあのことかんがえてた" },
                { word : "粉砕！玉砕！大喝采！" ,      kana : "ふんさい！ぎょくさい！だいかっさい！" },
                { word : "私の計算によれば、" ,      kana : "わたしのけいさんによれば、" },
                { word : "おい、デュエルしろよ" ,      kana : "おい、でゅえるしろよ" },
                { word : "ふぅん。" ,      kana : "ふぅん。" },
                { word : "悩みがあったら聞くよ。" ,      kana : "なやみがあったらきくよ。" },
                { word : "あ！それってハネクリボウ？" ,      kana : "あ！それってはねくりぼう？" },
                { word : "もっと腕にシルバー巻くとかさ！" ,      kana : "もっとうでにしるばーまくとかさ！" },
                { word : "お前は何者だ！" ,      kana : "おまえはなにものだ！" },
                { word : "デートかよ。" ,      kana : "でーとかよ。" },
                { word : "バイビー！！" ,      kana : "ばいびー！！" },
                { word : "困ったときのクリボー。" ,      kana : "こまったときのくりぼー。" },
                { word : "エンジョーイ？天上院！" ,      kana : "えんじょーい？てんじょういん！" }
            ];
            //個人的に単語の最後にスペースを打つ形式が好きなので、
            //単語リストにスペースを追加していきます。
            for(var i:uint=0;i<list.length;i++){list[i].kana+=" ";}
            
            
            //typingクラスに単語リストを設定します。
            typing.setWordList(list);
            
            
                
                
            //表示リストにtypingを追加します。
            stage.addChild(typing);           
            
            //TypingEventのリスナーを追加します。
            typing.addEventListener(TypingEvent.TYPE_WORD,onWordType);        //単語入力完了を監視するリスナー
            typing.addEventListener(TypingEvent.TYPE,onType);                //文字のタイプを監視するリスナー
            
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
            
            
            
            //タイピングを開始します。
            typing.start();
            
            
            
            
               //ターゲットとなる単語を設定します
               setTarget();
         
            
            
            
            
            
            //textFieldでタイピングの結果など表示します
                stage.addChild(textField);
                textField.autoSize = TextFieldAutoSize.LEFT;
                
                
                
                
                
                //Escキーを感知するためのリスナー
            stage.addEventListener("keyUp", restart);
        }
        
            //ターゲットを設定します
            private function setTarget():void{
                //単語表からタイプする単語を追加します。    addTargetFirst(追加する単語数)
                //typing.addTargetFirst(2);        //単語表の前から順番に単語を追加します。
                typing.addTargetRandom(3);        //ランダムに単語を追加します。
            
            
            
            
            //ウィンドウの表示場所を設定します。
            typing.typingWindows[0].x = 240;
            typing.typingWindows[0].y = 150;

            typing.typingWindows[1].x = 20;
            typing.typingWindows[1].y = 230;
            
            typing.typingWindows[2].x = 240;
            typing.typingWindows[2].y = 300;
            
            }    
        
        
        
        
        
        
        
        //タイプした時に呼び出されるイベント
            private function onType(e:TypingEvent):void{
                //好きなようにタイピングの結果を表示します。
                typeData = "   " + e.typed + "がタイプされました";
                typeData += "    タイプまでの時間: " + e.time.toFixed(3);
                if(e.miss==1){typeData += "    ミスしました!!";}
                
                textField.text = baseData  + "\n\n"  + typeData + "\n\n" + wordData;
            }
            
            
            
            
        //単語が入力完了した時に呼び出されるイベント
            private function onWordType(e:TypingEvent):void{
                //好きなようにタイピングの結果を表示します。
                wordData = "   単語番号" + e.index + "\n     "+ e.kana + "\n     "+ e.word + "\n     "+ e.typed + "     が入力されました";
                wordData += "\n    この単語にかかった時間: " + e.time.toFixed(3)+"秒";
            wordData += "    ミスタイプ数: " + e.miss;
            
            textField.text = baseData  + "\n\n"  + typeData  + "\n\n" + wordData;
                
                
                
                //20単語タイプしたらタイピング終了
             if(typing.finWord==20){
                 if(typing.play){
                     typing.stop();
                 }
                 wordData += "\n\n\n　  タイピングが終了しました\n   再び始めるにはEscキーを押してください";
             }else{
                    //ターゲットがなくなったのに合わせて、次のターゲットを表示します。
                    if(typing.target.length == 0){
                        setTarget();
                    }
             }
            }
            
            //毎フレーム呼び出されるイベント
            private function onEnterFrame(e:Event):void{
                //好きなようにタイピングの結果を表示します。
                baseData = "   経過時間: " + typing.time.toFixed(3);
                baseData += "   　単語数:" + typing.finWord;
                baseData += "    正しいタイプ数:" + typing.touch;
                baseData += "    ミスタイプ数:" + typing.missTouch;
                
                var speed:Number = typing.touch/typing.time;
                baseData += "    速度:" + speed.toFixed(1) + "key/秒";
                textField.text = baseData  + "\n\n"  + typeData + "\n\n" + wordData;
         }
            
            private function restart(e:KeyboardEvent):void{
                //Escキーを感知
                if(e.keyCode==27){
                    //タイピングを開始します。
                    typing.reset();
                    typing.start();
                    
                    
                    setTarget();
           }
            }
            
        
    }
}


import flash.display.Sprite;
import flash.text.*;
import flash.events.*;
import flash.utils.*;


//単語を表示する。ウィンドウの表示。
class TypingWindow extends Sprite{
    
    public var typedFormat:TextFormat = new TextFormat();
    public var kanaFormat:TextFormat = new TextFormat();
    public var wordFormat:TextFormat = new TextFormat();
    public var romanFormat:TextFormat = new TextFormat();
    
    public var kanaField:TextField = new TextField();
    public var wordField:TextField = new TextField();
    public var romanField:TextField = new TextField();
    
    public var blinde:Sprite = new Sprite();
    
    public var messageFormat:TextFormat = new TextFormat();
    public var messageField:TextField = new TextField();
    
    public function TypingWindow(){
        addChild(kanaField);
        addChild(wordField);
        addChild(romanField);
        layout();
    }
    
    
    //ウィンドウのレイアウトです。好きに改変してください*******************************************
    public function layout():void{
        
        var w :int　= 200;    //幅
        var h :int　= 90;        //高さ
        var r :int = 80;        //丸み
        
           
        
        //背景、枠の設定

        graphics.beginFill (0xFFC0CB, 1);    // 面のスタイル設定
        graphics.drawRoundRect(0, 0, w, h , r , r);  
        
        
        //かなの設定
        with(kanaFormat){    
            size = 9.5;            //サイズの設定
            bold = false         //太文字にするか
            font = "ＭＳ ゴシック"        //フォント
            align = "center";    //文字の揃え方
            
        }
        with(kanaField){
            width = 200;
            y = 10;
            alpha = 1;            //透明度
            
            selectable = false;
            defaultTextFormat = kanaFormat;
        }
        
        
        //メインの単語の設定
        with(wordFormat){    
            size = 12;            //サイズの設定
            bold = true;         //太文字にするか
            font = "メイリオ"        //フォント
            align = "center";    //文字の揃え方
        }
        with(wordField){
            width = 200;
            y = 25;
            alpha = 1;            //透明度
            
            selectable = false;
            defaultTextFormat = wordFormat;
        }
        
        
        
        //ローマ字の設定
        with(romanFormat){    
            size = 10;            //サイズの設定
            bold = false;         //太文字にするか
            font = "メイリオ"        //フォント
            align = "center";    //文字の揃え方
        }
        with(romanField){
            width = 200;
            x="0"
            y = 55;
            alpha = 1;            //透明度
            
            selectable = false;
            defaultTextFormat = romanFormat;
        }
        
        
        
        //タイプ済みの文字の設定
        with(typedFormat){    
            size = 10;            //サイズの設定
            bold = false;         //太文字にするか
            font = "メイリオ"        //フォント
            color = 0xff0000;    //色
            align = "center";    //文字の揃え方
        }
        
        
        
        
        
        
        
        
        //ウィンドウがオフのときの設定
        blinde.graphics.lineStyle (4, 0x444444, 0.5);    // 線のスタイル指定
        blinde.graphics.beginFill (0xFFFFFF, 0.7);    // 面のスタイル設定
        blinde.graphics.drawRoundRect(0, 0, w, h , r , r);
        
        //メッセージの設定
        with(messageFormat){    
            size = 30;            //サイズの設定
            bold = true;         //太文字にするか
            color = 0xFF1600;
            font = "メイリオ"        //フォント
            align = "center";    //文字の揃え方
        }
        with(messageField){
            width = 200;
            y = 28;
            alpha = 1;            //透明度
            
            selectable = false;
            defaultTextFormat = messageFormat;
        }
    }
    //****************************************************************
    
    public function off():void{
        if(contains(blinde)==false){addChild(blinde);}
    }
    public function on():void{
        if(contains(blinde)){removeChild(blinde);}
        if(contains(messageField)){removeChild(messageField);}
    }
    
    
    public function setMessage(m:String):void{
        messageField.text = m; 
        off();
        addChild(messageField);
    }
    
    
    
    public var _typed:String;
    public function set typed(t:String):void{
        _typed = t;
        var length:int = _typed.length;
        if(length > romanField.text.length){
            length = romanField.text.length;
        }else if(length+1 == romanField.text.length){
            if(romanField.text.substring(length)==" "){
                setMessage("SPACE");
            }
        }
        romanField.setTextFormat(typedFormat,-1,length);
    }

}


//ここから下は編集せずにタイピングゲームを作ることができます
class Typing extends Sprite{
    public var typed:String;
    public var play:Boolean;
    
    
    public var time:Number;
    private var lastTime:Number;
    
    
    public var touch:int;
    public var missTouch:int;
    public var finWord:int;

    public var typingWindows:Vector.<TypingWindow>;
    public var romanList:Vector.<Array>;
    
    public var wordList:Array = new Array();     //単語表
    
    public var target:Vector.<Object>;        //現在ターゲットとなっている単語     
    public var hint:Vector.<Object>;            //次以降の単語
    //Objectの変数は基本的に二つ    word:単語     kana:かな        index:単語リスト中での番号
    
    public var unused:Vector.<int>;            //未使用の単語のリスト

    private var lastWord:Object;
    private var lastType:Object;
    private var currentWord:Object;
    private var currentType:Object;
    
    
    
    //文字をタイプします。　t は length=1 の文字列にしてください。
    //このメソッドを呼び出すと指定された文字列をタイプしたのと同じ操作をします
    public function type(t:String):void{
        var s:String = typed + t;
        var miss:Boolean=true;
        var clear:int = -1;
        for(var i:int=target.length-1;i>=0;i--){
            if(match(target[i].kana,s) == s.length){
                typed = s;
                typingWindows[i].on();
                
                var preffered:String = preferredRoman(target[i].kana,s);
                typingWindows[i].romanField.text = preffered;
                typingWindows[i].typed = typed;
                miss = false;
                if(typed==preffered){
                    clear = i;
                }
            }else{
                typingWindows[i].off();
                typingWindows[i].romanField.text = firstRoman(target[i].kana);
            }
        }
        if(miss){
            currentType.miss = 1;
            currentWord.miss++;
            missTouch++;
            back();
        }else{
            touch++;
            currentType.miss=0;
        }
        currentType.typed = t;
        currentType.time = time;
        
        dispatchEvent(new TypingEvent(TypingEvent.TYPE,false,false,
                                currentType.time - lastType.time,currentType.typed,currentType.miss));
        lastType = currentType;
        currentType = {typed:"", miss:0, time:0};    
        
        if(clear>=0){
            finWord++;
            currentWord.index = target[clear].index;
            currentWord.word = target[clear].word;
            currentWord.kana = target[clear].kana;
            currentWord.typed = typed;
            clearWord(clear);
        }
    }
    
    
    

    
    
    
    
    
    //単語リストの設定
    //start()するより前に設定してください.
    //またtargetが設定されているときに単語リストを変更しないでください。
    public function setWordList(list:Array):void{
        wordList = list;
        unused = new Vector.<int>();
        for(var i:int=0;i<wordList.length;i++){
            unused[i] = i;
            wordList[i].index = i;
        }
    }
    
    
    
    
    
    
    
    
    
    //単語リスト hint の中から順番にnコの単語をtargetに追加
    public function addTargetFirst(n:int):void{
        if(wordList.length < 1){return;}
        for(var i:int=0;i<n;i++){
            var k:int;
            if(hint.length == 0){
                if(unused.length==0){
                    for(var j:int=0;j<wordList.length;j++){
                        unused[j] = j;
                    }
                }
                k = unused[0];
                unused.splice(0,1);
                addTarget(wordList[k]);
            }else{
                addTarget(hint[0]);
                hint.splice(0,1);
            }
        }
    }
    
    //単語リストまたは hint の中からランダムにnコの単語をtargetに追加
    public function addTargetRandom(n:int):void{
        if(wordList.length < 1){return;}
        for(var i:int=0;i<n;i++){
            var rand:int;
            var k:int;
            if(hint.length == 0){
                if(unused.length==0){
                    for(var j:int=0;j<wordList.length;j++){
                        unused[j] = j;
                    }
                }
                rand = Math.random() * unused.length;
                k = unused[rand];
                unused.splice(rand,1);
                addTarget(wordList[k]);
            }else{
                rand = Math.random() * hint.length;
                hint.splice(rand,1);
                addTarget(hint[rand]);
            }
        }
    }
    
    
    
    
    //単語リストの中から順番にnコの単語をhintに追加
    //hintに設定された単語は優先的にtargetに追加されるので,
    //hintを用いることで次の単語、その次の単語をあらかじめ決めることができます。
    public function addHintFirst(n:int):void{
        if(wordList.length < 1){return;}
        for(var i:int=0;i<n;i++){
            var k:int;
            if(unused.length==0){
                for(var j:int=0;j<wordList.length;j++){
                    unused[j] = j;
                }
            }
            k = unused[0];
            unused.splice(0,1);
            addHint(wordList[k]);
        }
    }
    
    //単語リストの中からランダムにnコの単語をhintに追加
    public function addHintRandom(n:int):void{
        if(wordList.length < 1){return;}
        for(var i:int=0;i<n;i++){
            var rand:int;
            var k:int;
            if(unused.length==0){
                for(var j:int=0;j<wordList.length;j++){
                    unused[j] = j;
                }
            }
            rand = Math.random() * unused.length;
            k = unused[rand];
            unused.splice(rand,1);
            addHint(wordList[k]);
        }
    }
    
    /*    
        addTargetRandom(),addTargetFirst(),
        addHintRandom(),addHintFirst()メソッドは
        既に使用されている単語を避けて、単語を追加します。
        
        つまり,addTargetRandom(),addTargetFirst()メソッドでは、
            1, hintに指定されている単語
            2, まだ使用されていない単語
            3, 既に使用された単語
        の順に、単語の追加が行われます。
    */
    
    
    
    
    
    
    //Objectを指定してtargetに追加
    public function addTarget(o:Object):void{
        target.push(o);
        typingWindows.push(new TypingWindow());
        typingWindows[typingWindows.length-1].kanaField.text = o.kana;
        typingWindows[typingWindows.length-1].wordField.text = o.word;
        typingWindows[typingWindows.length-1].romanField.text = firstRoman(o.kana);
        addChildAt(typingWindows[typingWindows.length-1],0);
    }
    //Objectを指定してhintに追加
    public function addHint(o:Object):void{
        hint.push(o);
    }
    
    
    
    
    
    //targetを消去。removeTarget(消去する最初のターゲット,消去する個数)
    public function removeTarget(s:int, count:int = -1):void{
        var c:int = 0;
        while(c != count && target.length > s){
            removeChild(typingWindows[s]);
            typingWindows.splice(s,1);
            target.splice(s,1);
            c++;
        }
        return;
    }
    
    
    
    //単語入力完了処理
    public function clearWord(n:int):void{
        removeTarget(n,1);
        typed="";
        back();
        currentWord.time = time;
        dispatchEvent(new TypingEvent(TypingEvent.TYPE_WORD,false,false,
                                currentWord.time - lastWord.time,currentWord.typed,currentWord.miss,
                                currentWord.word,currentWord.kana,currentWord.index
                                ));
        
        lastWord = currentWord;
        currentWord = {typed:"",word:"", kana:"",  index:0,  miss:0, time:0};
    }
    
    
    
    
    //与えられたかなの先頭にromanが最大何文字マッチするか返す
    public function match(kana:String,roman:String):int{
        var matchLength:int = 0;
        var longest:int = 0;
        var unreaded:String = kana;
        var unreadedRoman:String = roman;
        while(unreaded.length != 0 && unreadedRoman.length != 0){
            loop1:for(var n:int=4;n>0;n--){//文字数
                for(var m:int=0;m<3;m++){//候補番号
                    if(romanList[m][unreaded.substring(0,n)] != undefined){
                        var term:String = romanList[m][unreaded.substring(0,n)]
                        if(term == unreadedRoman.substring(0,term.length)){
                            unreaded = unreaded.substring(n);
                            unreadedRoman = unreadedRoman.substring(term.length);
                            matchLength += term.length;
                            longest = matchLength;
                            break loop1;
                        }else{
                            while(term.length > 1){
                                term = term.substring(0,term.length - 1);
                                if(term == unreadedRoman.substring(0,term.length)){
                                    if(longest < matchLength + term.length){longest = matchLength + term.length;}
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if(n==0){break;}
        }
        return longest;
    }
    
    public function preferredRoman(kana:String,roman:String):String{
        //romanがタイプされているときの最適なローマ字の振り方を返す
        var matchLength:int = 0;
        var longest:int = 0;
        var preferred:String = "";
        var unreaded:String = kana;
        var unreadedRoman:String = roman;
        while(unreaded.length != 0 && unreadedRoman.length != 0){
            loop1:for(var n:int=4;n>0;n--){//文字数
                for(var m:int=0;m<4;m++){//候補番号
                    if(romanList[m][unreaded.substring(0,n)] != undefined){
                        var term:String = romanList[m][unreaded.substring(0,n)]
                        if(term == unreadedRoman.substring(0,term.length)){
                            preferred += term;
                            unreaded = unreaded.substring(n);
                            unreadedRoman = unreadedRoman.substring(term.length);
                            matchLength += term.length;
                            longest = matchLength;
                            if(roman.length==longest){return preferred + firstRoman(unreaded);}
                            break loop1;
                        }else{
                            var bterm:String = term;
                            while(term.length > 1){
                                term = term.substring(0,term.length - 1);
                                if(term == unreadedRoman.substring(0,term.length)){
                                    longest = matchLength+term.length;
                                    if(roman.length==longest){
                                            preferred += bterm;
                                            unreaded = unreaded.substring(n);
                                            unreadedRoman = unreadedRoman.substring(term.length);
                                            matchLength += term.length;
                                            longest = matchLength;
                                            return preferred + firstRoman(unreaded);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if(n==0){
                break;
            }
        }
        preferred += firstRoman(unreaded);
        return preferred;
    }
    
    //kanaのもっとも簡単なローマ字の振り方を返す
    public function firstRoman(kana:String):String{
        var unreaded:String = kana;
        var preferred:String = "";
        while(unreaded.length != 0){
            loop1:for(var n:int=4;n>0;n--){//文字数
                for(var m:int=0;m<4;m++){//候補番号
                    if(romanList[m][unreaded.substring(0,n)] != undefined){
                        preferred += romanList[m][unreaded.substring(0,n)];                        
                        unreaded = unreaded.substring(n);
                        break loop1;
                    }
                }
            }
            if(n==0){
                break;
            }
        }
        return preferred;
    }
    
    
    //単語リストとウインドウスタイル以外を初期化します
    public function reset():void{
        time = 0;
        missTouch = 0;
        touch = 0;
        finWord = 0;
        
        typed = "";
        
        currentWord = {typed:"",word:"", kana:"",  index:0,  miss:0, time:0};
        currentType = {typed:"", miss:0, time:0};
        
        lastWord = {typed:"",word:"", kana:"",  index:0,  miss:0, time:0};
        lastType = {typed:"", miss:0, time:0};
        
        
        typingWindows = new Vector.<TypingWindow>();
        target = new Vector.<Object>();
        hint = new Vector.<Object>();
        
        while(numChildren>0){removeChildAt(0);}
        
        setWordList(wordList);
        
        play = false;
    }

    
    
    
    
    //タイピングを一時停止します
    public function stop():void{
        play = false;
        
        removeEventListener(Event.ENTER_FRAME,onEnterFrame);
        stage.removeEventListener("keyDown", onKeyDown);
    }
    
    //タイピングを開始します
    public function start():void{
        play = true;
        
        lastTime = getTimer()/1000;
        addEventListener(Event.ENTER_FRAME,onEnterFrame);
        stage.addEventListener("keyDown", onKeyDown);
    }
    
    public function onKeyDown(e:KeyboardEvent):void{
        if(e.keyCode < 16 || e.keyCode > 18){
            type(String.fromCharCode(e.charCode));
        }
    }
    
    
    private function back():void{
        for(var i:int=0;i<target.length;i++){
            if(match(target[i].kana,typed) == typed.length){
                var preffered:String = preferredRoman(target[i].kana,typed);    
                typingWindows[i].romanField.text = preffered;
                typingWindows[i].on();
                if(typed != ""){typingWindows[i].typed = typed;}
            }else{
                typingWindows[i].romanField.text = firstRoman(target[i].kana);
            }
        }
    }
    
    public function onEnterFrame(e:Event):void{
        var t:Number = getTimer()/1000;
        time += t - lastTime;
        lastTime = t;
        
    }
    
    
    
    
    public function Typing(){
            reset();
            
            
            romanList = new Vector.<Array>(4); //かなとローマ字の変換表
           //候補1------------------------------------------------------------
        romanList[0] = new Array();
        
        romanList[0]["ー"] = "-";
        romanList[0]["。"] = ".";
        romanList[0]["、"] = ",";
        romanList[0]["？"] = "?";
        romanList[0]["！"] = "!";
        romanList[0]["　"] = " ";
        romanList[0]["あ"] = "a";
        romanList[0]["い"] = "i";
        romanList[0]["う"] = "u";
        romanList[0]["え"] = "e";
        romanList[0]["お"] = "o";
        romanList[0]["か"] = "ka";
        romanList[0]["き"] = "ki";
        romanList[0]["く"] = "ku";
        romanList[0]["け"] = "ke";
        romanList[0]["こ"] = "ko";
        romanList[0]["さ"] = "sa";
        romanList[0]["し"] = "si";
        romanList[0]["す"] = "su";
        romanList[0]["せ"] = "se";
        romanList[0]["そ"] = "so";
        romanList[0]["な"] = "na";
        romanList[0]["に"] = "ni";
        romanList[0]["ぬ"] = "nu";
        romanList[0]["ね"] = "ne";
        romanList[0]["の"] = "no";
        romanList[0]["た"] = "ta";
        romanList[0]["ち"] = "ti";
        romanList[0]["つ"] = "tu";
        romanList[0]["て"] = "te";
        romanList[0]["と"] = "to";
        romanList[0]["は"] = "ha";
        romanList[0]["ひ"] = "hi";
        romanList[0]["ふ"] = "fu";
        romanList[0]["へ"] = "he";
        romanList[0]["ほ"] = "ho";
        romanList[0]["ま"] = "ma";
        romanList[0]["み"] = "mi";
        romanList[0]["む"] = "mu";
        romanList[0]["め"] = "me";
        romanList[0]["も"] = "mo";
        romanList[0]["や"] = "ya";
        romanList[0]["ゆ"] = "yu";
        romanList[0]["いぇ"] = "ye";
        romanList[0]["よ"] = "yo";
        romanList[0]["ら"] = "ra";
        romanList[0]["り"] = "ri";
        romanList[0]["る"] = "ru";
        romanList[0]["れ"] = "re";
        romanList[0]["ろ"] = "ro";
        romanList[0]["わ"] = "wa";
        romanList[0]["ゐ"] = "wi";
        romanList[0]["ゑ"] = "we";
        romanList[0]["を"] = "wo";
        romanList[0]["が"] = "ga";
        romanList[0]["ぎ"] = "gi";
        romanList[0]["ぐ"] = "gu";
        romanList[0]["げ"] = "ge";
        romanList[0]["ご"] = "go";
        romanList[0]["ざ"] = "za";
        romanList[0]["じ"] = "ji";
        romanList[0]["ず"] = "zu";
        romanList[0]["ぜ"] = "ze";
        romanList[0]["ぞ"] = "zo";
        romanList[0]["だ"] = "da";
        romanList[0]["ぢ"] = "di";
        romanList[0]["づ"] = "du";
        romanList[0]["で"] = "de";
        romanList[0]["ど"] = "do";
        romanList[0]["ば"] = "ba";
        romanList[0]["び"] = "bi";
        romanList[0]["ぶ"] = "bu";
        romanList[0]["べ"] = "be";
        romanList[0]["ぼ"] = "bo";
        romanList[0]["ぱ"] = "pa";
        romanList[0]["ぴ"] = "pi";
        romanList[0]["ぷ"] = "pu";
        romanList[0]["ぺ"] = "pe";
        romanList[0]["ぽ"] = "po";
        romanList[0]["ぁ"] = "la";
        romanList[0]["ぃ"] = "li";
        romanList[0]["ぅ"] = "lu";
        romanList[0]["ぇ"] = "le";
        romanList[0]["ぉ"] = "lo";
        romanList[0]["ゃ"] = "lya";
        romanList[0]["ゅ"] = "lyu";
        romanList[0]["ょ"] = "lyo";
        romanList[0]["ゎ"] = "lwa";
        romanList[0]["っ"] = "ltu";
        romanList[0]["ヵ"] = "lka";
        romanList[0]["ヶ"] = "lke";
        romanList[0]["きゃ"] = "kya";
        romanList[0]["きぃ"] = "kyi";
        romanList[0]["きゅ"] = "kyu";
        romanList[0]["きぇ"] = "kye";
        romanList[0]["きょ"] = "kyo";
        romanList[0]["しゃ"] = "sya";
        romanList[0]["しぃ"] = "syi";
        romanList[0]["しゅ"] = "syu";
        romanList[0]["しぇ"] = "sye";
        romanList[0]["しょ"] = "syo";
        romanList[0]["ちゃ"] = "tya";
        romanList[0]["ちぃ"] = "tyi";
        romanList[0]["ちゅ"] = "tyu";
        romanList[0]["ちぇ"] = "tye";
        romanList[0]["ちょ"] = "tyo";
        romanList[0]["にゃ"] = "nya";
        romanList[0]["にぃ"] = "nyi";
        romanList[0]["にゅ"] = "nyu";
        romanList[0]["にぇ"] = "nye";
        romanList[0]["にょ"] = "nyo";
        romanList[0]["ひゃ"] = "hya";
        romanList[0]["ひぃ"] = "hyi";
        romanList[0]["ひゅ"] = "hyu";
        romanList[0]["ひぇ"] = "hye";
        romanList[0]["ひょ"] = "hyo";
        romanList[0]["みゃ"] = "mya";
        romanList[0]["みぃ"] = "myi";
        romanList[0]["みゅ"] = "myu";
        romanList[0]["みぇ"] = "mye";
        romanList[0]["みょ"] = "myo";
        romanList[0]["りゃ"] = "rya";
        romanList[0]["りぃ"] = "ryi";
        romanList[0]["りゅ"] = "ryu";
        romanList[0]["りぇ"] = "rye";
        romanList[0]["りょ"] = "ryo";
        romanList[0]["ぎゃ"] = "gya";
        romanList[0]["ぎぃ"] = "gyi";
        romanList[0]["ぎゅ"] = "gyu";
        romanList[0]["ぎぇ"] = "gye";
        romanList[0]["ぎょ"] = "gyo";
        romanList[0]["じゃ"] = "ja";
        romanList[0]["じぃ"] = "zyi";
        romanList[0]["じゅ"] = "ju";
        romanList[0]["じぇ"] = "je";
        romanList[0]["じょ"] = "jo";
        romanList[0]["ぢゃ"] = "dya";
        romanList[0]["ぢぃ"] = "dyi";
        romanList[0]["ぢゅ"] = "dyu";
        romanList[0]["ぢぇ"] = "dye";
        romanList[0]["ぢょ"] = "dyo";
        romanList[0]["びゃ"] = "bya";
        romanList[0]["びぃ"] = "byi";
        romanList[0]["びゅ"] = "byu";
        romanList[0]["びぇ"] = "bye";
        romanList[0]["びょ"] = "byo";
        romanList[0]["ぴゃ"] = "pya";
        romanList[0]["ぴぃ"] = "pyi";
        romanList[0]["ぴゅ"] = "pyu";
        romanList[0]["ぴぇ"] = "pye";
        romanList[0]["ぴょ"] = "pyo";
        romanList[0]["うぁ"] = "wa";
        romanList[0]["うぃ"] = "wi";
        romanList[0]["うぇ"] = "we";
        romanList[0]["うぉ"] = "wo";
        romanList[0]["ヴぁ"] = "va";
        romanList[0]["ヴぃ"] = "vi";
        romanList[0]["ヴ"] = "vu";
        romanList[0]["ヴぇ"] = "ve";
        romanList[0]["ヴぉ"] = "vo";
        romanList[0]["ヴゃ"] = "vya";
        romanList[0]["ヴゅ"] = "vyu";
        romanList[0]["ヴょ"] = "vyo";
        romanList[0]["てゃ"] = "tha";
        romanList[0]["てぃ"] = "thi";
        romanList[0]["てゅ"] = "thu";
        romanList[0]["てぇ"] = "the";
        romanList[0]["てょ"] = "tho";
        romanList[0]["ふぁ"] = "fa";
        romanList[0]["ふぃ"] = "fi";
        romanList[0]["ふぅ"] = "fwu";
        romanList[0]["ふぇ"] = "fe";
        romanList[0]["ふぉ"] = "fo";
        romanList[0]["ふゃ"] = "fya";
        romanList[0]["ふゅ"] = "fyu";
        romanList[0]["ふょ"] = "fyo";
        romanList[0]["でゃ"] = "dha";
        romanList[0]["でぃ"] = "dhi";
        romanList[0]["でゅ"] = "dhu";
        romanList[0]["でぇ"] = "dhe";
        romanList[0]["でょ"] = "dho";
        romanList[0]["くぁ"] = "qa";
        romanList[0]["くぃ"] = "qi";
        romanList[0]["くぅ"] = "qwu";
        romanList[0]["くぇ"] = "qe";
        romanList[0]["くぉ"] = "qo";
        romanList[0]["くゃ"] = "qya";
        romanList[0]["くゅ"] = "qyu";
        romanList[0]["くょ"] = "qyo";
        romanList[0]["すぁ"] = "swa";
        romanList[0]["すぃ"] = "swi";
        romanList[0]["すぅ"] = "swu";
        romanList[0]["すぇ"] = "swe";
        romanList[0]["すぉ"] = "swo";
        romanList[0]["ぐぁ"] = "gwa";
        romanList[0]["ぐぃ"] = "gwi";
        romanList[0]["ぐぅ"] = "gwu";
        romanList[0]["ぐぇ"] = "gwe";
        romanList[0]["ぐぉ"] = "gwo";
        romanList[0]["どぁ"] = "dwa";
        romanList[0]["どぃ"] = "dwi";
        romanList[0]["どぅ"] = "dwu";
        romanList[0]["どぇ"] = "dwe";
        romanList[0]["どぉ"] = "dwo";
        romanList[0]["とぁ"] = "twa";
        romanList[0]["とぃ"] = "twi";
        romanList[0]["とぅ"] = "twu";
        romanList[0]["とぇ"] = "twe";
        romanList[0]["とぉ"] = "two";
        romanList[0]["つぁ"] = "tsa";
        romanList[0]["つぃ"] = "tsi";
        romanList[0]["つぇ"] = "tse";
        romanList[0]["つぉ"] = "tso";
        romanList[0]["ん"] = "nn";
    //候補2------------------------------------------------------------
        romanList[1] = new Array();
        
        romanList[1]["い"] = "yi";
        romanList[1]["う"] = "wu";
        romanList[1]["うぁ"] = "wha";
        romanList[1]["うぃ"] = "whi";
        romanList[1]["うぇ"] = "whe";
        romanList[1]["うぉ"] = "who";
        romanList[1]["う"] = "wu";
        romanList[1]["か"] = "ca";
        romanList[1]["く"] = "cu";
        romanList[1]["こ"] = "co";
        romanList[1]["くぃ"] = "qwi";
        romanList[1]["くぅ"] = "qwu";
        romanList[1]["くぇ"] = "qwe";
        romanList[1]["くぉ"] = "qwo";
        romanList[1]["くぁ"] = "kwa";
        romanList[1]["くぃ"] = "qwi";
        romanList[1]["くぅ"] = "qwu";
        romanList[1]["くぇ"] = "qwe";
        romanList[1]["くぉ"] = "qwo";
        romanList[1]["しゃ"] = "sha";
        romanList[1]["し"] = "shi";
        romanList[1]["しゅ"] = "shu";
        romanList[1]["しぇ"] = "she";
        romanList[1]["しょ"] = "sho";
        romanList[1]["せ"] = "ce";
        romanList[1]["じ"] = "zi";
        romanList[1]["じゃ"] = "zya";
        romanList[1]["じぃ"] = "jyi";
        romanList[1]["じゅ"] = "zyu";
        romanList[1]["じぇ"] = "zye";
        romanList[1]["じょ"] = "zyo";
        romanList[1]["ちゃ"] = "cha";
        romanList[1]["ち"] = "chi";
        romanList[1]["ちぃ"] = "cyi";
        romanList[1]["ちゅ"] = "chu";
        romanList[1]["ちぇ"] = "che";
        romanList[1]["ちょ"] = "cho";
        romanList[1]["つ"] = "tsu";
        romanList[1]["ふ"] = "hu";
        romanList[1]["ふぁ"] = "fwa";
        romanList[1]["ふぃ"] = "fwi";
        romanList[1]["ふぇ"] = "fwe";
        romanList[1]["ふぉ"] = "fwo";
        romanList[1]["ぁ"] = "xa";
        romanList[1]["ぃ"] = "xi";
        romanList[1]["ぅ"] = "xu";
        romanList[1]["ぇ"] = "xe";
        romanList[1]["ぉ"] = "xo";
        romanList[1]["ゃ"] = "xya";
        romanList[1]["ゅ"] = "xyi";
        romanList[1]["ょ"] = "xyu";
        romanList[1]["ゎ"] = "xwa";
        romanList[1]["っ"] = "ltsu";
        romanList[0]["ヵ"] = "xka";
        romanList[0]["ヶ"] = "xke";
    //候補3------------------------------------------------------------
        romanList[2] = new Array();
        romanList[2]["う"] = "whu";
        romanList[2]["し"] = "ci";
        romanList[2]["くぁ"] = "qwa";
        romanList[2]["くぃ"] = "qyi";
        romanList[2]["くぇ"] = "qye";
        romanList[2]["じゃ"] = "jya";
        romanList[2]["じゅ"] = "jyu";
        romanList[2]["じぇ"] = "jye";
        romanList[2]["じょ"] = "jyo";
        romanList[2]["ちゃ"] = "cya";
        romanList[2]["ちゅ"] = "cyu";
        romanList[2]["ちぇ"] = "cye";
        romanList[2]["ちょ"] = "cyo";
        romanList[2]["ふぃ"] = "fyi";
        romanList[2]["ふぇ"] = "fye";
        romanList[2]["ふぉ"] = "fwo";
        romanList[2]["ぃ"] = "lyi";
        romanList[2]["ぇ"] = "lye";
    //候補4------------------------------------------------------------
        romanList[3] = new Array();
        romanList[3]["ぃ"] = "xyi";
        romanList[3]["ぇ"] = "xye";
        
        //一文字目になるひらがな表
        var beforetse1:Array = [
                "あ","い","う","え","お",
                "か","き","く","け","こ",
                "さ","し","す","せ","そ",
                "た","ち","つ","て","と",
                "は","ひ","ふ","へ","ほ",
                "ま","み","む","め","も",
                "や","ゆ","よ",
                "わ","ゐ","う","ヱ","を","ん",
                "ら","り","る","れ","ろ",
                "が","ぎ","ぐ","げ","ご",
                "ざ","じ","ず","ぜ","ぞ",
                "だ","ぢ","づ","で","ど",
                "ば","び","ぶ","べ","ぼ",
                "ぱ","ぴ","ぷ","ぺ","ぽ","ヴ",
                "ゃ","ゅ","ょ","ゎ",
                "ぁ","ぃ","ぅ","ぇ","ぉ",
                "！","？","。","、","　"
                ];

        var beforetse2:Array = ["","ゃ","ゅ","ょ",
                "ぁ","ぃ","ぅ","ぇ","ぉ"
                ];
        
        //連続すると「っ」になるアルファベット　
        var tse:Array =["q","w","r","t","y","p","s","d","f","g","h","j","k","l","z","x","c","v","b","m"];
        
    
        //直前にn 1つで「ん」になるアルファベット
        var nn:Array =["q","w","r","t","p","s","d","f","g","h","j","k","l","z","x","c","v","b","m","!","?",".",","," "];
 
         //「っ」の付く候補作成
        for(var i:int = 0;i < beforetse1.length;i++){    
            for(var j:int = 0;j < beforetse2.length;j++){
                for(var k:int = 0;k < 4;k++){
                    var ok1:Boolean = false;
                    if( romanList[k][ beforetse1[i]+beforetse2[j] ] !=undefined){
                        for(var n:int=0;n<tse.length;n++){
                            if(romanList[k][ beforetse1[i]+beforetse2[j] ].substring(0,1) == tse[n]){ok1 = true;}
                        }
                    }
                    if( ok1 ){
                        romanList[k][ "っ"+beforetse1[i]+beforetse2[j] ] = romanList[k][ beforetse1[i]+beforetse2[j] ].substr(0,1) + romanList[k][ beforetse1[i]+beforetse2[j] ];
                    }
        
                    var ok2:Boolean = false;
                    if( romanList[k][ beforetse1[i]+beforetse2[j] ] !=undefined){
                        for(n=0;n<tse.length;n++){
                            if(romanList[k][ beforetse1[i]+beforetse2[j] ].substring(0,1) == nn[n]){ok2 = true;}
                        }
                    }
                    if( ok2 ){
                        romanList[k][ "ん"+beforetse1[i]+beforetse2[j] ] = "n" + romanList[k][ beforetse1[i]+beforetse2[j] ];
                    }
                    if( ok1 && ok2 ){
                        romanList[k][ "ん"+"っ"+beforetse1[i]+beforetse2[j] ] = "n" + romanList[k][ beforetse1[i]+beforetse2[j] ].substr(0,1) + romanList[k][ beforetse1[i]+beforetse2[j] ];
                    }
                }
            }
        }
        
        //半角文字
        for(i=32;i<127;i++){
            romanList[0][String.fromCharCode(i)] = String.fromCharCode(i);
        }
        
        
        }
}




class TypingEvent extends Event{
    public var time :Number;        //タイプにかかった時間
    
    public var typed:String;        //タイプされた文字列
    public var miss :int;        //ミスタイプの数
    
    
    public var word :String;        //タイプされた単語
    public var kana :String;        //タイプされたかな
    public var index :String;    //タイプされた単語の番号
    
    
    static public var TYPE_WORD :String = "typeWord";    //タイプされたかな
    static public var TYPE :String = "type";                //タイプされた単語の番号
    public function TypingEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false,
                                    timeValue:Number = 0, typedValue:String = "", missValue:int = 0,
                                    wordValue:String="", kanaValue:String = "", indexValue:String = ""
                                ):void{
        super( type , bubbles , cancelable);
        time = timeValue;
        typed = typedValue;
        miss = missValue;
        
        word = wordValue;
        kana = kanaValue;
        index = indexValue;
    }
}