/**
 * Copyright shapevent ( http://wonderfl.net/user/shapevent )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4DIs
 */

package {

	import flash.display.*;
	import flash.events.*;


	[SWF(width = 500, height=500, backgroundColor=0x000000)]

       public class NonsenseClocks extends MovieClip {
		private var clockNum:int;
		private var clocks:Vector.<Function>;
		private var clockContainer:Sprite;


               public function NonsenseClocks(){
                  // init
			clockNum = 100;
			clocks = new Vector.<Function>(clockNum, true);
			clockContainer = Sprite(addChild(new Sprite()));
			clockContainer.x = stage.stageWidth / 2;
			clockContainer.y = stage.stageHeight / 2;
			buildClocks();
			runClocks();
			

                       
               }
               // private methods

		private function buildClocks():void{
			for (var i:int = 0; i<clockNum; i++){
				var theta:Number = Math.random() * Math.PI * 2;
				var radius:Number = Math.random() * 200;
				var xp:Number = radius * Math.cos(theta);
				var yp:Number = radius * Math.sin(theta);
				clocks[i] = makeClock(xp,yp,Math.random() * Math.PI * 2);
			}
		}
		private function runClocks():void{
			addEventListener(Event.ENTER_FRAME, onRunClocks);
		}
		private function onRunClocks(evt:Event):void{
			for (var i:int = 0; i<clockNum; i++){
				clocks[i]();
			}
			clockContainer.rotationX = clockContainer.mouseY / 30;
			clockContainer.rotationY = -clockContainer.mouseX / 30;
		}
		private function makeClock(x:Number, y:Number, time:Number=0):Function{
			var radius:Number = Math.random() * 20 + 5;
			var border:Number = radius * 0.2;
			var smallRadius:Number = radius - radius * 0.3;
			var clock:Sprite = Sprite(clockContainer.addChild(new Sprite()));
			clock.x = x;
			clock.y = y;
			clock.z = 100 - Math.random() * 200;
			clock.rotationX = Math.random() * 40 - 20;
			clock.rotationY = Math.random() * 40 - 20;
			clock.rotationZ = Math.random() * 360;

			return function():void{
				with (clock.graphics){
					clear();
					lineStyle(1,0xFFFFFF);
					drawCircle(0,0,radius + border);
					x = smallRadius * Math.cos(time/2);
					y = smallRadius * Math.sin(time/2);
					moveTo(0,0);
					lineTo(x, y);
					x = radius * Math.cos(time);
					y = radius * Math.sin(time);
					moveTo(0,0);
					lineTo(x, y);
				}
				time+=0.1;
			}
		}
		

       }

}