/**
 * Copyright qbo ( http://wonderfl.net/user/qbo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4D7N
 */

// forked from hacker_9vjnvtdz's GYAOS_sample
/**
 * Copyright hacker_9vjnvtdz ( http://wonderfl.net/user/hacker_9vjnvtdz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f6f2
 */

/*
    attak
*/

package 
{
    import caurina.transitions.Tweener;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.Timer;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.ui.Mouse;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class Main extends MovieClip
    {
        private var _turn:Boolean = true;
        public function get turn ():Boolean { return _turn; }
        public function set turn (value:Boolean):void
        {
            _turn = value;
            _commandView.mode =
            _clickCursor.mode = _turn;
        }
        
        private var _loader:Loader;
        private var _hpView:HpView;
        private var _bg:Loader;
        private var _commandView:CommandView;
        private var _blinkTimer:Timer;
        private var _filter:Sprite;
        private var _statusTf:TextField;
        private var _clickCursor:ClickCursor;
        
        private var _chara1:Character = new PlayerCharacter;
        private var _chara2:Character = new NonPlayerCharacter;
        
        function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            Mouse.hide();
            
            _blinkTimer = new Timer(50, 10);
            
            _bg = new Loader;
            _bg.load(new URLRequest(SkinPath.BACKGROUND));
            addChild(_bg);
            
            var context:LoaderContext = new LoaderContext(true);
            _loader = new Loader;
            _loader.load(new URLRequest(SkinPath.MONSTER), context);
            addChild(_loader);
            
            _commandView = new CommandView(_chara1, _chara2);
            _commandView.y = stage.stageHeight - 100;
            addChild(_commandView);
            
            _hpView = new HpView(_chara1, _chara2);
            addChild(_hpView);
            
            _filter = new Sprite;
            _filter.graphics.beginFill(0x000000, 1);
            _filter.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            _filter.graphics.endFill();
            _filter.alpha = 0;
            addChild(_filter);
            
            var format:TextFormat = new TextFormat;
            format.color = "0xffffff";
            format.font = "_sans";
            format.size = 40;
            format.align = "center";
            
            _statusTf = new TextField;
            _statusTf.selectable = false;
            _statusTf.defaultTextFormat = format;
            _statusTf.y = 200;
            _statusTf.width = 465;
            _statusTf.text = "Game Over";
            _filter.addChild(_statusTf);
            
            _clickCursor = new ClickCursor;
            addChild(_clickCursor);
            
            turn = true;
            
            _blinkTimer.addEventListener(TimerEvent.TIMER, 
            function (e:TimerEvent):void
            {
                _loader.visible = (_blinkTimer.currentCount % 2== 1) ? false : true;
            } );
            
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE,
            function(e:Event):void
            {
                _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, arguments.callee);
                _loader.x = stage.stageWidth/2 - _loader.width/2;
                _loader.y = stage.stageHeight/2 - _loader.height/2 - 40;
            } );
            
            _commandView.addEventListener(CommandView.COMBO_COUNT_END,
            function(e:Event):void
            {
                Tweener.addTween( { }, { delay:0.5, onComplete:
                function():void {
                    if (_turn)
                    {
                        atcPlayer();
                    }
                    else
                    {
                        atcNonPlayer();
                    }
                    turn = !turn;
                } } );    
            } );
            
            _commandView.addEventListener(CommandView.ATTACK_CLICK,
            function(e:Event):void
            {
                _clickCursor.mode = false;
            } );
            
            addEventListener(Event.ENTER_FRAME, 
            function (e:Event):void
            {
                _clickCursor.x = mouseX;
                _clickCursor.y = mouseY;
            } );
            
            
        }
        
        private function atcPlayer():void
        {
            var target:Character = _chara2;
            
            target.currentHp -= Lib.attack(40, 40, _commandView.combo);
            
            if (target.currentHp < 1)
            {
                target.currentHp = 0;
                _loader.visible = false;
                _commandView.roulette(true);
                _statusTf.text = "You Win !";
                _clickCursor.visible = false;
                Tweener.addTween(_filter, { delay:2, alpha:1, time:2 } );
            }
            else
            {
                _blinkTimer.reset();
                _blinkTimer.start();
            }
            _hpView.update();
        }
            
        private function atcNonPlayer():void
        {
            var target:Character = _chara1;
            
            target.currentHp -= Lib.attack(40, 40, _commandView.combo);
            
            if (target.currentHp < 1)
            {
                target.currentHp = 0;
                _commandView.roulette(true);
                _statusTf.text = "Game Over ...";
                _clickCursor.visible = false;
                Tweener.addTween(_filter, { delay:2, alpha:1, time:2 } );
            }
            else
            {
                var timer:Timer = new Timer(50, 10);
                timer.addEventListener(TimerEvent.TIMER, 
                function (e:TimerEvent):void
                {
                    var pos:Array =
                    [
                        _hpView.y + 10, _hpView.y - 10,
                        _commandView.y + 10, _commandView.y - 10
                    ];
                    
                    if (timer.currentCount % 2== 1)
                    {
                        _hpView.y = pos[0];
                        _commandView.y = pos[2];
                    }
                    else
                    {
                        _hpView.y = pos[1];
                        _commandView.y = pos[3];
                    }
                } );
                timer.start();
            }
            _hpView.update();
        }
    }
}

import caurina.transitions.Tweener;
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.display.Loader;
import flash.display.Shape;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.utils.Timer;
import flash.net.URLRequest;

final class SkinPath
{
    //public static const MONSTER:String = "http://assets.wonderfl.net/images/related_images/6/6d/6d2a/6d2aac9165308e05d07f52232f99bfe9d52a06fb"
    public static const MONSTER:String = "http://assets.wonderfl.net/images/related_images/9/9a/9a67/9a674310835d956620db269594b14241d8c079ba"
    //public static const MONSTER:String = "http://assets.wonderfl.net/images/related_images/5/57/5728/5728bb5057da70c62a2bff824fac59cf139bcb44"
    
    public static const BACKGROUND:String = "http://assets.wonderfl.net/images/related_images/f/f2/f2c4/f2c485ad993ddac1e0d528d6c905b6c0349951da";
    public static const BAR:String = "http://assets.wonderfl.net/images/related_images/3/38/384d/384dff5908315fd8d47079e0458b5f153dc9b1a0"; 
    public static const BAR_SPACE_L:String = "http://assets.wonderfl.net/images/related_images/c/c5/c530/c5305ae6b0ca97d87b989bc6c22d50f2d09a67f5";
    public static const BAR_SPACE_R:String = "http://assets.wonderfl.net/images/related_images/3/39/39ae/39ae39536a5b27a8020b8687ffdef82b24742f57";
    
    public static const COMMAND_VIEW_BG:String = "http://assets.wonderfl.net/images/related_images/d/dc/dcc5/dcc55b2404bc880be802e9515829e69e6c6ea896";
    
    public static const COMMAND_BALL_1:String = "http://assets.wonderfl.net/images/related_images/6/64/648b/648b8c30fbc551881cf1ce21b573da809d92018a";
    public static const COMMAND_BALL_2:String = "http://assets.wonderfl.net/images/related_images/d/d2/d27d/d27d4b59d6fb0132ebd6ed6a28390a0c0b5ef84c";
    public static const COMMAND_BALL_3:String = "http://assets.wonderfl.net/images/related_images/1/11/1134/113475b745a7838bf26f909f00429795827cb833";
    public static const COMMAND_BALL_4:String = "http://assets.wonderfl.net/images/related_images/c/cf/cfaf/cfaf512be52b2c441f5eeee16dcd65b51ad3e0be";
    
    public static const COMBO_A_1:String = "http://assets.wonderfl.net/images/related_images/4/4f/4f40/4f40bf2621faa791d59900be37589b68b30d010a";
    public static const COMBO_A_2:String = "http://assets.wonderfl.net/images/related_images/5/52/5299/52999904f7dd1494d9b57c8b5e82392914eb93f0";
    public static const COMBO_A_3:String = "http://assets.wonderfl.net/images/related_images/6/6e/6e5e/6e5e6974a253f55d47d3f33052a71e85647224ff";
    public static const COMBO_A_4:String = "http://assets.wonderfl.net/images/related_images/f/f1/f199/f199f047e98cfdbb7ec8e2a7c7396f389cce9ed3";
    public static const COMBO_A_5:String = "http://assets.wonderfl.net/images/related_images/2/2a/2ace/2ace1c6d1a11068f5e5ca795dd1f58a474141ef6";
    public static const COMBO_A_6:String = "http://assets.wonderfl.net/images/related_images/c/cf/cf91/cf91a624bc5b5b8653a7aac087429026e713899b";
    public static const COMBO_A_7:String = "http://assets.wonderfl.net/images/related_images/c/c2/c213/c213687a041e02584ef596de2e89212de0c99111";
    public static const COMBO_B_1:String = "http://assets.wonderfl.net/images/related_images/7/7f/7f03/7f03201a5613b1f08d0ada04464fb87a6a80ba53";
    public static const COMBO_B_2:String = "http://assets.wonderfl.net/images/related_images/8/8c/8cef/8cefbfc5add91d107907fa1abd4c80e23975b673";
    public static const COMBO_B_3:String = "http://assets.wonderfl.net/images/related_images/d/dc/dc44/dc44ca24859ee6dbef77410d9174cb7a50bbd4e0";
    public static const COMBO_B_4:String = "http://assets.wonderfl.net/images/related_images/3/35/3528/35282f113a4cc6239764b84b2aabb533f985b945";
    public static const COMBO_B_5:String = "http://assets.wonderfl.net/images/related_images/7/7b/7b14/7b144676411639c9ca04748a94bdb50f4eed5727";
    public static const COMBO_B_6:String = "http://assets.wonderfl.net/images/related_images/0/0b/0b10/0b10da40b4407fa294f6c853d065432af60c68ea";
    public static const COMBO_B_7:String = "http://assets.wonderfl.net/images/related_images/6/66/66bb/66bb20ff3ae56ec294d63c3ef349707fef6e01a3";
    
    public static const CURSOR_A:String = "http://assets.wonderfl.net/images/related_images/b/b0/b023/b023093e3d74ac16676d0fde00598130358d6009";
    public static const CURSOR_B:String = "http://assets.wonderfl.net/images/related_images/2/2b/2b27/2b27fb60109a906fe880cf2a128065079a2609db";
    
    public static const COMMAND_LIST_BG_A:String = "http://assets.wonderfl.net/images/related_images/7/79/79df/79df81c3eb1ead143408f584d81b1e2a395cc643";
    public static const COMMAND_LIST_BG_B:String = "http://assets.wonderfl.net/images/related_images/9/94/9478/9478092c9457783f43a9c1794b2e79759601fcb2";
}

class Core extends Sprite
{
    protected var _container:Sprite;
    
    protected var _mode:Boolean = true;
    public function get mode (): Boolean { return _mode; }
    public function set mode (value:Boolean):void
    {
        _mode = value;
    }
    
    function Core ():void
    {
        _container = new Sprite;
        addChild(_container);
    }
}

class CommandView extends Core
{    
    public static const SLIDE_END:String = "slideEnd";
    public static const COMBO_COUNT:String = "comboCount";
    public static const COMBO_COUNT_END:String = "comboCountEnd";
    public static const ATTACK_CLICK:String = "attackClick";
    
    private var _chara1:Character;
    private var _chara2:Character;
    
    private var _isBattleEnd:Boolean = false;
    private var _length:int = 12;
    private var _speed:Number = 0.2;
    private var _transition:String = "linear";
    private var _comboCounting:Boolean = false;
    
    private var _loader:Loader;
    private var _comboView:ComboView;
    private var _commandList:CommandListView;
    private var _cursor:CommandBallCursor;
    private var _filter:Shape;
    private var _turnTf:TextField;
    
    public function get combo ():int { return _comboView.combo; }
    
    override public function set mode (value:Boolean):void
    {
        super.mode = value;
        _cursor.mode = 
        _comboView.mode = 
        _commandList.mode = value;
        
        _turnTf.text = ((_mode) ? _chara1.name : _chara2.name );
        
        if (!_isBattleEnd)
        {
            roulette();
        }
    }
    
    function CommandView (chara1:Character, chara2:Character):void
    {
        _chara1 = chara1;
        _chara2 = chara2;
        
        _loader = new Loader;
        _loader.load(new URLRequest(SkinPath.COMMAND_VIEW_BG));
        _loader.y = -19;
        addChildAt(_loader,0);
        
        compAddBall();
        
        var ball:CommandBall = getBallAt(0);
        _filter = new Shape;
        _filter.alpha = 0;
        _filter.graphics.beginFill(0x000000, 0.2);
        _filter.graphics.drawRect(0, 0, 465, ball.height);
        addChild(_filter);
        
        var containerMask:Shape = new Shape;
        containerMask.graphics.beginFill(0);
        containerMask.graphics.drawRect(0, 0, 465, ball.height);
        addChild(containerMask);
        _container.mask = containerMask;
        
        _comboView = new ComboView;
        _comboView.y = -160;
        addChild(_comboView);
        
        _cursor = new CommandBallCursor;
        _cursor.visible = false;
        addChild(_cursor);
        
        _commandList = new CommandListView(_chara1,_chara2);
        _commandList.x = 465 / 2 - 454/2;
        _commandList.y = 60;
        addChild(_commandList);
        
        var format:TextFormat = new TextFormat;
        format.color = "0xffffff";
        format.font = "_sans";
        format.size = 14;
        format.bold = true;
        format.align = "right";
        
        _turnTf = new TextField;
        _turnTf.defaultTextFormat = format;
        _turnTf.y = -20;
        _turnTf.width = 465;
        addChild(_turnTf);
        
        addEventListener(SLIDE_END,
        function(e:Event):void
        {
            compAddBall();
            checkColor();
        } );
        
        addEventListener(COMBO_COUNT_END,
        function(e:Event):void
        {
            _comboCounting = false;
        } );
    }
    
    private function addBallAt (index:int=-1):CommandBall
    {    
        if (index == -1)
        {
            index = _container.numChildren;
        }
        
        var ball:CommandBall = new CommandBall;
        ball.x = ball.width * index;
        _container.addChildAt(ball, index);
        
        if (index > 0)
        {
            var pball:CommandBall = getBallAt(index - 1);
            ball.setOtherColor(pball.color);
        }
        slide();
        
        return ball;
    }
    
    private function removeBallAt (index:int):void
    {    
        _container.removeChildAt(index);
        slide();
    }
    
    private function getBallAt(index:int):CommandBall
    {
        return _container.getChildAt(index) as CommandBall;
    }
    
    private function compAddBall ():void
    {
        var len:int = _length - _container.numChildren;
        if (len > 0)
        {
            for (var i:int = 0; i < len; i++)
            {
                addBallAt();
            }
        }
    }
    
    private function slide ():void
    {
        sortIndex();
        
        Tweener.removeAllTweens();
        
        var loop:int = 0;
        for (var i:int = 0, len:int = _container.numChildren; i < len; i++)
        {
            var ball:CommandBall = (getBallAt(i) as CommandBall);
            Tweener.addTween(ball, {
                x: ball.width * i, 
                time: _speed,
                transition: _transition,
                onComplete: function():void
                {
                    loop++;
                    if (_container.numChildren == loop)
                    {
                        dispatchEvent(new Event(SLIDE_END));
                    }
                }
            });
        }
    }
    
    private function checkColor ():void
    {    
        if (_container.numChildren < 2)
        {
            return; 
        }
        
        var isCommonColor:Boolean;
        for (var i:int = 0, len:int = _container.numChildren - 1; i < len; i++)
        {
            var ball:CommandBall = getBallAt(i);
            var ballR:CommandBall = getBallAt(i + 1);
            
            if (ball.color == ballR.color)
            {    
                isCommonColor = true;
                
                var timer:Timer = new Timer(100, 5);
                timer.addEventListener(TimerEvent.TIMER, 
                function(e:TimerEvent):void
                {
                    ball.visible = !ball.visible;
                    ballR.visible = !ballR.visible;
                } );
                timer.addEventListener(TimerEvent.TIMER_COMPLETE, 
                function(e:TimerEvent):void
                {
                    timer.reset();
                    try
                    {
                        _container.removeChild(ball);
                        _container.removeChild(ballR);
                        
                        slide();
                        
                        setCombo(_comboView.combo + 1, ball.url);
                    }
                    catch (e:Error)
                    {
                        
                    }
                } );
                timer.start();
                break;
            }
            else
            {
                isCommonColor = false;
            }
        }
        
        if (!isCommonColor && _comboCounting)
        {
            dispatchEvent(new Event(COMBO_COUNT_END));
        }
    }
    
    private function sortIndex ():void
    {
        var arr:Array = [];
        for (var i:int = 0, len:int = _container.numChildren; i < len; i++)
        {
            arr[i] = getBallAt(i);
        }
        
        arr.sortOn("x", Array.NUMERIC);
        
        for (i = 0, len = arr.length; i < len; i++)
        {
            var ball:CommandBall = arr[i];
            _container.setChildIndex(ball, i);
        }
    }
    
    private function setCombo (comboCount:int, url:String, reset:Boolean=false):void
    {
        _comboCounting = true;
        
        _comboView.x = (_mode) ? 0 : 340;
        
        _comboView.combo = comboCount;
        _comboView.render();
        if (reset)
        {
            _comboView.reset();
        }
        _comboView.addCommand(url);
        
    }
    
    public function roulette (stop:Boolean=false):void
    {        
        // RESET -
        var lastIndex:int = _length - 2;
        var index:int = 0;
        var loop:int = (_mode) ? 0 : lastIndex;
        _cursor.x = (_mode) ? 0 : _cursor.width * lastIndex;
        _cursor.visible = true;
        
        Tweener.addTween(_filter, { alpha:1, time:_speed } );
        
        // ACTION -
        if (_mode)
        {
            stage.addEventListener(MouseEvent.CLICK,
            function(e:MouseEvent):void
            {
                stage.removeEventListener(MouseEvent.CLICK, arguments.callee);
                timer.reset();
                
                index = loop - 1;
                Tweener.addTween( { }, { delay:_speed, onComplete:selectCommandBall } );
                Tweener.addTween(_filter, { alpha:0, time:1 } );
                
                dispatchEvent(new Event(ATTACK_CLICK));
            } );
        }
        else
        {
            var actTimer:Timer = new Timer( Lib.random(1000, 3000), 1);
            actTimer.addEventListener(TimerEvent.TIMER, 
            function(e:TimerEvent):void
            {
                actTimer.removeEventListener(TimerEvent.TIMER, arguments.callee);
                actTimer.reset();
                timer.reset();
                
                index = loop + 1//- 1;
                Tweener.addTween( { }, { delay:_speed, onComplete:selectCommandBall } );
                Tweener.addTween(_filter, { alpha:0, time:1 } );
            } );
            actTimer.start();
        }
        
        // CURSOR MOVE -
        var timer:Timer = new Timer(35, 0);
        timer.addEventListener(TimerEvent.TIMER,
        function(e:TimerEvent):void
        {
            if (_mode)
            {
                if (loop >= _length - 1)
                {
                    loop = 0;
                }
                _cursor.x = _cursor.width * loop;
                loop++;
            }
            else
            {
                if (loop < 0)
                {
                    loop = lastIndex;
                }
                _cursor.x = _cursor.width * loop;
                loop--;
            }
        } );
        if (!stop)
        {
            timer.start();
        }
        else
        {
            _isBattleEnd = true;
            _cursor.visible = false;
        }
        
        function selectCommandBall ():void
        {
            _cursor.visible = false;
            var ball:CommandBall = getBallAt(index);
            removeBallAt(index);
            addBallAt();
            setCombo(1, ball.url, true);
        }
    }
}

class CommandBallCursor extends Core
{
    private var _loaderA:Loader;
    private var _loaderB:Loader;
    
    override public function set mode (value:Boolean):void
    {
        _mode = value;
        
        if (_mode)
        {
            _loaderA.visible = true;
            _loaderB.visible = false;
        }
        else
        {
            _loaderA.visible = false;
            _loaderB.visible = true;
        }
    }
    
    function CommandBallCursor ():void
    {
        _loaderA = new Loader;
        _loaderA.load(new URLRequest(SkinPath.CURSOR_A));
        addChild(_loaderA);
        
        _loaderB = new Loader;
        _loaderB.load(new URLRequest(SkinPath.CURSOR_B));
        addChild(_loaderB);
    }
}

class CommandBall extends Core
{    
    public var color:String;
    private var _radius:Number = 20;
    private var _colorPattern:Array =
    [
        SkinPath.COMMAND_BALL_1,
        SkinPath.COMMAND_BALL_2,
        SkinPath.COMMAND_BALL_3,
        SkinPath.COMMAND_BALL_4
    ];
    
    private var _loader:Loader;
    private var _ur:URLRequest;
    
    public function get url ():String { return _loader.contentLoaderInfo.url; }
    
    function CommandBall ():void
    {
        graphics.drawCircle(_radius, _radius, _radius);
        graphics.endFill();
        
        _ur = new URLRequest;
        _loader = new Loader;
        addChild(_loader);
        
        getRandomColor();
        render();
    }
    
    public function setOtherColor(nonSelectColor:String):String
    {
        while (nonSelectColor == color)
        {
            getRandomColor();
        }
        render();
        return color;
    }
    
    private function getRandomColor ():String
    {
        color = _colorPattern[ Lib.random(0, _colorPattern.length) ];
        return color;
    }
    
    private function render ():void
    {
        _ur.url = color;
        _loader.load(_ur);
    }
}

class CommandListView extends Core
{
    private var _chara1:Character;
    private var _chara2:Character;
    
    private var _commandList1:Loader;
    private var _commandList2:Loader;
    private var _commandTf1:TextField;
    private var _commandTf2:TextField;
    private var _commandTf3:TextField;
    private var _commandTf4:TextField;
    
    override public function set mode (value:Boolean):void
    {
        super.mode = value;
        
        if (_mode)
        {
            _commandList1.visible = true;
            _commandList2.visible = false;
            _commandTf1.text = _chara1.commands.cmd1.name;
            _commandTf2.text = _chara1.commands.cmd2.name;
            _commandTf3.text = _chara1.commands.cmd3.name;
            _commandTf4.text = _chara1.commands.cmd4.name;
        }
        else
        {
            _commandList1.visible = false;
            _commandList2.visible = true;
            _commandTf1.text = _chara2.commands.cmd1.name;
            _commandTf2.text = _chara2.commands.cmd2.name;
            _commandTf3.text = _chara2.commands.cmd3.name;
            _commandTf4.text = _chara2.commands.cmd4.name;
        }
    }
    
    function CommandListView (chara1:Character, chara2:Character):void
    {
        _chara1 = chara1;
        _chara2 = chara2;
        
        _commandList1 = new Loader;
        _commandList1.load(new URLRequest(SkinPath.COMMAND_LIST_BG_A));
        _commandList1.visible = false;
        addChild(_commandList1);
        
        _commandList2 = new Loader;
        _commandList2.load(new URLRequest(SkinPath.COMMAND_LIST_BG_B));
        _commandList2.visible = false;
        addChild(_commandList2);
        
        var format:TextFormat = new TextFormat;
        format.color = 0xffffff;
        format.font = "_sans";
        format.align = "center";
        
        _commandTf1 = new TextField;
        _commandTf1.defaultTextFormat = format;
        _commandTf1.x = 25;
        _commandTf1.y = 12;
        addChild(_commandTf1);
        _commandTf2 = new TextField;
        _commandTf2.defaultTextFormat = format;
        _commandTf2.x = 135;
        _commandTf2.y = 12;
        addChild(_commandTf2);
        _commandTf3 = new TextField;
        _commandTf3.defaultTextFormat = format;
        _commandTf3.x = 245;
        _commandTf3.y = 12;
        addChild(_commandTf3);
        _commandTf4 = new TextField;
        _commandTf4.defaultTextFormat = format;
        _commandTf4.x = 355;
        _commandTf4.y = 12;
        addChild(_commandTf4);
    }
}

class ComboView extends Core
{
    public static const COMBO_INVISBLE:String = "comboInvisble";
    
    public var combo:int = 1;
    private var _speed:Number = 0.2;
    
    private var _loader:Loader = new Loader;
    private var _ur:URLRequest = new URLRequest;
    private var _timer:Timer = new Timer(1000, 0);
    
    private var images:Array =
    [
        SkinPath.COMBO_A_1,
        SkinPath.COMBO_A_2,
        SkinPath.COMBO_A_3,
        SkinPath.COMBO_A_4,
        SkinPath.COMBO_A_5,
        SkinPath.COMBO_A_6,
        SkinPath.COMBO_A_7,
        
        SkinPath.COMBO_B_1,
        SkinPath.COMBO_B_2,
        SkinPath.COMBO_B_3,
        SkinPath.COMBO_B_4,
        SkinPath.COMBO_B_5,
        SkinPath.COMBO_B_6,
        SkinPath.COMBO_B_7
    ];
    
    override public function set mode (value:Boolean):void
    {
        _mode = value;
    }
    
    function ComboView ():void
    {
        addChild(_loader);
        
        render();
        this.visible = false;
    }
    
    public function addCommand (url:String):void
    {
        var loader:Loader = new Loader;
        loader.load(new URLRequest(url));
        loader.x = (_mode) ? 20 * _container.numChildren : 75 - (20 * _container.numChildren);
        loader.y = 60;
        _container.addChild(loader);
    }
    
    public function reset (): void
    {
        for (var i:int = 0, len:int = _container.numChildren; i < len; i++)
        {
            _container.removeChildAt(0);
        }
    }
    
    public function render ():void
    {
        var scope:Sprite = this;
        scope.visible = true;
        
        _ur.url = (_mode) ? images[combo - 1] : images[combo - 1 + images.length/2];
        _loader.load(_ur);
        _loader.x = (_mode) ? -100 : 100;
        Tweener.addTween(_loader, { x: 0, time: _speed } );
        
        _timer.reset();
        _timer.addEventListener(TimerEvent.TIMER,
        function(e:TimerEvent):void
        {
            _timer.removeEventListener(TimerEvent.TIMER, arguments.callee);
            scope.visible = false;
            reset();
            
            dispatchEvent(new Event(COMBO_INVISBLE));
        } );
        _timer.start();
    }
}

class HpView extends Core
{
    private var _nameL:TextField;
    private var _nameR:TextField;
    private var _hpL:TextField;
    private var _hpR:TextField;
    private var _bar:Loader;
    private var _barL:HpBarView;
    private var _barR:HpBarView;
    private var _chara1:Character;
    private var _chara2:Character;
    
    private var txColor:int = 0xffffff;
    private var txFont:String = "_sans";
    
    public function HpView (chara1:Character, chara2:Character):void
    {
        _chara1 = chara1;
        _chara2 = chara2;
        
        _barL = new HpBarView(SkinPath.BAR_SPACE_L, HpBarView.HP_BAR_LEFT);
        _barL.x = 20;
        _barL.y = 34;
        addChild(_barL);

        _barR = new HpBarView(SkinPath.BAR_SPACE_R, HpBarView.HP_BAR_RIGHT);
        _barR.x = 259;
        _barR.y = 34;
        addChild(_barR);
        
        _bar = new Loader;
        _bar.load(new URLRequest(SkinPath.BAR));
        addChild(_bar);
        
        var format1:TextFormat = new TextFormat;
        format1.color = txColor;
        format1.font = txFont;
        
        _nameL = new TextField;
        _nameL.defaultTextFormat = format1;
        _nameL.text = _chara1.name;
        _nameL.x = 110;
        _nameL.y = 11;
        addChild(_nameL);
        
        _hpL = new TextField;
        _hpL.defaultTextFormat = format1;
        _hpL.text = "HP: " + String(_chara1.currentHp);
        _hpL.x = 30;
        _hpL.y = 11;
        addChild(_hpL);
        
        var format2:TextFormat = new TextFormat;
        format2.color = txColor;
        format2.font = txFont;
        format2.align = "right";
        
        _hpR = new TextField;
        _nameR = new TextField;
        _nameR.defaultTextFormat = format2;
        _nameR.text = _chara2.name;
        _nameR.x = 250;
        _nameR.y = 11;
        addChild(_nameR);
        
        _hpR.text = String(_chara2.currentHp);
        _hpR.defaultTextFormat = format2;
        _hpR.text = "HP: " + String(_chara2.currentHp);
        _hpR.x = 330;
        _hpR.y = 11;
        addChild(_hpR);
        
        update();
        
        _bar.contentLoaderInfo.addEventListener(Event.COMPLETE, 
        function (e:Event):void
        {
            _bar.x = stage.stageWidth / 2 - _bar.width / 2;
            _bar.y = 10;
        });
    }
    
    public function update ():void
    {
        _barL.update(_chara1.currentHp / _chara1.maxHp);
        _barR.update(_chara2.currentHp / _chara2.maxHp);
        _hpL.text = "HP: " + String(_chara1.currentHp);
        _hpR.text = "HP: " + String(_chara2.currentHp);
    }
}

class HpBarView extends Core
{
    public static const HP_BAR_LEFT:String = 'hpBarLeft';
    public static const HP_BAR_RIGHT:String = 'hpBarRight';
    
    private var _bar:Loader;
    private var _mask:Shape;
    private var _direction:String;
    
    public function HpBarView (url:String, direction:String):void
    {    
        _direction = direction;
        if (
            _direction != HP_BAR_LEFT && 
            _direction != HP_BAR_RIGHT
        ){
            _direction = HP_BAR_LEFT;
        }
        
        _mask = new Shape;
        addChild(_mask);
        
        _bar = new Loader;
        _bar.contentLoaderInfo.addEventListener(Event.COMPLETE,
        function(e:Event):void
        {
            _mask.graphics.beginFill(0);
            _mask.graphics.drawRect(0,0,_bar.width,_bar.height);
            _mask.graphics.endFill();
            _bar.mask = _mask;
        });
        _bar.load(new URLRequest(url));
        addChild(_bar);
    }
    
    public function update (scale:Number):void
    {
        animate(scale);
    }
    
    private function animate (scale:Number):void
    {
        var size:Number = _bar.width * scale;
        var offset:Number = size - _mask.width;
        var divide:Number = 30;
        var one:Number = offset / divide;
        var i:uint = 0;
        var timer:Timer = new Timer(1);
        
        timer.addEventListener(TimerEvent.TIMER, 
        function(e:TimerEvent):void{
            var w:Number = _mask.width + one;
            
            if (_direction == HP_BAR_LEFT)
            {
                _mask.graphics.clear();
                _mask.graphics.beginFill(0);
                _mask.graphics.drawRect(0,0,w,_bar.height);
                _mask.graphics.endFill();
            }
            else if (_direction == HP_BAR_RIGHT)
            {
                _mask.graphics.clear();
                _mask.graphics.beginFill(0);
                _mask.graphics.drawRect(_bar.width-w,0,w,_bar.height);
                _mask.graphics.endFill();
            }
            else
            {
                // DON'T USE -
            }
            i++;
            
            if (i > divide)
            {
                timer.reset();
                timer.removeEventListener(TimerEvent.TIMER, arguments.callee);
            }
        });
        timer.start();
    }
}

class ClickCursor extends Core
{
    private var _clickTf:TextField;
    
    override public function set mode (value:Boolean):void
    {
        super.mode = value;
        
        if (_mode)
        {
            alpha = 1;
            _clickTf.text = "[click]";
        }
        else
        {
            alpha = 0.5;
            _clickTf.text = "wait...";
        }
    }
    
    function ClickCursor ():void
    {
        graphics.beginFill(0xffffff);
        graphics.drawCircle(0, 0, 10);
        graphics.endFill();
        
        var format:TextFormat = new TextFormat;
        format.color = 0xffffff;
        format.size = 14;
        format.font = "_sans";
        format.bold = "true";
            
        _clickTf = new TextField;
        _clickTf.defaultTextFormat = format;
        _clickTf.x = 10;
        _clickTf.y = -10;
        _clickTf.selectable = false;
        addChild(_clickTf);
        
        mode = true;
    }
}

class Character extends EventDispatcher
{
    public var name:String;
    public var skin:String;
    
    public var commands:Commands;
    
    public var maxHp:int = 500;
    public var currentHp:int = maxHp;
}

class Commands
{
    public var cmd1:Command;
    public var cmd2:Command;
    public var cmd3:Command;
    public var cmd4:Command;
}

class Command
{
    public var name:String;
}

class PlayerCharacter extends Character
{    
    function PlayerCharacter ():void
    {
        name = "Player";
        commands = new Commands;
        commands.cmd1 = new Command;
        commands.cmd1.name = "カミツク";
        commands.cmd2 = new Command;
        commands.cmd2.name = "ハナデワラウ";
        commands.cmd3 = new Command;
        commands.cmd3.name = "オドリクルウ";
        commands.cmd4 = new Command;
        commands.cmd4.name = "シッポヲフル";
    }
}

class NonPlayerCharacter extends Character
{
    function NonPlayerCharacter ():void
    {
        name = "Non Player";
        skin = SkinPath.MONSTER;
        commands = new Commands;
        commands.cmd1 = new Command;
        commands.cmd1.name = "クビヲノバス";
        commands.cmd2 = new Command;
        commands.cmd2.name = "カミツク";
        commands.cmd3 = new Command;
        commands.cmd3.name = "タイアタリ";
        commands.cmd4 = new Command;
        commands.cmd4.name = "スルドイキバ";
    }
}

class Lib
{
    public static function random (min:Number = 0, max:Number = 0):Number
    {
        return Math.floor(Math.random() * max) + min;
    }
    
    public static function attack (min:Number = 0, max:Number = 0, combo:int = 0):Number
    {
        return Lib.random(min, max) * (combo / 10 + 1);
    }
}
