/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Cui
 */

// forked from kousho's 3DTube
// forked from kousho29's SpiralTube
package 
{
    import flash.display.GraphicsPathCommand;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.Point;
    import flash.geom.Vector3D;

    public class Tube3D extends Sprite 
    {
        private static var DIST:Number = 300;
        private static var WIND_CNT:int = 5;
        private static var WIND_DIV:int = 100;
        private static var WIND_RADIUS:int = 100;
        private static var WIND_INTERVAL:int = 60;
        private static var RING_DIV:int = 10;
        private static var RING_RADIUS:int = 10;
        private static var MAX_POINT_COUNT:int = 100;
        
        private var CENTER_X:Number = stage.stageWidth / 2;
        private var CENTER_Y:Number = stage.stageHeight / 2;
        
        private var pointsArray:/*Vector3D*/Array;
        private var viewRotX:Number = 0;
        private var viewRotY:Number = 0;
        
        public function Tube3D() 
        {
            pointsArray = new Array();
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        public function updateWire():void
        {
            if(pointsArray.length > MAX_POINT_COUNT) pointsArray.shift();
            var x:Number = mouseX - CENTER_X;
            var y:Number = mouseY - CENTER_Y;
            var z:Number = 0;
            
            var point:Vector3D = new Vector3D(x, y, z);
            pointsArray.push(point);
        }
        
        private function enterFrameHandler(event:Event):void 
        {
            graphics.clear();
            updateWire();
            viewRotX = (mouseX - stage.stageWidth / 2) / 20;
            viewRotY = - (mouseY - stage.stageHeight / 2) / 20;
            for (var cnt:int = 0; cnt < pointsArray.length; cnt++) pointsArray[cnt] = rotatePoint(pointsArray[cnt], viewRotX, viewRotY);
            drawTube(pointsArray);
        }
        
        private function drawTube(points:/*Vector3D*/Array):void
        {
            draw3DLines(points);
        }
        
        private function draw3DLines(points:/*Vector3D*/Array):void
        {
            var lineData:Vector.<Number> = new Vector.<Number>;
            var commands:Vector.<int> = new Vector.<int>;
            
            
            for (var cnt:int = 0; cnt < points.length; cnt++)
            {
                var point:Vector3D = get2DPoint(points[cnt]);
                graphics.lineStyle(5 * point.z, 0xcccccc);
                
                if (cnt == 0)
                    graphics.moveTo(point.x, point.y);
                else
                    graphics.lineTo(point.x, point.y);
            }
        }
        
        //private function getRingPointArray(point:Vector3D, radius:Number, tanVec:Vector3D):void
        //{
            //var points:/*Vector3D*/Array;
        //}
        
        private function get2DPoint(point3D:Vector3D):Vector3D
        {
            var viewScale:Number = DIST / (DIST + point3D.z);
            var x:Number = point3D.x * viewScale + CENTER_X;
            var y:Number = point3D.y * viewScale + CENTER_Y;
            return new Vector3D(x, y, viewScale);
        }
        
        private function rotatePoint(point3D:Vector3D, xrot:Number, yrot:Number):Vector3D
        {
            var matrix:Matrix3D = new Matrix3D();
            matrix.appendRotation(xrot, Vector3D.Y_AXIS);
            matrix.appendRotation(yrot, Vector3D.X_AXIS);
            var vec:Vector3D = matrix.transformVector(point3D);
            return vec;
        }
        
        
    }
}