/**
 * Copyright hycro ( http://wonderfl.net/user/hycro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Cmv
 */

// forked from hycro's Project Euler #009
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    
    public class ProjectEuler extends Sprite {
		private var _textField:TextField;
       
        public function ProjectEuler() {
        		initialize();
        		writeAnswer(new Problem010);
        }
        
        private function writeAnswer(problem:AbstructProblem):void {
        		var answer:String = problem.getAnswer();
        		 _textField.appendText(answer);
        }
        
        private function initialize():void {
        	    _textField = new TextField();
            _textField.width = stage.stageWidth;
            _textField.height = stage.stageHeight;
            addChild(_textField);
        }
    }
}

class AbstructProblem {
	final public function getAnswer():String {
		var answer:String;
		try {
			answer = solve().toString();
		} catch (err:Error) {
			answer = err.name + " : " + err.message;
		}
		return answer;
	}
	
	protected function solve():Number {
		throw new Error("unsolved");
	}
}

class Problem010 extends AbstructProblem {
	override protected function solve():Number {
		var answer:Number;
		var sequence:Vector.<uint> = getPrimeList(2000000);
		
		answer = 0;
		for each (var prime:uint in sequence) {
			answer += prime;
		}
		
		return answer;
	}
	
	private function getPrimeList(limit:uint):Vector.<uint> {
		var sequence:Vector.<uint> = new Vector.<uint>(limit);
		
		for (var i:uint = 2; i < limit; i++) {
			sequence[i] = i;
		}
		
		for (i=2; i < limit; i++) {
			if (sequence[i]) {
				for (var j:uint = i+i; j < limit; j+=i) {
					sequence[j] = 0;
				}
			}
		}
		
		var primeList:Vector.<uint> = new Vector.<uint>();
		for (i=2; i < limit; i++) {
			if (sequence[i]) {
				primeList.push(i);
			}
		}
		
		return primeList;
	}
}

class Utils {
	// 整数値の桁数の取得
	static public function disits(n:Number, radix:uint=10):Number {
		var d:Number = 0;
		
		n = Math.abs(n);
		while (n / radix != 0) {
			n = Math.floor(n / radix);
			d++;
		}
		
		return d;
	}
	
	// 指定した桁の値を取得
	static public function numberAt(n:Number, digit:Number, radix:Number=10):Number {
		var number:Number;
		
		while (--digit) {
			n = Math.floor(n / radix);
		}
		
		return n % radix
	}
}