/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Cge
 */

package {
    import flash.display.*;
    import flash.events.*;
//    import flash.utils.*;
    public class FlashTest extends Sprite {
		private var matters:Array;
		private var time:int;
		private function atEveryFrame(e:Event):void {
  	  		var m:Matter;
  	  		for each ( m in matters ) {
  	  			m.move();
  	  		}
   	 		while ( ( matters.length > 0 )&&( matters[0].scaleX < 0.02 ) ) {
   	 			this.removeChild(matters.shift());
    			}
    			if ( (++time)%10 == 0 ) {
    				var n:Matter = new Matter();
    				this.addChild(n);
    				n.locate();
    				matters.push(n);
    			}
   		}
		private function initialize(e:Event):void {
			time = 0;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			this.graphics.clear();
			this.graphics.beginFill(0xffffff);
			this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
			this.graphics.endFill();
        		matters = new Array;
            stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
		}
        public function FlashTest() {
        		if ( stage == null ) {
        			this.addEventListener(Event.ADDED_TO_STAGE, initialize);
        		} else {
        			initialize(null);
        		}
        }
    }
}

import flash.display.Shape;

class Matter extends Shape {
	private const theta:Number = Math.PI/180*6;
	private const A:Number = Math.cos(theta);
	private const B:Number = Math.sin(theta);
	private const R:Number = 0.97;
	private var qX:Number;
	private var qY:Number;
	public function locate():void {
		this.x = stage.stageWidth/2 + qX;
		this.y = stage.stageHeight/2 + qY;
	}
	public function move():void {
		var newX:Number = R*(qX*A-qY*B);
		var newY:Number = R*(qX*B+qY*A);
		qX = newX;
		qY = newY;
		this.scaleX *= R;
		this.scaleY *= R;
		locate();
	}
	public function Matter() {
		if ( stage != null ) {
			qX = (Math.random()*2-1)*stage.stageWidth/2
			qY = (Math.random()*2-1)*stage.stageHeight/2;
		} else {
			qX = (Math.random()*2-1)*232.5;
			qY = (Math.random()*2-1)*232.5;
		}
		var cc:uint;
		cc = (Math.floor(Math.random()*255.99)<<16)|(Math.floor(Math.random()*255.99)<<8)|(Math.floor(Math.random()*255.99));
		this.graphics.clear();
		this.graphics.lineStyle(NaN);
		this.graphics.beginFill(cc);
		this.graphics.drawCircle(0,0,80);
		this.graphics.drawCircle(0,0,60);
		this.graphics.endFill();
	}
}