/**
 * Copyright klh ( http://wonderfl.net/user/klh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4CZG
 */

// forked from klh's Bubble Sort
package {
    import flash.display.Sprite;
    
    [SWF(backgroundColor="#1C1C1C", frameRate=60)]
    public class FlashTest extends Sprite {
        private var _array:VisualizedArray;
        private var _start:int;
        private var _end:int;
        private var _index:int;
        
        public function FlashTest() {
            // write as3 code here..
            _array = new VisualizedArray();
            addChild(_array);
            
            for (var i:int = 0; i < 20; i++) {
                var u:VisualizedUnit = new VisualizedUnit(Math.floor(Math.random() * 128));
                _array.addChild(u);
            }
            
            _array.x = (stage.stageWidth - _array.width) / 2;
            _array.y = (stage.stageHeight - _array.height) / 2;
            
            var step:int = 0;
            for(i = 0; i < _array.length; ++i) {
                for(var j:int = 1; j < _array.length - i; ++j) {
                    var current:int = _array.getValueByIndex(j - 1);
                    var next:int = _array.getValueByIndex(j);
                    _array.select(j - 1);
                    _array.select(j);
                    _array.step += 1;
                    _array.deselect(j - 1);
                    _array.deselect(j);
                    _array.step += 1;
                    if (current < next) {
                        _array.swap(j - 1, j);
                        _array.step += 1;
                    }
                }
            }
        }
    }
}

import flash.text.TextField;
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.*;
import caurina.transitions.properties.FilterShortcuts;
FilterShortcuts.init();

import caurina.transitions.Tweener;
Tweener.autoOverwrite = false;

internal class VisualizedUnit extends Shape {
    public static var RADIUS:int = 10;
    private var _value:int;
    
    public function VisualizedUnit(v:int) {
        if (v >= 128) v = 127;
        if (v < 0) v = 0;
        _value = v;
        
        draw();
    }

    public function draw():void {
        graphics.beginFill(0x000100 * _value + 0xFF7700);
        graphics.drawCircle(VisualizedUnit.RADIUS, VisualizedUnit.RADIUS, VisualizedUnit.RADIUS);
        graphics.endFill();
    }

    public function destory():void {
        graphics.clear();
    }
    
    public function set value(v:int):void {
        _value = v;
        draw();
    }

    public function get value():int {
        return _value;
    }

}

    
internal class VisualizedArray extends Sprite {
    private static var SWAP_TIME:Number = 0.2;
    private var _step:int;
    private var _array:Array;
    private var _filterIn:GlowFilter;
    private var _filterOut:GlowFilter;

    public function VisualizedArray() {
        _step = 0;
        _array = [];
        _filterIn = new GlowFilter(0xFF0000, 1, VisualizedUnit.RADIUS/2, VisualizedUnit.RADIUS/2, VisualizedUnit.RADIUS/2, 1, true);
        _filterOut = new GlowFilter(0xFF0000, 0, VisualizedUnit.RADIUS/2, VisualizedUnit.RADIUS/2, VisualizedUnit.RADIUS/2, 1, true);
    }

    public function destory():void {
        for(var i:int = 0; i < _array.length; i++) {
            VisualizedUnit(_array[i]).destory();
        }
        _array = null;
    }
    
    public override function addChild(o:DisplayObject):DisplayObject {
        var ret:DisplayObject = super.addChild(o);
        if (o is VisualizedUnit) {
            o.x = _array.length * VisualizedUnit.RADIUS * 2;
            _array.push(o);
        }
        return ret;
    }
    
    public function get length():int {
        return _array.length;
    }
    
    public function getValueByIndex(index:int):int {
        return (_array[index] as VisualizedUnit).value;
    }
    
    public function get step():int {
        return _step;
    }
    
    public function set step(s:int):void {
        _step = s;
    }
    
    public function select(index:int):void {
        if (index >= _array.length) index = _array.length - 1;
        if (index < 0) index = 0;
        
        var tmp:VisualizedUnit = _array[index] as VisualizedUnit;
        Tweener.addTween(tmp, {_filter: _filterIn, time: SWAP_TIME, delay: SWAP_TIME * _step});
    }
    
    public function deselect(index:int):void {
        if (index >= _array.length) index = _array.length - 1;
        if (index < 0) index = 0;
        
        var tmp:VisualizedUnit = _array[index] as VisualizedUnit;
        Tweener.addTween(tmp, {_filter: _filterOut, time: SWAP_TIME, delay: SWAP_TIME * _step});
    }
    
    public function swap(from:int, to:int):void {
        if (from >= _array.length) from = _array.length - 1;
        if (from < 0) from = 0;
        if (to >= _array.length) to = _array.length - 1;
        if (to < 0) to = 0;
        
        var tmp:Object = _array[from];
        _array[from] = _array[to];
        _array[to] = tmp;
        
        Tweener.addTween(_array[to], {
            x: to * VisualizedUnit.RADIUS * 2,
            delay: SWAP_TIME * _step,
            time: SWAP_TIME,
            transition: "easeInOutSine"
        });
        Tweener.addTween(_array[to], {
            y: -1 * VisualizedUnit.RADIUS,
            delay: SWAP_TIME * _step,
            time: SWAP_TIME / 2,
            transition: "easeOutSine"
        });
        Tweener.addTween(_array[to], {
            y: 0,
            delay: SWAP_TIME * _step + SWAP_TIME / 2,
            time: SWAP_TIME / 2,
            transition: "easeInSine"
        });
        
        Tweener.addTween(_array[from], {
            x: from * VisualizedUnit.RADIUS * 2,
            delay: SWAP_TIME * _step,
            time: SWAP_TIME,
            transition: "easeInOutSine"
        });
        Tweener.addTween(_array[from], {
            y: VisualizedUnit.RADIUS,
            delay: SWAP_TIME * _step,
            time: SWAP_TIME / 2,
            transition: "easeOutSine"
        });
        Tweener.addTween(_array[from], {
            y: 0,
            delay: SWAP_TIME * _step + SWAP_TIME / 2,
            time: SWAP_TIME / 2,
            transition: "easeInSine"
        });
    }
}