/**
 * Copyright Jacky.Riawan ( http://wonderfl.net/user/Jacky.Riawan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4BLZ
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.Timer;
    /**
     * ...
     * @author Jacky Riawan
     */
    public class Main extends Sprite 
    {
        private const ukigumoFrame1:Array = [[0, 0, 1, 1, 1, 1, 1, 1, 0, 1],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 1],
                                            [1, 1, 1, 0, 1, 1, 0, 1, 1, 1],
                                            [1, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [1, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 0, 0, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 0, 0, 0, 0]];
        private const ukigumoFrame2:Array = [[1, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [1, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [1, 1, 1, 0, 1, 1, 0, 1, 1, 1],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 1],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 1],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 0, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 0, 0, 0, 1, 0, 0, 0]];
        private const ukigumoHit:Array = [[1, 0, 1, 1, 1, 1, 1, 1, 0, 1],
                                            [1, 0, 1, 1, 1, 1, 1, 1, 0, 1],
                                            [1, 1, 1, 0, 1, 1, 0, 1, 1, 1],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 1, 1, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 0, 0, 0, 1, 0, 0, 0]];
        private const ukigumoWin:Array = [[1, 0, 1, 1, 1, 1, 1, 1, 0, 1],
                                            [1, 0, 1, 1, 1, 1, 1, 1, 0, 1],
                                            [1, 1, 1, 0, 1, 1, 0, 1, 1, 1],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 1, 1, 1, 1, 1, 1, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0],
                                            [0, 0, 0, 1, 0, 0, 1, 0, 0, 0]];
        private var bitmapData:BitmapData
        private const SCALING:int = 4;
        private var ukigumoSprites:Array = [];
        private var ukigumoFrame:int = 0;
        private var ukiJump:int = 0;
        private var ukiPoint:Point = new Point();
        private var step:int = 0;
        private var mouseIsDown:Boolean = false;
        private var fillRect:Rectangle;
        private var obstacleRect:Rectangle = new Rectangle(0, 0, 10, 10);
        private var obstacles:Array = new Array();
        private var obstacleTimer:int = 0;
        private var damageTimer:int = 0;
        private var gameSpeed:int = 10;
        private var gameSpeedMax:int = 10;
        private var timeElapsed:int = 0;
        private var loader:Loader = new Loader();
        private const END:int = 138;
        private var baseColor:uint = 0xFFFFFFFF;
        private var bgColor:uint = 0xFF000000;
        public function Main():void 
        {
            renderBitmap(ukigumoFrame1, ukigumoSprites);
            renderBitmap(ukigumoFrame2, ukigumoSprites);
            renderBitmap(ukigumoHit, ukigumoSprites);
            renderBitmap(ukigumoWin, ukigumoSprites);
            bitmapData = new BitmapData(stage.stageWidth / SCALING, stage.stageHeight / SCALING);            
            var screen:Bitmap=new Bitmap(bitmapData)
            addChild(screen);
            fillRect = new Rectangle(0, 0, bitmapData.width, bitmapData.height / 2 + 11);
            obstacleRect.y = bitmapData.height/2+1;
            screen.scaleX = screen.scaleY = SCALING;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            update(null);
            timeElapsed = 0;
            Security.allowDomain("www.youtube.com");            
            loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
            loader.load(new URLRequest("http://www.youtube.com/v/hrew1qwH2oU?version=3"));
        }
        private function onLoaderInit(e:Event):void 
        {
            loader.content.addEventListener("onReady", onPlayerReady);
            loader.contentLoaderInfo.removeEventListener(Event.INIT, onLoaderInit);
        }
        private function onPlayerReady(e:Event):void 
        {
            stage.frameRate=60;
            addEventListener(Event.ENTER_FRAME, update);
            Object(loader.content).loadVideoById("hrew1qwH2oU", 0, "small");
            var timer:Timer = new Timer(1000);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
        }        
        private function timerHandler(e:TimerEvent):void 
        {
            timeElapsed++;
        }
        private function mouseDownHandler(e:MouseEvent):void 
        {
            if(ukiJump==0){
                mouseIsDown = true;
            }
        }
        private function renderBitmap(data:Array, target:Array):void {
            var sprite:BitmapData = new BitmapData(data[0].length, data.length,true,0x00000000);
            for (var _y:int = 0; _y < data.length; _y++) {
                for (var _x:int = 0; _x < data[_y].length; _x++) {
                    sprite.setPixel32(_x, _y, data[_y][_x]*0xFFFFFFFF);
                }
            }
            target.push(sprite);
        }
        private function normalColor():void {
            bgColor = 0xFF000000;
            baseColor = 0xFFFFFFFF;
        }
        private function swapColor():void {
            var r:int = Math.random() * 255;
            var g:int = Math.random() * 255;
            var b:int = Math.random() * 255;
            var bg_r:int = r +(255 - r) / 2;
            var bg_g:int = g +(255 - g) / 2;
            var bg_b:int = b +(255 - b) / 2;
            var bs_r:int = (255-r) / 2;
            var bs_g:int = (255-g) / 2;
            var bs_b:int = (255-b) / 2;
            baseColor = 255 << 24 | bg_r << 16 | bg_g << 8 | bg_b;
            bgColor = 255 << 24 | bs_r << 16 | bs_g << 8 | bs_b;
        }
        private function updateUkigumo():void {
            var jumpOffset:int = obstacleRect.height+3;
            if (timeElapsed >= END) {
                if (step % 2 == 0) {
                    jumpOffset = 3;
                }else {
                    jumpOffset = 0;
                }
                ukigumoFrame = 3;
            }else if(damageTimer<=0){
                if(step%2==0){
                    ukigumoFrame =(ukigumoFrame + 1) % 2;
                }
            }else {
                ukigumoFrame = 2;
            }            
            if (ukiJump == 0) {
                if (timeElapsed < END) {
                    if (mouseIsDown) {
                            mouseIsDown = false;
                            ukiJump = 30;
                    }else {
                        jumpOffset = 0;
                    }
                }
            }
            ukiPoint.x = bitmapData.width * .3;
            ukiPoint.y = bitmapData.height / 2-jumpOffset;            
        }
        private function renderObstacles():void {
            for (var i:int = 0; i < obstacles.length; i++) {
                if (obstacles[i] <= -40) {
                    obstacles.splice(i, 1);
                    i--;
                }else {
                    if(timeElapsed< END){
                        obstacles[i] = obstacleRect.x = obstacles[i] - 10;
                        if (ukiJump == false) {
                            if(damageTimer==0){
                                if (Math.abs(ukiPoint.x+2-obstacleRect.x)<=5) {
                                    damageTimer = 35;
                                }
                            }
                        }
                    }
                }
            }
            if(timeElapsed< END){
                if (obstacleTimer == 0) {
                    obstacles.push(bitmapData.width + obstacleRect.width);
                    obstacleTimer = 40 + Math.random() * 50;
                }else {
                    obstacleTimer--;
                }
            }
        }
        private function blitScreen():void {
            bitmapData.lock();
            fillRect.y = 0;
            bitmapData.fillRect(fillRect, bgColor);
            fillRect.y = bitmapData.height / 2+11;
            bitmapData.fillRect(fillRect, baseColor);
            for (var i:int = 0; i < obstacles.length; i++) {
                obstacleRect.x = obstacles[i];
                bitmapData.fillRect(obstacleRect, baseColor);
            }
            bitmapData.copyPixels(ukigumoSprites[ukigumoFrame], ukigumoSprites[ukigumoFrame].rect, ukiPoint,null,null,true);
            bitmapData.unlock();
        }
        private function update(e:Event):void 
        {
            if(gameSpeed==0){
                updateUkigumo();
                renderObstacles();
                blitScreen();
                step++;
                gameSpeed = gameSpeedMax;
            }else {
                gameSpeed--;
            }
            if (damageTimer > 0) {
                if(damageTimer%8==0){
                    bitmapData.paletteMap(bitmapData, bitmapData.rect, new Point(), null, [0], [0]);
                }
                damageTimer--;
            }
            if (ukiJump > 0) {
                ukiJump--;
                if (ukiJump == 0) {
                    ukiPoint.y = bitmapData.height / 2
                    blitScreen();
                }
            }
            switch(timeElapsed) {
                case 14:
                    gameSpeedMax = 8;
                    break;
                case 16:
                    gameSpeedMax = 7;
                    break;
                case 21:
                    gameSpeedMax = 6;
                    break;
                case 22:
                    gameSpeedMax = 3;
                    break;
                case 32:
                    swapColor();
                    gameSpeedMax = 1;
                    break;
                case 43:
                    normalColor();
                    gameSpeedMax = 4;
                    break;
                case 54:
                    swapColor();
                    gameSpeedMax = 2;
                    break;
                case 64:
                    normalColor();
                    gameSpeedMax = 7;
                    break;
                case 75:
                    swapColor();
                    gameSpeedMax = 1;
                    break;
                case 81:
                    swapColor();
                    gameSpeedMax = 0;
                    break;
                case 86:
                    normalColor();
                    gameSpeedMax = 7;
                    break;
                case 88:
                    gameSpeedMax = 4;
                    break;
                case 90:
                    gameSpeedMax = 8;
                    break;
                case 91:
                    swapColor();
                    gameSpeedMax = 0;
                    break;
                case 107:
                    swapColor();
                    gameSpeedMax = 1;
                    break;
                case 109:
                    gameSpeedMax = 2;
                    break;
                case 110:
                    swapColor();
                    gameSpeedMax = 0;
                    break;
                case 130:
                    normalColor();
                    gameSpeedMax = 10;
                    break;
                case END:
                    normalColor();
                    gameSpeedMax = 8;
                    break;
            }
        }
    }
}

