/**
 * Copyright nbernaz ( http://wonderfl.net/user/nbernaz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4B5L
 */

// forked from Kay's Looks like PV3D demo 
/*
 * PV3Dによくあるデモっぽいのを外部クラスなしでやってみる
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;

    public class Main extends Sprite {
        private const SW:Number=stage.stageHeight;
        private const SH:Number=stage.stageWidth;
        public var pp:PerspectiveProjection;
        public var real:Sprite;
        public var mirror:Sprite;
        public var strings:Array = new Array();

        public function Main() {
            pp=transform.perspectiveProjection;
            pp.projectionCenter=new Point(SW/2,SH/2);
            pp.fieldOfView=60;
            
            var bg:Shape = new Shape();
            bg.graphics.beginFill(0);
            bg.graphics.drawRect(0,0,SW,SH);
            bg.graphics.endFill();
            addChild(bg);
            
            strings.push("TextField");
            strings.push("Sprite");
            strings.push("ENTER_FRAME");
            strings.push("addChild");
            strings.push("graphics");
            strings.push("Event");
            strings.push("fieldOfView");
            strings.push("Math");
            strings.push("random");
            strings.push("Vector");

            mirror = new Sprite();
            addChild(mirror);
            mirror.x = SW/2;
            mirror.y = SH/2+250;
            
            real = new Sprite();
            addChild(real);
            real.x=SW/2;
            real.y=SH/2-150;
            
            var textFormat:TextFormat = new TextFormat();
            textFormat.font = "Arial";
            textFormat.bold = true;
            textFormat.size = 24;
            textFormat.align = TextFormatAlign.CENTER;
            
            for (var i:int=0; i < strings.length; i++) {
                // REAL
                var text:TextSprite = new TextSprite(strings[i],textFormat,0x0066ff);
                text.x = Math.random() * 600-300;
                text.y = Math.random() * 200-100;
                text.z = Math.random() * 600-300;
                text.rotationX = Math.random()*360;
                text.rotationY = Math.random()*360;
                text.rotationZ = Math.random()*360;
                real.addChild(text);
                // MIRROR
                var mText:TextSprite = new TextSprite(strings[i],textFormat,0x000099);
                mText.rotationX = -text.rotationX;
                mText.rotationY = text.rotationY;
                mText.rotationZ = -text.rotationZ;
                mText.scaleY = -1;
                mText.scaleZ = -1;
                mText.x = text.x;
                mText.y = -text.y;
                mText.z = text.z;
                mirror.addChild(mText);
            }
            addEventListener(Event.ENTER_FRAME, xEyePoint);
        }
        public function xEyePoint(e:Event):void {
            pp.projectionCenter=new Point(SW/2,mouseY);
            var eyePoint:Vector3D = new Vector3D(SW/2, mouseY, -pp.focalLength);
            real.rotationY += (mouseX / SW * 480 - real.rotationY) * 0.1;
            mirror.rotationY = real.rotationY;
        }
    }
}
import flash.display.*;
import flash.text.*;
class TextSprite extends Sprite {
    public function TextSprite(str:String, tf:TextFormat, nColor:int):void {
        var text:Sprite = new Sprite();
        var field:TextField = new TextField();
        field.antiAliasType = AntiAliasType.ADVANCED;
        field.autoSize=TextFieldAutoSize.LEFT;
        field.defaultTextFormat = tf;
        field.text = str;
        field.textColor= nColor;
        field.x -= field.width/2;
        field.y -= field.height/2;
        text.addChild(field);
        addChild(text);
    } 
}