/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4A9E
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
    public class FlashTest extends Sprite
	{
		private var particles:Array;
		private var bdView:BitmapData;
		private var src:Sprite;
		
        public function FlashTest()
		{
            particles = new Array();
			var sw:Number = stage.stageWidth;
			var sh:Number = stage.stageHeight;
			for (var i:int = 0; i < 10; i++)
			{
				var obj:Object = {
					x : sw * .5,
					y : sh * .5,
					rad : 20,
					vx : (Math.random()-.5)*4,
					vy : (Math.random()-.5)*4,
					gDir:Math.floor(Math.random() * 4) * Math.PI / 2
				}
				particles.push(obj);
			}
			
			bdView = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF);
			addChild(new Bitmap(bdView));
			
			src = new Sprite();
			src.graphics.beginFill(0xFF0000);
			src.graphics.drawCircle(0, 0, 1);
			src.graphics.endFill();
			
			addEventListener(Event.ENTER_FRAME, function(e:Event):void
			{
				update();
				draw();
			});
			draw();
        }
		
		private function update():void
		{
			if (Math.random() < .2)
			{
				var obj:Object = {
					x : stage.stageWidth * .5+(Math.random()-.5)*100,
					y : stage.stageHeight * .5+(Math.random()-.5)*100,
					rad : 20,
					vx : (Math.random()-.5)*4,
					vy : (Math.random()-.5)*4,
					gDir:Math.floor(Math.random() * 4) * Math.PI / 2
				}
				particles.push(obj);
			}
			
			particles = particles.filter(function(p:*, index:int, array:Array):Boolean
			{
				p.rad -= .1;
				if (p.rad <= 0)
				{
					return false;
				}
				p.vx += Math.cos(p.gDir);
				p.vy += Math.sin(p.gDir);
				p.x += p.vx;
				p.y += p.vy;
				var f:Boolean = false;
				if (p.x - p.rad < 0)
				{
					p.x = p.rad;
					p.vx *= -.5;
					f = true;
				}
				else if (p.x + p.rad > bdView.width)
				{
					p.x = bdView.width - p.rad;
					p.vx *= -.5;
					f = true;
				}
				if (p.y - p.rad < 0)
				{
					p.y = p.rad;
					p.vy *= -.5;
					f = true;
				}
				else if (p.y + p.rad > bdView.height)
				{
					p.y = bdView.height - p.rad;
					p.vy *= -.5;
					f = true;
				}
				if (f)
				{
					p.gDir = (p.gDir + (Math.floor(Math.random() * 3) - 1) * Math.PI / 2) % (Math.PI * 2);
				}
				return true;
			});
		}
		
		private function draw():void
		{
			bdView.fillRect(bdView.rect, 0xFFFFFF);
			var mat:Matrix = new Matrix();
			for (var index:String in particles)
			{
				var p:Object = particles[index];
				mat.identity();
				mat.scale(p.rad, p.rad);
				mat.translate(p.x, p.y);
				bdView.draw(src, mat);
			}
		}
    }
}
