/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4A6V
 */

package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.external.ExternalInterface;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    public class Main extends Sprite {
        
        private var _gridMap:Array = [];
        private var _gridList:Array = [];
        
        private var _timer:Timer = new Timer(30);
        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            for(var j:int=0; j<30; ++j) {
                _gridMap[j] = [];
                for(var i:int=0; i<4; ++i) {
                    _gridMap[j][i] = new Node(i,j);
                    _gridList.push(_gridMap[j][i]);
                }
            }
            
            draw();
            
            _timer.addEventListener(TimerEvent.TIMER,loop);
            
            _timer.start();
            
            //build();
        }
        
        private function build():void {
            for (var i:int = 0; i < 500; ++i ) {
                loop();
            }
        }
        private function margeGrid():void {
            var index:int = (Math.random()*_gridList.length)|0;
            var n:Node = _gridList[index];
            if ( n.size() == 8 ) return;
            
            var targets:Array = [];
            
            if ( n.size() == 4 ) {
                if ( _gridMap[n.y][n.x-n.w] ) {
                    targets.push(_gridMap[n.y][n.x-n.w]);
                }
                if ( _gridMap[n.y][n.x+n.w] ) {
                    targets.push(_gridMap[n.y][n.x+n.w]);
                }
            }
            else {
                if ( _gridMap[n.y+n.h] && _gridMap[n.y+n.h][n.x] ) {
                    targets.push(_gridMap[n.y+n.h][n.x]);
                }
                if ( _gridMap[n.y-n.h] && _gridMap[n.y-n.h][n.x] ) {
                    targets.push(_gridMap[n.y-n.h][n.x]);
                }
            }
            
            var t:Node = targets[(targets.length * Math.random()) | 0];
            if (!t || n.size() != t.size()) return;
            
            _gridMap[n.y][n.x] = null;
            
            if(t.x<n.x) {
                n.x = t.x;
                n.w += t.w;
            }
            else if(t.x>n.x) {
                n.w += t.w;
            }
            else if(t.y<n.y) {
                n.y = t.y;
                n.h += t.h;
            }
            else if(t.y>n.y) {
                n.h += t.h;
            }
            
            _gridList.splice(_gridList.indexOf(t), 1)
            
            _gridMap[t.y][t.x] = null;
            _gridMap[n.y][n.x] = n;
        }
        private function shuffleGrid():void {
            var index:int = (Math.random()*_gridList.length)|0;
            var n:Node = _gridList[index];
            if ( n.size() == 8 ) return;
            
            var t:Node;
            if ( _gridMap[n.y + n.h] && _gridMap[n.y + n.h][n.x] ) {
                t =  _gridMap[n.y + n.h][n.x];
            }
            if (!t || t.size() == 8) return;
            
            if (n.y > t.y) {
                n.y = t.y;
                t.y = n.y + n.h;
            }
            _gridMap[t.y][t.x] = t;
            _gridMap[n.y][n.x] = n;
        }
        
        private var _mode:Boolean = true;
        private var _count:int = 0;
        private  function loop(e:TimerEvent=null):void {
            if (_count++ % 50 == 0) {
                _mode = !_mode;
            }
            
            if( _mode ) {
                margeGrid();
            }
            else {
                shuffleGrid();
            }
            
            draw();
        }
        
        public function draw():void {
            graphics.clear();
            graphics.lineStyle(1,0xCCCCCC);
            
            var gridX:int = 100;
            var gridY:int = 25;
            
            for each( var n:Node in _gridList ) {
                graphics.beginFill(n.color, 0.5);
                graphics.drawRect(n.x*gridX, n.y*gridY, n.w*gridX, n.h*gridY);
                graphics.endFill();
            }
        }
    }
}

class Node {
    public var x:int;
    public var y:int;
    public var w:int;
    public var h:int;
    public var color:uint;
    public function Node(x:int,y:int,w:int=1,h:int=1){
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        
        function getCode():uint { return (0xff*Math.random())|0; }
        this.color = getCode()<<16|getCode()<<8|getCode();
    }
    
    public function size():int { return w * h; }
    public function toString():String {
        return '[Node (x=' + x + ',y=' + y + ',w=' + w + ',h=' + h + ',size='+size()+')]';
    }
}