/**
 * Copyright scoundrel ( http://wonderfl.net/user/scoundrel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/49rh
 */

// ******************************************
// * cubed sphere experiment from scoundrel *
// * made in hungary at 20090617            *
// ******************************************
package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.geom.Rectangle;

	[SWF(width=400,height=300,frameRate=200,backgroundColor=0x000000)]

	public class scoCubedSphere1kayac extends Sprite
	{
		private var output: BitmapData;
		private const scoRect:Rectangle= new Rectangle(0,0,400,300);
		private var fpsText = new TextField();

		private var alfa:Number=0, beta:Number=0, gamma:Number=0;
		private var d:int = 500;
		private var Zoom:int = 600;
		private var objKP_x:int = 200;
		private var objKP_y:int = 150;
		private var CSsurfaceX=20;
		private var CSsurfaceY=20;
		private var CSsurfaceW=0.1;
		private var Vertices=CSsurfaceX*CSsurfaceY;
		private var objectVertices = [];
		private var rotateVertices = [];
		private var projVertices = [];
		private var scoi:int,scoj:int;
		private var scox:Number,scoy:Number,scoz:Number;
		private var scox2:Number,scoy2:Number,scoz2:Number;
		private var scon:Number;
		private var sinalfa:Number,sinbeta:Number,singamma:Number;
		private var cosalfa:Number,cosbeta:Number,cosgamma:Number;

		public function scoCubedSphere1kayac()
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			output = new BitmapData( 400, 300, false, 0x000000 );
			var outputBitmap: Bitmap = new Bitmap(output);
			addChild(outputBitmap);

// **************************************************
// * generate a 3D vertices of cubedSphere one side *
// * please write you better and faster solution!!! *
// **************************************************
			for (scoj=0; scoj<CSsurfaceY; scoj++) {
				for (scoi=0; scoi<CSsurfaceX; scoi++) {
					scox=CSsurfaceW*scoi-CSsurfaceX*CSsurfaceW/2;
					scoy=CSsurfaceW*scoj-CSsurfaceY*CSsurfaceW/2;
					scoz=1;
					scox2=Math.sqrt(1-scoy*scoy/2-scoz*scoz/2+scoy*scoy*scoz*scoz/3);
					scoy2=Math.sqrt(1-scoz*scoz/2-scox*scox/2+scoz*scoz*scox*scox/3);
					scoz2=Math.sqrt(1-scox*scox/2-scoy*scoy/2+scox*scox*scoy*scoy/3);
					objectVertices.push(scox*scox2*70);
					objectVertices.push(scoy*scoy2*70);
					objectVertices.push(scoz*scoz2*70);
				}
			}

// textfield set
			fpsText.y=280;
			fpsText.textColor=0xa0a0a0;
			addChild(fpsText);
	
			stage.addEventListener( Event.ENTER_FRAME, CubedSphereDoIt );
		}

		private function CubedSphereDoIt(event: Event): void
		{
			var startTime:Number = getTimer();

			alfa += (mouseX / 50 - alfa);
			if (alfa>=6.283) alfa=0;
			beta += (mouseY / 50 - beta);		// /12
			if (beta>=6.283) beta=0;

			scoRotate();

			output.fillRect(scoRect,0x000000);

// draw vertices
			for (scoi=0;scoi<Vertices;scoi++) {
				output.setPixel(rotateVertices[scoi*3+0]+200,rotateVertices[scoi*3+1]+150, 0xffff00);
			}

			var scoTime:int = (getTimer() - startTime);
			fpsText.text = ""+Vertices+" vertices: "+scoTime+" ms";
		}

// *************************************************************
// * scoRotate: if you can faster solution, please contact me! *
// *************************************************************
		function scoRotate():void {
			sinalfa=Math.sin(alfa);
			cosalfa=Math.cos(alfa);
			sinbeta=Math.sin(beta);
			cosbeta=Math.cos(beta);
			singamma=Math.sin(gamma);
			cosgamma=Math.cos(gamma);
			var xx:Number = cosalfa*cosgamma-sinalfa*sinbeta*singamma;
			var xy:Number = -(sinbeta*cosalfa*singamma+cosgamma*sinalfa);
			var xz:Number = singamma*cosbeta;
			var yx:Number = sinalfa*cosbeta;
			var yy:Number = cosalfa*cosbeta;
			var yz:Number = sinbeta;
			var zx:Number = singamma*cosalfa+cosgamma*sinbeta*sinalfa;
			var zy:Number = cosalfa*cosgamma*sinbeta-sinalfa*singamma;
			var zz:Number = -cosbeta*cosgamma;
			for (scoi=0;scoi<Vertices;scoi+=1) {
				scox = objectVertices[scoi*3+0];
				scoy = objectVertices[scoi*3+1];
				scoz = objectVertices[scoi*3+2];
				scox2 = scox*xx+scoy*xy+scoz*xz;
				scoy2 = scox*yx+scoy*yy+scoz*yz;
				scoz2 = scox*zx+scoy*zy+scoz*zz;
				rotateVertices[scoi*3+0]=scox2;
				rotateVertices[scoi*3+1]=scoy2;
			} 
		} //scoRotate

	} //scoCubedSphere
} //package
