/**
 * Copyright albatrus_jp ( http://wonderfl.net/user/albatrus_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/49ke
 */

// forked from soundkitchen's sample 7
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.CurveModifiers;
    import frocessing.color.ColorHSV;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xFFFFFF)]

    public class Sample extends Sprite
    {
        private var _isMouseDown:Boolean = false;
        private var _hsv:ColorHSV;

        public function Sample()
        {
            //  CurveModifiers を有効化
            CurveModifiers.init();

            //  ColorHSV を色相 0 で作成
            _hsv = new ColorHSV(0, 1, 1, 1);

            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
        }

        private function enterFrameHandler(evt:Event):void
        {
            //  色を更新
            _hsv.h= ++_hsv.h % 360;

            //  マウスダウンされていなければ処理しない
            if (!_isMouseDown) return;

            //  Sprite を作成
            var sp:Sprite = new Sprite();
            sp.x = mouseX;
            sp.y = mouseY;
            sp.alpha = .2;
            sp.graphics.beginFill(_hsv.value);
            sp.graphics.drawCircle(0, 0, 20);
            sp.graphics.endFill();

            addChild(sp);

            var endX:Number = Math.random() * stage.stageWidth;
            var ctlX:Number = mouseX + (endX - mouseX) / 2;

            Tweener.addTween(sp, {
                x: endX,
                y: stage.stageHeight, 
                _bezier: [{x: ctlX, y:0 }], 
                time: Math.random()* 4+1,
                transition: "linear",
                onComplete: onTweenComplete,
                onCompleteParams: [sp]
            });
        }

        private function onTweenComplete(sp:Sprite):void
        {
            removeChild(sp);
        }

        private function mouseDownHandler(evt:MouseEvent):void
        {
            _isMouseDown = true;
        }

        private function mouseUpHandler(evt:MouseEvent):void
        {
            _isMouseDown = false;
        }
    }
}
