/**
 * Copyright taka_milk ( http://wonderfl.net/user/taka_milk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/49jy
 */

// forked from kazy's forked from: SPRING TO MOUSE
// forked from kazy's SPRING TO MOUSE
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * Main
	 * メインクラス.
	 */
	public class Main extends Sprite
	{
		private var ball0:Ball;
		private var ball1:Ball;
		private var ball2:Ball;
		private var spring:Number = 0.1;
		private var friction:Number = 0.8;
		private var gravity:Number = 5;
		/**
		 * コンストラクタ.
		 */
		public function Main()
		{
			init();
		}
		/**
		 * 初期化.
		 */
		private function init():void
		{
			ball0 = new Ball(20);
			addChild(ball0);
			ball1 = new Ball(20);
			addChild(ball1);
			ball2 = new Ball(20);
			addChild(ball2);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void
		{
			//ばねの動きをさせる
			moveBall(ball0, mouseX, mouseY);
			moveBall(ball1, ball0.x, ball0.y);
			moveBall(ball2, ball1.x, ball1.y);
			//ラインを描く
			graphics.clear();
			graphics.lineStyle(1);
			graphics.moveTo(mouseX, mouseY);
			graphics.lineTo(ball0.x, ball0.y);
			graphics.lineTo(ball1.x, ball1.y);
			graphics.lineTo(ball2.x, ball2.y);
		}
		/**
		 * ばねの動き.
		 */
		private function moveBall(ball:Ball, targetX:Number, targetY:Number):void
		{
			//バネ
			ball.vx += (targetX - ball.x) * spring;
			ball.vy += (targetY - ball.y) * spring;
			//重力
			ball.vy += gravity;
			//減速
			ball.vx *= friction;
			ball.vy *= friction;
			//ボールの座標に適応
			ball.x += ball.vx;
			ball.y += ball.vy;
		}
	}
}


/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=40, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}