/**
 * Copyright yoneken ( http://wonderfl.net/user/yoneken )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/49LX
 */

// forked from k0rin's Animated Illusions
//
// 「ほ～ら，ネギが曲がって見える～」

package {
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	
	[SWF(width = "465", height = "465", frameRate = "60")]
	public class AnimatedIllusions extends Sprite {
		private var shape:Shape = new Shape();
		private var g:Graphics = shape.graphics; 
		public var miku:Hatyune; 
		
		private var param:Number;
		
		public function AnimatedIllusions():void {
			addChild(shape);
			miku = new Hatyune(); 
			miku.start(); 
			addChild(miku.body); 

			miku.body.x = 100;
			miku.body.y = 200;

			addEventListener(Event.ENTER_FRAME, enterFrameHandler);

			Wonderfl.capture_delay( 20 );
		}
		
		private function enterFrameHandler(event:Event):void {
			param = Math.sin(getTimer() / 200);
			
			g.clear();
			drawMullerLyerIllusion();
			drawZollnerIllusion();

			miku.arm_r.rotate(Math.sin(param/2)); 
			miku.negi.rotate(Math.sin(-param)); 
			miku.hair_l.rotate(Math.sin(param)/5); 
			miku.hair_r.rotate(-Math.sin(param)/5); 
		}
		
		private function drawMullerLyerIllusion():void {
			const XL:Number = 465 / 2 - 80;
			const XR:Number = 465 / 2 + 80;
			const H:Number = 40;
			
			g.lineStyle(4, 0x000000);
			var offset:Number = param * 40;
			for (var i:int = 0; i < 2; i++) {
				var y:Number = 80 + i * 100;
				
				g.drawPath(Vector.<int>([1, 2, 1, 2, 2, 1, 2, 2]), 
					Vector.<Number>([
						XL, y,  XR, y,  
						XL + offset, y - H,  XL, y,  XL + offset, y + H, 
						XR - offset, y - H,  XR, y,  XR - offset, y + H
					]));
				offset = -offset;
			}
		}
		
		private function drawZollnerIllusion():void {
			const XL:Number = 40;
			const XR:Number = 425;
			const SPACING:Number = 30;
			const H:Number = 15;
			
			g.lineStyle(4, 0x000000, 1, false, LineScaleMode.NORMAL, CapsStyle.SQUARE);
			var offset:Number = param * 40;
			for (var i:int = 0; i < 4; i++) {
				var y:Number = 290 + i * 40;
				
				g.moveTo(XL, y);
				g.lineTo(XR, y);
				for (var x:Number = XL + 12; x < XR; x += SPACING) {
					g.moveTo(x + offset, y - H);
					g.lineTo(x - offset, y + H);
				}
				offset = -offset;
			}
		}
	}
}

// ------はちゅねを動かすだけなら、こっから下は読まなくてＯＫ！------- 

import flash.display.Loader; 
import flash.display.Sprite; 
import flash.net.URLRequest; 
import flash.errors.IOError; 
import org.libspark.thread.Thread; 
import org.libspark.thread.EnterFrameThreadExecutor; 
import org.libspark.thread.utils.ParallelExecutor; 
import org.libspark.thread.threads.display.LoaderThread; 

class Hatyune extends Thread 
{ 
  public var arm_r:Parts; 
  public var head0:Parts; 
  public var head1:Parts; 
  public var body:Parts; 
  public var hair_l:Parts; 
  public var hair_r:Parts; 
  public var negi:Parts; 

  private var hair_r_lt:LoaderThread; 
  private var negi_lt:LoaderThread; 
  private var hand_r_lt:LoaderThread; 
  private var body_lt:LoaderThread; 
  private var face_lt:LoaderThread; 
  private var hair_l_lt:LoaderThread; 

  public function Hatyune() 
  { 
    if(!Thread.isReady) 
      Thread.initialize(new EnterFrameThreadExecutor()); 

    super(); 

    body = new Parts(0,0,200,140); 
    head0 = new Parts(106,0,212,112); 
    hair_r = new Parts(0,6,77,13); 
    arm_r = new Parts(0,91,197,119); 
    negi = new Parts(0,0,118,15); 
    head1 = new Parts(106,0,212,112); 
    hair_l = new Parts(132,6,141,16); 
  } 

  override protected function run():void 
  { 
    var ParaExe:ParallelExecutor = new ParallelExecutor(); 

    hair_l_lt = new LoaderThread(new URLRequest("http://image.blog.livedoor.jp/k_yon/imgs/1/4/14e2dce1.png")); 
    negi_lt = new LoaderThread(new URLRequest("http://image.blog.livedoor.jp/k_yon/imgs/4/c/4cd1ba9c.png")); 
    hand_r_lt = new LoaderThread(new URLRequest("http://image.blog.livedoor.jp/k_yon/imgs/b/c/bc0ba0f1.png")); 
    body_lt = new LoaderThread(new URLRequest("http://image.blog.livedoor.jp/k_yon/imgs/6/5/659cbeb2.png")); 
    face_lt = new LoaderThread(new URLRequest("http://image.blog.livedoor.jp/k_yon/imgs/c/c/cc3baf4f.png")); 
    hair_r_lt = new LoaderThread(new URLRequest("http://image.blog.livedoor.jp/k_yon/imgs/0/9/09def37a.png")); 

    ParaExe.addThread(hair_r_lt); 
    ParaExe.addThread(negi_lt); 
    ParaExe.addThread(hand_r_lt); 
    ParaExe.addThread(body_lt); 
    ParaExe.addThread(face_lt); 
    ParaExe.addThread(hair_l_lt); 

    ParaExe.start(); 
    ParaExe.join(); 

    next(imgLoaded); 
    error(IOError, errorHandler); 
    error(SecurityError, errorHandler); 
  } 

  private function imgLoaded():void 
  { 
    var _hair_r:Loader = hair_r_lt.loader; 
    _hair_r.width = 82; 
    _hair_r.height = 257; 
    hair_r.addChild(_hair_r); 
    head0.addChild(hair_r); 
    body.addChild(head0); 

    var _negi:Loader = negi_lt.loader; 
    _negi.width = 124; 
    _negi.height = 44; 
    negi.addChild(_negi); 
    arm_r.addChild(negi); 

    var _hand_r:Loader = hand_r_lt.loader; 
    _hand_r.width = 96; 
    _hand_r.height = 43; 
    _hand_r.x = 113; 
    _hand_r.y = 5; 
    arm_r.addChild(_hand_r); 
    body.addChild(arm_r); 

    var _body:Loader = body_lt.loader; 
    _body.width = 116; 
    _body.height = 172; 
    _body.x = 150; 
    _body.y = 93; 
    body.addChild(_body); 

    var _face:Loader = face_lt.loader; 
    _face.width = 114; 
    _face.height = 111; 
    _face.x = 47; 
    _face.y = 0; 
    head1.addChild(_face); 

    var _hair_l:Loader = hair_l_lt.loader; 
    _hair_l.width = 85; 
    _hair_l.height = 247; 
    hair_l.addChild(_hair_l); 
    head1.addChild(hair_l); 
    body.addChild(head1); 
  } 

  private function errorHandler(e:IOError, t:Thread):void 
  { 
    next(null); 
  } 

  protected override function finalize():void 
  { 
  } 
} 

// -------------------------------------------- 

class Parts extends Sprite 
{ 
  public var originX:Number; 
  public var originY:Number; 
  public var baseX:Number; 
  public var baseY:Number; 
  private var GShape:flash.display.Shape; 

  public function Parts( bx:Number, by:Number, gx:Number, gy:Number ) 
  { 
    x = baseX = bx; 
    y = baseY = by; 
    originX = gx; 
    originY = gy; 
  } 
  public function rotate( rad:Number ):void 
  { 
    var tmpX:Number = baseX - originX; 
    var tmpY:Number = baseY - originY; 
    x = tmpX * Math.cos(rad) - tmpY * Math.sin(rad) + originX; 
    y = tmpY * Math.cos(rad) + tmpX * Math.sin(rad) + originY; 
    rotation = rad / Math.PI * 180; 
  } 
  public function showRotatePoint():void 
  { 
    GShape = new flash.display.Shape(); 
    GShape.graphics.beginFill(0xff0000); 
    GShape.graphics.drawCircle(0,0,5); 
    GShape.graphics.endFill(); 
    GShape.x = originX; 
    GShape.y = originY; 
    addChild(GShape); 
  } 
  public function hideRotatePoint():void 
  { 
    removeChild(GShape); 
  } 
} 
