/**
 * Copyright k__ ( http://wonderfl.net/user/k__ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/49AW
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.media.*;
	
	public class Main extends Sprite {
		private var xNum:uint = 24;
		private var yNum:uint = 12;
		private var isMouseDown:Boolean = false;
		private var gridW:Number,gridH:Number;
		private var xPos:uint = 0, yPos:uint = 0;
		private var canvas:BitmapData;
		private var feedback:BitmapData;
		private var feedbackRect:Rectangle;
		private var oPt:Point;
		private var filter:ColorMatrixFilter;
		private var cursor:Shape;
		private var cam:Camera;
		private var video:Video;
		private var videoStage:Sprite;
		private var mtx:Matrix, mtx2:Matrix;
		private var buff1:BitmapData,buff2:BitmapData;
		private var buffInterval:uint = 1000;
		private var buffCnt:uint;
		private var thresholdMin:uint = 50;
		private var thresholdMax:uint = 155;
		private var threshold:uint = thresholdMax;
		private const COLOR_OVER:uint = 0xffff00;
		
		public function Main() {
			//display
			addChild(new Bitmap(canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000)));
			addChild(new Bitmap(feedback = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000)));
			cursor = new Shape();
			
			//camera
			videoStage = new Sprite();
			cam = Camera.getCamera();
			cam.addEventListener(StatusEvent.STATUS, h_camStatus);
			videoStage.addChild(video = new Video());
			video.scaleX = -1;
			video.x = video.width;
			video.attachCamera(cam);
			
			//transforms
			oPt = new Point(0,0);
			feedbackRect = canvas.rect;
			mtx = new Matrix();
			mtx2 = new Matrix();
			mtx.scale(xNum / video.width, yNum / video.height);
			mtx2.scale(stage.stageWidth / xNum, stage.stageHeight / yNum);
			filter = new ColorMatrixFilter(
										   [0.96,0,0,0,0,
											0,0.97,0,0,0,
											0,0,0.98,0,0,
											0,0,0,0.9,-1]);
			
			gridW = stage.stageWidth / xNum;
			gridH = stage.stageHeight / yNum;			
			
			// enterframe
			addEventListener(Event.ENTER_FRAME, h_enterFrame);
		}
		
		private function h_camStatus(evt:StatusEvent):void {
			trace (evt.code);
		}
		
		private function h_enterFrame(evt:Event):void {
			xPos = mouseX / gridW;
			yPos = mouseY / gridH;
			buff1 = new BitmapData(xNum,yNum);
			buff1.draw(videoStage, mtx);
			canvas.draw(buff1,mtx2);
			feedback.applyFilter(feedback,feedbackRect,oPt,filter);
			checkLevel();
		}
		
		private function checkLevel():void {
			if (threshold > thresholdMin) {
				threshold --;
			}
			var lev:Number = 0;
			var xPosBuff:uint, yPosBuff:uint;
			if (buff2) {
				for (var i:uint = 0; i < xNum; i ++) {
					for (var j:uint = 0; j < yNum; j ++) {
						var tmpLev:Number = colorDiff(buff1.getPixel(i,j),buff2.getPixel(i,j))
						if (tmpLev > lev) {
							xPosBuff = i;
							yPosBuff = j;
							lev = tmpLev;
						}
					}
				}
			}
			if (lev > threshold) {
				var g:Graphics = cursor.graphics;
				g.clear();
				g.beginFill(COLOR_OVER);
				g.drawRect(xPosBuff * gridW, yPosBuff * gridH, gridW, gridH);
				g.endFill();
				feedback.draw(cursor);
				
				threshold = thresholdMax;
				var s:SoundPlayer = new SoundPlayer(xPosBuff + (yNum - yPosBuff) * xNum,xNum, 1500,500,1000 , lev / Math.sqrt(255 * 255 * 3));
			}
			buff2 = buff1;
		}
		
		private function colorDiff(col1:uint, col2:uint):Number {
			var r1:uint,g1:uint,b1:uint,r2:uint,g2:uint,b2:uint;
			r1 = col1 >> 16 & 0xff;
			g1 = col1 >> 8 & 0xff;
			b1 = col1 & 0xff;
			r2 = col2 >> 16 & 0xff;
			g2 = col2 >> 8 & 0xff;
			b2 = col2 & 0xff;
			return Math.sqrt((r1 - r2) * (r1 - r2) + (g1 - g2) * (g1 - g2) + (b1 - b2) * (b1 - b2));
		}
		
		private function h_mouseDown(evt:MouseEvent):void {
			isMouseDown = true;
			canvas.draw(cursor);
		}
		private function h_mouseUp(evt:MouseEvent):void {
			isMouseDown = false;
		}
	}
}

import flash.events.*;
import flash.media.*;
import flash.utils.ByteArray;
class SoundPlayer extends EventDispatcher {
	private var sound:Sound;
	private var channel:SoundChannel;
	private var pitch:uint;
	private var freq:Number;
	private var div:uint;
	private var duration:uint;
	private var vol:Number;
	private var attack:uint;
	private var decay:uint;
	
	public function SoundPlayer(p:uint, di:uint, du:uint, at:uint, dc:uint,v:Number) {
		sound = new Sound();
		sound.addEventListener(SampleDataEvent.SAMPLE_DATA, h_sampleData);
		pitch = p;
		div = di;
		duration = du;
		attack = at;
		decay = dc;
		
		freq = Math.pow(2, pitch / di) * 55;
		vol = v;
		channel = sound.play();
	}
	
	private function h_sampleData(evt:SampleDataEvent):void {
		var wavelev:Number;
		var lev:Number = 1;
		var flag:Boolean;
		for (var i:uint = 0; i < 8192; i++) {
			if ((evt.position + i) < 44.1 * attack) {
				lev = (evt.position + i) / (44.1 * attack);
			}
			if ((evt.position + i) > 44.1 * (duration - decay)) {
				lev = (duration * 44.1 - (evt.position + i)) / (decay * 44.1);
			}
			if (evt.position + i > 44.1 * duration) {
				sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, h_sampleData);
				break;
			}
			wavelev = Math.sin((i + evt.position) * Math.PI / (44100 / freq)) / 8 * lev * vol;
			evt.data.writeFloat(wavelev);
			evt.data.writeFloat(wavelev);
		}
    }
}