/**
 * Copyright komatsu ( http://wonderfl.net/user/komatsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/48oY
 */

package {
	import flash.text.engine.TextLine;
	import flash.text.engine.TextBlock;
	import flash.text.engine.TextElement;
	import flash.text.engine.ElementFormat;
	import flash.text.engine.FontDescription;
	import flash.text.engine.EastAsianJustifier;
	import flash.text.engine.LineJustification;
	import flash.text.engine.TextRotation;
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    public class FlashTest extends Sprite {
        public function FlashTest() {
           var sp:Sprite = new Sprite();
			sp.graphics.beginFill(0x000000,0.1);
			sp.graphics.drawRect(0,0,465,400);
			sp.y = 32;
			addChild(sp);
            //表示したいテキスト
			var str:String = "親譲（おやゆず）りの無鉄砲（むてっぽう）で小供の時から損ばかりしている。小学校に居る時分学校の二階から飛び降りて一週間ほど腰（こし）を抜（ぬ）かした事がある。なぜそんな無闇（むやみ）をしたと聞く人があるかも知れぬ。別段深い理由でもない。新築の二階から首を出していたら、同級生の一人が冗談（じょうだん）に、いくら威張（いば）っても、そこから飛び降りる事は出来まい。弱虫やーい。と囃（はや）したからである。小使（こづかい）に負ぶさって帰って来た時、おやじが大きな眼（め）をして二階ぐらいから飛び降りて腰を抜かす奴（やつ）があるかと云（い）ったから、この次は抜かさずに飛んで見せますと答えた。（夏目漱石 坊っちゃん）";
			
			
			//フォント書式
			var fontDesc:FontDescription = new FontDescription();
			fontDesc.fontName = "Kozuka Mincho Pro M";

			//エレメントのフォーマット
			var format:ElementFormat = new ElementFormat();
			format.locale = "ja";//テキストのロケール。jaだと日本語。
			format.fontSize=18;
			format.fontDescription = fontDesc;//FontDescription形式のデータを設定

			//テキストエレメントを作る
			var txtEle:TextElement = new TextElement(str , format);

			//テキストブロック
			var txtBlock:TextBlock = new TextBlock();
			txtBlock.textJustifier = new EastAsianJustifier("ja",LineJustification.ALL_BUT_LAST);
			
			txtBlock.lineRotation = TextRotation.ROTATE_90;//縦書きにする
			txtBlock.content = txtEle;//テキストエレメントをコンテンツとして設定



			var txtW:uint = 380;//１行あたりのピクセル数にする予定
			var textLine:TextLine= txtBlock.createTextLine(null , txtW);
			var posX:uint = sp.width;//textLineのX座標用
			var posY:uint = 10;//textLineのY座標用
			var cnt:uint = 0;//各textLineの個別の条件を与えるための変数


			while(textLine != null){
				//TextLineオブジェクトを参照している、textLine
				//変数の参照先がnullになるまで繰り返す。
				sp.addChild(textLine);
				cnt++;
				posX -= (textLine.width + 12);//textLineの幅＋マージン分、次座標を修正
				textLine.x = posX;
				textLine.y = posY+50;
				textLine.alpha = 0;
	
				Tweener.addTween(textLine , {y:posY , alpha:1  , time:0.5 ,delay:cnt/10, transition:"easeOutBack"});
	
				textLine = txtBlock.createTextLine(textLine , txtW);
				//現在のtextLineから、次のTextLineオブジェクトを参照
			}
        }
    }
}