/**
 * Copyright 0057 ( http://wonderfl.net/user/0057 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/48ek
 */

package {
    
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.display.Sprite;
[SWF(width="150", height="250", backgroundColor="#ffffff", frameRate="2")] 

public class Main extends Sprite {

    private var scr:Array,buffer:Array,pz:Array;
    private var g:Object,h:Function;
    private var pressedKeys:Object = {};
    private var axis:Object = {x:0,y:0,r:0}

    public function Main(){
        super();
        init();
    }

    public function init ():void{
        scr = [0,0,0,0,0,0,0,0,0,0,0,0];
        buffer = [0,0,0,0,0,0,0,0,0,0,0,0];
        pz =[
            [2,3,2,0],[2,7,0,0],[2,6,2,0],[0,7,2,0],  //|-
            [2,2,3,0],[1,7,0,0],[6,2,2,0],[0,7,4,0],  //_|
            [2,2,6,0],[4,7,0,0],[3,2,2,0],[0,7,1,0],  //|_
            [3,3,0,0],[3,3,0,0],[3,3,0,0],[3,3,0,0],  //::
            [2,3,1,0],[3,6,0,0],[2,3,1,0],[3,6,0,0],  //Z
            [1,3,2,0],[6,3,0,0],[1,3,2,0],[6,3,0,0],  //S
            [2,2,2,2],[0,15,0,0],[2,2,2,2],[0,15,0,0]]//| 
        g = graphics;
        h=g.drawRect;
        addEventListener (Event.ENTER_FRAME, onLoop);
        stage.addEventListener( KeyboardEvent.KEY_DOWN, keyDownHandler );
        stage.addEventListener( KeyboardEvent.KEY_UP, keyUpHandler );
        creaPieza();
    }


    private function keyDownHandler( e:KeyboardEvent ):void{
            if( pressedKeys[ e.keyCode ] ){return}
        pressedKeys[ e.keyCode ] = 1;
        traceEvent( e );
    }


    private function keyUpHandler( e:KeyboardEvent ):void {delete pressedKeys[ e.keyCode ]}


    private function traceEvent( e:KeyboardEvent ):void{
        switch(e.keyCode){
            case 40:caePieza();break;
            case 37:mueveDer();break;
            case 39:mueveIzq();break;
            case 38:rota();break;
        }
    }
    
    private function onLoop(e:Event):void{
        if (libre(buffer)){
            if (desplazaBuffer()){
                bloquea();
                creaPieza()
            }
        }else{    
            bloquea();
            creaPieza()
        }
        destruye()
        if (updateView())gameOver();
    }

    
    private function libre (buffer:Array):Boolean{
        var l:int = buffer.length;
        while(l--){if (((buffer[l]&scr[l+1])>0)||buffer[l]<0 || buffer[l]>256)return false;}
        return true;
    }

    
    private function mueveDer():void{
        var l:int = buffer.length , hit : int = 0;
        while(l--){hit|= ((buffer[l]>>1)&scr[l])?1:0;hit|= (((buffer[l])&1)==1)?1:0;}    
        l = buffer.length;
        if (hit==0){
            axis.x--;
            while(l--){buffer[l]>>=1}
        }
    }
    
    
    private function mueveIzq():void{
        var l:int = buffer.length, hit :int = 0;
        while(l--){hit|= ((buffer[l]<<1)&scr[l])?1:0;hit|= (((buffer[l])&128)==128)?1:0}    
        l = buffer.length;
        if (hit==0){
            axis.x++;
            while(l--){buffer[l]<<=1}
        }
    }
    
    private function rota():void{
        var bufferTemp: Array = [0,0,0,0,0,0,0,0,0,0,0,0];
        (axis.r>2)?axis.r=0:axis.r++;
        for (var i:int=0;i<pz[0].length;i++){bufferTemp[i+axis.y] |= (pz[axis.r + axis.p][i])<<(axis.x);
        }
        libre(bufferTemp)?buffer = bufferTemp:(axis.r==0)?axis.r=2:axis.r--;
    }
    
    private function caePieza():void{
        while(libre(buffer)&&!desplazaBuffer()){}
        bloquea();
    }
    
    private function creaPieza():Boolean{
        buffer = [0,0,0,0,0,0,0,0,0,0,0,0];
        axis.p = O.mult (4, O.rand());
        axis.y = axis.r = 0;
        for (var i:int=0;i<pz[0].length;i++){buffer[i]|= (pz[axis.p][i])<<(axis.x=3)}    
        return true
    }

    
    private function desplazaBuffer():Boolean{
        var l:int = buffer.length;
        if ((buffer[l-1])>0)return true;
        while(l--){buffer[l]=(buffer[l]^=buffer[(l-1)])^(buffer[(l-1)]^=buffer[l]);}
        axis.y++;
        return false;
    }
    
    private function bloquea():void{
        var l:int = scr.length;
        while(l--){scr[l]|= buffer[l]}
    }
    
    private function desplaza():Boolean{
        var l:int = scr.length;
        while(l--){
            if (scr[l]==0){scr[l] = scr[l-1];scr[l-1]=0;
            }
        }
        return false;
    }

    private function destruye():Boolean{
        var ll:int,l:int = scr.length-1;
        while(l--){
            if (scr[l]==255){
                ll = ++l;
                while(ll--){scr[ll] = scr[ll-1]}
            }
        }
        return false
    }

    private function gameOver():void{scr = [0,0,0,0,0,0,0,0,0,0,0,0]}

    private function updateView():Boolean{
        g.clear();
        var l:int = scr.length, i:int = 8;
        while(l--){
            i=8;
            while(i--){
                if (((buffer[l]|scr[l])&(1<<i))>0){g.beginFill(0);h(O.mult(10,i),O.mult(10,l),9,9);}
            }
        } 
        return (scr[2]>0)
    }
}}


class O {
    public static function mult (x:Number , y :Number):Number{
        if (y > x){
            return mult(y,x);    
        }else{
            var p:Number  = 0;
            while(y > 0) {
                if(y & 1){ p += x}
                x <<= 1;
                y >>= 1;
            }
        }
        return p;
    }
    
    
    public static function rand():Number{
        var p:Number = Number (String(Math.random()).split("0.")[1].slice(0,1));
        return (p<7)?p:rand();
    }
}