/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/48EG
 */

package {
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.media.Sound;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var c:Console;
        
        public function FlashTest() {
            addChild(c = new Console(stage.stageWidth, stage.stageHeight));
            c.println('This is like a console.');
            c.println('Tell me about yourself, would you?');
            c.input([
                {name: 'age', width: 32, restrict: '0-9'},
                {name: 'sex', width: 20, maxChars: 1, restrict: 'MF'},
                {name: 'location', width: 200}], asl);
        }
        
        private function asl(a:Object):void {
            var age:int = parseInt(a.age, 10);
            c.println('Well I am ' + (age + 1) + ' years old. When is your birthday?');
            c.input('birthday', birthday);
        }
        
        private function birthday(a:Object):void {
            if (a.birthday == 'today')
                c.println('Happy birthday!');
            else
                c.println('Let\'s have a party on ' + a.birthday);
            var s:Sound = new Sound(new URLRequest('http://www.apmmusic.com/audio/KPM/KPM_KPM_0730/KPM_KPM_0730_02601.mp3'));
            c.load(s, 'music');
            s.addEventListener(Event.COMPLETE, sound);
        }
        
        private function sound(e:Event):void {
            e.target.play();
        }
        
    }
}

import com.bit101.components.*;
import flash.events.*;
import flash.display.Sprite;
internal class Console extends Sprite {

    private var flow:Number = 2;
    private var maxWidth:Number;
    private var maxHeight:Number;
    
    public function Console(maxWidth:Number, maxHeight:Number) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }
    
    private function grayLine(lineHeight:Number):void {
        graphics.beginFill(0xf0f0f0);
        graphics.drawRect(0, flow + 2, maxWidth, lineHeight + 8);
        graphics.endFill();
        flow += 6;
    }
    
    // -- text line --
    
    public function println(message:String):void {
        flow += new Label(this, 2, flow - 3, message).height - 5;
    }
    
    // -- input line --
    
    private var inputTexts:Object = null;
    private var pushButton:PushButton = null;
    private var callback:Function = null;
    
    public function input(questions:Object, callback:Function):void {
        if (inputTexts) inputEnd();
        inputTexts = {};
        grayLine(16);
        if (!(questions is Array)) questions = [questions];
        var xflow:Number = 2;
        for each (var question:Object in questions) {
            if (question is String) question = {name: question};
            xflow += new Label(this, xflow, flow, question.name + ':').width + 2;
            var inputText:InputText = new InputText(this, xflow, flow, '');
            if ('maxChars' in question) inputText.maxChars = question.maxChars;
            if ('password' in question) inputText.password = question.password;
            if ('restrict' in question) inputText.restrict = question.restrict;
            if ('text'     in question) inputText.text     = question.text;
            if ('width'    in question) inputText.width    = question.width;
            xflow += inputText.width + 8;
            inputTexts[question.name] = inputText;
        }
        pushButton = new PushButton(this, xflow, flow, 'OK', inputSubmit);
        pushButton.width = 32;
        pushButton.height = 16;
        this.callback = callback;
        flow += 22;
    }
    
    private function inputSubmit(e:MouseEvent):void {
        var answer:Object = {};
        for (var name:String in inputTexts)
            answer[name] = inputTexts[name].text;
        var callback:Function = callback;
        inputEnd();
        callback(answer);
    }
    
    private function inputEnd():void {
        for (var name:String in inputTexts)
            inputTexts[name].enabled = false;
        inputTexts = null;
        pushButton.enabled = false;
        pushButton = null;
        callback = null;
    }
    
    // -- progress line --
    
    private var progressBar:ProgressBar = null;
    
    public function load(eventDispatcher:IEventDispatcher, name:String = null):void {
        if (progressBar) endProgress();
        grayLine(10);
        var xflow:Number = 4;
        if (name) xflow += new Label(this, xflow - 2, flow - 4, name).width;
        progressBar = new ProgressBar(this, xflow, flow);
        progressBar.width = maxWidth - 4 - xflow;
        flow += 16;
        eventDispatcher.addEventListener(ProgressEvent.PROGRESS, loadProgress);
        eventDispatcher.addEventListener(Event.COMPLETE, endProgress);
        eventDispatcher.addEventListener(IOErrorEvent.IO_ERROR, endProgress);
    }
    
    public function loadProgress(e:ProgressEvent):void {
        progressBar.maximum = e.bytesTotal;
        progressBar.value = e.bytesLoaded;
    }
    
    public function endProgress(e:Event = null):void {
        progressBar.enabled = false;
        progressBar = null;
    }
    
}